/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.ObjectInputFilter;
import org.cojen.dirmi.Serialized;
import org.cojen.dirmi.core.MarshalledSkeleton;
import org.cojen.dirmi.core.MarshalledStub;
import org.cojen.dirmi.core.SoftCache;

final class SerializedFilter {
    private static final SoftCache<String, ObjectInputFilter> cCache = new SoftCache();

    SerializedFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectInputFilter filterFor(Serialized ann) {
        String originalPattern = ann.filter();
        ObjectInputFilter filter = cCache.get(originalPattern);
        if (filter == null) {
            SoftCache<String, ObjectInputFilter> softCache = cCache;
            synchronized (softCache) {
                filter = cCache.get(originalPattern);
                if (filter == null) {
                    Object pattern = originalPattern;
                    if (!((String)pattern).contains("!*")) {
                        pattern = (String)pattern + ";!*";
                    }
                    pattern = MarshalledStub.class.getName() + ";" + MarshalledSkeleton.class.getName() + ";" + (String)pattern;
                    try {
                        filter = ObjectInputFilter.Config.createFilter((String)pattern);
                    }
                    catch (IllegalArgumentException e) {
                        if (pattern != originalPattern) {
                            ObjectInputFilter.Config.createFilter(originalPattern);
                        }
                        throw e;
                    }
                    cCache.put(originalPattern, filter);
                }
            }
        }
        return filter;
    }
}

