/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Serializer;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.SoftCache;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;

public final class SerializerMaker {
    private static final SoftCache<Object, Serializer> cCache = new SoftCache();
    private final Class<?> mType;
    private final String mDescriptor;
    private Map<String, String> mDescriptorMap;
    private ClassMaker mMaker;
    private MethodMaker mWriteMaker;
    private Variable mWritePipeVar;
    private Variable mWriteObjectVar;
    private MethodMaker mReadMaker;
    private Variable mReadPipeVar;
    private StringBuilder mDescriptorBuilder;
    private String mEffectiveDescriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializer forClass(Class<?> type) {
        Serializer serializer = cCache.get(type);
        if (serializer == null) {
            SoftCache<Object, Serializer> softCache = cCache;
            synchronized (softCache) {
                serializer = cCache.get(type);
                if (serializer == null) {
                    serializer = new SerializerMaker(type, null).make().finish();
                    cCache.put(type, serializer);
                }
            }
        }
        return serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializer adapt(Serializer s, Class<?> type, Object descriptor) {
        if (s.descriptor().equals(descriptor)) {
            return s;
        }
        String descString = ((String)descriptor).intern();
        WithDescriptor key = new WithDescriptor(type, descString);
        Serializer serializer = cCache.get(key);
        if (serializer == null) {
            SoftCache<Object, Serializer> softCache = cCache;
            synchronized (softCache) {
                serializer = cCache.get(key);
                if (serializer == null) {
                    SerializerMaker maker = new SerializerMaker(type, descString).make();
                    WithDescriptor canonicalKey = new WithDescriptor(type, maker.mEffectiveDescriptor);
                    serializer = cCache.get(canonicalKey);
                    if (serializer != null) {
                        cCache.put(key, serializer);
                    } else {
                        serializer = maker.finish();
                        cCache.put(key, serializer);
                        cCache.put(canonicalKey, serializer);
                    }
                }
            }
        }
        return serializer;
    }

    private SerializerMaker(Class<?> type, String descriptor) {
        this.mType = type;
        this.mDescriptor = descriptor;
    }

    private SerializerMaker make() {
        if (!Modifier.isPublic(this.mType.getModifiers())) {
            throw new IllegalArgumentException("Not public: " + this.mType.getName());
        }
        if (this.mType.isRecord()) {
            this.makeForRecord();
        } else if (this.mType.isEnum()) {
            this.makeForEnum();
        } else {
            this.makeForClass();
        }
        this.mEffectiveDescriptor = this.mDescriptorBuilder.toString().intern();
        return this;
    }

    private Serializer finish() {
        this.mMaker.addMethod(Object.class, "descriptor", new Object[0]).public_().return_((Object)this.mEffectiveDescriptor);
        MethodMaker mm = this.mMaker.addMethod(Serializer.class, "adapt", new Object[]{Object.class}).public_();
        mm.return_((Object)mm.var(SerializerMaker.class).invoke("adapt", new Object[]{mm.this_(), this.mType, mm.param(0)}));
        MethodHandles.Lookup lookup = this.mMaker.finishLookup();
        try {
            return lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    private void makeForRecord() {
        Constructor<?> ctor;
        RecordComponent[] components = this.mType.getRecordComponents();
        Class[] paramTypes = (Class[])Arrays.stream(components).map(RecordComponent::getType).toArray(Class[]::new);
        try {
            ctor = this.mType.getDeclaredConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        if (!Modifier.isPublic(ctor.getModifiers())) {
            throw new IllegalArgumentException("No public constructor: " + this.mType.getName());
        }
        for (RecordComponent comp : components) {
            if (Modifier.isPublic(comp.getAccessor().getModifiers())) continue;
            throw new IllegalArgumentException("Not public: " + this.mType.getName() + "." + comp.getName());
        }
        TreeMap<RecordComponent, Integer> componentMap = new TreeMap<RecordComponent, Integer>(Comparator.comparing(RecordComponent::getName));
        for (int i = 0; i < components.length; ++i) {
            componentMap.put(components[i], i);
        }
        this.begin();
        this.mDescriptorMap = SerializerMaker.parseDescriptorMap(this.mDescriptor);
        Variable[] readParamVars = new Variable[components.length];
        for (Map.Entry e : componentMap.entrySet()) {
            RecordComponent comp = e.getKey();
            int i = (Integer)e.getValue();
            readParamVars[i] = this.mReadMaker.var((Object)paramTypes[i]);
            if (this.shouldSkip(comp)) {
                readParamVars[i].clear();
                continue;
            }
            String name = comp.getName();
            CoreUtils.writeParam(this.mWritePipeVar, this.mWriteObjectVar.invoke(name, new Object[0]));
            CoreUtils.readParam(this.mReadPipeVar, readParamVars[i]);
            this.appendToDescriptor(name, comp.getType());
        }
        this.mReadMaker.return_((Object)this.mReadMaker.new_(this.mType, (Object[])readParamVars));
    }

    private void makeForClass() {
        try {
            this.mType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No public no-arg constructor: " + this.mType.getName());
        }
        Field[] fields = this.mType.getFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if (!Modifier.isStatic(mods) && !Modifier.isTransient(mods)) continue;
            fields[i] = null;
        }
        this.begin();
        this.mDescriptorMap = SerializerMaker.parseDescriptorMap(this.mDescriptor);
        Variable readObjectVar = this.mReadMaker.new_(this.mType, new Object[0]);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field == null || this.shouldSkip(field)) continue;
            String name = field.getName();
            CoreUtils.writeParam(this.mWritePipeVar, (Variable)this.mWriteObjectVar.field(name));
            CoreUtils.readParam(this.mReadPipeVar, (Variable)readObjectVar.field(name));
            this.appendToDescriptor(name, field.getType());
        }
        this.mReadMaker.var(VarHandle.class).invoke("storeStoreFence", new Object[0]);
        this.mReadMaker.return_((Object)readObjectVar);
    }

    private void makeForEnum() {
        int i;
        Enum[] enums = (Enum[])this.mType.getEnumConstants();
        if (this.mDescriptor != null) {
            LinkedHashMap<String, Enum> supported = new LinkedHashMap<String, Enum>(enums.length * 2);
            for (Enum e : enums) {
                supported.put(e.name(), e);
            }
            String[] split = this.mDescriptor.split(";");
            HashSet retain = new HashSet(split.length * 2);
            Collections.addAll(retain, split);
            supported.keySet().retainAll(retain);
            enums = (Enum[])supported.values().toArray(Enum[]::new);
        }
        this.begin();
        int[] writeCases = new int[enums.length];
        Label[] writeLabels = new Label[enums.length];
        for (int i2 = 0; i2 < enums.length; ++i2) {
            writeCases[i2] = enums[i2].ordinal();
            writeLabels[i2] = this.mWriteMaker.label();
        }
        Enum[] sortedEnums = (Enum[])enums.clone();
        Comparator<Enum> cmp = Comparator.comparing(Enum::name);
        Arrays.sort(sortedEnums, cmp);
        int[] readCases = new int[sortedEnums.length];
        Label[] readLabels = new Label[sortedEnums.length];
        for (int i3 = 0; i3 < sortedEnums.length; ++i3) {
            Enum e = sortedEnums[i3];
            readCases[i3] = i3 + 1;
            readLabels[i3] = this.mReadMaker.label();
            if (!this.mDescriptorBuilder.isEmpty()) {
                this.mDescriptorBuilder.append(';');
            }
            this.mDescriptorBuilder.append(e.name());
        }
        Label unknown = this.mWriteMaker.label();
        this.mWriteObjectVar.invoke("ordinal", new Object[0]).switch_(unknown, writeCases, writeLabels);
        Variable numberVar = this.mWriteMaker.var(Integer.TYPE);
        Label doWrite = this.mWriteMaker.label();
        for (i = 0; i < enums.length; ++i) {
            writeLabels[i].here();
            numberVar.set((Object)(Arrays.binarySearch(sortedEnums, enums[i], cmp) + 1));
            doWrite.goto_();
        }
        unknown.here();
        numberVar.set((Object)0);
        doWrite.here();
        CoreUtils.writeIntId(this.mWritePipeVar, enums.length, numberVar);
        Variable numberVar2 = CoreUtils.readIntId(this.mReadPipeVar, enums.length);
        Label end = this.mReadMaker.label();
        numberVar2.switch_(end, readCases, readLabels);
        Variable typeVar = this.mReadMaker.var(this.mType);
        for (i = 0; i < sortedEnums.length; ++i) {
            readLabels[i].here();
            this.mReadMaker.return_((Object)typeVar.field(sortedEnums[i].name()));
        }
        end.here();
        this.mReadMaker.return_(null);
    }

    private void begin() {
        Object name = this.mType.getName();
        if (((String)name).startsWith("java.")) {
            name = "$" + (String)name;
        }
        ClassMaker cm = ClassMaker.begin((String)name, (ClassLoader)this.mType.getClassLoader(), (Object)CoreUtils.MAKER_KEY).implement(Serializer.class);
        Class<?> thisClass = this.getClass();
        Module thisModule = thisClass.getModule();
        Module thatModule = cm.classLoader().getUnnamedModule();
        thisModule.addExports(thisClass.getPackageName(), thatModule);
        cm.addConstructor(new Object[0]);
        MethodMaker mm = cm.addMethod(Set.class, "supportedTypes", new Object[0]).public_();
        mm.return_((Object)mm.var(Set.class).invoke("of", new Object[]{this.mType}));
        this.mMaker = cm;
        this.mWriteMaker = this.mMaker.addMethod(null, "write", new Object[]{Pipe.class, Object.class}).public_();
        this.mWritePipeVar = this.mWriteMaker.param(0);
        this.mWriteObjectVar = this.mWriteMaker.param(1).cast(this.mType);
        this.mReadMaker = this.mMaker.addMethod(Object.class, "read", new Object[]{Pipe.class}).public_();
        this.mReadPipeVar = this.mReadMaker.param(0);
        this.mDescriptorBuilder = new StringBuilder();
    }

    private boolean shouldSkip(RecordComponent comp) {
        Map<String, String> descMap = this.mDescriptorMap;
        if (descMap != null) {
            String desc = descMap.get(comp.getName());
            return desc == null || !desc.equals(comp.getType().descriptorString());
        }
        return false;
    }

    private boolean shouldSkip(Field field) {
        Map<String, String> descMap = this.mDescriptorMap;
        if (descMap != null) {
            String desc = descMap.get(field.getName());
            return desc == null || !desc.equals(field.getType().descriptorString());
        }
        return false;
    }

    private void appendToDescriptor(String name, Class<?> type) {
        this.mDescriptorBuilder.append(name).append(';').append(type.descriptorString());
    }

    private static Map<String, String> parseDescriptorMap(String descriptor) {
        int ix2;
        if (descriptor == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int ix = 0;
        while ((ix2 = descriptor.indexOf(59, ix)) >= 0) {
            char c;
            String name = descriptor.substring(ix, ix2);
            ix2 = ix = ix2 + 1;
            while ((c = descriptor.charAt(ix2)) == '[') {
                ++ix2;
            }
            ix2 = c == 'L' ? descriptor.indexOf(59, ix2 + 1) + 1 : ++ix2;
            String desc = descriptor.substring(ix, ix2);
            map.put(name, desc);
            ix = ix2;
        }
        return map;
    }

    private record WithDescriptor(Class<?> type, String descriptor) {
    }
}

