/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.concurrent.locks.LockSupport;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.core.CorePipe;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.Engine;
import org.cojen.dirmi.core.IdGenerator;
import org.cojen.dirmi.core.Item;
import org.cojen.dirmi.core.Settings;
import org.cojen.dirmi.core.Skeleton;

final class ServerSession<R>
extends CoreSession<R> {
    private final Skeleton<R> mRoot;
    private final long mReverseId = IdGenerator.nextPositive();
    private ConnectWaiter mFirstWaiter;
    private ConnectWaiter mLastWaiter;

    ServerSession(Engine engine, Settings settings, R root, CorePipe pipe) throws RemoteException {
        super(engine, settings);
        this.registerNewConnection(pipe);
        this.controlPipe(pipe);
        this.mSkeletons.put(new Connector(this.mReverseId));
        this.mRoot = this.mSkeletons.skeletonFor(root);
        this.mKnownTypes.put(new Item(this.mRoot.typeId()));
    }

    void writeHeader(Pipe pipe, long clientSessionId) throws IOException {
        pipe.writeLong(4052788960387224692L);
        pipe.writeLong(clientSessionId);
        pipe.writeLong(this.id);
        pipe.writeLong(this.mRoot.id);
        pipe.writeLong(this.mRoot.typeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean close(int reason, CorePipe controlPipe) {
        ConnectWaiter waiter;
        boolean justClosed = super.close(reason, null);
        this.mEngine.removeSession(this);
        this.conLockAcquire();
        try {
            waiter = this.mFirstWaiter;
            this.mFirstWaiter = null;
            this.mLastWaiter = null;
        }
        finally {
            this.conLockRelease();
        }
        while (waiter != null) {
            waiter.unpark();
            waiter = waiter.mNext;
        }
        return justClosed;
    }

    @Override
    public R root() {
        return this.mRoot.server();
    }

    @Override
    public void connected(SocketAddress localAddr, SocketAddress remoteAttr, InputStream in, OutputStream out) {
        throw new UnsupportedOperationException();
    }

    void accepted(CorePipe pipe) throws IOException {
        if (this.mState == null) {
            this.mStateLock.lock();
            this.mStateLock.unlock();
        }
        pipe.initTypeCodeMap(this.mTypeCodeMap);
        this.registerNewConnection(pipe);
        this.startRequestProcessor(pipe);
    }

    @Override
    void registerNewAvailableConnection(CorePipe pipe, long sessionId) throws RemoteException {
        super.registerNewAvailableConnection(pipe, sessionId);
        this.notifyConnectWaiter();
    }

    @Override
    boolean recycleConnection(CorePipe pipe) {
        if (super.recycleConnection(pipe)) {
            this.notifyConnectWaiter();
            return true;
        }
        return false;
    }

    private void notifyConnectWaiter() {
        ConnectWaiter waiter;
        this.conLockAcquire();
        try {
            ConnectWaiter next;
            waiter = this.mFirstWaiter;
            if (waiter == null) {
                return;
            }
            this.mFirstWaiter = next = waiter.mNext;
            if (next == null) {
                this.mLastWaiter = null;
            }
        }
        finally {
            this.conLockRelease();
        }
        waiter.unpark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CorePipe connect() throws IOException {
        ConnectWaiter waiter = null;
        CorePipe pipe;
        while ((pipe = this.tryObtainConnection()) == null) {
            this.mControlLock.lock();
            try {
                CorePipe controlPipe = this.controlPipe();
                controlPipe.write(5);
                controlPipe.writeLong(this.mReverseId);
                controlPipe.flush();
            }
            finally {
                this.mControlLock.unlock();
            }
            if (waiter == null || waiter.mUnparked) {
                waiter = new ConnectWaiter(Thread.currentThread());
                this.conLockAcquire();
                try {
                    ConnectWaiter last = this.mLastWaiter;
                    if (last == null) {
                        this.mFirstWaiter = waiter;
                    } else {
                        last.mNext = waiter;
                    }
                    this.mLastWaiter = waiter;
                }
                finally {
                    this.conLockRelease();
                }
            }
            if (this.hasAvailableConnection()) {
                this.notifyConnectWaiter();
            }
            LockSupport.park();
        }
        return pipe;
    }

    static {
        Class<LockSupport> clazz = LockSupport.class;
    }

    private final class Connector
    extends Skeleton {
        Connector(long id) {
            super(id);
        }

        public Class type() {
            return Connector.class;
        }

        @Override
        public long typeId() {
            return 0L;
        }

        public Object server() {
            return this;
        }

        @Override
        public Object invoke(Pipe pipe, Object context) {
            CorePipe cp = (CorePipe)pipe;
            cp.mMode = 1;
            ServerSession.this.recycleConnection(cp);
            return Skeleton.STOP_READING;
        }
    }

    private static final class ConnectWaiter {
        final Thread mThread;
        ConnectWaiter mNext;
        volatile boolean mUnparked;

        ConnectWaiter(Thread thread) {
            this.mThread = thread;
        }

        void unpark() {
            this.mUnparked = true;
            LockSupport.unpark(this.mThread);
        }
    }
}

