/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cojen.dirmi.ClassResolver;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Serializer;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.TypeCodeMap;

final class Settings
implements Cloneable {
    int reconnectDelayMillis = 1000;
    int pingTimeoutMillis = 2000;
    int idleConnectionMillis = 60000;
    ClassResolver resolver;
    LinkedHashMap<Class<?>, Serializer> serializers;

    Settings() {
    }

    Settings copy() {
        try {
            return (Settings)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw CoreUtils.rethrow(e);
        }
    }

    Settings withReconnectDelayMillis(int millis) {
        Settings settings = this.copy();
        settings.reconnectDelayMillis = millis;
        return settings;
    }

    Settings withPingTimeoutMillis(int millis) {
        Settings settings = this.copy();
        settings.pingTimeoutMillis = millis;
        return settings;
    }

    Settings withIdleConnectionMillis(int millis) {
        Settings settings = this.copy();
        settings.idleConnectionMillis = millis;
        return settings;
    }

    Settings withClassResolver(ClassResolver resolver) {
        Settings settings = this.copy();
        settings.resolver = resolver;
        return settings;
    }

    Settings withSerializers(LinkedHashMap<Class<?>, Serializer> serializers) {
        Settings settings = this.copy();
        settings.serializers = serializers;
        return settings;
    }

    LinkedHashMap<String, Object> writeSerializerTypes(Pipe pipe) throws IOException {
        if (this.serializers == null || this.serializers.isEmpty()) {
            pipe.writeByte(0);
            return null;
        }
        int size = this.serializers.size();
        LinkedHashMap<String, Object> typeMap = new LinkedHashMap<String, Object>(size * 2);
        pipe.writeByte(55);
        pipe.writeInt(size);
        for (Map.Entry<Class<?>, Serializer> e : this.serializers.entrySet()) {
            String name = e.getKey().getName();
            Object descriptor = e.getValue().descriptor();
            typeMap.put(name, descriptor);
            pipe.writeObject(name);
            pipe.writeObject(descriptor);
        }
        return typeMap;
    }

    static LinkedHashMap<String, Object> readSerializerTypes(Pipe pipe) throws IOException {
        int size = pipe.readInt();
        LinkedHashMap<String, Object> typeMap = new LinkedHashMap<String, Object>(size * 2);
        for (int i = 0; i < size; ++i) {
            String name = (String)pipe.readObject();
            Object descriptor = pipe.readObject();
            typeMap.put(name, descriptor);
        }
        return typeMap;
    }

    TypeCodeMap mergeSerializerTypes(int typeCode, LinkedHashMap<String, Object> localCustomTypes, LinkedHashMap<String, Object> remoteCustomTypes) {
        if (Settings.isEmpty(localCustomTypes) && Settings.isEmpty(remoteCustomTypes)) {
            return TypeCodeMap.STANDARD;
        }
        HashMap<String, ClassSerializer> available = new HashMap<String, ClassSerializer>();
        for (Map.Entry<Class<?>, Serializer> e : this.serializers.entrySet()) {
            Serializer serializer;
            Class<?> clazz = e.getKey();
            String name = clazz.getName();
            if (Settings.containsKey(localCustomTypes, name) && Settings.containsKey(remoteCustomTypes, name)) {
                serializer = e.getValue();
                serializer = serializer.adapt(remoteCustomTypes.get(name));
            } else {
                serializer = null;
            }
            available.put(name, new ClassSerializer(clazz, serializer));
        }
        LinkedHashMap<Object, Serializer> merged = new LinkedHashMap<Object, Serializer>();
        Settings.putAll(localCustomTypes, merged, available);
        Settings.putAll(remoteCustomTypes, merged, available);
        typeCode = Math.max(typeCode, 55);
        return TypeCodeMap.find(typeCode, merged);
    }

    private static boolean isEmpty(LinkedHashMap<?, ?> map) {
        return map == null || map.isEmpty();
    }

    private static boolean containsKey(LinkedHashMap<?, ?> map, Object key) {
        return map != null && map.containsKey(key);
    }

    private static void putAll(LinkedHashMap<String, Object> src, LinkedHashMap<Object, Serializer> dst, Map<String, ClassSerializer> available) {
        if (src != null) {
            for (Map.Entry<String, Object> e : src.entrySet()) {
                String name = e.getKey();
                if (available == null || !available.containsKey(name)) {
                    dst.put(name, null);
                    continue;
                }
                ClassSerializer cs = available.get(name);
                dst.put(cs.clazz, cs.serializer);
            }
        }
    }

    private record ClassSerializer(Class clazz, Serializer serializer) {
    }
}

