/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.core.Item;

public abstract class Skeleton<R>
extends Item {
    public static final Object STOP_READING = new Object();
    private static final Object BATCHING = new Object();
    private final Throwable mException;

    public Skeleton(long id) {
        super(id);
        this.mException = null;
    }

    public Skeleton(Throwable exception, long id) {
        super(id);
        this.mException = exception;
    }

    public abstract Class<R> type();

    public abstract long typeId();

    public abstract R server();

    public abstract Object invoke(Pipe var1, Object var2) throws Throwable;

    public final Throwable checkException(Throwable exception) {
        return this.mException == null ? exception : this.mException;
    }

    public static void batchedResultCheck(Object server, String methodName, Object result) {
        if (result == null) {
            Skeleton.nullBatchedResult(server, methodName);
        }
    }

    private static void nullBatchedResult(Object server, String methodName) {
        String message = "Cannot return null from a batched method: " + server.getClass().getName() + "." + methodName;
        throw new IllegalStateException(message);
    }

    public static Throwable batchException(Object context) {
        return context instanceof Throwable ? (Throwable)context : null;
    }

    public static Object batchInvokeSuccess(Object context) {
        return context == null ? BATCHING : context;
    }

    public static Object batchInvokeFailure(Pipe pipe, Object context, Throwable exception) {
        pipe.enableReferences();
        return exception;
    }

    public static int batchFinish(Pipe pipe, Object context) throws IOException {
        if (context == null) {
            return -1;
        }
        if (context instanceof Throwable) {
            pipe.writeObject(context);
            pipe.disableReferences();
            return 1;
        }
        pipe.writeNull();
        return 0;
    }
}

