/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.ObjectInputFilter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.UnimplementedException;
import org.cojen.dirmi.core.CoreObjectInputStream;
import org.cojen.dirmi.core.CoreObjectOutputStream;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.IdGenerator;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.RemoteMethod;
import org.cojen.dirmi.core.Skeleton;
import org.cojen.dirmi.core.SkeletonFactory;
import org.cojen.dirmi.core.SkeletonSupport;
import org.cojen.dirmi.core.SoftCache;
import org.cojen.dirmi.core.UncaughtException;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;

final class SkeletonMaker<R> {
    private static final SoftCache<Class<?>, SkeletonFactory<?>> cCache = new SoftCache();
    private final Class<R> mType;
    private final long mTypeId;
    private final RemoteInfo mServerInfo;
    private final ClassMaker mFactoryMaker;
    private final ClassMaker mSkeletonMaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R> SkeletonFactory<R> factoryFor(Class<R> type) {
        SkeletonFactory<Object> factory = cCache.get(type);
        if (factory == null) {
            SoftCache<Class<?>, SkeletonFactory<?>> softCache = cCache;
            synchronized (softCache) {
                factory = cCache.get(type);
                if (factory == null) {
                    factory = new SkeletonMaker<R>(type).finishFactory();
                    cCache.put(type, factory);
                }
            }
        }
        return factory;
    }

    private SkeletonMaker(Class<R> type) {
        this.mType = type;
        this.mServerInfo = RemoteInfo.examine(type);
        this.mTypeId = IdGenerator.next();
        String sourceFile = SkeletonMaker.class.getSimpleName();
        this.mFactoryMaker = ClassMaker.begin((String)type.getName(), (ClassLoader)type.getClassLoader(), (Object)CoreUtils.MAKER_KEY).implement(SkeletonFactory.class).final_().sourceFile(sourceFile);
        CoreUtils.allowAccess(this.mFactoryMaker);
        this.mSkeletonMaker = this.mFactoryMaker.another(type.getName()).extend(Skeleton.class).final_().sourceFile(sourceFile);
        this.mSkeletonMaker.addField(SkeletonSupport.class, "support").private_().final_();
        this.mSkeletonMaker.addField(this.mType, "server").private_().final_();
        MethodMaker mm = this.mSkeletonMaker.addConstructor(new Object[]{Long.TYPE, SkeletonSupport.class, this.mType});
        mm.invokeSuperConstructor(new Object[]{mm.param(0)});
        mm.field("support").set((Object)mm.param(1));
        mm.field("server").set((Object)mm.param(2));
        mm = this.mSkeletonMaker.addConstructor(new Object[]{Throwable.class, Long.TYPE, SkeletonSupport.class});
        mm.invokeSuperConstructor(new Object[]{mm.param(0), mm.param(1)});
        mm.field("support").set((Object)mm.param(2));
        mm.field("server").set(null);
    }

    private SkeletonFactory<R> finishFactory() {
        this.mFactoryMaker.addConstructor(new Object[0]);
        this.mFactoryMaker.addMethod(Long.TYPE, "typeId", new Object[0]).public_().return_((Object)this.mTypeId);
        MethodMaker mm = this.mFactoryMaker.addMethod(Skeleton.class, "newSkeleton", new Object[]{Long.TYPE, SkeletonSupport.class, Object.class});
        Variable skel = mm.new_((Object)this.mSkeletonMaker, new Object[]{mm.param(0), mm.param(1), mm.param(2).cast(this.mType)});
        mm.public_().return_((Object)skel);
        mm = this.mFactoryMaker.addMethod(Skeleton.class, "newSkeleton", new Object[]{Throwable.class, Long.TYPE, SkeletonSupport.class});
        skel = mm.new_((Object)this.mSkeletonMaker, new Object[]{mm.param(0), mm.param(1), mm.param(2)});
        mm.public_().return_((Object)skel);
        this.mFactoryMaker.finish();
        this.mSkeletonMaker.addField(SkeletonFactory.class, "factory").private_().static_().final_();
        mm = this.mSkeletonMaker.addClinit();
        mm.field("factory").set((Object)mm.new_((Object)this.mFactoryMaker, new Object[0]));
        MethodHandles.Lookup skeletonLookup = this.finishSkeleton();
        Class<?> skeletonClass = skeletonLookup.lookupClass();
        try {
            MethodHandle mh = skeletonLookup.findStaticGetter(skeletonClass, "factory", SkeletonFactory.class);
            return mh.invokeExact();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    private MethodHandles.Lookup finishSkeleton() {
        this.mSkeletonMaker.addMethod(Class.class, "type", new Object[0]).public_().return_(this.mType);
        this.mSkeletonMaker.addMethod(Long.TYPE, "typeId", new Object[0]).public_().return_((Object)this.mTypeId);
        MethodMaker mm = this.mSkeletonMaker.addMethod(this.mType, "server", new Object[0]).public_();
        mm.return_((Object)mm.field("server"));
        mm = this.mSkeletonMaker.addMethod(Object.class, "server", new Object[0]).public_().bridge();
        mm.return_((Object)mm.this_().invoke(this.mType, "server", null, new Object[0]));
        Map<Integer, CaseInfo> caseMap = this.defineInvokers();
        MethodMaker mm2 = this.mSkeletonMaker.addMethod(Object.class, "invoke", new Object[]{Pipe.class, Object.class}).public_();
        Variable pipeVar = mm2.param(0);
        Variable contextVar = mm2.param(1);
        Variable methodIdVar = CoreUtils.readIntId(pipeVar, caseMap.size());
        int[] cases = new int[caseMap.size()];
        Label[] labels = new Label[cases.length];
        int i = 0;
        for (Integer methodId : caseMap.keySet()) {
            cases[i] = methodId;
            labels[i] = mm2.label();
            ++i;
        }
        Field supportVar = mm2.field("support");
        Label noMethodLabel = mm2.label();
        methodIdVar.switch_(noMethodLabel, cases, labels);
        for (int i2 = 0; i2 < cases.length; ++i2) {
            labels[i2].here();
            CaseInfo ci = caseMap.get(cases[i2]);
            if (!ci.serverMethod.isDisposer()) {
                mm2.return_((Object)ci.invoke(mm2, pipeVar, contextVar, (Variable)supportVar));
                continue;
            }
            Label invokeStart = mm2.label().here();
            mm2.return_((Object)ci.invoke(mm2, pipeVar, contextVar, (Variable)supportVar));
            mm2.finally_(invokeStart, () -> supportVar.invoke("dispose", new Object[]{mm2.this_()}));
        }
        noMethodLabel.here();
        Variable typeNameVar = mm2.var(Class.class).set(this.mType).invoke("getName", new Object[0]);
        Variable messageVar = mm2.concat(new Object[]{typeNameVar, Character.valueOf('#'), methodIdVar});
        mm2.new_(UnimplementedException.class, new Object[]{messageVar}).throw_();
        return this.mSkeletonMaker.finishLookup();
    }

    private Map<Integer, CaseInfo> defineInvokers() {
        SortedSet<RemoteMethod> serverMethods = this.mServerInfo.remoteMethods();
        if (serverMethods.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> methodNames = new HashMap<String, Integer>();
        HashMap<Integer, CaseInfo> caseMap = new HashMap<Integer, CaseInfo>();
        int methodId = 0;
        for (RemoteMethod rm : serverMethods) {
            Variable batchResultVar;
            Variable supportVar;
            Variable exVar;
            Variable supportVar2;
            Label invokeEnd;
            Variable resultVar;
            Variable serverVar;
            Label invokeStart;
            boolean isPiped;
            String name = SkeletonMaker.generateMethodName(methodNames, rm);
            caseMap.put(methodId++, new CaseInfo(rm, name));
            MethodMaker mm = !SkeletonMaker.needsSupport(rm) ? this.mSkeletonMaker.addMethod(Object.class, name, new Object[]{Pipe.class, Object.class}) : this.mSkeletonMaker.addMethod(Object.class, name, new Object[]{Pipe.class, Object.class, SkeletonSupport.class});
            mm.private_();
            Variable pipeVar = mm.param(0);
            Variable contextVar = mm.param(1);
            List<String> paramTypes = rm.parameterTypes();
            Variable[] paramVars = new Variable[paramTypes.size()];
            boolean findPipe = isPiped = rm.isPiped();
            if (paramVars.length > 0) {
                Variable inVar = pipeVar;
                if (rm.isSerialized() && CoreUtils.anyObjectTypes(paramTypes)) {
                    inVar = mm.new_(CoreObjectInputStream.class, new Object[]{pipeVar});
                    ObjectInputFilter filter = rm.objectInputFilter();
                    Variable filterVar = mm.var(ObjectInputFilter.class).setExact((Object)filter);
                    inVar.invoke("setObjectInputFilter", new Object[]{filterVar});
                }
                for (int i = 0; i < paramVars.length; ++i) {
                    Variable paramVar = mm.var((Object)paramTypes.get(i));
                    if (findPipe && paramVar.classType() == Pipe.class) {
                        paramVar = pipeVar;
                        findPipe = false;
                    } else {
                        CoreUtils.readParam(inVar, paramVar);
                    }
                    paramVars[i] = paramVar;
                }
            }
            Variable aliasIdVar = null;
            if (rm.isBatched() && !rm.returnType().equals("V")) {
                aliasIdVar = pipeVar.invoke("readLong", new Object[0]);
            }
            if (rm.isBatched() && !rm.isBatchedImmediate()) {
                Variable exceptionVar = mm.invoke("batchException", new Object[]{contextVar});
                invokeStart = mm.label();
                Label skip = mm.label();
                if (aliasIdVar == null) {
                    skip = mm.label();
                    exceptionVar.ifNe(null, skip);
                } else {
                    exceptionVar.ifEq(null, invokeStart);
                    Variable supportVar3 = mm.param(2);
                    Class returnType = mm.var((Object)rm.returnType()).classType();
                    supportVar3.invoke("createBrokenSkeletonAlias", new Object[]{returnType, aliasIdVar, exceptionVar});
                    mm.goto_(skip);
                }
                invokeStart.here();
                serverVar = mm.field("server").get();
                resultVar = serverVar.invoke(rm.name(), (Object[])paramVars);
                if (resultVar != null) {
                    mm.invoke("batchedResultCheck", new Object[]{serverVar, rm.name(), resultVar});
                }
                invokeEnd = mm.label().here();
                if (resultVar != null) {
                    supportVar2 = mm.param(2);
                    supportVar2.invoke("createSkeletonAlias", new Object[]{resultVar, aliasIdVar});
                }
                contextVar.set((Object)mm.invoke("batchInvokeSuccess", new Object[]{contextVar}));
                skip.here();
                mm.return_((Object)contextVar);
                exVar = mm.catch_(invokeStart, invokeEnd, Throwable.class);
                this.checkException(exVar);
                contextVar.set((Object)mm.invoke("batchInvokeFailure", new Object[]{pipeVar, contextVar, exVar}));
                if (aliasIdVar != null) {
                    supportVar = mm.param(2);
                    supportVar.invoke("createBrokenSkeletonAlias", new Object[]{resultVar.classType(), aliasIdVar, exVar});
                }
                mm.return_((Object)contextVar);
                continue;
            }
            if (isPiped) {
                batchResultVar = mm.invoke("batchFinish", new Object[]{pipeVar, contextVar});
                invokeStart = mm.label();
                batchResultVar.ifLt((Object)0, invokeStart);
                pipeVar.invoke("flush", new Object[0]);
                batchResultVar.ifEq((Object)0, invokeStart);
                mm.return_(null);
                invokeStart.here();
                mm.field("server").invoke(rm.name(), (Object[])paramVars);
                Label invokeEnd2 = mm.label().here();
                mm.return_((Object)mm.field("STOP_READING"));
                Variable exVar2 = mm.catch_(invokeStart, invokeEnd2, Throwable.class);
                this.checkException(exVar2);
                mm.new_(UncaughtException.class, new Object[]{exVar2}).throw_();
                continue;
            }
            batchResultVar = mm.invoke("batchFinish", new Object[]{pipeVar, contextVar});
            invokeStart = mm.label();
            Label finished = mm.label();
            if (rm.isNoReply()) {
                batchResultVar.ifLt((Object)0, invokeStart);
                pipeVar.invoke("flush", new Object[0]);
                batchResultVar.ifNe((Object)0, finished);
            } else {
                batchResultVar.ifGt((Object)0, finished);
            }
            invokeStart.here();
            serverVar = mm.field("server").get();
            resultVar = serverVar.invoke(rm.name(), (Object[])paramVars);
            if (resultVar != null && rm.isBatchedImmediate()) {
                mm.invoke("batchedResultCheck", new Object[]{serverVar, rm.name(), resultVar});
            }
            invokeEnd = mm.label().here();
            if (rm.isNoReply()) {
                finished.here();
            } else {
                pipeVar.invoke("writeNull", new Object[0]);
                if (rm.isBatchedImmediate()) {
                    supportVar2 = mm.param(2);
                    supportVar2.invoke("writeSkeletonAlias", new Object[]{pipeVar, resultVar, aliasIdVar});
                } else if (resultVar != null) {
                    Variable outVar = pipeVar;
                    if (rm.isSerialized() && CoreUtils.isObjectType(resultVar)) {
                        outVar = mm.new_(CoreObjectOutputStream.class, new Object[]{pipeVar});
                    }
                    CoreUtils.writeParam(outVar, resultVar);
                    if (outVar != pipeVar) {
                        outVar.invoke("drain", new Object[0]);
                    }
                }
                finished.here();
                pipeVar.invoke("flush", new Object[0]);
            }
            if (!rm.isBatchedImmediate()) {
                mm.return_(null);
            } else {
                mm.return_((Object)mm.invoke("batchInvokeSuccess", new Object[]{null}));
            }
            exVar = mm.catch_(invokeStart, invokeEnd, Throwable.class);
            this.checkException(exVar);
            if (rm.isNoReply()) {
                supportVar = mm.param(2);
                supportVar.invoke("uncaught", new Object[]{exVar});
            } else {
                if (rm.isBatchedImmediate()) {
                    pipeVar.invoke("writeNull", new Object[0]);
                    supportVar = mm.param(2);
                    supportVar.invoke("writeBrokenSkeletonAlias", new Object[]{pipeVar, resultVar.classType(), aliasIdVar, exVar});
                } else {
                    pipeVar.invoke("writeObject", new Object[]{exVar});
                }
                pipeVar.invoke("flush", new Object[0]);
            }
            mm.return_(null);
        }
        return caseMap;
    }

    private void checkException(Variable exVar) {
        exVar.set((Object)exVar.methodMaker().invoke("checkException", new Object[]{exVar}));
    }

    private static boolean needsSupport(RemoteMethod rm) {
        return rm.isNoReply() || rm.isBatched() && !rm.returnType().equals("V");
    }

    private static String generateMethodName(Map<String, Integer> methodNames, RemoteMethod rm) {
        Object name = rm.name();
        while (true) {
            Integer count;
            if ((count = methodNames.get(name)) == null) {
                methodNames.put((String)name, 1);
                return name;
            }
            methodNames.put((String)name, count + 1);
            name = (String)name + "$" + count;
        }
    }

    private record CaseInfo(RemoteMethod serverMethod, String serverMethodName) {
        Variable invoke(MethodMaker mm, Variable pipeVar, Variable contextVar, Variable supportVar) {
            if (!SkeletonMaker.needsSupport(this.serverMethod)) {
                return mm.invoke(this.serverMethodName, new Object[]{pipeVar, contextVar});
            }
            return mm.invoke(this.serverMethodName, new Object[]{pipeVar, contextVar, supportVar});
        }
    }
}

