/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.cojen.dirmi.SessionAware;
import org.cojen.dirmi.core.CoreSession;
import org.cojen.dirmi.core.IdGenerator;
import org.cojen.dirmi.core.ItemMap;
import org.cojen.dirmi.core.RemoteExaminer;
import org.cojen.dirmi.core.Skeleton;
import org.cojen.dirmi.core.SkeletonFactory;
import org.cojen.dirmi.core.SkeletonMaker;

final class SkeletonMap
extends ItemMap<Skeleton> {
    private final CoreSession mSession;
    private Entry[] mEntries;
    private int mSize;

    SkeletonMap(CoreSession session) {
        this.mSession = session;
        this.mEntries = new Entry[8];
    }

    @Override
    synchronized void clear() {
        super.clear();
        Object[] entries = this.mEntries;
        for (int i = 0; i < entries.length; ++i) {
            Entry e = entries[i];
            while (e != null) {
                Object skeletonOrLatch = e.mSkeletonOrLatch;
                if (skeletonOrLatch instanceof CountDownLatch) {
                    ((CountDownLatch)skeletonOrLatch).countDown();
                }
                e = e.mNext;
            }
        }
        Arrays.fill(entries, null);
        this.mSize = 0;
    }

    @Override
    synchronized Skeleton remove(long id) {
        Skeleton skeleton = (Skeleton)super.remove(id);
        if (id >= 0L && skeleton != null) {
            this.removeServer(skeleton.server());
        }
        return skeleton;
    }

    <R> Skeleton<R> skeletonFor(R server) {
        return this.skeletonFor(server, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> Skeleton<R> skeletonFor(R server, boolean make) {
        int hash = System.identityHashCode(server);
        while (true) {
            Entry entry;
            block22: {
                CountDownLatch latch;
                Entry[] entries = this.mEntries;
                Entry e = entries[hash & entries.length - 1];
                while (e != null) {
                    if (e.mServer == server) {
                        entry = e;
                        break block22;
                    }
                    e = e.mNext;
                }
                SkeletonMap skeletonMap = this;
                synchronized (skeletonMap) {
                    entries = this.mEntries;
                    int slot = hash & entries.length - 1;
                    Entry e2 = entries[slot];
                    while (e2 != null) {
                        if (e2.mServer == server) {
                            entry = e2;
                            break block22;
                        }
                        e2 = e2.mNext;
                    }
                    if (!make) {
                        return null;
                    }
                    int size = this.mSize;
                    if (size + (size >> 1) >= entries.length && this.grow()) {
                        entries = this.mEntries;
                        slot = hash & entries.length - 1;
                    }
                    latch = new CountDownLatch(1);
                    entry = new Entry(server, latch);
                    entry.mNext = entries[slot];
                    VarHandle.storeStoreFence();
                    entries[slot] = entry;
                    this.mSize = size + 1;
                }
                try {
                    Class<?> type = RemoteExaminer.remoteType(server);
                    SkeletonFactory<?> factory = SkeletonMaker.factoryFor(type);
                    long id = IdGenerator.nextPositive();
                    Skeleton<?> skeleton = factory.newSkeleton(id, this.mSession.mSkeletonSupport, server);
                    if (server instanceof SessionAware) {
                        SessionAware sa = (SessionAware)server;
                        this.mSession.attachNotify(sa);
                    }
                    VarHandle.storeStoreFence();
                    super.put(skeleton);
                    entry.mSkeletonOrLatch = skeleton;
                    Skeleton<?> skeleton2 = skeleton;
                    return skeleton2;
                }
                catch (Throwable e3) {
                    SkeletonMap skeletonMap2 = this;
                    synchronized (skeletonMap2) {
                        this.removeServer(server);
                    }
                    throw e3;
                }
                finally {
                    latch.countDown();
                }
            }
            Object skeletonOrLatch = entry.mSkeletonOrLatch;
            if (skeletonOrLatch instanceof Skeleton) {
                return (Skeleton)skeletonOrLatch;
            }
            try {
                ((CountDownLatch)skeletonOrLatch).await();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void removeServer(Object server) {
        Entry[] entries = this.mEntries;
        int slot = System.identityHashCode(server) & entries.length - 1;
        Entry e = entries[slot];
        Entry prev = null;
        while (e != null) {
            Entry next = e.mNext;
            if (e.mServer == server) {
                if (prev == null) {
                    entries[slot] = next;
                } else {
                    prev.mNext = next;
                }
                --this.mSize;
                e.mNext = null;
                return;
            }
            prev = e;
            e = next;
        }
    }

    private boolean grow() {
        Entry[] entries = this.mEntries;
        int capacity = entries.length << 1;
        if (capacity < 0) {
            return false;
        }
        Entry[] newEntries = new Entry[capacity];
        for (int i = 0; i < entries.length; ++i) {
            Entry e = entries[i];
            while (e != null) {
                Entry next = e.mNext;
                int slot = System.identityHashCode(e.mServer) & newEntries.length - 1;
                e.mNext = newEntries[slot];
                newEntries[slot] = e;
                e = next;
            }
        }
        this.mEntries = newEntries;
        return true;
    }

    private static final class Entry {
        final Object mServer;
        Object mSkeletonOrLatch;
        Entry mNext;

        Entry(Object server, CountDownLatch latch) {
            this.mServer = server;
            this.mSkeletonOrLatch = latch;
        }
    }
}

