/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

final class SoftCache<K, V>
extends ReferenceQueue<Object> {
    private Entry<K, V>[] mEntries = new Entry[2];
    private int mSize;

    public synchronized int size() {
        return this.mSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Reference ref = this.poll();
        if (ref != null) {
            SoftCache softCache = this;
            synchronized (softCache) {
                this.cleanup(ref);
            }
        }
        Entry<K, V>[] entries = this.mEntries;
        Entry<K, V> e = entries[key.hashCode() & entries.length - 1];
        while (e != null) {
            if (e.mKey.equals(key)) {
                return (V)e.get();
            }
            e = e.mNext;
        }
        return null;
    }

    public synchronized V put(K key, V value) {
        Reference ref = this.poll();
        if (ref != null) {
            this.cleanup(ref);
        }
        Entry<K, V>[] entries = this.mEntries;
        int hash = key.hashCode();
        int slot = hash & entries.length - 1;
        Entry<K, V> e = entries[slot];
        Entry<K, V> prev = null;
        while (e != null) {
            if (e.mKey.equals(key)) {
                Object replaced = e.get();
                if (replaced != null) {
                    e.clear();
                }
                Entry<K, V> newEntry = new Entry<K, V>(key, value, hash, this);
                if (prev == null) {
                    newEntry.mNext = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                    newEntry.mNext = entries[slot];
                }
                VarHandle.storeStoreFence();
                entries[slot] = newEntry;
                return (V)replaced;
            }
            prev = e;
            e = e.mNext;
        }
        int size = this.mSize;
        if (size + (size >> 1) >= entries.length && entries.length < 0x40000000) {
            Entry[] newEntries = new Entry[entries.length << 1];
            for (int i = 0; i < entries.length; ++i) {
                Entry<K, V> e2 = entries[i];
                while (e2 != null) {
                    Entry next = e2.mNext;
                    slot = e2.mHash & newEntries.length - 1;
                    e2.mNext = newEntries[slot];
                    newEntries[slot] = e2;
                    e2 = next;
                }
            }
            entries = newEntries;
            this.mEntries = newEntries;
            slot = hash & entries.length - 1;
        }
        Entry<K, V> newEntry = new Entry<K, V>(key, value, hash, this);
        newEntry.mNext = entries[slot];
        VarHandle.storeStoreFence();
        entries[slot] = newEntry;
        ++this.mSize;
        return null;
    }

    private void cleanup(Object ref) {
        Entry<K, V>[] entries = this.mEntries;
        block0: do {
            Entry cleared = (Entry)ref;
            int ix = cleared.mHash & entries.length - 1;
            Entry<K, V> e = entries[ix];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e == cleared) {
                    if (prev == null) {
                        entries[ix] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    --this.mSize;
                    continue block0;
                }
                prev = e;
                e = e.mNext;
            }
        } while ((ref = this.poll()) != null);
    }

    private static final class Entry<K, V>
    extends SoftReference<V> {
        final K mKey;
        final int mHash;
        Entry<K, V> mNext;

        Entry(K key, V value, int hash, SoftCache<K, V> cache) {
            super(value, cache);
            this.mKey = key;
            this.mHash = hash;
        }
    }
}

