/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.cojen.dirmi.Remote;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.Item;
import org.cojen.dirmi.core.MethodIdWriter;
import org.cojen.dirmi.core.StubSupport;

public class Stub
extends Item
implements Remote {
    static final VarHandle cSupportHandle;
    static final VarHandle cWriterHandle;
    static final VarHandle cOriginHandle;
    private static final MethodHandle cRootOrigin;
    protected StubSupport support;
    protected MethodIdWriter miw;
    protected MethodHandle origin;

    static void setRootOrigin(Stub root) {
        cOriginHandle.setRelease(root, cRootOrigin);
    }

    public Stub(long id, StubSupport support, MethodIdWriter miw) {
        super(id);
        this.support = support;
        this.miw = miw;
        VarHandle.storeStoreFence();
    }

    final boolean isRestorable() {
        MethodHandle origin = cOriginHandle.getAcquire(this);
        if (origin == null) {
            return cSupportHandle.getAcquire(this).isLenientRestorable();
        }
        return origin != cRootOrigin;
    }

    public String toString() {
        String name = this.getClass().getName();
        int ix = name.lastIndexOf(45);
        if (ix > 0) {
            name = name.substring(0, ix);
        }
        StringBuilder b = new StringBuilder();
        b.append(name).append('@').append(Integer.toHexString(System.identityHashCode(this))).append("{id=").append(this.id);
        this.support.appendInfo(b);
        return b.append('}').toString();
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cSupportHandle = lookup.findVarHandle(Stub.class, "support", StubSupport.class);
            cWriterHandle = lookup.findVarHandle(Stub.class, "miw", MethodIdWriter.class);
            cOriginHandle = lookup.findVarHandle(Stub.class, "origin", MethodHandle.class);
        }
        catch (Throwable e) {
            throw CoreUtils.rethrow(e);
        }
        cRootOrigin = MethodHandles.constant(Stub.class, null);
    }
}

