/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.ObjectInputFilter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.dirmi.Batched;
import org.cojen.dirmi.Disposer;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteException;
import org.cojen.dirmi.RemoteFailure;
import org.cojen.dirmi.Restorable;
import org.cojen.dirmi.Unbatched;
import org.cojen.dirmi.core.CoreObjectInputStream;
import org.cojen.dirmi.core.CoreObjectOutputStream;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.JoinedIterator;
import org.cojen.dirmi.core.MethodIdWriter;
import org.cojen.dirmi.core.RemoteInfo;
import org.cojen.dirmi.core.RemoteMethod;
import org.cojen.dirmi.core.SoftCache;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.StubFactory;
import org.cojen.dirmi.core.StubSupport;
import org.cojen.dirmi.core.Unimplemented;
import org.cojen.maker.AnnotationMaker;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;

final class StubMaker {
    private static final SoftCache<TypeInfoKey, MethodHandle> cCache = new SoftCache();
    private final Class<?> mType;
    private final RemoteInfo mClientInfo;
    private final RemoteInfo mServerInfo;
    private final ClassMaker mFactoryMaker;
    private final ClassMaker mStubMaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StubFactory factoryFor(Class<?> type, long typeId, RemoteInfo info) {
        TypeInfoKey key = new TypeInfoKey(type, info);
        MethodHandle mh = cCache.get(key);
        if (mh == null) {
            SoftCache<TypeInfoKey, MethodHandle> softCache = cCache;
            synchronized (softCache) {
                mh = cCache.get(key);
                if (mh == null) {
                    mh = new StubMaker(type, info).finishFactory();
                    cCache.put(key, mh);
                }
            }
        }
        try {
            return mh.invoke(typeId);
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
    }

    private StubMaker(Class<?> type, RemoteInfo info) {
        this.mType = type;
        this.mClientInfo = RemoteInfo.examine(type);
        this.mServerInfo = info;
        String sourceFile = StubMaker.class.getSimpleName();
        int numMethods = this.mServerInfo.remoteMethods().size();
        Class superClass = numMethods < 256 ? StubFactory.BW.class : (numMethods < 65536 ? StubFactory.SW.class : StubFactory.IW.class);
        this.mFactoryMaker = ClassMaker.begin((String)type.getName(), (ClassLoader)type.getClassLoader(), (Object)CoreUtils.MAKER_KEY).extend(superClass).final_().sourceFile(sourceFile);
        CoreUtils.allowAccess(this.mFactoryMaker);
        this.mStubMaker = this.mFactoryMaker.another(type.getName()).public_().extend(Stub.class).implement(type).final_().sourceFile(sourceFile);
    }

    private MethodHandle finishFactory() {
        this.finishStub();
        MethodMaker mm = this.mFactoryMaker.addConstructor(new Object[]{Long.TYPE});
        mm.invokeSuperConstructor(new Object[]{mm.param(0)});
        mm = this.mFactoryMaker.addMethod(Stub.class, "newStub", new Object[]{Long.TYPE, StubSupport.class});
        mm.public_().return_((Object)mm.new_((Object)this.mStubMaker, new Object[]{mm.param(0), mm.param(1), mm.this_()}));
        MethodHandles.Lookup lookup = this.mFactoryMaker.finishLookup();
        try {
            return lookup.findConstructor(lookup.lookupClass(), MethodType.methodType(Void.TYPE, Long.TYPE));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private Class<?> finishStub() {
        MethodMaker mm = this.mStubMaker.addConstructor(new Object[]{Long.TYPE, StubSupport.class, MethodIdWriter.class});
        mm.invokeSuperConstructor(new Object[]{mm.param(0), mm.param(1), mm.param(2)});
        JoinedIterator<RemoteMethod> it = new JoinedIterator<RemoteMethod>(this.mClientInfo.remoteMethods(), this.mServerInfo.remoteMethods());
        RemoteMethod lastServerMethod = null;
        int serverMethodId = -1;
        int batchedImmediateMethodId = -1;
        int syntheticMethodId = this.mServerInfo.remoteMethods().size();
        while (it.hasNext()) {
            Label connectStart;
            AnnotationMaker am;
            Class<?> remoteFailureClass;
            Object returnType;
            Object[] ptypes;
            String methodName;
            RemoteMethod serverMethod;
            RemoteMethod clientMethod;
            block43: {
                Object pair = it.next();
                clientMethod = (RemoteMethod)((JoinedIterator.Pair)pair).a;
                serverMethod = (RemoteMethod)((JoinedIterator.Pair)pair).b;
                if (serverMethod != lastServerMethod && serverMethod != null) {
                    ++serverMethodId;
                    lastServerMethod = serverMethod;
                }
                if (serverMethod != null && serverMethod.isBatchedImmediate()) {
                    batchedImmediateMethodId = serverMethodId;
                    continue;
                }
                if (clientMethod == null) {
                    try {
                        Class<?> returnClass = this.classForEx(serverMethod.returnType());
                        if (serverMethod.isSerialized() && !returnClass.isPrimitive()) continue;
                        methodName = serverMethod.name();
                        List<String> pnames = serverMethod.parameterTypes();
                        ptypes = new Object[pnames.size()];
                        int i = 0;
                        for (String pname : pnames) {
                            ptypes[i++] = this.classForEx(pname);
                        }
                        returnType = returnClass;
                        break block43;
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                }
                if (clientMethod.isBatchedImmediate()) continue;
                returnType = clientMethod.returnType();
                methodName = clientMethod.name();
                ptypes = clientMethod.parameterTypes().toArray(Object[]::new);
            }
            MethodMaker mm2 = this.mStubMaker.addMethod(returnType, methodName, ptypes).public_();
            ArrayList thrownClasses = null;
            if (clientMethod == null) {
                try {
                    remoteFailureClass = this.classForEx(serverMethod.remoteFailureException());
                }
                catch (ClassNotFoundException e) {
                    remoteFailureClass = this.classFor(this.mClientInfo.remoteFailureException());
                }
            } else {
                remoteFailureClass = this.classFor(clientMethod.remoteFailureException());
                for (String ex : clientMethod.exceptionTypes()) {
                    Class<?> exClass = this.classFor(ex);
                    if (CoreUtils.isUnchecked(exClass) || remoteFailureClass.isAssignableFrom(exClass)) continue;
                    if (thrownClasses == null) {
                        thrownClasses = new ArrayList();
                    }
                    thrownClasses.add(exClass);
                    mm2.throws_(exClass);
                }
            }
            mm2.throws_(remoteFailureClass);
            RemoteMethod method = serverMethod;
            int methodId = serverMethodId;
            if (method == null) {
                method = clientMethod;
                mm2.addAnnotation(Unimplemented.class, true);
                if (method.isBatched()) {
                    batchedImmediateMethodId = syntheticMethodId++;
                }
                methodId = syntheticMethodId++;
            }
            if (method.isDisposer()) {
                mm2.addAnnotation(Disposer.class, true);
            }
            if (method.isBatched()) {
                mm2.addAnnotation(Batched.class, true);
            } else if (method.isUnbatched()) {
                mm2.addAnnotation(Unbatched.class, true);
            }
            if (StubMaker.isClientMethodRestorable(clientMethod)) {
                am = mm2.addAnnotation(Restorable.class, true);
                if (clientMethod.isLenient()) {
                    am.put("lenient", (Object)true);
                }
            }
            if (remoteFailureClass == RemoteException.class) {
                if (method.isRemoteFailureExceptionUndeclared()) {
                    mm2.addAnnotation(RemoteFailure.class, true).put("declared", (Object)false);
                }
            } else {
                am = mm2.addAnnotation(RemoteFailure.class, true);
                am.put("exception", remoteFailureClass);
                if (method.isRemoteFailureExceptionUndeclared()) {
                    am.put("declared", (Object)false);
                }
            }
            if (clientMethod != null && clientMethod.isPiped() != method.isPiped()) {
                mm2.new_(IncompatibleClassChangeError.class, new Object[0]).throw_();
                continue;
            }
            Label obtainSupport = mm2.label().here();
            Variable supportVar = mm2.field("support").getAcquire();
            Label label = connectStart = method.isDisposer() ? mm2.label().here() : null;
            String connectMethod = StubMaker.isClientMethodRestorableLenient(clientMethod) ? (method.isUnbatched() ? "tryConnectUnbatched" : "tryConnect") : (method.isUnbatched() ? "connectUnbatched" : "connect");
            Variable pipeVar = supportVar.invoke(connectMethod, new Object[]{mm2.this_(), remoteFailureClass});
            if (method.isDisposer()) {
                mm2.catch_(connectStart, Throwable.class, exVar -> {
                    supportVar.invoke("dispose", new Object[]{mm2.this_()});
                    exVar.throw_();
                });
            }
            supportVar.invoke("validate", new Object[]{mm2.this_(), pipeVar}).ifFalse(obtainSupport);
            Variable returnVar = StubMaker.isVoid(returnType) ? null : mm2.var(returnType);
            Label hasResult = null;
            if (returnVar != null && StubMaker.isClientMethodRestorableLenient(clientMethod)) {
                Label connected = mm2.label();
                pipeVar.ifNe(null, connected);
                returnVar.set((Object)supportVar.invoke("newDisconnectedStub", new Object[]{returnVar.classType(), null}).cast(returnType));
                hasResult = mm2.label().goto_();
                connected.here();
            }
            if (method.isDisposer()) {
                supportVar.invoke("dispose", new Object[]{mm2.this_()});
            }
            Label invokeStart = mm2.label().here();
            Label invokeEnd = mm2.label();
            pipeVar.invoke("writeLong", new Object[]{mm2.field("id")});
            Variable thrownVar = null;
            Label throwException = null;
            Variable typeIdVar = null;
            Variable aliasIdVar = null;
            if (method.isBatched() && returnVar != null) {
                Class<?> returnClass = this.classFor(returnType);
                typeIdVar = supportVar.invoke("remoteTypeId", new Object[]{returnClass});
                aliasIdVar = supportVar.invoke("newAliasId", new Object[0]);
                if (batchedImmediateMethodId >= 0) {
                    Label hasType = mm2.label();
                    typeIdVar.ifNe((Object)0L, hasType);
                    this.writeParams(mm2, pipeVar, method, batchedImmediateMethodId, ptypes);
                    pipeVar.invoke("writeLong", new Object[]{aliasIdVar});
                    pipeVar.invoke("flush", new Object[0]);
                    Label noBatch = mm2.label();
                    Variable isBatchingVar = supportVar.invoke("isBatching", new Object[]{pipeVar});
                    isBatchingVar.ifFalse(noBatch);
                    thrownVar = supportVar.invoke("readResponse", new Object[]{pipeVar});
                    throwException = mm2.label();
                    thrownVar.ifNe(null, throwException);
                    noBatch.here();
                    thrownVar.set((Object)supportVar.invoke("readResponse", new Object[]{pipeVar}));
                    thrownVar.ifNe(null, throwException);
                    CoreUtils.readParam(pipeVar, returnVar);
                    Label done = mm2.label();
                    isBatchingVar.ifTrue(done);
                    supportVar.invoke("batched", new Object[]{pipeVar});
                    done.here();
                    this.returnResult(mm2, clientMethod, hasResult, returnVar);
                    hasType.here();
                }
            }
            this.writeParams(mm2, pipeVar, method, methodId, ptypes);
            if (method.isPiped()) {
                supportVar.invoke("finishBatch", new Object[]{pipeVar}).ifFalse(invokeEnd);
                pipeVar.invoke("flush", new Object[0]);
                thrownVar = supportVar.invoke("readResponse", new Object[]{pipeVar});
                throwException = mm2.label();
                thrownVar.ifNe(null, throwException);
                invokeEnd.here();
                mm2.return_((Object)pipeVar);
            } else if (method.isBatched()) {
                invokeEnd.here();
                supportVar.invoke("batched", new Object[]{pipeVar});
                if (returnVar == null) {
                    mm2.return_();
                } else {
                    pipeVar.invoke("writeLong", new Object[]{aliasIdVar});
                    Variable stubVar = supportVar.invoke("newAliasStub", new Object[]{remoteFailureClass, aliasIdVar, typeIdVar});
                    returnVar.set((Object)stubVar.cast(returnType));
                    this.returnResult(mm2, clientMethod, hasResult, returnVar);
                }
            } else {
                pipeVar.invoke("flush", new Object[0]);
                Label noBatch = mm2.label();
                supportVar.invoke("finishBatch", new Object[]{pipeVar}).ifFalse(noBatch);
                thrownVar = supportVar.invoke("readResponse", new Object[]{pipeVar});
                throwException = mm2.label();
                thrownVar.ifNe(null, throwException);
                noBatch.here();
                if (!method.isNoReply()) {
                    thrownVar.set((Object)supportVar.invoke("readResponse", new Object[]{pipeVar}));
                    thrownVar.ifNe(null, throwException);
                }
                if (returnVar == null) {
                    invokeEnd.here();
                    supportVar.invoke("finished", new Object[]{pipeVar});
                    mm2.return_();
                } else {
                    Variable inVar = pipeVar;
                    if (method.isSerialized() && CoreUtils.isObjectType(returnType)) {
                        inVar = mm2.new_(CoreObjectInputStream.class, new Object[]{pipeVar});
                        ObjectInputFilter filter = clientMethod.objectInputFilter();
                        Variable filterVar = mm2.var(ObjectInputFilter.class).setExact((Object)filter);
                        inVar.invoke("setObjectInputFilter", new Object[]{filterVar});
                    }
                    CoreUtils.readParam(inVar, returnVar);
                    invokeEnd.here();
                    supportVar.invoke("finished", new Object[]{pipeVar});
                    this.returnResult(mm2, clientMethod, hasResult, returnVar);
                }
            }
            Variable exVar2 = mm2.catch_(invokeStart, invokeEnd, Throwable.class);
            if (returnVar != null && StubMaker.isClientMethodRestorableLenient(clientMethod)) {
                returnVar.set((Object)supportVar.invoke("newDisconnectedStub", new Object[]{returnVar.classType(), exVar2}).cast(returnType));
                hasResult.goto_();
            }
            supportVar.invoke("failed", new Object[]{remoteFailureClass, pipeVar, exVar2}).throw_();
            if (thrownVar != null) {
                throwException.here();
                supportVar.invoke("finished", new Object[]{pipeVar});
                StubMaker.throwException(thrownVar, remoteFailureClass, thrownClasses);
            }
            batchedImmediateMethodId = -1;
        }
        return this.mStubMaker.finish();
    }

    private static void throwException(Variable exVar, Class<?> remoteFailureClass, List<Class<?>> thrownClasses) {
        MethodMaker mm = exVar.methodMaker();
        Label throwIt = mm.label();
        List<Class<?>> toCheck = CoreUtils.reduceExceptions(remoteFailureClass, thrownClasses);
        for (Class<?> type : toCheck) {
            exVar.instanceOf(type).ifTrue(throwIt);
        }
        Variable msgVar = exVar.invoke("getMessage", new Object[0]);
        exVar.set((Object)mm.new_(UndeclaredThrowableException.class, new Object[]{exVar, msgVar}));
        throwIt.here();
        exVar.throw_();
    }

    private static boolean isVoid(Object returnType) {
        return returnType == Void.TYPE || returnType.equals("V");
    }

    private void writeParams(MethodMaker mm, Variable pipeVar, RemoteMethod method, int methodId, Object[] ptypes) {
        String writeName = "writeMethodId";
        if (methodId >= this.mServerInfo.remoteMethods().size()) {
            writeName = "writeSyntheticMethodId";
        }
        mm.field("miw").getAcquire().invoke(writeName, new Object[]{pipeVar, methodId, method.name()});
        if (ptypes.length <= 0) {
            return;
        }
        Variable outVar = pipeVar;
        if (method.isSerialized() && CoreUtils.anyObjectTypes(ptypes)) {
            outVar = mm.new_(CoreObjectOutputStream.class, new Object[]{pipeVar});
        }
        if (!method.isPiped()) {
            for (int i = 0; i < ptypes.length; ++i) {
                CoreUtils.writeParam(outVar, mm.param(i));
            }
        } else {
            String pipeDesc = Pipe.class.descriptorString();
            for (int i = 0; i < ptypes.length; ++i) {
                Object ptype = ptypes[i];
                if (ptype == Pipe.class || ptype.equals(pipeDesc)) continue;
                CoreUtils.writeParam(outVar, mm.param(i));
            }
        }
        if (outVar != pipeVar) {
            outVar.invoke("drain", new Object[0]);
        }
    }

    private static boolean isClientMethodRestorable(RemoteMethod clientMethod) {
        return clientMethod != null && clientMethod.isRestorable();
    }

    private static boolean isClientMethodRestorableLenient(RemoteMethod clientMethod) {
        return StubMaker.isClientMethodRestorable(clientMethod) && clientMethod.isLenient();
    }

    private void returnResult(MethodMaker mm, RemoteMethod clientMethod, Label hasResult, Variable resultVar) {
        if (StubMaker.isClientMethodRestorable(clientMethod)) {
            Label finished = mm.label();
            resultVar.ifEq(null, finished);
            if (hasResult != null) {
                hasResult.here();
            }
            Object[] originStub = new Object[]{mm.this_()};
            Field originField = mm.access(Stub.cOriginHandle, originStub);
            Label parentHasOrigin = mm.label();
            originField.getAcquire().ifNe(null, parentHasOrigin);
            mm.new_(IllegalStateException.class, new Object[]{"Cannot make a restorable object from a non-restorable parent"}).throw_();
            parentHasOrigin.here();
            originStub[0] = resultVar.cast(Stub.class);
            originField.getAcquire().ifNe(null, finished);
            Class<?> returnType = this.classFor(clientMethod.returnType());
            List<String> pnames = clientMethod.parameterTypes();
            Class[] ptypes = new Class[pnames.size()];
            int i = 0;
            for (String pname : pnames) {
                ptypes[i++] = this.classFor(pname);
            }
            MethodType mt = MethodType.methodType(returnType, ptypes);
            Variable mhVar = mm.var(CoreUtils.class).condy("findVirtual", new Object[]{this.mType, mt}).invoke(MethodHandle.class, clientMethod.name());
            Variable paramVars = mm.new_(Object[].class, new Object[]{1 + ptypes.length});
            paramVars.aset((Object)0, (Object)mm.this_());
            for (i = 0; i < ptypes.length; ++i) {
                paramVars.aset((Object)(i + 1), (Object)mm.param(i));
            }
            Variable methodHandlesVar = mm.var(MethodHandles.class);
            mhVar = methodHandlesVar.invoke("insertArguments", new Object[]{mhVar, 0, paramVars});
            originField.setRelease((Object)mhVar);
            finished.here();
        }
        mm.return_((Object)resultVar);
    }

    private Class<?> classFor(Object obj) throws NoClassDefFoundError {
        return obj instanceof Class ? (Class<?>)obj : this.classFor((String)obj);
    }

    private Class<?> classFor(String name) throws NoClassDefFoundError {
        try {
            return this.classForEx(name);
        }
        catch (ClassNotFoundException e) {
            NoClassDefFoundError error = new NoClassDefFoundError(name);
            error.initCause(e);
            throw error;
        }
    }

    private Class<?> classForEx(String name) throws ClassNotFoundException {
        return CoreUtils.loadClassByNameOrDescriptor(name, this.mStubMaker.classLoader());
    }

    private record TypeInfoKey(Class<?> type, RemoteInfo info) {
    }
}

