/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cojen.dirmi.Serializer;
import org.cojen.dirmi.core.BufferedPipe;
import org.cojen.dirmi.core.CoreUtils;
import org.cojen.dirmi.core.NullSerializer;
import org.cojen.dirmi.core.SoftCache;
import org.cojen.dirmi.core.Stub;

final class TypeCodeMap {
    static final TypeCodeMap STANDARD = new TypeCodeMap();
    private static final SoftCache<Key, TypeCodeMap> cCache = new SoftCache();
    private final Custom[] mCustomSerializers;
    private Entry[] mEntries;
    private int mSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeCodeMap find(int typeCode, Map<Object, Serializer> serializers) {
        Key key = new Key(typeCode, serializers);
        TypeCodeMap tcm = cCache.get(key);
        if (tcm == null) {
            SoftCache<Key, TypeCodeMap> softCache = cCache;
            synchronized (softCache) {
                tcm = cCache.get(key);
                if (tcm == null) {
                    tcm = new TypeCodeMap(typeCode, serializers);
                    cCache.put(key, tcm);
                }
            }
        }
        return tcm;
    }

    private TypeCodeMap(int typeCode, Map<Object, Serializer> serializers) {
        if (serializers == null || serializers.isEmpty()) {
            this.mCustomSerializers = TypeCodeMap.STANDARD.mCustomSerializers;
            this.mEntries = new Entry[8];
        } else {
            this.mCustomSerializers = new Custom[serializers.size()];
            this.mEntries = new Entry[CoreUtils.roundUpPower2(serializers.size() + 8)];
            for (Map.Entry<Object, Serializer> e : serializers.entrySet()) {
                Object key = e.getKey();
                Class clazz = key instanceof Class ? (Class)key : Object.class;
                Serializer serializer = e.getValue();
                if (serializer == null) {
                    serializer = NullSerializer.THE;
                }
                Custom custom = typeCode < 256 ? new Custom1(clazz, typeCode, serializer) : (typeCode < 65536 ? new Custom2(clazz, typeCode, serializer) : new Custom4(clazz, typeCode, serializer));
                this.mCustomSerializers[typeCode - 55] = custom;
                if (key instanceof Class) {
                    this.put(clazz, custom);
                }
                ++typeCode;
            }
        }
    }

    private TypeCodeMap() {
        this.mCustomSerializers = new Custom[0];
        this.mEntries = new Entry[CoreUtils.roundUpPower2(54)];
        this.put(Void.TYPE.getClass(), 11);
        this.put(Object.class, 12);
        this.put(Boolean.class, 13);
        this.put(Character.class, 15);
        this.put(Float.class, 16);
        this.put(Double.class, 17);
        this.put(Byte.class, 18);
        this.put(Short.class, 19);
        this.put(Integer.class, 20);
        this.put(Long.class, 21);
        this.put(String.class, 22);
        this.put(boolean[].class, 24);
        this.put(char[].class, 26);
        this.put(float[].class, 28);
        this.put(double[].class, 30);
        this.put(byte[].class, 32);
        this.put(short[].class, 34);
        this.put(int[].class, 36);
        this.put(long[].class, 38);
        this.put(Object[].class, 40);
        this.put(List.class, 42);
        this.put(Set.class, 44);
        this.put(Map.class, 46);
        this.put(BigInteger.class, 48);
        this.put(BigDecimal.class, 50);
        this.put(Throwable.class, 51);
        this.put(StackTraceElement.class, 52);
        this.put(Stub.class, 6);
    }

    Class<?> typeClass(int typeCode) {
        Custom[] customs;
        switch (typeCode) {
            case 6: 
            case 7: {
                return Object.class;
            }
            case 11: {
                return Void.TYPE;
            }
            case 13: 
            case 14: {
                return Boolean.class;
            }
            case 15: {
                return Character.class;
            }
            case 16: {
                return Float.class;
            }
            case 17: {
                return Double.class;
            }
            case 18: {
                return Byte.class;
            }
            case 19: {
                return Short.class;
            }
            case 20: {
                return Integer.class;
            }
            case 21: {
                return Long.class;
            }
            case 22: 
            case 23: {
                return String.class;
            }
            case 24: 
            case 25: {
                return boolean[].class;
            }
            case 26: 
            case 27: {
                return char[].class;
            }
            case 28: 
            case 29: {
                return float[].class;
            }
            case 30: 
            case 31: {
                return double[].class;
            }
            case 32: 
            case 33: {
                return byte[].class;
            }
            case 34: 
            case 35: {
                return short[].class;
            }
            case 36: 
            case 37: {
                return int[].class;
            }
            case 38: 
            case 39: {
                return long[].class;
            }
            case 40: 
            case 41: {
                return Object[].class;
            }
            case 42: 
            case 43: {
                return List.class;
            }
            case 44: 
            case 45: {
                return Set.class;
            }
            case 46: 
            case 47: {
                return Map.class;
            }
            case 48: 
            case 49: {
                return BigInteger.class;
            }
            case 50: {
                return BigDecimal.class;
            }
            case 51: {
                return Throwable.class;
            }
            case 52: {
                return StackTraceElement.class;
            }
        }
        if ((typeCode -= 55) >= 0 && typeCode < (customs = this.mCustomSerializers).length) {
            return customs[typeCode].mClass;
        }
        return Object.class;
    }

    Object readCustom(BufferedPipe pipe, int typeCode) throws IOException {
        try {
            return this.mCustomSerializers[typeCode - 55].read(pipe);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidObjectException("Unknown type: " + typeCode);
        }
    }

    void write(BufferedPipe pipe, Object obj) throws IOException {
        Class<?> clazz = obj.getClass();
        Entry e = this.tryFind(clazz);
        if (e == null) {
            e = this.infer(clazz);
        }
        e.write(pipe, obj);
    }

    int writeTypeCode(BufferedPipe pipe, Class<?> clazz) throws IOException {
        Entry e = this.tryFind(clazz);
        if (e == null && (e = this.tryInfer(clazz)) == null) {
            pipe.write(12);
            return 12;
        }
        return e.writeTypeCode(pipe);
    }

    private Entry tryFind(Class<?> clazz) {
        Entry[] entries = this.mEntries;
        Entry e = entries[clazz.hashCode() & entries.length - 1];
        while (e != null) {
            if (clazz == e.clazz()) {
                return e;
            }
            e = e.mNext;
        }
        return null;
    }

    private Entry infer(Class<?> clazz) throws IllegalArgumentException {
        Entry e = this.tryInfer(clazz);
        if (e == null) {
            throw BufferedPipe.unsupported(clazz);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry tryInfer(Class<?> clazz) {
        int typeCode;
        Entry e;
        TypeCodeMap typeCodeMap = this;
        synchronized (typeCodeMap) {
            e = this.tryFind(clazz);
            if (e != null) {
                return e;
            }
        }
        if (this != STANDARD) {
            typeCodeMap = STANDARD;
            synchronized (typeCodeMap) {
                e = STANDARD.tryFind(clazz);
            }
        }
        if (e != null) {
            typeCode = e.mTypeCode;
        } else if (Throwable.class.isAssignableFrom(clazz)) {
            typeCode = 51;
        } else if (Object[].class.isAssignableFrom(clazz)) {
            typeCode = 40;
        } else if (List.class.isAssignableFrom(clazz)) {
            typeCode = 42;
        } else if (Set.class.isAssignableFrom(clazz)) {
            typeCode = 44;
        } else if (Map.class.isAssignableFrom(clazz)) {
            typeCode = 46;
        } else if (Stub.class.isAssignableFrom(clazz)) {
            typeCode = 6;
        } else if (CoreUtils.isRemote(clazz)) {
            typeCode = 7;
        } else {
            return null;
        }
        return this.put(clazz, typeCode);
    }

    private Entry put(Class<?> clazz, int typeCode) {
        return this.put(clazz, new Standard(clazz, typeCode));
    }

    private synchronized Entry put(Class<?> clazz, Entry newEntry) {
        Entry[] entries = this.mEntries;
        int hash = clazz.hashCode();
        int index = hash & entries.length - 1;
        Entry e = entries[index];
        while (e != null) {
            if (clazz == e.clazz()) {
                return e;
            }
            e = e.mNext;
        }
        int size = this.mSize;
        if (size + (size >> 1) >= entries.length && entries.length < 0x40000000) {
            Entry[] newEntries = new Entry[entries.length << 1];
            size = 0;
            for (int i = 0; i < entries.length; ++i) {
                Entry existing = entries[i];
                while (existing != null) {
                    Entry e2 = existing;
                    existing = existing.mNext;
                    Class ec = e2.clazz();
                    if (ec == null) continue;
                    ++size;
                    index = ec.hashCode() & newEntries.length - 1;
                    e2.mNext = newEntries[index];
                    newEntries[index] = e2;
                }
            }
            entries = newEntries;
            this.mEntries = newEntries;
            this.mSize = size;
            index = hash & entries.length - 1;
        }
        newEntry.mNext = entries[index];
        entries[index] = newEntry;
        ++this.mSize;
        return newEntry;
    }

    private record Key(int typeCode, Map<Object, Serializer> serializers) {
    }

    private static abstract class Custom
    extends Entry {
        final Class mClass;
        final Serializer mSerializer;

        Custom(Class clazz, int typeCode, Serializer serializer) {
            super(typeCode);
            this.mClass = clazz;
            this.mSerializer = serializer;
        }

        @Override
        Class clazz() {
            return this.mClass;
        }

        @Override
        Object read(BufferedPipe pipe) throws IOException {
            int identifier = pipe.reserveReference();
            Object obj = this.mSerializer.read(pipe);
            pipe.stashReference(identifier, obj);
            return obj;
        }

        @Override
        final void write(BufferedPipe pipe, Object obj) throws IOException {
            this.writeTypeCode(pipe);
            this.mSerializer.write(pipe, obj);
        }
    }

    private static abstract class Entry {
        final int mTypeCode;
        Entry mNext;

        Entry(int typeCode) {
            this.mTypeCode = typeCode;
        }

        Object read(BufferedPipe pipe) throws IOException {
            throw new UnsupportedOperationException();
        }

        abstract Class clazz();

        abstract void write(BufferedPipe var1, Object var2) throws IOException;

        abstract int writeTypeCode(BufferedPipe var1) throws IOException;
    }

    private static final class Custom1
    extends Custom {
        Custom1(Class clazz, int typeCode, Serializer serializer) {
            super(clazz, typeCode, serializer);
        }

        @Override
        int writeTypeCode(BufferedPipe pipe) throws IOException {
            int typeCode = this.mTypeCode;
            pipe.write(typeCode);
            return typeCode;
        }
    }

    private static final class Custom2
    extends Custom {
        Custom2(Class clazz, int typeCode, Serializer serializer) {
            super(clazz, typeCode, serializer);
        }

        @Override
        int writeTypeCode(BufferedPipe pipe) throws IOException {
            pipe.write(53);
            int typeCode = this.mTypeCode;
            pipe.writeShort(typeCode);
            return typeCode;
        }
    }

    private static final class Custom4
    extends Custom {
        Custom4(Class clazz, int typeCode, Serializer serializer) {
            super(clazz, typeCode, serializer);
        }

        @Override
        int writeTypeCode(BufferedPipe pipe) throws IOException {
            pipe.write(54);
            int typeCode = this.mTypeCode;
            pipe.writeInt(typeCode);
            return typeCode;
        }
    }

    private static final class Standard
    extends Entry {
        final SoftReference<Class> mClassRef;

        Standard(Class clazz, int typeCode) {
            super(typeCode);
            this.mClassRef = new SoftReference<Class>(clazz);
        }

        @Override
        Class clazz() {
            return this.mClassRef.get();
        }

        @Override
        void write(BufferedPipe pipe, Object obj) throws IOException {
            switch (this.mTypeCode) {
                case 6: {
                    pipe.writeStub((Stub)obj);
                    break;
                }
                case 7: {
                    pipe.writeSkeleton(obj);
                    break;
                }
                case 11: {
                    pipe.write(11);
                    break;
                }
                case 12: {
                    pipe.writePlainObject(obj);
                    break;
                }
                case 13: 
                case 14: {
                    pipe.writeBooleanObj((Boolean)obj);
                    break;
                }
                case 15: {
                    pipe.writeCharObj((Character)obj);
                    break;
                }
                case 16: {
                    pipe.writeFloatObj((Float)obj);
                    break;
                }
                case 17: {
                    pipe.writeDoubleObj((Double)obj);
                    break;
                }
                case 18: {
                    pipe.writeByteObj((Byte)obj);
                    break;
                }
                case 19: {
                    pipe.writeShortObj((Short)obj);
                    break;
                }
                case 20: {
                    pipe.writeIntObj((Integer)obj);
                    break;
                }
                case 21: {
                    pipe.writeLongObj((Long)obj);
                    break;
                }
                case 22: 
                case 23: {
                    pipe.writeString((String)obj);
                    break;
                }
                case 24: 
                case 25: {
                    pipe.writeBooleanA((boolean[])obj);
                    break;
                }
                case 26: 
                case 27: {
                    pipe.writeCharA((char[])obj);
                    break;
                }
                case 28: 
                case 29: {
                    pipe.writeFloatA((float[])obj);
                    break;
                }
                case 30: 
                case 31: {
                    pipe.writeDoubleA((double[])obj);
                    break;
                }
                case 32: 
                case 33: {
                    pipe.writeByteA((byte[])obj);
                    break;
                }
                case 34: 
                case 35: {
                    pipe.writeShortA((short[])obj);
                    break;
                }
                case 36: 
                case 37: {
                    pipe.writeIntA((int[])obj);
                    break;
                }
                case 38: 
                case 39: {
                    pipe.writeLongA((long[])obj);
                    break;
                }
                case 40: 
                case 41: {
                    pipe.writeObjectA((Object[])obj);
                    break;
                }
                case 42: 
                case 43: {
                    pipe.writeList((List)obj);
                    break;
                }
                case 44: 
                case 45: {
                    pipe.writeSet((Set)obj);
                    break;
                }
                case 46: 
                case 47: {
                    pipe.writeMap((Map)obj);
                    break;
                }
                case 48: 
                case 49: {
                    pipe.writeBigInteger((BigInteger)obj);
                    break;
                }
                case 50: {
                    pipe.writeBigDecimal((BigDecimal)obj);
                    break;
                }
                case 51: {
                    pipe.writeThrowable((Throwable)obj);
                    break;
                }
                case 52: {
                    pipe.writeStackTraceElement((StackTraceElement)obj);
                    break;
                }
                default: {
                    throw BufferedPipe.unsupported(obj.getClass());
                }
            }
        }

        @Override
        int writeTypeCode(BufferedPipe pipe) throws IOException {
            pipe.write(this.mTypeCode);
            return this.mTypeCode;
        }
    }
}

