/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

final class WaitMap<K, V> {
    private final ConcurrentHashMap<K, V> mMap = new ConcurrentHashMap();
    private final Semaphore mSem = new Semaphore(0);
    private int mExpect;

    WaitMap() {
    }

    boolean add(K key) {
        if (this.mMap.putIfAbsent(key, this) != null) {
            return false;
        }
        ++this.mExpect;
        return true;
    }

    Map<K, V> await() throws InterruptedException {
        this.mSem.acquire(this.mExpect);
        return this.mMap;
    }

    void put(K key, V value) {
        if (this.mMap.put(key, value) == this) {
            this.mSem.release();
        }
    }

    void remove(K key) {
        if (this.mMap.remove(key) == this) {
            this.mSem.release();
        }
    }
}

