/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class CaptureOutputStream
extends OutputStream {
    private byte[] mBytes;
    private ByteArrayOutputStream mBout;

    @Override
    public void write(int b) {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.mBout == null) {
            if (this.mBytes == null) {
                byte[] bytes = new byte[len];
                System.arraycopy(b, off, bytes, 0, len);
                this.mBytes = bytes;
                return;
            }
            this.mBout = new ByteArrayOutputStream(this.mBytes.length + len);
            this.mBout.writeBytes(this.mBytes);
            this.mBytes = null;
        }
        this.mBout.write(b, off, len);
    }

    public byte[] getBytes() {
        return this.mBout == null ? this.mBytes : this.mBout.toByteArray();
    }
}

