/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.io.PipedOutputStream;

public final class PipedInputStream
extends InputStream {
    private static final int NOT_CONNECTED = 0;
    private static final int CONNECTED = 1;
    private static final int HALF_CLOSED = 2;
    private static final int CLOSED = 3;
    private final Lock mLock;
    private PipedOutputStream mPout;
    private int mConnectState;

    public PipedInputStream() {
        this.mLock = new ReentrantLock();
    }

    public PipedInputStream(PipedOutputStream pout) throws IOException {
        this.mLock = pout.setInput(this);
        this.setOutput(pout);
    }

    @Override
    public int read() throws IOException {
        this.mLock.lock();
        try {
            int n = this.mPout.read();
            return n;
        }
        catch (Exception e) {
            this.checkHalfClosed(e);
            int n = -1;
            return n;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        this.mLock.lock();
        try {
            int n = this.mPout.read(bytes, offset, length);
            return n;
        }
        catch (Exception e) {
            this.checkHalfClosed(e);
            int n = -1;
            return n;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        this.mLock.lock();
        try {
            long l = this.mPout.skip(n);
            return l;
        }
        catch (Exception e) {
            this.checkHalfClosed(e);
            long l = 0L;
            return l;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public int available() throws IOException {
        this.mLock.lock();
        try {
            int n = this.mPout.inputAvailable();
            return n;
        }
        catch (Exception e) {
            this.checkHalfClosed(e);
            int n = 0;
            return n;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean isClosed() {
        this.mLock.lock();
        try {
            boolean bl = this.mConnectState == 3;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public void close() {
        this.mLock.lock();
        try {
            if (this.mPout != null) {
                PipedOutputStream pout = this.mPout;
                this.mPout = null;
                pout.close();
            }
            this.mConnectState = 3;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public String toString() {
        String superStr = this.superToString();
        this.mLock.lock();
        try {
            if (this.mPout == null) {
                String string = superStr.concat(" (unconnected)");
                return string;
            }
            String string = superStr + " connected to " + this.mPout.superToString();
            return string;
        }
        finally {
            this.mLock.unlock();
        }
    }

    void outputClosed() {
        this.mLock.lock();
        try {
            this.mPout = null;
            if (this.mConnectState != 3) {
                this.mConnectState = 2;
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    String superToString() {
        return super.toString();
    }

    Lock setOutput(PipedOutputStream pout) throws IOException {
        this.mLock.lock();
        try {
            switch (this.mConnectState) {
                case 0: {
                    this.mPout = pout;
                    this.mConnectState = 1;
                    Lock lock = this.mLock;
                    return lock;
                }
                case 1: {
                    throw new IOException("Already connected");
                }
            }
            throw new ClosedException();
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void checkHalfClosed(Exception e) throws IOException {
        if (this.mPout == null) {
            if (this.mConnectState == 2) {
                return;
            }
            if (e instanceof NullPointerException) {
                e = this.mConnectState == 0 ? new IOException("Not connected") : new ClosedException();
            }
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new IOException(e);
    }
}

