/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.io.PipedInputStream;

public final class PipedOutputStream
extends OutputStream {
    private final Lock mLock;
    private final Condition mReadCondition;
    private final Condition mWriteCondition;
    private PipedInputStream mPin;
    private boolean mEverConnected;
    private byte[] mData;
    private int mOffset;
    private int mLength;
    private byte[] mTinyBuf;

    public PipedOutputStream() {
        this.mLock = new ReentrantLock();
        this.mReadCondition = this.mLock.newCondition();
        this.mWriteCondition = this.mLock.newCondition();
    }

    public PipedOutputStream(PipedInputStream pin) throws IOException {
        this.mLock = pin.setOutput(this);
        this.mReadCondition = this.mLock.newCondition();
        this.mWriteCondition = this.mLock.newCondition();
        this.setInput(pin);
    }

    @Override
    public void write(int b) throws IOException {
        this.mLock.lock();
        try {
            this.checkConnected();
            byte[] bytes = this.mTinyBuf;
            if (bytes == null) {
                this.mTinyBuf = bytes = new byte[1];
            }
            bytes[0] = (byte)b;
            this.mData = bytes;
            this.mOffset = 0;
            this.mLength = 1;
            this.mReadCondition.signal();
            this.waitForWriteCompletion();
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, bytes.length);
        if (length <= 0) {
            return;
        }
        this.mLock.lock();
        try {
            this.checkConnected();
            this.mData = bytes;
            this.mOffset = offset;
            this.mLength = length;
            this.mReadCondition.signal();
            this.waitForWriteCompletion();
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void waitForWriteCompletion() throws IOException {
        try {
            if (this.mData != null) {
                while (true) {
                    this.mWriteCondition.await();
                    if (this.mData != null) {
                        this.checkConnected();
                        continue;
                    }
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            this.mData = null;
            throw new InterruptedIOException("Thread interrupted");
        }
    }

    public boolean isClosed() {
        this.mLock.lock();
        try {
            boolean bl = this.mPin == null && this.mEverConnected;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    @Override
    public void close() {
        this.mLock.lock();
        try {
            if (this.mPin != null) {
                PipedInputStream pin = this.mPin;
                this.mPin = null;
                pin.outputClosed();
                this.mReadCondition.signalAll();
                this.mWriteCondition.signalAll();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public String toString() {
        String superStr = this.superToString();
        this.mLock.lock();
        try {
            if (this.mPin == null) {
                String string = superStr.concat(" (unconnected)");
                return string;
            }
            String string = superStr + " connected to " + this.mPin.superToString();
            return string;
        }
        finally {
            this.mLock.unlock();
        }
    }

    String superToString() {
        return super.toString();
    }

    int read() throws IOException {
        this.waitForReadAvailable();
        int offset = this.mOffset;
        int b = this.mData[offset] & 0xFF;
        if (--this.mLength <= 0) {
            this.mData = null;
            this.mWriteCondition.signal();
        } else {
            this.mOffset = offset + 1;
        }
        return b;
    }

    int read(byte[] bytes, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, bytes.length);
        int amt = 0;
        this.waitForReadAvailable();
        if (length >= this.mLength) {
            length = this.mLength;
        }
        System.arraycopy(this.mData, this.mOffset, bytes, offset, length);
        amt += length;
        if ((this.mLength -= length) <= 0) {
            this.mData = null;
            this.mWriteCondition.signal();
        } else {
            this.mOffset += length;
        }
        return amt;
    }

    long skip(long n) throws IOException {
        long amt = 0L;
        while (n > 0L) {
            this.waitForReadAvailable();
            if (n <= (long)this.mLength) {
                amt += n;
                this.mLength = (int)((long)this.mLength - n);
                if (this.mLength <= 0) {
                    this.mData = null;
                    this.mWriteCondition.signal();
                    break;
                }
                this.mOffset = (int)((long)this.mOffset + n);
                break;
            }
            amt += (long)this.mLength;
            n -= (long)this.mLength;
            this.mData = null;
            this.mWriteCondition.signal();
        }
        return amt;
    }

    private void waitForReadAvailable() throws IOException {
        try {
            while (this.mData == null) {
                this.mReadCondition.await();
                this.checkConnected();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Thread interrupted");
        }
    }

    int inputAvailable() {
        return this.mData == null ? 0 : this.mLength;
    }

    Lock setInput(PipedInputStream pin) throws IOException {
        this.mLock.lock();
        try {
            if (this.mPin != null) {
                throw new IOException("Already connected");
            }
            if (this.mEverConnected) {
                throw new ClosedException();
            }
            this.mPin = pin;
            this.mEverConnected = true;
        }
        finally {
            this.mLock.unlock();
        }
        return this.mLock;
    }

    private void checkConnected() throws IOException {
        if (this.mPin == null) {
            if (this.mEverConnected) {
                throw new ClosedException();
            }
            throw new IOException("Not connected");
        }
    }
}

