/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.cojen.maker.Attributed;
import org.cojen.maker.BytesOut;
import org.cojen.maker.ConstantPool;
import org.cojen.maker.ExceptionHandler;
import org.cojen.maker.TheAnnotationMaker;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.TheFieldMaker;

abstract class Attribute
extends Attributed {
    final ConstantPool.C_UTF8 mAttrName;

    Attribute(ConstantPool cp, String name) {
        super(cp);
        this.mAttrName = name == null ? null : cp.addUTF8(name);
    }

    abstract int length();

    final void writeTo(BytesOut out) throws IOException {
        out.writeShort(this.mAttrName.mIndex);
        out.writeInt(this.length());
        this.writeDataTo(out);
    }

    abstract void writeDataTo(BytesOut var1) throws IOException;

    static class Record
    extends ListAttribute<Entry> {
        Record(ConstantPool cp) {
            super(cp, "Record");
        }

        Entry add(TheFieldMaker field) {
            return this.add(field.mName, field.mDescriptor);
        }

        Entry add(ConstantPool.C_UTF8 name, ConstantPool.C_UTF8 descriptor) {
            Entry e = new Entry(this.mConstants, name, descriptor);
            this.addEntry(e);
            return e;
        }

        @Override
        int length() {
            int length = 2;
            int i = this.numEntries();
            while (--i >= 0) {
                length += 4 + ((Entry)this.entry(i)).attributesLength();
            }
            return length;
        }

        @Override
        protected int entryLength() {
            throw new AssertionError();
        }

        @Override
        protected void writeEntryTo(BytesOut out, Entry entry) throws IOException {
            out.writeShort(entry.mName.mIndex);
            out.writeShort(entry.mDescriptor.mIndex);
            this.writeAttributesTo(out);
        }

        static class Entry
        extends Attributed {
            final ConstantPool.C_UTF8 mName;
            final ConstantPool.C_UTF8 mDescriptor;

            Entry(ConstantPool cp, ConstantPool.C_UTF8 name, ConstantPool.C_UTF8 descriptor) {
                super(cp);
                this.mName = name;
                this.mDescriptor = descriptor;
            }
        }
    }

    static class MethodParameters
    extends Attribute {
        private final ConstantPool.C_UTF8[] mNames;

        MethodParameters(ConstantPool cp, int numParams) {
            super(cp, "MethodParameters");
            this.mNames = new ConstantPool.C_UTF8[Math.min(numParams, 255)];
        }

        void setName(int index, ConstantPool.C_UTF8 name) {
            if (index < this.mNames.length) {
                this.mNames[index] = name;
            }
        }

        @Override
        int length() {
            return 1 + this.mNames.length * 4;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeByte(this.mNames.length);
            for (ConstantPool.C_UTF8 name : this.mNames) {
                out.writeShort(name == null ? 0 : name.mIndex);
                out.writeShort(0);
            }
        }
    }

    static class AnnotationDefault
    extends Attribute {
        private final TheAnnotationMaker.Element mElement;

        AnnotationDefault(ConstantPool cp, TheAnnotationMaker.Element element) {
            super(cp, "AnnotationDefault");
            this.mElement = element;
        }

        @Override
        int length() {
            return this.mElement.length();
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            this.mElement.writeTo(out);
        }
    }

    static class ParameterAnnotations
    extends Attribute {
        private final Entry[] mEntries;

        ParameterAnnotations(ConstantPool cp, boolean visible, int numParams) {
            super(cp, visible ? "RuntimeVisibleParameterAnnotations" : "RuntimeInvisibleParameterAnnotations");
            this.mEntries = new Entry[numParams];
        }

        Entry forParam(int index) {
            Entry entry = this.mEntries[index];
            if (entry == null) {
                this.mEntries[index] = entry = new Entry();
            }
            return entry;
        }

        @Override
        int length() {
            int numParams = Math.min(this.mEntries.length, 255);
            int length = 1;
            for (int i = 0; i < numParams; ++i) {
                Entry entry = this.mEntries[i];
                length += entry == null ? 2 : entry.length();
            }
            return length;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            int numParams = Math.min(this.mEntries.length, 255);
            out.writeByte(numParams);
            for (int i = 0; i < numParams; ++i) {
                Entry entry = this.mEntries[i];
                if (entry == null) {
                    out.writeShort(0);
                    continue;
                }
                entry.writeTo(out);
            }
        }

        static class Entry
        extends ArrayList<TheAnnotationMaker> {
            Entry() {
            }

            int length() {
                int length = 2;
                int size = this.size();
                for (int i = 0; i < size; ++i) {
                    length += ((TheAnnotationMaker)this.get(i)).length();
                }
                return length;
            }

            void writeTo(BytesOut out) throws IOException {
                int size = this.size();
                out.writeShort(size);
                for (int i = 0; i < size; ++i) {
                    ((TheAnnotationMaker)this.get(i)).writeTo(out);
                }
            }
        }
    }

    static class Annotations
    extends ListAttribute<TheAnnotationMaker> {
        Annotations(ConstantPool cp, boolean visible) {
            super(cp, visible ? "RuntimeVisibleAnnotations" : "RuntimeInvisibleAnnotations");
        }

        void add(TheAnnotationMaker am) {
            super.addEntry(am);
        }

        @Override
        int length() {
            int length = 2;
            int i = this.numEntries();
            while (--i >= 0) {
                length += ((TheAnnotationMaker)this.entry(i)).length();
            }
            return length;
        }

        @Override
        protected int entryLength() {
            throw new AssertionError();
        }

        @Override
        protected void writeEntryTo(BytesOut out, TheAnnotationMaker am) throws IOException {
            am.writeTo(out);
        }
    }

    static class InnerClasses
    extends ListAttribute<Entry> {
        private HashMap<String, Integer> mClassNumbers;

        InnerClasses(ConstantPool cp) {
            super(cp, "InnerClasses");
        }

        int classNumberFor(String name) {
            int num;
            if (this.mClassNumbers == null) {
                this.mClassNumbers = new HashMap(4);
                num = 1;
            } else {
                Integer obj = this.mClassNumbers.get(name);
                num = obj == null ? 1 : obj + 1;
            }
            this.mClassNumbers.put(name, num);
            return num;
        }

        void add(TheClassMaker inner, TheClassMaker outer, String innerName) {
            ConstantPool.C_UTF8 cname = null;
            if (innerName != null) {
                cname = this.mConstants.addUTF8(innerName);
            }
            this.addEntry(new Entry(this.mConstants.addClass(inner.type()), this.mConstants.addClass(outer.type()), cname, inner));
        }

        @Override
        protected int entryLength() {
            return 8;
        }

        @Override
        protected void writeEntryTo(BytesOut out, Entry entry) throws IOException {
            out.writeShort(entry.mInnerClass.mIndex);
            out.writeShort(entry.mOuterClass.mIndex);
            out.writeShort(entry.mInnerName == null ? 0 : entry.mInnerName.mIndex);
            out.writeShort(entry.mInnerMaker.mModifiers);
        }

        static class Entry {
            final ConstantPool.C_Class mInnerClass;
            final ConstantPool.C_Class mOuterClass;
            final ConstantPool.C_UTF8 mInnerName;
            final TheClassMaker mInnerMaker;

            Entry(ConstantPool.C_Class inner, ConstantPool.C_Class outer, ConstantPool.C_UTF8 innerName, TheClassMaker innerMaker) {
                this.mInnerClass = inner;
                this.mOuterClass = outer;
                this.mInnerName = innerName;
                this.mInnerMaker = innerMaker;
            }
        }
    }

    static class EnclosingMethod
    extends Attribute {
        private final ConstantPool.C_Class mHostClass;
        private final ConstantPool.C_NameAndType mHostMethod;

        EnclosingMethod(ConstantPool cp, ConstantPool.C_Class hostClass, ConstantPool.C_NameAndType hostMethod) {
            super(cp, "EnclosingMethod");
            this.mHostClass = hostClass;
            this.mHostMethod = hostMethod;
        }

        @Override
        int length() {
            return 4;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mHostClass.mIndex);
            out.writeShort(this.mHostMethod.mIndex);
        }
    }

    static class BootstrapMethods
    extends Attribute {
        private final LinkedHashMap<Entry, Entry> mEntries = new LinkedHashMap(8);
        private int mLength = 2;

        BootstrapMethods(ConstantPool cp) {
            super(cp, "BootstrapMethods");
        }

        int add(ConstantPool.C_MethodHandle method, ConstantPool.Constant[] args) {
            Entry entry = new Entry(method, args);
            Entry existing = this.mEntries.putIfAbsent(entry, entry);
            if (existing == null) {
                entry.mIndex = this.mEntries.size() - 1;
                this.mLength += 4 + 2 * args.length;
            } else {
                entry = existing;
            }
            return entry.mIndex;
        }

        @Override
        int length() {
            return this.mLength;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mEntries.size());
            for (Entry entry : this.mEntries.keySet()) {
                out.writeShort(entry.mMethod.mIndex);
                ConstantPool.Constant[] args = entry.mArgs;
                out.writeShort(args.length);
                for (ConstantPool.Constant arg : args) {
                    out.writeShort(arg.mIndex);
                }
            }
        }

        static class Entry {
            final ConstantPool.C_MethodHandle mMethod;
            final ConstantPool.Constant[] mArgs;
            int mIndex;

            Entry(ConstantPool.C_MethodHandle method, ConstantPool.Constant[] args) {
                this.mMethod = method;
                this.mArgs = args;
            }

            public int hashCode() {
                return this.mMethod.hashCode() * 31 + Arrays.hashCode(this.mArgs);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object obj) {
                if (this == obj) return true;
                if (!(obj instanceof Entry)) return false;
                Entry other = (Entry)obj;
                if (!this.mMethod.equals(other.mMethod)) return false;
                if (!Arrays.equals(this.mArgs, other.mArgs)) return false;
                return true;
            }
        }
    }

    static class LocalVariableTable
    extends ListAttribute<Entry> {
        private int mMaxOffset;

        LocalVariableTable(ConstantPool cp, String name) {
            super(cp, name);
        }

        void add(int startOffset, int endOffset, ConstantPool.C_UTF8 name, ConstantPool.C_UTF8 type, int slot) {
            this.addEntry(new Entry(startOffset, endOffset, name, type, slot));
        }

        boolean finish(int offset) {
            this.mMaxOffset = offset;
            return this.numEntries() != 0;
        }

        @Override
        protected int entryLength() {
            return 10;
        }

        @Override
        protected void writeEntryTo(BytesOut out, Entry entry) throws IOException {
            int start = entry.mStartOffset;
            out.writeShort(start);
            int end = Math.min(this.mMaxOffset, entry.mEndOffset);
            out.writeShort(Math.min(65535, Math.max(0, end - start)));
            out.writeShort(entry.mName.mIndex);
            out.writeShort(entry.mType.mIndex);
            out.writeShort(entry.mSlot);
        }

        static class Entry {
            final int mStartOffset;
            final int mEndOffset;
            final int mSlot;
            final ConstantPool.C_UTF8 mName;
            final ConstantPool.C_UTF8 mType;

            Entry(int startOffset, int endOffset, ConstantPool.C_UTF8 name, ConstantPool.C_UTF8 type, int slot) {
                this.mStartOffset = startOffset;
                this.mEndOffset = endOffset;
                this.mName = name;
                this.mType = type;
                this.mSlot = slot;
            }
        }
    }

    static class LineNumberTable
    extends Attribute {
        private int[] mTable = new int[8];
        private int mLength;

        LineNumberTable(ConstantPool cp) {
            super(cp, "LineNumberTable");
        }

        void add(int offset, int number) {
            if (offset < 65536 && number < 65536 && this.mLength < 65535) {
                if (this.mLength >= this.mTable.length) {
                    this.mTable = Arrays.copyOf(this.mTable, this.mTable.length << 1);
                }
                this.mTable[this.mLength++] = offset << 16 | number & 0xFFFF;
            }
        }

        boolean finish(int offset) {
            if (this.mLength > 0 && this.mTable[this.mLength - 1] >>> 16 >= offset) {
                --this.mLength;
            }
            return this.mLength != 0;
        }

        @Override
        int length() {
            return 2 + this.mLength * 4;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mLength);
            for (int i = 0; i < this.mLength; ++i) {
                int entry = this.mTable[i];
                out.writeShort(entry >>> 16);
                out.writeShort(entry);
            }
        }
    }

    static class Code
    extends Attribute {
        private final int mMaxStack;
        private final int mMaxLocals;
        private final byte[] mCode;
        private final int mCodeLen;
        private final List<? extends ExceptionHandler> mExceptionHandlers;

        Code(ConstantPool cp, int maxStack, int maxLocals, byte[] code, int codeLen, List<? extends ExceptionHandler> exceptionHandlers) {
            super(cp, "Code");
            this.mMaxStack = maxStack;
            this.mMaxLocals = maxLocals;
            this.mCode = code;
            this.mCodeLen = codeLen;
            this.mExceptionHandlers = exceptionHandlers;
        }

        @Override
        int length() {
            int length = 10 + this.mCodeLen;
            if (this.mExceptionHandlers != null) {
                length += 8 * this.mExceptionHandlers.size();
            }
            return length += this.attributesLength();
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mMaxStack);
            out.writeShort(this.mMaxLocals);
            out.writeInt(this.mCodeLen);
            out.write(this.mCode, 0, this.mCodeLen);
            if (this.mExceptionHandlers == null) {
                out.writeShort(0);
            } else {
                out.writeShort(this.mExceptionHandlers.size());
                for (ExceptionHandler exceptionHandler : this.mExceptionHandlers) {
                    out.writeShort(exceptionHandler.startAddr());
                    out.writeShort(exceptionHandler.endAddr());
                    out.writeShort(exceptionHandler.handlerAddr());
                    ConstantPool.C_Class catchClass = exceptionHandler.catchClass();
                    out.writeShort(catchClass == null ? 0 : catchClass.mIndex);
                }
            }
            this.writeAttributesTo(out);
        }
    }

    static class PermittedSubclasses
    extends ConstantList {
        PermittedSubclasses(ConstantPool cp, Iterable<ConstantPool.C_Class> subclasses) {
            super(cp, "PermittedSubclasses");
            for (ConstantPool.C_Class subclass : subclasses) {
                this.add(subclass);
            }
        }
    }

    static class ConstantList
    extends ListAttribute<ConstantPool.Constant> {
        ConstantList(ConstantPool cp, String name) {
            super(cp, name);
        }

        void add(ConstantPool.Constant member) {
            this.addEntry(member);
        }

        @Override
        protected int entryLength() {
            return 2;
        }

        @Override
        protected void writeEntryTo(BytesOut out, ConstantPool.Constant c) throws IOException {
            out.writeShort(c.mIndex);
        }
    }

    static abstract class ListAttribute<E>
    extends Attribute {
        private E[] mEntries = new Object[4];
        private int mSize;

        ListAttribute(ConstantPool cp, String name) {
            super(cp, name);
        }

        @Override
        int length() {
            return 2 + this.mSize * this.entryLength();
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mSize);
            for (int i = 0; i < this.mSize; ++i) {
                this.writeEntryTo(out, this.mEntries[i]);
            }
        }

        protected void addEntry(E entry) {
            if (this.mSize >= this.mEntries.length) {
                this.mEntries = Arrays.copyOf(this.mEntries, this.mEntries.length << 1);
            }
            this.mEntries[this.mSize++] = entry;
        }

        protected int numEntries() {
            return this.mSize;
        }

        protected E entry(int i) {
            return this.mEntries[i];
        }

        protected abstract int entryLength();

        protected abstract void writeEntryTo(BytesOut var1, E var2) throws IOException;
    }

    static class Constant
    extends Attribute {
        private final ConstantPool.Constant mConstant;

        Constant(ConstantPool cp, String name, ConstantPool.Constant constant) {
            super(cp, name);
            this.mConstant = constant;
        }

        @Override
        int length() {
            return 2;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mConstant.mIndex);
        }
    }

    static class Bytes
    extends Attribute {
        private final byte[] mBytes;

        Bytes(ConstantPool cp, String name, byte[] bytes) {
            super(cp, name);
            this.mBytes = bytes;
        }

        @Override
        int length() {
            return this.mBytes.length;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.write(this.mBytes, 0, this.mBytes.length);
        }
    }

    static class Composite
    extends Attribute {
        private final Attribute[] mEntries;

        Composite(ConstantPool cp, String name, Attribute[] entries) {
            super(cp, name);
            this.mEntries = entries;
        }

        @Override
        int length() {
            int length = 0;
            for (Attribute entry : this.mEntries) {
                length += entry.length();
            }
            return length;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            for (Attribute entry : this.mEntries) {
                entry.writeDataTo(out);
            }
        }
    }

    static class Empty
    extends Attribute {
        Empty(ConstantPool cp, String name) {
            super(cp, name);
        }

        @Override
        int length() {
            return 0;
        }

        @Override
        void writeDataTo(BytesOut out) {
        }
    }
}

