/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cojen.maker.Attribute;
import org.cojen.maker.BytesOut;
import org.cojen.maker.ConstantPool;
import org.cojen.maker.ModuleAttribute;
import org.cojen.maker.TheAnnotationMaker;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.TheMethodMaker;
import org.cojen.maker.Type;
import org.cojen.maker.Typed;

abstract class Attributed {
    ConstantPool mConstants;
    List<Attribute> mAttributes;
    private Attribute.Annotations[] mAnnotationSets;

    Attributed(ConstantPool cp) {
        this.mConstants = cp;
    }

    void addAttribute(Attribute attr) {
        if (this.mAttributes == null) {
            this.mAttributes = new ArrayList<Attribute>(4);
        }
        this.mAttributes.add(attr);
    }

    public void addAttribute(String name, Object value) {
        Objects.requireNonNull(name);
        this.addAttribute(NamedAttribute.make(this, this.mConstants, name, value));
    }

    TheAnnotationMaker addAnnotation(TheAnnotationMaker am, boolean visible) {
        int which;
        Attribute.Annotations annotations;
        if (this.mAnnotationSets == null) {
            this.mAnnotationSets = new Attribute.Annotations[2];
        }
        if ((annotations = this.mAnnotationSets[which = visible ? 0 : 1]) == null) {
            annotations = new Attribute.Annotations(this.mConstants, visible);
            this.addAttribute(annotations);
            this.mAnnotationSets[which] = annotations;
        }
        annotations.add(am);
        return am;
    }

    public void addSignature(Object ... components) {
        ConstantPool.C_UTF8 sig = this.mConstants.addUTF8(Attributed.fullSignature(components));
        this.addAttribute(new Attribute.Constant(this.mConstants, "Signature", sig));
    }

    static String fullSignature(Object ... components) {
        if (components.length == 0) {
            throw new IllegalArgumentException();
        }
        String first = Attributed.resolveComponent(components[0]);
        if (components.length == 1) {
            return first;
        }
        StringBuilder b = new StringBuilder(first.length() + 16);
        for (int i = 0; i < components.length; ++i) {
            String component;
            String string = component = i == 0 ? first : Attributed.resolveComponent(components[i]);
            if (component.startsWith("<")) {
                i = Attributed.appendTypeArgs(0, b, component, components, i);
                continue;
            }
            b.append(component);
        }
        return b.toString();
    }

    private static String resolveComponent(Object component) {
        Type type;
        if (component instanceof String) {
            String str = (String)component;
            return str;
        }
        if (component instanceof Class) {
            Class clazz = (Class)component;
            type = Type.from(clazz);
        } else if (component instanceof Typed) {
            Typed typed = (Typed)component;
            type = typed.type();
        } else {
            throw new IllegalArgumentException("Unsupported component type");
        }
        return type.descriptor();
    }

    private static int appendTypeArgs(int depth, StringBuilder b, String first, Object[] components, int i) {
        boolean semi = false;
        int end = b.length() - 1;
        if (end >= 0 && b.charAt(end) == ';') {
            b.setLength(end);
            semi = true;
        }
        b.append(first);
        ++i;
        while (i < components.length) {
            String component = Attributed.resolveComponent(components[i]);
            if (component.startsWith("<")) {
                i = Attributed.appendTypeArgs(depth + 1, b, component, components, i);
            } else {
                b.append(component);
                if (component.contains(">")) break;
            }
            ++i;
        }
        if (semi) {
            int j = b.length();
            while (--j >= end) {
                if (b.charAt(j) != '>') continue;
                if (depth <= 0) {
                    b.insert(j + 1, ';');
                    return i;
                }
                --depth;
            }
            b.insert(end, ';');
        }
        return i;
    }

    int attributesLength() {
        int length = 2;
        if (this.mAttributes != null) {
            for (Attribute attr : this.mAttributes) {
                length += 6 + attr.length();
            }
        }
        return length;
    }

    void writeAttributesTo(BytesOut out) throws IOException {
        if (this.mAttributes == null) {
            out.writeShort(0);
        } else {
            TheClassMaker.checkSize(this.mAttributes, 65535, "Attribute");
            out.writeShort(this.mAttributes.size());
            for (Attribute attr : this.mAttributes) {
                attr.writeTo(out);
            }
        }
    }

    private static class NamedAttribute {
        private NamedAttribute() {
        }

        static Attribute make(Attributed a, ConstantPool cp, String name, Object value) {
            block17: {
                block8: {
                    ConstantPool.Constant constant;
                    block10: {
                        block13: {
                            block16: {
                                block15: {
                                    block14: {
                                        block12: {
                                            block11: {
                                                block9: {
                                                    if (a instanceof TheMethodMaker && ((TheMethodMaker)a).mClassMaker.isAnnotation() && "AnnotationDefault".equals(name)) {
                                                        return new Attribute.AnnotationDefault(cp, TheAnnotationMaker.toElement(null, cp, value));
                                                    }
                                                    if (value == null) {
                                                        return new Attribute.Empty(cp, name);
                                                    }
                                                    if (value instanceof byte[]) {
                                                        byte[] bytes = (byte[])value;
                                                        return new Attribute.Bytes(cp, name, bytes);
                                                    }
                                                    if (value.getClass().isArray()) break block8;
                                                    if (!(value instanceof String)) break block9;
                                                    String str = (String)value;
                                                    constant = cp.addUTF8(str);
                                                    break block10;
                                                }
                                                if (!(value instanceof Class)) break block11;
                                                Class clazz = (Class)value;
                                                constant = cp.addClass(Type.from(clazz));
                                                break block10;
                                            }
                                            if (!(value instanceof Typed)) break block12;
                                            Typed typed = (Typed)value;
                                            constant = cp.addClass(typed.type());
                                            break block10;
                                        }
                                        if (!(value instanceof Number)) break block13;
                                        if (!(value instanceof Integer)) break block14;
                                        constant = cp.addInteger((Integer)value);
                                        break block10;
                                    }
                                    if (!(value instanceof Long)) break block15;
                                    constant = cp.addLong((Long)value);
                                    break block10;
                                }
                                if (!(value instanceof Float)) break block16;
                                constant = cp.addFloat(((Float)value).floatValue());
                                break block10;
                            }
                            if (!(value instanceof Double)) break block17;
                            constant = cp.addDouble((Double)value);
                            break block10;
                        }
                        if (value instanceof ModuleDescriptor) {
                            ModuleDescriptor md = (ModuleDescriptor)value;
                            return ModuleAttribute.make(a, name, md);
                        }
                        break block17;
                    }
                    return new Attribute.Constant(cp, name, constant);
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    if (values.length == 0) {
                        return NamedAttribute.make(a, cp, name, null);
                    }
                    if (values.length == 1) {
                        return NamedAttribute.make(a, cp, name, values[0]);
                    }
                    Attribute[] entries = new Attribute[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        entries[i] = NamedAttribute.make(a, cp, null, values[i]);
                    }
                    return new Attribute.Composite(cp, name, entries);
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

