/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;

final class BytesOut {
    static final VarHandle cShortArrayHandle;
    static final VarHandle cIntArrayHandle;
    static final VarHandle cLongArrayHandle;
    private final OutputStream mOut;
    private byte[] mBuffer;
    private int mSize;

    BytesOut(OutputStream out, int bufferSize) {
        this.mOut = out;
        this.mBuffer = new byte[bufferSize];
    }

    public int size() {
        return this.mSize;
    }

    public void writeByte(int v) throws IOException {
        this.ensureCapacity(1);
        this.mBuffer[this.mSize++] = (byte)v;
    }

    public void writeShort(int v) throws IOException {
        this.ensureCapacity(2);
        cShortArrayHandle.set(this.mBuffer, this.mSize, (short)v);
        this.mSize += 2;
    }

    public void writeInt(int v) throws IOException {
        this.ensureCapacity(4);
        cIntArrayHandle.set(this.mBuffer, this.mSize, v);
        this.mSize += 4;
    }

    public void writeLong(long v) throws IOException {
        this.ensureCapacity(8);
        cLongArrayHandle.set(this.mBuffer, this.mSize, v);
        this.mSize += 8;
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int avail = this.mBuffer.length - this.mSize;
        if (len > avail) {
            if (this.mOut == null) {
                this.flushOrExpand(len);
            } else {
                System.arraycopy(b, off, this.mBuffer, this.mSize, avail);
                off += avail;
                this.mOut.write(this.mBuffer);
                this.mSize = 0;
                if ((len -= avail) >= this.mBuffer.length) {
                    this.mOut.write(b, off, len);
                    return;
                }
            }
        }
        System.arraycopy(b, off, this.mBuffer, this.mSize, len);
        this.mSize += len;
    }

    public void writeUTF(String str) throws IOException {
        int length = str.length();
        this.strictEnsureCapacity(2 + length);
        int start = this.mSize;
        this.mSize += 2;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080' && c != '\u0000') {
                this.mBuffer[this.mSize++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                this.strictEnsureCapacity(2);
                this.mBuffer[this.mSize++] = (byte)(0xC0 | c >> 6);
                this.mBuffer[this.mSize++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            this.strictEnsureCapacity(3);
            this.mBuffer[this.mSize++] = (byte)(0xE0 | c >> 12);
            this.mBuffer[this.mSize++] = (byte)(0x80 | c >> 6 & 0x3F);
            this.mBuffer[this.mSize++] = (byte)(0x80 | c & 0x3F);
        }
        int utflen = this.mSize - start - 2;
        if (utflen > 65535) {
            throw new IllegalStateException("String constant is too large: " + utflen + " bytes");
        }
        cShortArrayHandle.set(this.mBuffer, start, (short)utflen);
    }

    public static int checkUTF(String str) {
        return str.length() <= 21845 ? 0 : BytesOut.fullCheckUTF(str);
    }

    private static int fullCheckUTF(String str) {
        int length = str.length();
        int utflen = 0;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080' && c != '\u0000') {
                ++utflen;
                continue;
            }
            if (c < '\u0800') {
                utflen += 2;
                continue;
            }
            utflen += 3;
        }
        return utflen <= 65535 ? 0 : utflen;
    }

    public void write(BytesOut out) throws IOException {
        this.write(out.mBuffer, 0, out.mSize);
    }

    public void flush() throws IOException {
        if (this.mOut != null && this.mSize > 0) {
            this.mOut.write(this.mBuffer, 0, this.mSize);
            this.mSize = 0;
        }
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.mBuffer, this.mSize);
    }

    private void ensureCapacity(int amt) throws IOException {
        if (this.mSize + amt > this.mBuffer.length) {
            this.flushOrExpand(amt);
        }
    }

    private void strictEnsureCapacity(int amt) throws IOException {
        if (this.mSize + amt > this.mBuffer.length) {
            this.flushAndExpand(amt);
        }
    }

    private void flushOrExpand(int amt) throws IOException {
        if (this.mOut != null) {
            this.mOut.write(this.mBuffer, 0, this.mSize);
            this.mSize = 0;
        } else {
            this.expand(amt);
        }
    }

    private void flushAndExpand(int amt) throws IOException {
        if (this.mOut != null) {
            this.mOut.write(this.mBuffer, 0, this.mSize);
            this.mSize = 0;
        }
        this.expand(amt);
    }

    private void expand(int amt) {
        this.mBuffer = Arrays.copyOf(this.mBuffer, Math.max(this.mSize + amt, this.mSize << 1));
    }

    static {
        try {
            cShortArrayHandle = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
            cIntArrayHandle = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
            cLongArrayHandle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError();
        }
    }
}

