/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import org.cojen.maker.Type;

final class Candidate {
    Candidate() {
    }

    public static int compare(Type[] params, Type.Method a, Type.Method b) {
        Type[] aParams = a.paramTypes();
        Type[] bParams = b.paramTypes();
        int best = 0;
        for (int i = 0; i < params.length && i < aParams.length && i < bParams.length; ++i) {
            int cmp = Candidate.compare(params[i], aParams[i], bParams[i]);
            if (best == 0) {
                best = cmp;
                continue;
            }
            if (cmp == 0 || best == cmp) continue;
            return 0;
        }
        if (best == 0) {
            if (a.isVarargs()) {
                if (!b.isVarargs()) {
                    return 1;
                }
            } else if (b.isVarargs()) {
                return -1;
            }
        }
        return best;
    }

    public static int compare(Type param, Type aParam, Type bParam) {
        int bCost;
        int aCost = param.canConvertTo(aParam);
        if (aCost != (bCost = param.canConvertTo(bParam))) {
            return aCost < bCost ? -1 : 1;
        }
        if (aCost != 0) {
            return 0;
        }
        if (param.equals(aParam)) {
            return param.equals(bParam) ? 0 : -1;
        }
        if (param.equals(bParam)) {
            return 1;
        }
        if (param.isArray()) {
            if (aParam.isArray()) {
                if (bParam.isArray()) {
                    return Candidate.compare(Candidate.root(param), Candidate.root(aParam), Candidate.root(bParam));
                }
                return -1;
            }
            if (bParam.isArray()) {
                return 1;
            }
            return 0;
        }
        int aSpec = Candidate.specialization(aParam);
        int bSpec = Candidate.specialization(bParam);
        return Integer.compare(bSpec, aSpec);
    }

    private static Type root(Type type) {
        Type next;
        while ((next = type.elementType()) != null) {
            type = next;
        }
        return type;
    }

    private static int specialization(Type type) {
        int spec = 0;
        while ((type = type.superType()) != null) {
            ++spec;
        }
        return spec;
    }
}

