/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.WeakCache;

class ClassInjector
extends ClassLoader {
    private static final WeakCache<Object, ClassInjector> cInjectors = new WeakCache();
    private final Map<String, Boolean> mReservedNames;
    private final WeakCache<String, Group> mPackageGroups;

    private ClassInjector(boolean explicit, ClassLoader parent) {
        super(parent);
        this.mReservedNames = explicit ? null : new WeakHashMap();
        this.mPackageGroups = new WeakCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClassInjector find(boolean explicit, ClassLoader parentLoader, Object key) {
        Objects.requireNonNull(parentLoader);
        Key injectorKey = new Key(explicit, parentLoader, key);
        ClassInjector injector = cInjectors.get(injectorKey);
        if (injector == null) {
            WeakCache<Object, ClassInjector> weakCache = cInjectors;
            synchronized (weakCache) {
                injector = cInjectors.get(injectorKey);
                if (injector == null) {
                    injector = new ClassInjector(explicit, parentLoader);
                    cInjectors.put(injectorKey, injector);
                }
            }
        }
        return injector;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        Group group = this.findPackageGroup(name, false);
        if (group != null && (clazz = group.tryFindClass(name)) != null) {
            return clazz;
        }
        return this.getParent().loadClass(name);
    }

    Class<?> define(Group group, String name, byte[] b) {
        try {
            Class<?> clazz = group.define(name, b);
            return clazz;
        }
        catch (LinkageError e) {
            try {
                this.loadClass(name);
                throw new IllegalStateException("Class already defined: " + name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw e;
            }
        }
        finally {
            this.unreserve(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unreserve(String name) {
        if (this.mReservedNames != null) {
            Map<String, Boolean> map = this.mReservedNames;
            synchronized (map) {
                this.mReservedNames.remove(name);
            }
        }
    }

    String reserve(TheClassMaker maker, String className, boolean willUse) {
        if (this.mReservedNames == null) {
            Objects.requireNonNull(className);
            if (willUse && maker.mInjectorGroup == null) {
                maker.mInjectorGroup = this.findPackageGroup(className, true);
            }
            return className;
        }
        if (className == null) {
            className = ClassMaker.class.getName();
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int range = 10;
        String mangled;
        while (!this.tryReserve(maker, mangled = className + "-" + rnd.nextInt(range), willUse)) {
            if (range >= 1000000000) continue;
            range *= 10;
        }
        return mangled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryReserve(TheClassMaker maker, String name, boolean willUse) {
        Map<String, Boolean> map = this.mReservedNames;
        synchronized (map) {
            if (this.mReservedNames.put(name, Boolean.TRUE) != null) {
                return false;
            }
        }
        Group group = maker.mInjectorGroup;
        if (group == null) {
            maker.mInjectorGroup = group = this.findPackageGroup(name, true);
        }
        if (!group.isLoaded(name)) {
            ClassLoader parent;
            if (willUse || (parent = this.getParent()) == null) {
                return true;
            }
            try {
                parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Group findPackageGroup(String className, boolean create) {
        int ix = className.lastIndexOf(46);
        String packageName = ix <= 0 ? "" : className.substring(0, ix);
        Group group = this.mPackageGroups.get(packageName);
        if (group == null) {
            WeakCache<String, Group> weakCache = this.mPackageGroups;
            synchronized (weakCache) {
                group = this.mPackageGroups.get(packageName);
                if (group == null && create) {
                    group = new Group();
                    this.mPackageGroups.put(packageName, group);
                }
            }
        }
        return group;
    }

    private static class Key
    extends WeakReference<ClassLoader> {
        private final Object mRest;
        private final int mHash;

        Key(boolean explicit, ClassLoader loader, Object rest) {
            super(loader);
            this.mRest = rest;
            int hash = loader.hashCode() * 31;
            if (rest != null) {
                hash += rest.hashCode();
            }
            hash &= Integer.MAX_VALUE;
            if (explicit) {
                hash |= Integer.MIN_VALUE;
            }
            this.mHash = hash;
        }

        public int hashCode() {
            return this.mHash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Key)) return false;
            Key other = (Key)obj;
            if (this.mHash != other.mHash) return false;
            if (!Objects.equals(this.get(), other.get())) return false;
            if (!Objects.equals(this.mRest, other.mRest)) return false;
            return true;
        }
    }

    class Group
    extends ClassLoader {
        private volatile MethodHandles.Lookup mLookup;
        Map<Class, Object> mConstants;

        private Group() {
            super(ClassInjector.this.getParent());
        }

        MethodHandles.Lookup lookup(String className) {
            MethodHandles.Lookup lookup = this.mLookup;
            if (lookup == null) {
                lookup = this.makeLookup(className);
            }
            return lookup;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return ClassInjector.this.loadClass(name);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return ClassInjector.this.loadClass(name);
        }

        private Class<?> tryFindClass(String name) {
            return this.findLoadedClass(name);
        }

        private Class<?> define(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }

        private boolean isLoaded(String name) {
            return this.findLoadedClass(name) != null;
        }

        private synchronized MethodHandles.Lookup makeLookup(String className) {
            MethodHandles.Lookup lookup = this.mLookup;
            if (lookup != null) {
                return lookup;
            }
            className = ((String)className).substring(0, ((String)className).lastIndexOf(46) + 1) + "lookup";
            ClassMaker cm = new TheClassMaker((String)className, ClassInjector.this, this).public_().synthetic();
            MethodType mt = MethodType.methodType(MethodHandles.Lookup.class, Object.class);
            MethodMaker mm = cm.addMethod("lookup", mt).public_().static_().synthetic();
            Label ok = mm.label();
            mm.var(Object.class).setExact(ClassInjector.this).ifEq((Object)mm.param(0), ok);
            mm.new_(IllegalAccessError.class).throw_();
            ok.here();
            mm.return_(mm.var(MethodHandles.class).invoke("lookup"));
            Class<?> clazz = cm.finish();
            try {
                MethodHandle mh = MethodHandles.publicLookup().findStatic(clazz, "lookup", mt);
                lookup = mh.invoke(ClassInjector.this);
            }
            catch (Throwable e) {
                throw TheClassMaker.toUnchecked(e);
            }
            this.mLookup = lookup;
            return lookup;
        }
    }
}

