/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.Optional;
import org.cojen.maker.ConstantPool;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.TheMethodMaker;
import org.cojen.maker.Type;

abstract class ConstableSupport {
    ConstableSupport() {
    }

    static String toTypeDescriptor(Object value) {
        if (value instanceof ClassDesc) {
            ClassDesc desc = (ClassDesc)value;
            return desc.descriptorString();
        }
        return null;
    }

    static TheMethodMaker.ConstantVar toConstantVar(TheMethodMaker mm, Object value) {
        ConstantPool.Constant constant;
        Type type;
        if (value instanceof MethodTypeDesc) {
            MethodTypeDesc desc = (MethodTypeDesc)value;
            type = Type.from(MethodType.class);
            constant = mm.mConstants.addMethodType(desc.descriptorString());
        } else if (value instanceof DirectMethodHandleDesc) {
            DirectMethodHandleDesc desc = (DirectMethodHandleDesc)value;
            type = Type.from(MethodHandle.class);
            constant = ConstableSupport.addMethodHandle(mm, desc);
        } else if (value instanceof DynamicConstantDesc) {
            DynamicConstantDesc desc = (DynamicConstantDesc)value;
            type = mm.mClassMaker.typeFrom(desc.constantType().descriptorString());
            DirectMethodHandleDesc bootDesc = desc.bootstrapMethod();
            ConstantPool.C_MethodHandle bootHandle = ConstableSupport.addMethodHandle(mm, bootDesc);
            ConstantDesc[] bootArgs = desc.bootstrapArgs();
            ConstantPool.Constant[] bootConstants = new ConstantPool.Constant[bootArgs.length];
            ConstantPool cp = mm.mConstants;
            for (int i = 0; i < bootArgs.length; ++i) {
                bootConstants[i] = mm.addLoadableConstant(null, bootArgs[i]);
            }
            constant = cp.addDynamicConstant(mm.mClassMaker.addBootstrapMethod(bootHandle, bootConstants), desc.constantName(), type);
        } else if (value instanceof ClassDesc) {
            ClassDesc desc = (ClassDesc)value;
            type = Type.from(Class.class);
            constant = mm.addLoadableConstant(type, mm.mClassMaker.typeFrom(desc.descriptorString()));
        } else {
            if (value instanceof Constable) {
                Constable c = (Constable)value;
                Optional<? extends ConstantDesc> opt = c.describeConstable();
                if (opt.isEmpty()) {
                    return null;
                }
                return ConstableSupport.toConstantVar(mm, opt.get());
            }
            return null;
        }
        TheMethodMaker theMethodMaker = mm;
        Objects.requireNonNull(theMethodMaker);
        return new TheMethodMaker.ConstantVar(theMethodMaker, type, constant);
    }

    private static ConstantPool.C_MethodHandle addMethodHandle(TheMethodMaker mm, DirectMethodHandleDesc mdesc) {
        ConstantPool cp = mm.mConstants;
        TheClassMaker cm = mm.mClassMaker;
        int refKind = mdesc.refKind();
        Type owner = cm.typeFrom(mdesc.owner().descriptorString());
        MethodTypeDesc mtype = mdesc.invocationType();
        String name = mdesc.methodName();
        return cp.addMethodHandle(refKind, switch (refKind) {
            default -> throw new AssertionError();
            case 1, 2 -> {
                Type type = cm.typeFrom(mtype.returnType().descriptorString());
                yield cp.addField(owner.inventField(refKind == 2 ? 8 : 0, type, name));
            }
            case 3, 4 -> {
                Type type = cm.typeFrom(mtype.parameterType(0).descriptorString());
                yield cp.addField(owner.inventField(refKind == 4 ? 8 : 0, type, name));
            }
            case 5, 6, 7, 8, 9 -> {
                int drop;
                Type ret;
                if (mdesc.kind() == DirectMethodHandleDesc.Kind.CONSTRUCTOR) {
                    ret = Type.VOID;
                    drop = 0;
                } else {
                    ret = cm.typeFrom(mtype.returnType().descriptorString());
                    drop = refKind == 6 ? 0 : 1;
                }
                Type[] params = new Type[mtype.parameterCount() - drop];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = cm.typeFrom(mtype.parameterType(i + drop).descriptorString());
                }
                yield cp.addMethod(owner.inventMethod(refKind == 6 ? 8 : 0, ret, name, params));
            }
        });
    }

    static boolean isConstantDesc(Object value) {
        return value instanceof ConstantDesc;
    }

    static Type toConstantDescType(TheMethodMaker mm, Object value) {
        if (value instanceof ConstantDesc) {
            if (value instanceof MethodTypeDesc) {
                return Type.from(MethodType.class);
            }
            if (value instanceof DirectMethodHandleDesc) {
                return Type.from(MethodHandle.class);
            }
            if (value instanceof DynamicConstantDesc) {
                DynamicConstantDesc desc = (DynamicConstantDesc)value;
                return mm.mClassMaker.typeFrom(desc.constantType().descriptorString());
            }
            if (value instanceof ClassDesc) {
                return Type.from(Class.class);
            }
        }
        return null;
    }

    static boolean isDynamicConstant(Object value) {
        if (value instanceof DynamicConstantDesc) {
            return true;
        }
        if (value instanceof Constable) {
            Constable c = (Constable)value;
            Optional<? extends ConstantDesc> opt = c.describeConstable();
            return opt.isPresent() && opt.get() instanceof DynamicConstantDesc;
        }
        return false;
    }
}

