/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.IOException;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cojen.maker.BytesOut;
import org.cojen.maker.Type;

class ConstantPool {
    private final Map<Constant, Constant> mConstants = new LinkedHashMap<Constant, Constant>(64);
    private int mSize = 1;

    ConstantPool() {
    }

    void writeTo(BytesOut out) throws IOException {
        int size = this.mSize;
        if (size > 65535) {
            throw new IllegalStateException("Constant pool entry count cannot exceed 65535: " + size);
        }
        out.writeShort(size);
        for (Constant c : this.mConstants.keySet()) {
            c.writeTo(out);
        }
    }

    C_UTF8 addUTF8(String value) {
        Objects.requireNonNull(value);
        return this.addConstant(new C_UTF8(value));
    }

    C_Integer addInteger(int value) {
        return this.addConstant(new C_Integer(value));
    }

    C_Float addFloat(float value) {
        return this.addConstant(new C_Float(value));
    }

    C_Long addLong(long value) {
        C_Long constant = new C_Long(value);
        C_Long actual = this.addConstant(constant);
        if (constant == actual) {
            ++this.mSize;
        }
        return actual;
    }

    C_Double addDouble(double value) {
        C_Double constant = new C_Double(value);
        C_Double actual = this.addConstant(constant);
        if (constant == actual) {
            ++this.mSize;
        }
        return actual;
    }

    C_Class addClass(Type type) {
        if (!type.isObject()) {
            throw new IllegalArgumentException(type.name());
        }
        return this.doAddClass(type);
    }

    C_Class addClass(String name) {
        return this.addConstant(new C_Class(this.addUTF8(name.replace('.', '/')), null));
    }

    private C_Class doAddClass(Type type) {
        String name = type.isArray() ? type.descriptor() : type.name().replace('.', '/');
        return this.addConstant(new C_Class(this.addUTF8(name), type));
    }

    C_String addString(String value) {
        return this.addString(8, value);
    }

    private C_String addString(int tag, String value) {
        return this.addConstant(new C_String(tag, this.addUTF8(value)));
    }

    C_Field addField(Type.Field field) {
        C_Class clazz = this.addClass(field.enclosingType());
        C_NameAndType nameAndType = this.addNameAndType(field.name(), field.type().descriptor());
        return this.addConstant(new C_Field(clazz, nameAndType, field));
    }

    C_Method addMethod(Type.Method method) {
        int tag = method.enclosingType().isInterface() ? 11 : 10;
        C_Class clazz = this.addClass(method.enclosingType());
        C_NameAndType nameAndType = this.addNameAndType(method.name(), method.descriptor());
        return this.addConstant(new C_Method(tag, clazz, nameAndType, method));
    }

    C_String addMethodType(MethodType type) {
        return this.addMethodType(type.toMethodDescriptorString());
    }

    C_MethodHandle addMethodHandle(MethodHandleInfo info) {
        int kind = info.getReferenceKind();
        Type decl = Type.from(info.getDeclaringClass());
        MethodType mtype = info.getMethodType();
        String name = info.getName();
        return this.addMethodHandle(kind, switch (kind) {
            default -> throw new AssertionError();
            case 1, 2 -> this.addField(decl.inventField(kind == 2 ? 8 : 0, Type.from((Class)mtype.returnType()), name));
            case 3, 4 -> this.addField(decl.inventField(kind == 4 ? 8 : 0, Type.from(mtype.lastParameterType()), name));
            case 5, 6, 7, 8, 9 -> {
                Type ret = Type.from((Class)mtype.returnType());
                Type[] params = new Type[mtype.parameterCount()];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = Type.from((Class)mtype.parameterType(i));
                }
                yield this.addMethod(decl.inventMethod(kind == 6 ? 8 : 0, ret, name, params));
            }
        });
    }

    C_MethodHandle addMethodHandle(int kind, C_MemberRef ref) {
        return this.addConstant(new C_MethodHandle((byte)kind, ref));
    }

    C_Dynamic addInvokeDynamic(int bootstrapIndex, String name, String descriptor) {
        C_NameAndType nameAndType = this.addNameAndType(name, descriptor);
        return this.addConstant(new C_Dynamic(18, bootstrapIndex, nameAndType));
    }

    C_Dynamic addDynamicConstant(int bootstrapIndex, String name, Type type) {
        return this.addDynamicConstant(bootstrapIndex, this.addNameAndType(name, type.descriptor()));
    }

    C_Dynamic addDynamicConstant(int bootstrapIndex, C_UTF8 name, Type type) {
        return this.addDynamicConstant(bootstrapIndex, this.addNameAndType(name, this.addUTF8(type.descriptor())));
    }

    C_Dynamic addDynamicConstant(int bootstrapIndex, C_NameAndType nameAndType) {
        return this.addConstant(new C_Dynamic(17, bootstrapIndex, nameAndType));
    }

    Constant tryAddLoadableConstant(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return this.addString(str);
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            if (!clazz.isHidden() && !clazz.isPrimitive()) {
                return this.doAddClass(Type.from(clazz));
            }
        } else if (value instanceof Type) {
            Type type = (Type)value;
            if (!type.isHidden() && type.isObject()) {
                return this.doAddClass(type);
            }
        } else if (value instanceof Number) {
            if (value instanceof Integer) {
                Integer num = (Integer)value;
                return this.addInteger(num);
            }
            if (value instanceof Long) {
                Long num = (Long)value;
                return this.addLong(num);
            }
            if (value instanceof Float) {
                Float num = (Float)value;
                return this.addFloat(num.floatValue());
            }
            if (value instanceof Double) {
                Double num = (Double)value;
                return this.addDouble(num);
            }
        } else {
            if (value instanceof MethodType) {
                MethodType mt = (MethodType)value;
                return this.addMethodType(mt);
            }
            if (value instanceof MethodHandleInfo) {
                MethodHandleInfo info = (MethodHandleInfo)value;
                return this.addMethodHandle(info);
            }
        }
        return null;
    }

    C_String addMethodType(String typeDesc) {
        return this.addString(16, typeDesc);
    }

    C_String addModule(String name) {
        return this.addString(19, name);
    }

    C_String addPackage(String name) {
        return this.addString(20, name.replace('.', '/'));
    }

    C_NameAndType addNameAndType(String name, String typeDesc) {
        return this.addNameAndType(this.addUTF8(name), this.addUTF8(typeDesc));
    }

    C_NameAndType addNameAndType(C_UTF8 name, C_UTF8 typeDesc) {
        return this.addConstant(new C_NameAndType(name, typeDesc));
    }

    private <C extends Constant> C addConstant(C constant) {
        Constant existing = this.mConstants.get(constant);
        if (existing == null) {
            constant.mIndex = this.mSize++;
            this.mConstants.put((Constant)constant, (Constant)constant);
        } else {
            constant = existing;
        }
        return constant;
    }

    static abstract class Constant {
        final int mTag;
        int mIndex;

        Constant(int tag) {
            this.mTag = tag;
        }

        void writeTo(BytesOut out) throws IOException {
            out.writeByte(this.mTag);
        }
    }

    static final class C_UTF8
    extends Constant {
        final String mValue;

        C_UTF8(String value) {
            super(1);
            this.mValue = value;
        }

        public int hashCode() {
            return this.mValue.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_UTF8)) return false;
            C_UTF8 other = (C_UTF8)obj;
            if (!this.mValue.equals(other.mValue)) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeUTF(this.mValue);
        }
    }

    static final class C_Integer
    extends Constant {
        final int mValue;

        C_Integer(int value) {
            super(3);
            this.mValue = value;
        }

        public int hashCode() {
            return Integer.hashCode(this.mValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_Integer)) return false;
            C_Integer other = (C_Integer)obj;
            if (this.mValue != other.mValue) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.mValue);
        }
    }

    static final class C_Float
    extends Constant {
        final float mValue;

        C_Float(float value) {
            super(4);
            this.mValue = value;
        }

        public int hashCode() {
            return Float.hashCode(this.mValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_Float)) return false;
            C_Float other = (C_Float)obj;
            if (Float.floatToRawIntBits(this.mValue) != Float.floatToRawIntBits(other.mValue)) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeFloat(this.mValue);
        }
    }

    static final class C_Long
    extends Constant {
        final long mValue;

        C_Long(long value) {
            super(5);
            this.mValue = value;
        }

        public int hashCode() {
            return Long.hashCode(this.mValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_Long)) return false;
            C_Long other = (C_Long)obj;
            if (this.mValue != other.mValue) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.mValue);
        }
    }

    static final class C_Double
    extends Constant {
        final double mValue;

        C_Double(double value) {
            super(6);
            this.mValue = value;
        }

        public int hashCode() {
            return Double.hashCode(this.mValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_Double)) return false;
            C_Double other = (C_Double)obj;
            if (Double.doubleToRawLongBits(this.mValue) != Double.doubleToRawLongBits(other.mValue)) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeDouble(this.mValue);
        }
    }

    static final class C_Class
    extends C_String {
        final Type mType;

        C_Class(C_UTF8 name, Type type) {
            super(7, name);
            this.mType = type;
        }

        void rename(C_UTF8 name) {
            this.mValue = name;
        }
    }

    static class C_String
    extends Constant {
        C_UTF8 mValue;

        C_String(int tag, C_UTF8 value) {
            super(tag);
            this.mValue = value;
        }

        public int hashCode() {
            return this.mValue.hashCode() * 31 + this.mTag;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_String)) return false;
            C_String other = (C_String)obj;
            if (this.mTag != other.mTag) return false;
            if (!this.mValue.equals(other.mValue)) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeShort(this.mValue.mIndex);
        }
    }

    static final class C_NameAndType
    extends Constant {
        final C_UTF8 mName;
        final C_UTF8 mTypeDesc;

        C_NameAndType(C_UTF8 name, C_UTF8 typeDesc) {
            super(12);
            this.mName = name;
            this.mTypeDesc = typeDesc;
        }

        public int hashCode() {
            return this.mName.hashCode() * 31 + this.mTypeDesc.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_NameAndType)) return false;
            C_NameAndType other = (C_NameAndType)obj;
            if (!this.mName.equals(other.mName)) return false;
            if (!this.mTypeDesc.equals(other.mTypeDesc)) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeShort(this.mName.mIndex);
            out.writeShort(this.mTypeDesc.mIndex);
        }
    }

    static final class C_Field
    extends C_MemberRef {
        final Type.Field mField;

        C_Field(C_Class clazz, C_NameAndType nameAndType, Type.Field field) {
            super(9, clazz, nameAndType);
            this.mField = field;
        }
    }

    static final class C_Method
    extends C_MemberRef {
        final Type.Method mMethod;

        C_Method(int tag, C_Class clazz, C_NameAndType nameAndType, Type.Method method) {
            super(tag, clazz, nameAndType);
            this.mMethod = method;
        }
    }

    static abstract class C_MemberRef
    extends Constant {
        final C_Class mClass;
        final C_NameAndType mNameAndType;

        C_MemberRef(int tag, C_Class clazz, C_NameAndType nameAndType) {
            super(tag);
            this.mClass = clazz;
            this.mNameAndType = nameAndType;
        }

        public int hashCode() {
            return (this.mClass.hashCode() + this.mNameAndType.hashCode()) * 31 + this.mTag;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_MemberRef)) return false;
            C_MemberRef other = (C_MemberRef)obj;
            if (this.mTag != other.mTag) return false;
            if (!this.mClass.equals(other.mClass)) return false;
            if (!this.mNameAndType.equals(other.mNameAndType)) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeShort(this.mClass.mIndex);
            out.writeShort(this.mNameAndType.mIndex);
        }
    }

    static final class C_MethodHandle
    extends Constant {
        final byte mKind;
        final Constant mRef;

        C_MethodHandle(byte kind, Constant ref) {
            super(15);
            this.mKind = kind;
            this.mRef = ref;
        }

        public int hashCode() {
            return this.mKind * 31 + this.mRef.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_MethodHandle)) return false;
            C_MethodHandle other = (C_MethodHandle)obj;
            if (this.mKind != other.mKind) return false;
            if (!this.mRef.equals(other.mRef)) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeByte(this.mKind);
            out.writeShort(this.mRef.mIndex);
        }
    }

    static final class C_Dynamic
    extends Constant {
        final int mBootstrapIndex;
        final C_NameAndType mNameAndType;

        C_Dynamic(int tag, int bootstrapIndex, C_NameAndType nameAndType) {
            super(tag);
            this.mBootstrapIndex = bootstrapIndex;
            this.mNameAndType = nameAndType;
        }

        public int hashCode() {
            return (this.mNameAndType.hashCode() * 31 + this.mTag) * 31 + this.mBootstrapIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof C_Dynamic)) return false;
            C_Dynamic other = (C_Dynamic)obj;
            if (this.mTag != other.mTag) return false;
            if (this.mBootstrapIndex != other.mBootstrapIndex) return false;
            if (!this.mNameAndType.equals(other.mNameAndType)) return false;
            return true;
        }

        @Override
        void writeTo(BytesOut out) throws IOException {
            super.writeTo(out);
            out.writeShort(this.mBootstrapIndex);
            out.writeShort(this.mNameAndType.mIndex);
        }
    }
}

