/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.cojen.maker.ClassInjector;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.TheMethodMaker;

public abstract class ConstantsRegistry {
    private static WeakHashMap<ClassLoader, WeakReference<ConstantsRegistry>> cRegistries;
    private Map<Class, Object> mConstants;

    protected ConstantsRegistry() {
    }

    static int add(TheClassMaker cm, Object value) {
        Entries entries;
        Objects.requireNonNull(value);
        Object obj = cm.mExactConstants;
        if (obj == null) {
            cm.mExactConstants = value;
            return 0;
        }
        if (obj instanceof Entries) {
            entries = (Entries)obj;
        } else {
            entries = new Entries(obj);
            cm.mExactConstants = entries;
        }
        return entries.add(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void finish(TheClassMaker cm, MethodHandles.Lookup lookup, Class clazz) {
        ClassLoader loader;
        Object obj = cm.mExactConstants;
        if (obj == null) {
            return;
        }
        if (obj instanceof Entries) {
            Entries entries = (Entries)obj;
            entries.prune();
        }
        if ((loader = clazz.getClassLoader()) instanceof ClassInjector.Group) {
            ClassInjector.Group group;
            ClassInjector.Group group2 = group = (ClassInjector.Group)loader;
            synchronized (group2) {
                Map<Class, Object> constants = group.mConstants;
                if (constants == null) {
                    group.mConstants = constants = new WeakHashMap<Class, Object>(4);
                }
                constants.put(clazz, obj);
            }
        }
        Object object = ConstantsRegistry.class;
        synchronized (ConstantsRegistry.class) {
            ConstantsRegistry registry;
            WeakReference<ConstantsRegistry> registryRef;
            if (cRegistries == null) {
                cRegistries = new WeakHashMap(4);
            }
            if ((registryRef = cRegistries.get(loader)) == null || (registry = (ConstantsRegistry)registryRef.get()) == null) {
                registry = ConstantsRegistry.defineRegistry(lookup);
                cRegistries.put(loader, new WeakReference<ConstantsRegistry>(registry));
            }
            // ** MonitorExit[var7_9] (shouldn't be in output)
            object = registry;
            synchronized (object) {
                Map<Class, Object> constants = registry.mConstants;
                if (constants == null) {
                    registry.mConstants = constants = new WeakHashMap<Class, Object>(4);
                }
                constants.put(clazz, obj);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object find(MethodHandles.Lookup lookup, String name, Class<?> type, int slot) {
        Object object;
        ClassInjector.Group group;
        Object value;
        if ((lookup.lookupModes() & 0x40) == 0) {
            throw new IllegalStateException();
        }
        Class<?> clazz = lookup.lookupClass();
        ClassLoader loader = null;
        ConstantsRegistry registry = null;
        if (clazz.isHidden()) {
            try {
                value = MethodHandles.classData(lookup, name, Object.class);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException();
            }
        }
        loader = clazz.getClassLoader();
        if (loader instanceof ClassInjector.Group) {
            group = (ClassInjector.Group)loader;
            object = group;
            synchronized (object) {
                value = group.mConstants == null ? null : group.mConstants.get(clazz);
            }
        }
        Object object2 = ConstantsRegistry.class;
        synchronized (ConstantsRegistry.class) {
            WeakReference<ConstantsRegistry> registryRef = cRegistries.get(loader);
            // ** MonitorExit[var10_12] (shouldn't be in output)
            if (registryRef == null || (registry = (ConstantsRegistry)registryRef.get()) == null) {
                value = null;
            } else {
                object2 = registry;
                synchronized (object2) {
                    value = registry.mConstants == null ? null : registry.mConstants.get(clazz);
                }
            }
            if (value == null) {
                throw new NullPointerException();
            }
            if (value instanceof Entries) {
                Entries entries = (Entries)value;
                object = entries;
                synchronized (object) {
                    value = entries.mValues[slot & Integer.MAX_VALUE];
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    int size = entries.mSize;
                    if (slot < 0) {
                        entries.mValues[slot & Integer.MAX_VALUE] = null;
                        entries.mSize = --size;
                    }
                    if (size > 0) {
                        return value;
                    }
                }
            }
            if (slot < 0) {
                if (loader instanceof ClassInjector.Group) {
                    group = (ClassInjector.Group)loader;
                    object = group;
                    synchronized (object) {
                        group.mConstants.remove(clazz);
                        if (group.mConstants.isEmpty()) {
                            group.mConstants = null;
                        }
                    }
                }
                if (registry != null) {
                    object = registry;
                    synchronized (object) {
                        registry.mConstants.remove(clazz);
                        if (registry.mConstants.isEmpty()) {
                            registry.mConstants = null;
                        }
                    }
                }
            }
            return value;
        }
    }

    private static ConstantsRegistry defineRegistry(MethodHandles.Lookup lookup) {
        VarHandle vh;
        Object className = "registry";
        String pn = lookup.lookupClass().getPackageName();
        if (!pn.isEmpty()) {
            className = pn + "." + (String)className;
        }
        TheClassMaker cm = (TheClassMaker)ClassMaker.begin((String)className, lookup).synthetic();
        cm.extend(ConstantsRegistry.class);
        cm.addField(ConstantsRegistry.class, "_").static_().final_().synthetic();
        cm.addConstructor().private_().synthetic();
        TheMethodMaker mm = cm.addClinit();
        mm.field("_").set(mm.new_(cm));
        Class<?> clazz = cm.finishHidden(true).lookupClass();
        try {
            vh = lookup.findStaticVarHandle(clazz, "_", ConstantsRegistry.class);
        }
        catch (Exception e) {
            throw TheClassMaker.toUnchecked(e);
        }
        return vh.get();
    }

    private static final class Entries {
        Object[] mValues;
        int mSize;

        Entries(Object first) {
            Object[] objectArray = new Object[4];
            this.mValues = objectArray;
            objectArray[0] = first;
            this.mSize = 1;
        }

        int add(Object value) {
            int slot = this.mSize;
            if (slot >= this.mValues.length) {
                this.mValues = Arrays.copyOf(this.mValues, (int)Math.min(Integer.MAX_VALUE, (long)slot << 1));
            }
            this.mValues[slot] = value;
            this.mSize = slot + 1;
            return slot;
        }

        void prune() {
            if (this.mSize < this.mValues.length) {
                this.mValues = Arrays.copyOf(this.mValues, this.mSize);
            }
        }
    }
}

