/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.function.Consumer;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.Maker;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.TheMethodMaker;
import org.cojen.maker.Type;
import org.cojen.maker.Variable;

public interface MethodMaker
extends Maker {
    public static MethodMaker begin(MethodHandles.Lookup lookup, Object retType, String name, Object ... paramTypes) {
        return MethodMaker.begin(lookup, null, retType, name, paramTypes);
    }

    public static MethodMaker begin(MethodHandles.Lookup lookup, Object retType, String name) {
        return MethodMaker.begin(lookup, retType, name, Type.NO_ARGS);
    }

    public static MethodMaker begin(MethodHandles.Lookup lookup, String name, MethodType type) {
        if (type == null) {
            type = MethodType.methodType(Void.TYPE);
        }
        return MethodMaker.begin(lookup, type, type.returnType(), name, (Object[])type.parameterArray());
    }

    private static MethodMaker begin(MethodHandles.Lookup lookup, MethodType type, Object retType, String methodName, Object ... paramTypes) {
        MethodType mtype;
        final String mname = methodName == null ? "_" : methodName;
        Class<?> lookupClass = lookup.lookupClass();
        Object className = lookupClass.getName();
        className = ((String)className).substring(0, ((String)className).lastIndexOf(46) + 1) + mname;
        ClassLoader loader = lookupClass.getClassLoader();
        TheClassMaker cm = TheClassMaker.begin(false, (String)className, true, loader, null, lookup);
        Type.Method method = cm.defineMethod(retType, mname, paramTypes);
        if (type != null) {
            mtype = type;
        } else {
            Type[] ptypes = method.paramTypes();
            Class[] pclasses = new Class[ptypes.length];
            for (int i = 0; i < pclasses.length; ++i) {
                pclasses[i] = MethodMaker.classFor(ptypes[i]);
            }
            mtype = MethodType.methodType(MethodMaker.classFor(method.returnType()), pclasses);
        }
        TheMethodMaker mm = new TheMethodMaker(cm, method){

            @Override
            public MethodHandle finish() {
                MethodHandles.Lookup lookup = this.mClassMaker.finishHidden();
                try {
                    return lookup.findStatic(lookup.lookupClass(), mname, mtype);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        mm.static_();
        cm.doAddMethod(mm);
        return mm;
    }

    private static Class<?> classFor(Type type) {
        Class clazz = type.clazz();
        if (clazz == null) {
            throw new IllegalStateException("Unknown type: " + type.name());
        }
        return clazz;
    }

    public String name();

    @Override
    public MethodMaker public_();

    @Override
    public MethodMaker private_();

    @Override
    public MethodMaker protected_();

    @Override
    public MethodMaker static_();

    @Override
    public MethodMaker final_();

    public MethodMaker synchronized_();

    public MethodMaker abstract_();

    public MethodMaker native_();

    @Override
    public MethodMaker synthetic();

    public MethodMaker bridge();

    public MethodMaker varargs();

    public MethodMaker throws_(Object var1);

    public MethodMaker override();

    @Override
    public MethodMaker signature(Object ... var1);

    public Variable class_();

    public Variable this_();

    public Variable super_();

    public Variable param(int var1);

    public int paramCount();

    public Variable var(Object var1);

    public void lineNum(int var1);

    public Label label();

    public void goto_(Label var1);

    public void return_();

    public void return_(Object var1);

    public Field field(String var1);

    public Variable invoke(String var1, Object ... var2);

    default public Variable invoke(String name) {
        return this.invoke(name, Type.NO_ARGS);
    }

    public void invokeSuperConstructor(Object ... var1);

    default public void invokeSuperConstructor() {
        this.invokeSuperConstructor(Type.NO_ARGS);
    }

    public void invokeThisConstructor(Object ... var1);

    default public void invokeThisConstructor() {
        this.invokeThisConstructor(Type.NO_ARGS);
    }

    public Variable invoke(MethodHandle var1, Object ... var2);

    default public Variable invoke(MethodHandle handle) {
        return this.invoke(handle, Type.NO_ARGS);
    }

    public Variable new_(Object var1, Object ... var2);

    default public Variable new_(Object type) {
        return this.new_(type, Type.NO_ARGS);
    }

    public Variable catch_(Label var1, Label var2, Object var3);

    public Variable catch_(Label var1, Label var2, Object ... var3);

    public void catch_(Label var1, Object var2, Consumer<Variable> var3);

    public void finally_(Label var1, Runnable var2);

    public Variable concat(Object ... var1);

    public Field access(VarHandle var1, Object ... var2);

    default public Field access(VarHandle handle) {
        return this.access(handle, Type.NO_ARGS);
    }

    public void nop();

    public ClassMaker addInnerClass(String var1);

    public MethodHandle finish();
}

