/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.util.List;
import java.util.Set;
import org.cojen.maker.Attribute;
import org.cojen.maker.Attributed;
import org.cojen.maker.BytesOut;
import org.cojen.maker.ConstantPool;
import org.cojen.maker.TheClassMaker;

class ModuleAttribute
extends Attribute {
    private final BytesOut mBytes = new BytesOut(null, 100);

    static ModuleAttribute make(Attributed a, String name, ModuleDescriptor desc) {
        String mainClass;
        TheClassMaker cm;
        block9: {
            block8: {
                if (!(a instanceof TheClassMaker)) break block8;
                cm = (TheClassMaker)a;
                if ("Module".equals(name)) break block9;
            }
            throw new IllegalArgumentException();
        }
        if (!"module-info".equals(cm.name())) {
            throw new IllegalStateException();
        }
        cm.toModule();
        ConstantPool cp = cm.mConstants;
        ModuleAttribute attr = new ModuleAttribute(cp, name);
        try {
            attr.encode(cp, desc);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        Set<String> packages = desc.packages();
        if (!packages.isEmpty()) {
            cm.addAttribute(new Packages(cp, packages));
        }
        if ((mainClass = (String)desc.mainClass().orElse(null)) != null) {
            cm.addAttribute(new Attribute.Constant(cp, "ModuleMainClass", cp.addClass(mainClass)));
        }
        return attr;
    }

    private ModuleAttribute(ConstantPool cp, String name) {
        super(cp, name);
    }

    @Override
    int length() {
        return this.mBytes.size();
    }

    @Override
    void writeDataTo(BytesOut out) throws IOException {
        out.write(this.mBytes);
    }

    private void encode(ConstantPool cp, ModuleDescriptor desc) throws IOException {
        Set<String> targets;
        int flags;
        this.mBytes.writeShort(cp.addModule((String)desc.name()).mIndex);
        int flags2 = 0;
        for (ModuleDescriptor.Modifier modifier : desc.modifiers()) {
            switch (modifier) {
                case OPEN: {
                    flags2 |= 0x20;
                    break;
                }
                case SYNTHETIC: {
                    flags2 |= 0x1000;
                    break;
                }
                case MANDATED: {
                    flags2 |= 0x8000;
                }
            }
        }
        this.mBytes.writeShort(flags2);
        String version = desc.rawVersion().orElse(null);
        this.mBytes.writeShort(version == null ? 0 : cp.addUTF8((String)version).mIndex);
        Set<Object> set = desc.requires();
        this.mBytes.writeShort(set.size());
        for (ModuleDescriptor.Requires requires : set) {
            this.mBytes.writeShort(cp.addModule((String)requires.name()).mIndex);
            flags = 0;
            for (ModuleDescriptor.Requires.Modifier modifier : requires.modifiers()) {
                switch (modifier) {
                    case TRANSITIVE: {
                        flags |= 0x20;
                        break;
                    }
                    case STATIC: {
                        flags |= 0x40;
                        break;
                    }
                    case SYNTHETIC: {
                        flags |= 0x1000;
                        break;
                    }
                    case MANDATED: {
                        flags |= 0x8000;
                    }
                }
            }
            this.mBytes.writeShort(flags);
            String version2 = requires.rawCompiledVersion().orElse(null);
            this.mBytes.writeShort(version2 == null ? 0 : cp.addUTF8((String)version2).mIndex);
        }
        set = desc.exports();
        this.mBytes.writeShort(set.size());
        for (ModuleDescriptor.Exports exports : set) {
            this.mBytes.writeShort(cp.addPackage((String)exports.source()).mIndex);
            flags = 0;
            for (ModuleDescriptor.Exports.Modifier modifier : exports.modifiers()) {
                switch (modifier) {
                    case SYNTHETIC: {
                        flags |= 0x1000;
                        break;
                    }
                    case MANDATED: {
                        flags |= 0x8000;
                    }
                }
            }
            this.mBytes.writeShort(flags);
            targets = exports.targets();
            this.mBytes.writeShort(targets.size());
            for (String target : targets) {
                this.mBytes.writeShort(cp.addModule((String)target).mIndex);
            }
        }
        set = desc.opens();
        this.mBytes.writeShort(set.size());
        for (ModuleDescriptor.Opens opens : set) {
            this.mBytes.writeShort(cp.addPackage((String)opens.source()).mIndex);
            flags = 0;
            for (ModuleDescriptor.Opens.Modifier modifier : opens.modifiers()) {
                switch (modifier) {
                    case SYNTHETIC: {
                        flags |= 0x1000;
                        break;
                    }
                    case MANDATED: {
                        flags |= 0x8000;
                    }
                }
            }
            this.mBytes.writeShort(flags);
            targets = opens.targets();
            this.mBytes.writeShort(targets.size());
            for (String target : targets) {
                this.mBytes.writeShort(cp.addModule((String)target).mIndex);
            }
        }
        set = desc.uses();
        this.mBytes.writeShort(set.size());
        for (String string : set) {
            this.mBytes.writeShort(cp.addClass((String)string).mIndex);
        }
        set = desc.provides();
        this.mBytes.writeShort(set.size());
        for (ModuleDescriptor.Provides provides : set) {
            this.mBytes.writeShort(cp.addClass((String)provides.service()).mIndex);
            List<String> providers = provides.providers();
            this.mBytes.writeShort(providers.size());
            for (String string : providers) {
                this.mBytes.writeShort(cp.addClass((String)string).mIndex);
            }
        }
    }

    static class Packages
    extends Attribute {
        private final ConstantPool.C_String[] mPackages;

        Packages(ConstantPool cp, Set<String> packages) {
            super(cp, "ModulePackages");
            this.mPackages = new ConstantPool.C_String[packages.size()];
            int i = 0;
            for (String p : packages) {
                this.mPackages[i++] = cp.addPackage(p);
            }
        }

        @Override
        int length() {
            return 2 + this.mPackages.length * 2;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mPackages.length);
            for (ConstantPool.C_String p : this.mPackages) {
                out.writeShort(p.mIndex);
            }
        }
    }
}

