/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.IOException;
import java.util.Arrays;
import org.cojen.maker.Attribute;
import org.cojen.maker.BytesOut;
import org.cojen.maker.ConstantPool;

class StackMapTable
extends Attribute {
    private final Frame mInitFrame;
    private Frame mFirstFrame;
    private Frame mLastFrame;
    private int mNumFrames;
    private BytesOut mFinished;

    StackMapTable(ConstantPool cp, int[] initCodes) {
        super(cp, "StackMapTable");
        this.mInitFrame = new Frame(Integer.MIN_VALUE, initCodes, null);
    }

    void add(int address, int[] localCodes, int[] stackCodes) {
        Frame frame = new Frame(address, localCodes, stackCodes);
        Frame last = this.mLastFrame;
        if (last == null) {
            this.mFirstFrame = frame;
        } else {
            if (address <= last.mAddress) {
                if (address < last.mAddress) {
                    throw new IllegalStateException("Reverse address ordering");
                }
                if (Frame.diff(last.mStackCodes, stackCodes) != 0) {
                    throw new IllegalStateException("Mismatched stack at branch target");
                }
                last.mLocalCodes = localCodes;
                return;
            }
            last.mNext = frame;
        }
        this.mLastFrame = frame;
        ++this.mNumFrames;
    }

    void reset() {
        this.mFirstFrame = null;
        this.mLastFrame = null;
        this.mNumFrames = 0;
        this.mFinished = null;
    }

    boolean finish() {
        if (this.mFirstFrame == null) {
            return false;
        }
        BytesOut out = new BytesOut(null, this.mNumFrames * 4);
        try {
            out.writeShort(this.mNumFrames);
            Frame prev = this.mInitFrame;
            Frame frame = this.mFirstFrame;
            do {
                frame.writeTo(prev, out);
                prev = frame;
            } while ((frame = frame.mNext) != null);
            this.mFinished = out;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return true;
    }

    @Override
    int length() {
        return this.mFinished.size();
    }

    @Override
    void writeDataTo(BytesOut out) throws IOException {
        out.write(this.mFinished);
    }

    private static class Frame {
        final int mAddress;
        int[] mLocalCodes;
        final int[] mStackCodes;
        Frame mNext;

        Frame(int address, int[] localCodes, int[] stackCodes) {
            this.mAddress = address;
            this.mLocalCodes = localCodes;
            this.mStackCodes = stackCodes;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeTo(Frame prev, BytesOut out) throws IOException {
            int offsetDelta;
            if (prev.mAddress < 0) {
                if (prev.mAddress != Integer.MIN_VALUE) throw new IllegalStateException("Unpositioned frame");
                offsetDelta = this.mAddress;
            } else {
                offsetDelta = this.mAddress - prev.mAddress - 1;
            }
            if (this.mStackCodes == null || this.mStackCodes.length <= 1) {
                int localsDiff = Frame.diff(prev.mLocalCodes, this.mLocalCodes);
                if (localsDiff == 0) {
                    if (offsetDelta < 64) {
                        if (this.mStackCodes == null || this.mStackCodes.length == 0) {
                            out.writeByte(offsetDelta);
                            return;
                        } else {
                            out.writeByte(offsetDelta + 64);
                            Frame.writeCode(out, this.mStackCodes[0]);
                        }
                        return;
                    } else if (this.mStackCodes == null || this.mStackCodes.length == 0) {
                        out.writeByte(251);
                        out.writeShort(offsetDelta);
                        return;
                    } else {
                        out.writeByte(247);
                        out.writeShort(offsetDelta);
                        Frame.writeCode(out, this.mStackCodes[0]);
                    }
                    return;
                }
                if (localsDiff >= -3 && localsDiff <= 3 && (this.mStackCodes == null || this.mStackCodes.length == 0)) {
                    out.writeByte(251 + localsDiff);
                    out.writeShort(offsetDelta);
                    if (localsDiff <= 0) return;
                    for (int i = this.mLocalCodes.length - localsDiff; i < this.mLocalCodes.length; ++i) {
                        Frame.writeCode(out, this.mLocalCodes[i]);
                    }
                    return;
                }
            }
            out.writeByte(255);
            out.writeShort(offsetDelta);
            Frame.writeCodes(out, this.mLocalCodes);
            Frame.writeCodes(out, this.mStackCodes);
        }

        private static void writeCodes(BytesOut out, int[] codes) throws IOException {
            if (codes == null) {
                out.writeShort(0);
            } else {
                out.writeShort(codes.length);
                for (int code : codes) {
                    Frame.writeCode(out, code);
                }
            }
        }

        private static void writeCode(BytesOut out, int code) throws IOException {
            int smCode = code & 0xFF;
            out.writeByte(smCode);
            if (smCode >= 7) {
                out.writeShort(code >> 8);
            }
        }

        private static int diff(int[] from, int[] to) {
            if (from == null || from.length == 0) {
                return to == null ? 0 : to.length;
            }
            if (to == null || to.length == 0) {
                return -from.length;
            }
            int mismatch = Arrays.mismatch(from, to);
            if (mismatch < 0) {
                return 0;
            }
            if (mismatch >= from.length || mismatch >= to.length) {
                return to.length - from.length;
            }
            return Integer.MIN_VALUE;
        }
    }
}

