/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.cojen.maker.Label;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Variable;

final class Switcher {
    Switcher() {
    }

    public static void switchString(MethodMaker mm, Variable condition, Label defaultLabel, String[] keys, Label ... labels) {
        ArrayList list;
        if (condition.classType() != String.class) {
            throw new IllegalStateException("Not switching on a String type");
        }
        if (keys.length != labels.length) {
            throw new IllegalArgumentException("Number of cases and labels doesn't match");
        }
        if (keys.length <= 2) {
            for (int i = 0; i < keys.length; ++i) {
                condition.invoke("equals", Objects.requireNonNull(keys[i])).ifTrue(labels[i]);
            }
            defaultLabel.goto_();
            return;
        }
        HashMap<Integer, Object> hashMatches = new HashMap<Integer, Object>();
        for (int i = 0; i < keys.length; ++i) {
            String key = Objects.requireNonNull(keys[i]);
            StringMatch match = new StringMatch(key, labels[i]);
            Integer hash = key.hashCode();
            Object matches = hashMatches.get(hash);
            if (matches == null) {
                hashMatches.put(hash, match);
                continue;
            }
            if (matches instanceof ArrayList) {
                list = (ArrayList)matches;
            } else {
                list = new ArrayList();
                list.add(matches);
                hashMatches.put(hash, list);
            }
            list.add(match);
        }
        int[] hashCases = new int[hashMatches.size()];
        Label[] hashLabels = new Label[hashCases.length];
        int i = 0;
        for (Integer hash : hashMatches.keySet()) {
            hashCases[i] = hash;
            hashLabels[i++] = mm.label();
        }
        condition.invoke("hashCode").switch_(defaultLabel, hashCases, hashLabels);
        i = 0;
        for (Object matches : hashMatches.values()) {
            hashLabels[i++].here();
            if (matches instanceof ArrayList) {
                list = (ArrayList)matches;
                for (Object match : list) {
                    ((StringMatch)match).addCheck(condition);
                }
            } else {
                ((StringMatch)matches).addCheck(condition);
            }
            mm.goto_(defaultLabel);
        }
    }

    private record StringMatch(String key, Label label) {
        void addCheck(Variable condition) {
            condition.invoke("equals", this.key).ifTrue(this.label);
        }
    }
}

