/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cojen.maker.AnnotationMaker;
import org.cojen.maker.BytesOut;
import org.cojen.maker.ConstantPool;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.Type;
import org.cojen.maker.Typed;

class TheAnnotationMaker
implements AnnotationMaker {
    private final TheClassMaker mClassMaker;
    private final ConstantPool.C_UTF8 mType;
    private final Map<ConstantPool.C_UTF8, Element> mElements;
    private TheAnnotationMaker mParent;

    TheAnnotationMaker(TheClassMaker classMaker, Object annotationType) {
        this.mClassMaker = classMaker;
        this.mType = classMaker.mConstants.addUTF8(classMaker.typeFrom(annotationType).descriptor());
        this.mElements = new LinkedHashMap<ConstantPool.C_UTF8, Element>();
    }

    @Override
    public void put(String name, Object value) {
        if (this.mElements.size() >= 65535) {
            throw new IllegalStateException();
        }
        ConstantPool.C_UTF8 utf = this.mClassMaker.mConstants.addUTF8(name);
        if (this.mElements.containsKey(utf)) {
            throw new IllegalStateException();
        }
        this.mElements.put(utf, TheAnnotationMaker.toElement(this, this.mClassMaker.mConstants, value));
    }

    @Override
    public AnnotationMaker newAnnotation(Object annotationType) {
        TheAnnotationMaker am = new TheAnnotationMaker(this.mClassMaker, annotationType);
        am.mParent = this;
        return am;
    }

    int length() {
        int length = 4 + this.mElements.size() * 2;
        for (Element e : this.mElements.values()) {
            length += e.length();
        }
        return length;
    }

    void writeTo(BytesOut out) throws IOException {
        out.writeShort(this.mType.mIndex);
        out.writeShort(this.mElements.size());
        for (Map.Entry<ConstantPool.C_UTF8, Element> e : this.mElements.entrySet()) {
            out.writeShort(e.getKey().mIndex);
            e.getValue().writeTo(out);
        }
    }

    static Element toElement(TheAnnotationMaker parent, ConstantPool cp, Object value) {
        Objects.requireNonNull(value);
        if (value instanceof String) {
            String str = (String)value;
            return new ConstElement('s', cp.addUTF8(str));
        }
        if (value instanceof Integer) {
            Integer num = (Integer)value;
            return new ConstElement('I', cp.addInteger(num));
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return new ConstElement('Z', cp.addInteger(b != false ? 1 : 0));
        }
        if (value instanceof Enum) {
            Enum ev = (Enum)value;
            return new EnumElement(cp.addUTF8(Type.from(ev.getDeclaringClass()).descriptor()), cp.addUTF8(ev.name()));
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length > 65535) {
                throw new IllegalArgumentException();
            }
            Element[] elements = new Element[length];
            for (int i = 0; i < length; ++i) {
                elements[i] = TheAnnotationMaker.toElement(parent, cp, Array.get(value, i));
            }
            return new ArrayElement(elements);
        }
        if (value instanceof TheAnnotationMaker) {
            TheAnnotationMaker am = (TheAnnotationMaker)value;
            if (am.mParent != parent) {
                throw new IllegalStateException();
            }
            am.mParent = null;
            return new AnnotationElement(am);
        }
        if (value instanceof Long) {
            Long num = (Long)value;
            return new ConstElement('J', cp.addLong(num));
        }
        if (value instanceof Double) {
            Double num = (Double)value;
            return new ConstElement('D', cp.addDouble(num));
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            return new ConstElement('c', cp.addUTF8(Type.from(clazz).descriptor()));
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return new ConstElement('C', cp.addInteger(c.charValue()));
        }
        if (value instanceof Byte) {
            Byte num = (Byte)value;
            return new ConstElement('B', cp.addInteger(num.intValue()));
        }
        if (value instanceof Short) {
            Short num = (Short)value;
            return new ConstElement('S', cp.addInteger(num.intValue()));
        }
        if (value instanceof Float) {
            Float num = (Float)value;
            return new ConstElement('F', cp.addFloat(num.floatValue()));
        }
        if (value instanceof Typed) {
            Typed typed = (Typed)value;
            return new ConstElement('c', cp.addUTF8(typed.type().descriptor()));
        }
        throw new IllegalArgumentException();
    }

    static abstract class Element {
        private final char mTag;

        Element(char tag) {
            this.mTag = tag;
        }

        abstract int length();

        final void writeTo(BytesOut out) throws IOException {
            out.writeByte((byte)this.mTag);
            this.writeDataTo(out);
        }

        abstract void writeDataTo(BytesOut var1) throws IOException;
    }

    static class ConstElement
    extends Element {
        private final ConstantPool.Constant mConstant;

        ConstElement(char tag, ConstantPool.Constant constant) {
            super(tag);
            this.mConstant = constant;
        }

        @Override
        int length() {
            return 3;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mConstant.mIndex);
        }
    }

    static class EnumElement
    extends Element {
        private final ConstantPool.C_UTF8 mType;
        private final ConstantPool.C_UTF8 mName;

        EnumElement(ConstantPool.C_UTF8 type, ConstantPool.C_UTF8 name) {
            super('e');
            this.mType = type;
            this.mName = name;
        }

        @Override
        int length() {
            return 5;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mType.mIndex);
            out.writeShort(this.mName.mIndex);
        }
    }

    static class ArrayElement
    extends Element {
        private final Element[] mElements;

        ArrayElement(Element[] elements) {
            super('[');
            this.mElements = elements;
        }

        @Override
        int length() {
            int length = 3;
            for (Element e : this.mElements) {
                length += e.length();
            }
            return length;
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            out.writeShort(this.mElements.length);
            for (Element e : this.mElements) {
                e.writeTo(out);
            }
        }
    }

    static class AnnotationElement
    extends Element {
        private final TheAnnotationMaker mAnnotation;

        AnnotationElement(TheAnnotationMaker ann) {
            super('@');
            this.mAnnotation = ann;
        }

        @Override
        int length() {
            return 1 + this.mAnnotation.length();
        }

        @Override
        void writeDataTo(BytesOut out) throws IOException {
            this.mAnnotation.writeTo(out);
        }
    }
}

