/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.maker.AnnotationMaker;
import org.cojen.maker.Attribute;
import org.cojen.maker.Attributed;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.BytesOut;
import org.cojen.maker.ClassInjector;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.ConstantPool;
import org.cojen.maker.ConstantsRegistry;
import org.cojen.maker.DebugWriter;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Modifiers;
import org.cojen.maker.TheAnnotationMaker;
import org.cojen.maker.TheFieldMaker;
import org.cojen.maker.TheMethodMaker;
import org.cojen.maker.Type;
import org.cojen.maker.Typed;
import org.cojen.maker.Variable;

final class TheClassMaker
extends Attributed
implements ClassMaker,
Typed {
    static final boolean DEBUG = Boolean.getBoolean(ClassMaker.class.getName() + ".DEBUG");
    private final TheClassMaker mParent;
    private boolean mExternal;
    private final MethodHandles.Lookup mLookup;
    private final ClassInjector mInjector;
    ClassInjector.Group mInjectorGroup;
    final ConstantPool.C_Class mThisClass;
    private ConstantPool.C_Class mSuperClass;
    int mModifiers;
    private Set<ConstantPool.C_Class> mInterfaces;
    private LinkedHashMap<String, TheFieldMaker> mFields;
    private List<TheMethodMaker> mMethods;
    private ArrayList<TheMethodMaker> mClinitMethods;
    private Attribute.BootstrapMethods mBootstrapMethods;
    private Attribute.ConstantList mNestMembers;
    private Attribute.InnerClasses mInnerClasses;
    private Set<ConstantPool.C_Class> mPermittedSubclasses;
    private ArrayList<TheMethodMaker> mRecordCtors;
    Object mExactConstants;
    private IdentityHashMap<Object, Integer> mSharedExactConstants;
    Map<ConstantPool.Constant, ConstantPool.C_Field> mResolvedConstants;

    static TheClassMaker begin(boolean external, String className, boolean explicit, ClassLoader parentLoader, Object key, MethodHandles.Lookup lookup) {
        if (parentLoader == null) {
            parentLoader = ClassLoader.getSystemClassLoader();
        }
        ClassInjector injector = ClassInjector.find(explicit, parentLoader, key);
        return new TheClassMaker(null, external, className, lookup, injector);
    }

    private TheClassMaker(TheClassMaker parent, boolean external, String className, MethodHandles.Lookup lookup, ClassInjector injector) {
        super(new ConstantPool());
        this.mParent = parent;
        this.mExternal = external;
        this.mLookup = lookup;
        this.mInjector = injector;
        className = injector.reserve(this, className, lookup == null);
        this.mThisClass = this.mConstants.addClass(Type.begin(injector, this, className));
    }

    private TheClassMaker(TheClassMaker from, String className) {
        this(from, from.mExternal, className, from.mLookup, from.mInjector);
    }

    TheClassMaker(String className, ClassInjector injector, ClassInjector.Group injectorGroup) {
        this(null, false, className, null, injector);
        this.mInjectorGroup = injectorGroup;
    }

    @Override
    public ClassMaker another(String className) {
        return new TheClassMaker(this, className);
    }

    @Override
    public ClassMaker classMaker() {
        return this;
    }

    @Override
    public ClassMaker public_() {
        this.checkFinished();
        this.mModifiers = Modifiers.toPublic(this.mModifiers);
        return this;
    }

    @Override
    public ClassMaker private_() {
        this.checkFinished();
        this.mModifiers = Modifiers.toPrivate(this.mModifiers);
        return this;
    }

    @Override
    public ClassMaker protected_() {
        this.checkFinished();
        this.mModifiers = Modifiers.toProtected(this.mModifiers);
        return this;
    }

    @Override
    public ClassMaker static_() {
        this.checkFinished();
        this.mModifiers = Modifiers.toStatic(this.mModifiers);
        return this;
    }

    @Override
    public ClassMaker final_() {
        this.checkFinished();
        this.mModifiers = Modifiers.toFinal(this.mModifiers);
        return this;
    }

    @Override
    public ClassMaker interface_() {
        this.checkFinished();
        this.mModifiers = Modifiers.toInterface(this.mModifiers);
        this.type().toInterface();
        return this;
    }

    @Override
    public ClassMaker abstract_() {
        this.checkFinished();
        this.mModifiers = Modifiers.toAbstract(this.mModifiers);
        return this;
    }

    @Override
    public ClassMaker synthetic() {
        this.checkFinished();
        this.mModifiers = Modifiers.toSynthetic(this.mModifiers);
        return this;
    }

    @Override
    public ClassMaker enum_() {
        this.checkFinished();
        this.mModifiers = Modifiers.toEnum(this.mModifiers);
        return this;
    }

    @Override
    public ClassMaker annotation() {
        if (!this.isAnnotation()) {
            this.interface_().implement(Annotation.class);
            this.mModifiers |= 0x2000;
        }
        return this;
    }

    boolean isAnnotation() {
        return (this.mModifiers & 0x2000) != 0;
    }

    @Override
    public ClassMaker extend(Object superClass) {
        Objects.requireNonNull(superClass);
        if (this.mSuperClass != null) {
            throw new IllegalStateException("Super class has already been assigned");
        }
        this.doExtend(superClass);
        return this;
    }

    private void doExtend(Object superClass) {
        this.mSuperClass = this.mConstants.addClass(this.typeFrom(superClass));
        this.type().resetInherited();
    }

    ConstantPool.C_Class superClass() {
        ConstantPool.C_Class superClass = this.mSuperClass;
        if (superClass == null) {
            this.doExtend(Object.class);
            superClass = this.mSuperClass;
        }
        return superClass;
    }

    Type superType() {
        return this.superClass().mType;
    }

    @Override
    public ClassMaker implement(Object iface) {
        Objects.requireNonNull(iface);
        this.checkFinished();
        if (this.mInterfaces == null) {
            this.mInterfaces = new LinkedHashSet<ConstantPool.C_Class>(4);
        }
        this.mInterfaces.add(this.mConstants.addClass(this.typeFrom(iface)));
        this.type().resetInherited();
        return this;
    }

    @Override
    public ClassMaker signature(Object ... components) {
        this.checkFinished();
        this.addSignature(components);
        return this;
    }

    @Override
    public ClassMaker permitSubclass(Object subclass) {
        Objects.requireNonNull(subclass);
        this.checkFinished();
        if (this.mPermittedSubclasses == null) {
            this.mPermittedSubclasses = new LinkedHashSet<ConstantPool.C_Class>(4);
        }
        this.mPermittedSubclasses.add(this.mConstants.addClass(this.typeFrom(subclass)));
        return this;
    }

    Set<Type> allInterfaces() {
        LinkedHashSet<Object> all = null;
        if (this.mInterfaces != null) {
            all = new LinkedHashSet(this.mInterfaces.size());
            for (ConstantPool.C_Class clazz : this.mInterfaces) {
                Type type = clazz.mType;
                all.add(type);
                all.addAll(type.interfaces());
            }
        }
        for (Type s = this.superType(); s != null; s = s.superType()) {
            Set<Type> inherited = s.interfaces();
            if (inherited == null || inherited.isEmpty()) continue;
            if (all == null) {
                all = new LinkedHashSet(inherited.size());
            }
            all.addAll(inherited);
        }
        return all == null ? Collections.emptySet() : all;
    }

    @Override
    public TheFieldMaker addField(Object type, String name) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(name);
        this.checkFinished();
        if (this.mFields == null) {
            this.mFields = new LinkedHashMap();
        } else if (this.mFields.containsKey(name)) {
            throw new IllegalStateException("Field is already defined: " + name);
        }
        Type tType = this.typeFrom(type);
        TheFieldMaker fm = new TheFieldMaker(this, this.type().defineField(0, tType, name));
        this.mFields.put(name, fm);
        return fm;
    }

    TheFieldMaker addSyntheticField(Type type, String prefix) {
        String name;
        this.checkFinished();
        if (this.mFields == null) {
            this.mFields = new LinkedHashMap();
            name = prefix + "0";
        } else {
            name = prefix + this.mFields.size();
            while (this.mFields.containsKey(name)) {
                name = prefix + ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
            }
        }
        TheFieldMaker fm = new TheFieldMaker(this, this.type().defineField(0, type, name));
        fm.synthetic();
        this.mFields.put(name, fm);
        return fm;
    }

    @Override
    public TheMethodMaker addMethod(Object retType, String name, Object ... paramTypes) {
        if (name.equals("<clinit>")) {
            throw new IllegalArgumentException("Use the addClinit method");
        }
        if (name.equals("<init>")) {
            throw new IllegalArgumentException("Use the addConstructor method");
        }
        this.checkFinished();
        return this.doAddMethod(retType, name, paramTypes);
    }

    @Override
    public TheMethodMaker addConstructor(Object ... paramTypes) {
        this.checkFinished();
        return this.doAddMethod(null, "<init>", paramTypes);
    }

    private TheMethodMaker doAddMethod(Object retType, String name, Object ... paramTypes) {
        TheMethodMaker mm = new TheMethodMaker(this, this.defineMethod(retType, name, paramTypes));
        this.doAddMethod(mm);
        return mm;
    }

    void doAddMethod(TheMethodMaker mm) {
        if (this.mMethods == null) {
            this.mMethods = new ArrayList<TheMethodMaker>();
        }
        this.mMethods.add(mm);
    }

    Type.Method defineMethod(Object retType, String name, Object ... paramTypes) {
        Type[] tParamTypes;
        Type tRetType;
        Type type = tRetType = retType == null ? Type.VOID : this.typeFrom(retType);
        if (paramTypes == null) {
            tParamTypes = new Type[]{};
        } else {
            tParamTypes = new Type[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                tParamTypes[i] = this.typeFrom(paramTypes[i]);
            }
        }
        return this.type().defineMethod(0, tRetType, name, tParamTypes);
    }

    @Override
    public TheMethodMaker addClinit() {
        TheMethodMaker mm;
        this.checkFinished();
        if (this.mClinitMethods == null) {
            this.mClinitMethods = new ArrayList();
            mm = this.doAddMethod(null, "<clinit>", new Object[0]);
        } else {
            mm = new TheMethodMaker(this.mClinitMethods.get(this.mClinitMethods.size() - 1));
        }
        mm.static_();
        mm.useReturnLabel();
        this.mClinitMethods.add(mm);
        return mm;
    }

    @Override
    public MethodMaker asRecord() {
        return AsRecord.apply(this);
    }

    @Override
    public TheClassMaker addInnerClass(String className) {
        return this.addInnerClass(className, null);
    }

    TheClassMaker addInnerClass(String className, Type.Method hostMethod) {
        String fullName;
        TheClassMaker nestHost = TheClassMaker.nestHost(this);
        String prefix = this.name();
        int ix = prefix.lastIndexOf(45);
        if (ix > 0) {
            prefix = prefix.substring(0, ix);
        }
        Attribute.InnerClasses innerClasses = this.innerClasses();
        if (className == null) {
            fullName = prefix + "$" + innerClasses.classNumberFor("");
        } else {
            if (className.indexOf(46) >= 0) {
                throw new IllegalArgumentException("Not a simple name: " + className);
            }
            fullName = hostMethod == null || (ix = prefix.indexOf(36)) >= 0 && ++ix < prefix.length() && !Character.isJavaIdentifierStart(prefix.charAt(ix)) ? prefix + "$" + className : prefix + "$" + innerClasses.classNumberFor(className) + className;
        }
        TheClassMaker clazz = new TheClassMaker(this, fullName);
        clazz.setNestHost(nestHost.type());
        nestHost.addNestMember(clazz.type());
        if (hostMethod != null) {
            clazz.setEnclosingMethod(this.type(), hostMethod);
        }
        innerClasses.add(clazz, this, className);
        clazz.innerClasses().add(clazz, this, className);
        return clazz;
    }

    private static TheClassMaker nestHost(TheClassMaker cm) {
        while (true) {
            cm.checkFinished();
            TheClassMaker parent = cm.mParent;
            if (parent == null) {
                return cm;
            }
            cm = parent;
        }
    }

    private void setNestHost(Type nestHost) {
        ConstantPool cp = this.mConstants;
        this.addAttribute(new Attribute.Constant(cp, "NestHost", cp.addClass(nestHost)));
    }

    private synchronized void addNestMember(Type nestMember) {
        if (this.mNestMembers == null) {
            this.mNestMembers = new Attribute.ConstantList(this.mConstants, "NestMembers");
            this.addAttribute(this.mNestMembers);
        }
        this.mNestMembers.add(this.mConstants.addClass(nestMember));
    }

    private void setEnclosingMethod(Type hostType, Type.Method hostMethod) {
        this.addAttribute(new Attribute.EnclosingMethod(this.mConstants, this.mConstants.addClass(hostType), this.mConstants.addNameAndType(hostMethod.name(), hostMethod.descriptor())));
    }

    private Attribute.InnerClasses innerClasses() {
        if (this.mInnerClasses == null) {
            this.mInnerClasses = new Attribute.InnerClasses(this.mConstants);
            this.addAttribute(this.mInnerClasses);
        }
        return this.mInnerClasses;
    }

    @Override
    public AnnotationMaker addAnnotation(Object annotationType, boolean visible) {
        return this.addAnnotation(new TheAnnotationMaker(this, annotationType), visible);
    }

    @Override
    public ClassMaker sourceFile(String fileName) {
        this.checkFinished();
        ConstantPool cp = this.mConstants;
        this.addAttribute(new Attribute.Constant(cp, "SourceFile", cp.addUTF8(fileName)));
        return this;
    }

    @Override
    public Object arrayType(int dimensions) {
        if (dimensions < 1 || dimensions > 255) {
            throw new IllegalArgumentException();
        }
        Type type = this.type();
        do {
            type = type.asArray();
        } while (--dimensions > 0);
        Type fType = type;
        return () -> fType;
    }

    @Override
    public ClassLoader classLoader() {
        return this.mLookup != null ? this.mLookup.lookupClass().getClassLoader() : this.mInjectorGroup;
    }

    @Override
    public Set<String> unimplementedMethods() {
        TreeSet<Object> unimplemented = null;
        HashSet<Type.Method> methodSet = new HashSet<Type.Method>();
        Type type = this.type();
        do {
            for (Type.Method method : type.methods().values()) {
                if (!methodSet.add(method) || !Modifier.isAbstract(method.mFlags)) continue;
                if (unimplemented == null) {
                    unimplemented = new TreeSet();
                }
                unimplemented.add(method.signature());
            }
        } while ((type = type.superType()) != null);
        for (Type ifaceType : this.type().interfaces()) {
            for (Type.Method method : ifaceType.methods().values()) {
                if ((method.mFlags & 0x408) != 0) continue;
                methodSet.add(method);
            }
        }
        for (Type ifaceType : this.type().interfaces()) {
            for (Type.Method method : ifaceType.methods().values()) {
                if (!Modifier.isAbstract(method.mFlags) || methodSet.contains(method)) continue;
                if (unimplemented == null) {
                    unimplemented = new TreeSet();
                }
                unimplemented.add(method.signature());
            }
        }
        return unimplemented == null ? Collections.emptySet() : unimplemented;
    }

    String name() {
        return this.type().name();
    }

    void toModule() {
        if (this.mSuperClass != null) {
            throw new IllegalStateException();
        }
        this.mSuperClass = new ConstantPool.C_Class(null, null);
        this.mModifiers = Modifiers.toModule(this.mModifiers);
    }

    @Override
    public Class<?> finish() {
        Class<?> clazz;
        String name = this.name();
        if (this.mLookup == null) {
            clazz = this.mInjector.define(this.mInjectorGroup, name, this.finishBytes(false));
        } else {
            try {
                clazz = this.mLookup.defineClass(this.finishBytes(false));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        ConstantsRegistry.finish(this, this.mLookup, clazz);
        return clazz;
    }

    @Override
    public MethodHandles.Lookup finishLookup() {
        this.checkFinished();
        MethodHandles.Lookup[] lookupRef = new MethodHandles.Lookup[1];
        boolean wasExternal = this.mExternal;
        this.mExternal = false;
        try {
            TheMethodMaker mm = this.addClinit();
            Variable lookupVar = mm.var(MethodHandles.class).invoke("lookup");
            mm.var(lookupRef.getClass()).setExact(lookupRef).aset(0, lookupVar);
            MethodHandles.Lookup lookup = this.mLookup;
            if (lookup == null) {
                lookup = this.mInjectorGroup.lookup(this.name());
            }
            lookup.ensureInitialized(this.finish());
        }
        catch (Exception e) {
            throw TheClassMaker.toUnchecked(e);
        }
        finally {
            if (wasExternal) {
                this.mExternal = true;
            }
        }
        MethodHandles.Lookup lookup = lookupRef[0];
        lookupRef[0] = null;
        return lookup;
    }

    @Override
    public MethodHandles.Lookup finishHidden() {
        return this.finishHidden(false);
    }

    MethodHandles.Lookup finishHidden(boolean strong) {
        MethodHandles.Lookup result;
        MethodHandles.Lookup lookup = this.mLookup;
        if (lookup == null) {
            lookup = this.mInjectorGroup.lookup(this.name());
        }
        MethodHandles.Lookup.ClassOption[] options = !strong ? new MethodHandles.Lookup.ClassOption[]{MethodHandles.Lookup.ClassOption.NESTMATE} : new MethodHandles.Lookup.ClassOption[]{MethodHandles.Lookup.ClassOption.NESTMATE, MethodHandles.Lookup.ClassOption.STRONG};
        String originalName = this.name();
        byte[] bytes = this.finishBytes(true);
        try {
            Object classData = this.mExactConstants;
            if (classData == null) {
                result = lookup.defineHiddenClass(bytes, false, options);
            } else {
                result = lookup.defineHiddenClassWithClassData(bytes, classData, false, options);
                this.mExactConstants = null;
            }
        }
        catch (Exception e) {
            throw TheClassMaker.toUnchecked(e);
        }
        finally {
            this.mInjector.unreserve(originalName);
        }
        ConstantsRegistry.finish(this, lookup, result.lookupClass());
        return result;
    }

    @Override
    public byte[] finishBytes() {
        this.noExactConstants();
        String name = this.name();
        try {
            byte[] byArray = this.finishBytes(false);
            return byArray;
        }
        finally {
            this.mInjector.unreserve(name);
        }
    }

    private byte[] finishBytes(boolean hidden) {
        byte[] bytes;
        try {
            BytesOut out = new BytesOut(null, 1000);
            this.finishTo(out, hidden);
            bytes = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.mConstants = null;
        }
        if (DEBUG) {
            DebugWriter.write(this.name(), bytes);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishTo(OutputStream out) throws IOException {
        this.noExactConstants();
        String name = this.name();
        try {
            BytesOut bout = new BytesOut(out, 1000);
            this.finishTo(bout, false);
            bout.flush();
        }
        finally {
            this.mConstants = null;
            this.mInjector.unreserve(name);
        }
    }

    private void finishTo(BytesOut out, boolean hidden) throws IOException {
        String name;
        int ix;
        this.checkFinished();
        this.superClass();
        int version = 61;
        if (this.mRecordCtors != null) {
            TheMethodMaker.doFinish(this.mRecordCtors);
        }
        if (this.mPermittedSubclasses != null) {
            this.addAttribute(new Attribute.PermittedSubclasses(this.mConstants, this.mPermittedSubclasses));
        }
        TheMethodMaker.doFinish(this.mClinitMethods);
        TheClassMaker.checkSize(this.mInterfaces, 65535, "Interface");
        TheClassMaker.checkSize(this.mFields, 65535, "Field");
        TheClassMaker.checkSize(this.mMethods, 65535, "Method");
        if (this.mMethods != null) {
            for (TheMethodMaker method : this.mMethods) {
                method.doFinish();
            }
        }
        if (hidden && (ix = (name = this.mThisClass.mValue.mValue).lastIndexOf(45)) > 0) {
            this.mThisClass.rename(this.mConstants.addUTF8(name.substring(0, ix)));
        }
        out.writeInt(-889275714);
        out.writeInt(version);
        this.mConstants.writeTo(out);
        out.writeShort(this.mModifiers);
        out.writeShort(this.mThisClass.mIndex);
        out.writeShort(this.mSuperClass.mIndex);
        if (this.mInterfaces == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.mInterfaces.size());
            for (ConstantPool.C_Class iface : this.mInterfaces) {
                out.writeShort(iface.mIndex);
            }
        }
        if (this.mFields == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.mFields.size());
            for (TheFieldMaker field : this.mFields.values()) {
                field.writeTo(out);
            }
        }
        if (this.mMethods == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.mMethods.size());
            for (TheMethodMaker method : this.mMethods) {
                method.writeTo(out);
            }
        }
        this.writeAttributesTo(out);
    }

    static void checkSize(Map<?, ?> c, int maxSize, String desc) {
        if (c != null) {
            TheClassMaker.checkSize(c.keySet(), maxSize, desc);
        }
    }

    static void checkSize(Collection<?> c, int maxSize, String desc) {
        if (c != null && c.size() > maxSize) {
            throw new IllegalStateException(desc + " count cannot exceed " + maxSize + ": " + c.size());
        }
    }

    private void checkFinished() {
        if (this.mConstants == null) {
            throw new IllegalStateException("Class definition is already finished");
        }
    }

    private void noExactConstants() {
        this.checkFinished();
        if (this.mExactConstants != null) {
            throw new IllegalStateException("Class has exact constants defined");
        }
    }

    @Override
    public Type type() {
        return this.mThisClass.mType;
    }

    Type typeFrom(Object type) {
        return Type.from((ClassLoader)this.mInjector, type);
    }

    int addBootstrapMethod(ConstantPool.C_MethodHandle method, ConstantPool.Constant[] args) {
        if (this.mBootstrapMethods == null) {
            this.mBootstrapMethods = new Attribute.BootstrapMethods(this.mConstants);
            this.addAttribute(this.mBootstrapMethods);
        }
        return this.mBootstrapMethods.add(method, args);
    }

    boolean allowExactConstants() {
        return !this.mExternal;
    }

    int addExactConstant(Object value, boolean shared) {
        this.checkFinished();
        if (this.mExternal) {
            throw new IllegalStateException("Making an external class");
        }
        if (!shared) {
            return ConstantsRegistry.add(this, value);
        }
        IdentityHashMap<Object, Integer> map = this.mSharedExactConstants;
        if (map == null) {
            map = new IdentityHashMap();
            this.mSharedExactConstants = map;
        } else {
            Integer slot = map.get(value);
            if (slot != null) {
                return slot;
            }
        }
        int slot = ConstantsRegistry.add(this, value);
        map.put(value, slot);
        return slot;
    }

    static RuntimeException toUnchecked(Throwable e) {
        while (true) {
            Throwable e2;
            if (e instanceof RuntimeException) {
                e2 = (RuntimeException)e;
                throw e2;
            }
            if (e instanceof Error) {
                e2 = (Error)e;
                throw e2;
            }
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IllegalStateException(e);
            }
            e = cause;
        }
    }

    private static class AsRecord {
        private AsRecord() {
        }

        private static TheMethodMaker apply(TheClassMaker cm) {
            Object bootstrap;
            Object[] args;
            MethodMaker mm;
            cm.extend("java.lang.Record").final_();
            Attribute.Record recordAttr = new Attribute.Record(cm.mConstants);
            cm.addAttribute(recordAttr);
            Map<String, TheFieldMaker> fields = cm.mFields;
            if (fields == null) {
                fields = Collections.emptyMap();
            }
            Object[] paramTypes = new Object[fields.size()];
            int i = 0;
            for (TheFieldMaker fm : fields.values()) {
                recordAttr.add(fm);
                paramTypes[i++] = fm;
            }
            TheMethodMaker ctor = cm.addConstructor(paramTypes);
            ctor.mModifiers = cm.mModifiers & 7;
            ctor.useReturnLabel();
            ctor.invokeSuperConstructor();
            cm.mRecordCtors = new ArrayList(2);
            cm.mRecordCtors.add(ctor);
            if (!fields.isEmpty()) {
                TheMethodMaker finisher = new TheMethodMaker(ctor);
                cm.mRecordCtors.add(finisher);
                int i2 = 0;
                for (TheFieldMaker fm : fields.values()) {
                    finisher.field(fm.name()).set(finisher.param(i2++));
                }
            }
            int toAdd = 7;
            LinkedHashSet<String> toSkip = null;
            if (cm.mMethods != null) {
                block12: for (TheMethodMaker mm2 : cm.mMethods) {
                    String name;
                    Type.Method m = mm2.mMethod;
                    switch (name = m.name()) {
                        case "equals": {
                            if (m.returnType() != Type.BOOLEAN || m.paramTypes().length != 1 || m.paramTypes()[0] != Type.from(Object.class)) continue block12;
                            toAdd &= 0xFFFFFFFE;
                            continue block12;
                        }
                        case "hashCode": {
                            if (m.returnType() != Type.INT || m.paramTypes().length != 0) continue block12;
                            toAdd &= 0xFFFFFFFD;
                            continue block12;
                        }
                        case "toString": {
                            if (m.paramTypes().length != 0 || m.returnType() != Type.from(String.class)) continue block12;
                            toAdd &= 0xFFFFFFFB;
                            continue block12;
                        }
                    }
                    TheFieldMaker field = fields.get(name);
                    if (field == null || m.paramTypes().length != 0 || m.returnType() != field.type()) continue;
                    if (toSkip == null) {
                        toSkip = new LinkedHashSet<String>();
                    }
                    toSkip.add(name);
                }
            }
            for (TheFieldMaker fm : fields.values()) {
                String name = fm.name();
                if (toSkip != null && toSkip.contains(name)) continue;
                MethodMaker mm3 = cm.addMethod(fm, name).public_().final_();
                mm3.return_(mm3.field(name));
            }
            if ((toAdd & 1) != 0) {
                mm = cm.addMethod(Boolean.TYPE, "equals", Object.class).public_().final_();
                args = new Object[2 + fields.size()];
                args[0] = mm.class_();
                args[1] = "";
                AsRecord.getters(mm, fields, args, 2);
                bootstrap = mm.var("java.lang.runtime.ObjectMethods").indy("bootstrap", args);
                mm.return_(bootstrap.invoke(Boolean.TYPE, "equals", new Object[]{cm, Object.class}, mm.this_(), mm.param(0)));
            }
            if ((toAdd & 2) != 0) {
                mm = cm.addMethod(Integer.TYPE, "hashCode").public_().final_();
                args = new Object[2 + fields.size()];
                args[0] = mm.class_();
                args[1] = "";
                AsRecord.getters(mm, fields, args, 2);
                bootstrap = mm.var("java.lang.runtime.ObjectMethods").indy("bootstrap", args);
                mm.return_(bootstrap.invoke(Integer.TYPE, "hashCode", new Object[]{cm}, mm.this_()));
            }
            if ((toAdd & 4) != 0) {
                mm = cm.addMethod(String.class, "toString").public_().final_();
                StringBuilder names = new StringBuilder();
                for (String name : fields.keySet()) {
                    if (names.length() != 0) {
                        names.append(';');
                    }
                    names.append(name);
                }
                Object[] args2 = new Object[2 + fields.size()];
                args2[0] = mm.class_();
                args2[1] = names.toString();
                AsRecord.getters(mm, fields, args2, 2);
                Bootstrap bootstrap2 = mm.var("java.lang.runtime.ObjectMethods").indy("bootstrap", args2);
                mm.return_(bootstrap2.invoke(String.class, "toString", new Object[]{cm}, mm.this_()));
            }
            return ctor;
        }

        private static void getters(MethodMaker mm, Map<String, TheFieldMaker> fields, Object[] args, int offset) {
            for (String name : fields.keySet()) {
                args[offset++] = mm.field(name).methodHandleGet();
            }
        }
    }
}

