/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.StringConcatFactory;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.cojen.maker.AnnotationMaker;
import org.cojen.maker.Attribute;
import org.cojen.maker.Attributed;
import org.cojen.maker.Bootstrap;
import org.cojen.maker.BytesOut;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.ClassMember;
import org.cojen.maker.ConstableSupport;
import org.cojen.maker.ConstantPool;
import org.cojen.maker.ConstantsRegistry;
import org.cojen.maker.ExceptionHandler;
import org.cojen.maker.Field;
import org.cojen.maker.Label;
import org.cojen.maker.MethodHandleBootstraps;
import org.cojen.maker.MethodMaker;
import org.cojen.maker.Modifiers;
import org.cojen.maker.StackMapTable;
import org.cojen.maker.Switcher;
import org.cojen.maker.TheAnnotationMaker;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.TheFieldMaker;
import org.cojen.maker.Type;
import org.cojen.maker.Typed;
import org.cojen.maker.Variable;

class TheMethodMaker
extends ClassMember
implements MethodMaker {
    private static final int MAX_CODE_LENGTH = 65535;
    private static final boolean CONDY_WORKAROUND = Runtime.version().feature() < 19;
    final Type.Method mMethod;
    private ParamVar[] mParams;
    private Op mFirstOp;
    private Op mLastOp;
    private ClassVar mClassVar;
    private ParamVar mThisVar;
    private SuperVar mSuperVar;
    private List<Handler> mExceptionHandlers;
    private Lab mReturnLabel;
    private byte[] mCode;
    private int mCodeLen;
    private LocalVar[] mVars;
    private LocalVar[] mStack;
    private int mStackSize;
    private int mMaxStackSlot;
    private int mUnpositionedLabels;
    private StackMapTable mStackMapTable;
    private Attribute.LineNumberTable mLineNumberTable;
    private Attribute.LocalVariableTable mLocalVariableTable;
    private Attribute.LocalVariableTable mLocalVariableTypeTable;
    private Attribute.MethodParameters mMethodParameters;
    private Attribute.ParameterAnnotations[] mParameterAnnotationsSet;
    private Attribute.ConstantList mExceptionsThrown;
    private boolean mHasBranches;
    private int mFinished;

    TheMethodMaker(TheClassMaker classMaker, Type.Method method) {
        super(classMaker, method.name(), method.descriptor());
        this.mMethod = method;
    }

    TheMethodMaker(TheMethodMaker prev) {
        super(prev.mClassMaker, prev.mName, prev.mDescriptor);
        this.mMethod = prev.mMethod;
    }

    void useReturnLabel() {
        if (this.mReturnLabel != null) {
            throw new IllegalStateException();
        }
        this.mReturnLabel = new Lab();
    }

    private void positionReturnLabel() {
        if (this.mReturnLabel != null) {
            this.mReturnLabel.here();
            this.mReturnLabel = null;
        }
    }

    void doFinish() {
        int[] initCodes;
        if (this.mFinished != 0 || (this.mModifiers & 0x500) != 0) {
            return;
        }
        this.positionReturnLabel();
        if (TheMethodMaker.flowsThroughEnd(this.mLastOp)) {
            if (this.mMethod.returnType() == Type.VOID) {
                if (this.mLastOp == null && "<init>".equals(this.name()) && this.mMethod.paramTypes().length == 0) {
                    this.invokeSuperConstructor();
                }
                this.doReturn();
            } else if (this.mLastOp == null) {
                throw new IllegalStateException("End reached without returning: " + this.mMethod.returnType().name());
            }
        }
        if (this.mParams == null) {
            this.initParams();
        }
        ArrayList<LocalVar> varList = new ArrayList<LocalVar>();
        BitSet varUsage = new BitSet();
        for (ParamVar param : this.mParams) {
            varList.add(param);
            varUsage.set(param.mSlot);
        }
        Flow flow = new Flow(varList, varUsage);
        flow.run(this.mFirstOp);
        int opCount = flow.mOpCount;
        int maxLocals = flow.nextSlot();
        if (maxLocals >= 65536) {
            throw new IllegalStateException("Too many local variables");
        }
        if (this.mExceptionHandlers != null) {
            Iterator<Handler> it = this.mExceptionHandlers.iterator();
            while (it.hasNext()) {
                Handler h = it.next();
                if (!h.mEndLab.isPositioned()) {
                    throw new IllegalStateException("Unpositioned exception handler end label in method: " + this.name());
                }
                if (h.mHandlerLab.mVisited) continue;
                it.remove();
            }
        }
        this.mVars = varList.toArray(new LocalVar[varList.size()]);
        Arrays.sort(this.mVars);
        if (this.mParams.length == 0) {
            initCodes = null;
        } else {
            initCodes = new int[this.mParams.length];
            for (int i = 0; i < initCodes.length; ++i) {
                initCodes[i] = this.mParams[i].smCode();
            }
        }
        this.mStackMapTable = new StackMapTable(this.mConstants, initCodes);
        this.mCode = new byte[Math.min(65535, opCount * 2)];
        this.mStack = new LocalVar[8];
        Op lastAppendedOp = null;
        while (true) {
            this.mCodeLen = 0;
            this.mStackSize = 0;
            this.mMaxStackSlot = 0;
            this.mUnpositionedLabels = 0;
            this.mLineNumberTable = null;
            this.mLocalVariableTable = null;
            this.mLocalVariableTypeTable = null;
            this.mFinished = 0;
            Op op = this.mFirstOp;
            while (op != null) {
                if (op.mVisited) {
                    op.appendTo(this);
                    lastAppendedOp = op;
                }
                op = op.mNext;
            }
            if (this.mUnpositionedLabels != 0) {
                throw new IllegalStateException("Unpositioned labels in method: " + this.name() + ": " + this.mUnpositionedLabels);
            }
            if (this.mFinished >= 0) break;
            op = this.mFirstOp;
            while (op != null) {
                op.reset();
                op = op.mNext;
            }
            this.mStackMapTable.reset();
            new Flow(varList, varUsage).run(this.mFirstOp);
        }
        this.mParams = null;
        this.mFirstOp = null;
        this.mLastOp = null;
        this.mReturnLabel = null;
        this.mVars = null;
        this.mStack = null;
        if (this.mThisVar instanceof InitThisVar && this.mThisVar.smCode() == 6) {
            throw new IllegalStateException("Super or this constructor never invoked");
        }
        if (TheMethodMaker.flowsThroughEnd(lastAppendedOp)) {
            throw new IllegalStateException("End reached without returning: " + this.mMethod.returnType().name());
        }
        Attribute.Code codeAttr = new Attribute.Code(this.mConstants, this.mMaxStackSlot, maxLocals, this.mCode, this.mCodeLen, this.mExceptionHandlers);
        this.mExceptionHandlers = null;
        if (this.mStackMapTable.finish()) {
            codeAttr.addAttribute(this.mStackMapTable);
            this.mStackMapTable = null;
        }
        if (this.mLineNumberTable != null && this.mLineNumberTable.finish(this.mCodeLen)) {
            codeAttr.addAttribute(this.mLineNumberTable);
        }
        if (this.mLocalVariableTable != null && this.mLocalVariableTable.finish(this.mCodeLen)) {
            codeAttr.addAttribute(this.mLocalVariableTable);
            this.mLocalVariableTable = null;
        }
        if (this.mLocalVariableTypeTable != null && this.mLocalVariableTypeTable.finish(this.mCodeLen)) {
            codeAttr.addAttribute(this.mLocalVariableTypeTable);
            this.mLocalVariableTypeTable = null;
        }
        this.addAttribute(codeAttr);
        this.mFinished = 1;
    }

    static void doFinish(List<TheMethodMaker> list) {
        int size;
        if (list == null || (size = list.size()) == 0) {
            return;
        }
        TheMethodMaker first = list.get(0);
        first.positionReturnLabel();
        for (int i = 1; i < size; ++i) {
            TheMethodMaker next = list.get(i);
            if (next.mFirstOp == null) continue;
            next.positionReturnLabel();
            first.mLastOp.mNext = next.mFirstOp;
            first.mLastOp = next.mLastOp;
            if (next.mExceptionHandlers == null) continue;
            if (first.mExceptionHandlers == null) {
                first.mExceptionHandlers = next.mExceptionHandlers;
                continue;
            }
            first.mExceptionHandlers.addAll(next.mExceptionHandlers);
        }
        first.doFinish();
    }

    private static boolean flowsThroughEnd(Op lastOp) {
        if (lastOp instanceof BytecodeOp) {
            if (lastOp instanceof ReturnOp) {
                return false;
            }
            byte opcode = ((BytecodeOp)lastOp).op();
            if (opcode == -89 || opcode == -56 || opcode == -65) {
                return false;
            }
        }
        return true;
    }

    @Override
    public MethodMaker public_() {
        this.mModifiers = Modifiers.toPublic(this.mModifiers);
        return this;
    }

    @Override
    public MethodMaker private_() {
        this.mModifiers = Modifiers.toPrivate(this.mModifiers);
        this.mMethod.toPrivate();
        return this;
    }

    @Override
    public MethodMaker protected_() {
        this.mModifiers = Modifiers.toProtected(this.mModifiers);
        return this;
    }

    @Override
    public MethodMaker static_() {
        if (this.mParams != null) {
            throw new IllegalStateException("Cannot become static after parameters have been accessed");
        }
        this.mModifiers = Modifiers.toStatic(this.mModifiers);
        this.mMethod.toStatic();
        return this;
    }

    @Override
    public MethodMaker final_() {
        this.mModifiers = Modifiers.toFinal(this.mModifiers);
        this.mMethod.toFinal();
        return this;
    }

    @Override
    public MethodMaker synchronized_() {
        this.mModifiers = Modifiers.toSynchronized(this.mModifiers);
        return this;
    }

    @Override
    public MethodMaker abstract_() {
        this.mModifiers = Modifiers.toAbstract(this.mModifiers);
        return this;
    }

    @Override
    public MethodMaker native_() {
        this.mModifiers = Modifiers.toNative(this.mModifiers);
        return this;
    }

    @Override
    public MethodMaker synthetic() {
        this.mModifiers = Modifiers.toSynthetic(this.mModifiers);
        return this;
    }

    @Override
    public MethodMaker bridge() {
        this.mModifiers = Modifiers.toBridge(this.mModifiers);
        this.mMethod.toBridge();
        return this;
    }

    @Override
    public MethodMaker varargs() {
        Type[] params = this.mMethod.paramTypes();
        if (params.length == 0 || !params[params.length - 1].isArray()) {
            throw new IllegalStateException();
        }
        this.mModifiers = Modifiers.toVarArgs(this.mModifiers);
        this.mMethod.toVarargs();
        return this;
    }

    @Override
    public MethodMaker throws_(Object type) {
        if (this.mExceptionsThrown == null) {
            this.mExceptionsThrown = new Attribute.ConstantList(this.mConstants, "Exceptions");
            this.addAttribute(this.mExceptionsThrown);
        }
        this.mExceptionsThrown.add(this.mConstants.addClass(this.mClassMaker.typeFrom(type)));
        return this;
    }

    @Override
    public MethodMaker override() {
        if (Modifier.isStatic(this.mModifiers) || Modifier.isPrivate(this.mModifiers)) {
            throw new IllegalStateException("Not defining a virtual method");
        }
        Type thisType = this.mClassMaker.type();
        Type.MethodKey key = new Type.MethodKey(this.mMethod.returnType(), this.mMethod.name(), this.mMethod.paramTypes());
        for (Type s = thisType.superType(); s != null; s = s.superType()) {
            if (!this.override(s.methods().get(key))) continue;
            return this;
        }
        for (Type iface : thisType.interfaces()) {
            if (!this.override(iface.methods().get(key))) continue;
            return this;
        }
        throw new IllegalStateException("Not overriding a virtual method");
    }

    private boolean override(Type.Method method) {
        if (method != null && !method.isStatic() && !method.isPrivate()) {
            if (method.isFinal()) {
                throw new IllegalStateException("Cannot override a final method");
            }
            return true;
        }
        return false;
    }

    @Override
    public MethodMaker signature(Object ... components) {
        this.addSignature(components);
        return this;
    }

    @Override
    public ClassVar class_() {
        if (this.mClassVar == null) {
            this.mClassVar = new ClassVar(Type.from(Class.class));
        }
        return this.mClassVar;
    }

    @Override
    public LocalVar this_() {
        while (true) {
            if (this.mThisVar != null) {
                return this.mThisVar;
            }
            if (this.mParams != null) break;
            this.initParams();
        }
        throw new IllegalStateException("Not an instance method");
    }

    LocalVar tryThis() {
        ParamVar this_ = this.mThisVar;
        if (this_ == null && this.mParams == null) {
            this.initParams();
            this_ = this.mThisVar;
        }
        return this_;
    }

    @Override
    public Variable super_() {
        return this.mSuperVar == null ? (this.mSuperVar = new SuperVar()) : this.mSuperVar;
    }

    @Override
    public LocalVar param(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        LocalVar[] params = this.params();
        if (this.mThisVar != null) {
            ++index;
        }
        return params[index];
    }

    @Override
    public int paramCount() {
        int count = this.params().length;
        if (this.mThisVar != null) {
            --count;
        }
        return count;
    }

    private LocalVar[] params() {
        LocalVar[] params = this.mParams;
        if (params == null) {
            this.initParams();
            params = this.mParams;
        }
        return params;
    }

    private void initParams() {
        int count = this.mMethod.paramTypes().length;
        int slot = 0;
        if (!Modifier.isStatic(this.mModifiers)) {
            Type type = this.mClassMaker.type();
            this.mThisVar = "<init>".equals(this.name()) ? new InitThisVar(type) : new ParamVar(type, 0);
            this.mThisVar.mSlot = 0;
            ++count;
            slot = 1;
        }
        int i = 0;
        this.mParams = new ParamVar[count];
        if (this.mThisVar != null) {
            this.mParams[i++] = this.mThisVar;
        }
        for (Type t : this.mMethod.paramTypes()) {
            ParamVar param = new ParamVar(t, i);
            param.mSlot = slot;
            slot += param.slotWidth();
            this.mParams[i++] = param;
        }
    }

    @Override
    public LocalVar var(Object type) {
        return new LocalVar(this.mClassMaker.typeFrom(type));
    }

    @Override
    public void lineNum(int num) {
        this.addOp(new LineNumOp(num));
    }

    @Override
    public Label label() {
        return new Lab();
    }

    @Override
    public void goto_(Label label) {
        this.addBranchOp((byte)-89, 0, label);
    }

    @Override
    public void return_() {
        if (this.mMethod.returnType() != Type.VOID) {
            throw new IllegalStateException("Must return a value from this method");
        }
        this.doReturn();
    }

    private void doReturn() {
        if (this.mReturnLabel == null) {
            this.addOp(new ReturnOp(-79, 0));
        } else {
            this.addOp(new BranchOp(-89, 0, this.mReturnLabel));
        }
    }

    @Override
    public void return_(Object value) {
        Type type = this.mMethod.returnType();
        if (type == Type.VOID) {
            Typed typed;
            if (value instanceof Typed && (typed = (Typed)value).type() == Type.VOID) {
                this.doReturn();
                return;
            }
            throw new IllegalStateException("Cannot return a value from this method");
        }
        byte op = switch (type.stackMapCode()) {
            default -> throw new IllegalStateException("Unsupported return type: " + type.name());
            case 1 -> -84;
            case 2 -> -82;
            case 3 -> -81;
            case 4 -> -83;
            case 7 -> -80;
        };
        this.addPushOp(type, value);
        this.addOp(new ReturnOp(op, 1));
    }

    @Override
    public FieldVar field(String name) {
        return this.field(this.mClassMaker.type(), name);
    }

    FieldVar field(Type type, String name) {
        Type.Field field = this.findField(type, name);
        LocalVar instance = field.isStatic() ? null : this.this_();
        return new FieldVar(instance, this.mConstants.addField(field));
    }

    private BaseFieldVar field(LocalVar var, String name) {
        Type type = var.mType.box();
        Type.Field field = this.findField(type, name);
        if (field.isStatic()) {
            var = null;
        }
        return new FieldVar(var, this.mConstants.addField(field)).access();
    }

    private Type.Field findField(Type type, String name) {
        Type.Field field = type.findField(name);
        if (field == null) {
            throw new IllegalStateException("Field not found in " + type.name() + ": " + name);
        }
        return field;
    }

    @Override
    public Variable invoke(String name, Object ... values) {
        return this.doInvoke(this.mClassMaker.type(), this.tryThis(), name, 0, values, null, null);
    }

    @Override
    public void invokeSuperConstructor(Object ... values) {
        this.invokeConstructor(this.mClassMaker.superClass(), values);
    }

    @Override
    public void invokeThisConstructor(Object ... values) {
        this.invokeConstructor(this.mClassMaker.mThisClass, values);
    }

    private void invokeConstructor(ConstantPool.C_Class type, Object[] values) {
        if (!"<init>".equals(this.name())) {
            throw new IllegalStateException("Not defining a constructor");
        }
        this.doInvoke(type.mType, this.this_(), "<init>", -1, values, null, null);
        this.addOp(new Op(){

            @Override
            void appendTo(TheMethodMaker m) {
                ((InitThisVar)TheMethodMaker.this.this_()).ready();
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    LocalVar doInvoke(Type type, OwnedVar instance, String methodName, int inherit, Object[] args, Type specificReturnType, Type[] specificParamTypes) {
        block31: {
            if (!methodName.equals("<init>")) ** GOTO lbl6
            if (inherit == -1) {
                staticAllowed = -1;
            } else {
                throw new IllegalStateException("Unsupported method: " + methodName);
lbl6:
                // 1 sources

                staticAllowed = instance != null ? 0 : 1;
            }
            if (type.isPrimitive()) {
                type = type.box();
            }
            savepoint = this.mLastOp;
            try {
                paramTypes = new Type[args.length];
                for (i = 0; i < args.length; ++i) {
                    paramTypes[i] = this.addPushOp(null, args[i]);
                }
                if (specificParamTypes != null) {
                    original = specificParamTypes;
                    for (i = 0; i < specificParamTypes.length; ++i) {
                        if (specificParamTypes[i] != null) continue;
                        if (i >= paramTypes.length) break;
                        if (specificParamTypes == original) {
                            specificParamTypes = (Type[])original.clone();
                        }
                        specificParamTypes[i] = paramTypes[i];
                    }
                }
                method = type.findMethod(methodName, paramTypes, inherit, staticAllowed, specificReturnType, specificParamTypes);
            }
            catch (Throwable e) {
                this.rollback(savepoint);
                throw e;
            }
            if (type.isHidden() && (preferred = method.tryNonHidden()) != null) {
                method = preferred;
                type = method.enclosingType();
            }
            actualTypes = method.paramTypes();
            len = actualTypes.length;
            if (!method.isVarargs() || len == paramTypes.length && paramTypes[len - 1].canConvertTo(actualTypes[len - 1]) != 0x7FFFFFFF) {
                if (len != 0) {
                    for (i = 0; i < len; ++i) {
                        if (actualTypes[i].equals(paramTypes[i])) {
                            continue;
                        }
                        this.rollback(savepoint);
                        for (i = 0; i < args.length; ++i) {
                            this.addPushOp(actualTypes[i], args[i]);
                        }
                        break;
                    }
                }
            } else {
                this.rollback(savepoint);
                firstLen = len - 1;
                for (i = 0; i < firstLen; ++i) {
                    this.addPushOp(actualTypes[i], args[i]);
                }
                vararg = this.doNew(actualTypes[firstLen], new Object[]{args.length - i}, null);
                while (i < args.length) {
                    vararg.aset(i - firstLen, args[i]);
                    ++i;
                }
                this.addPushOp(null, vararg);
            }
            stackPop = actualTypes.length;
            returnType = method.returnType();
            if (!type.isHidden()) {
                if (instance != null && !method.isStatic()) {
                    savepoint = this.pushInstanceAt(savepoint, instance);
                }
            } else {
                if (instance != null) {
                    mhVar = instance.methodHandle(returnType, methodName, actualTypes);
                    if (method.isStatic()) {
                        invokeTypes = actualTypes;
                    } else {
                        invokeTypes = new Type[actualTypes.length + 1];
                        System.arraycopy(actualTypes, 0, invokeTypes, 1, actualTypes.length);
                        invokeTypes[0] = Type.from(Object.class);
                        this.pushInstanceAt(savepoint, instance);
                        ++stackPop;
                    }
                    method = mhVar.type().inventMethod(0, returnType, "invoke", invokeTypes);
                } else {
                    if (!TheMethodMaker.$assertionsDisabled && methodName != "<init>") {
                        throw new AssertionError();
                    }
                    inherit = 0;
                    mhVar = new LocalVar(type).methodHandle(null, ".new", actualTypes);
                    instanceType = type.nonHiddenBase();
                    method = mhVar.type().inventMethod(0, instanceType, "invoke", actualTypes);
                    returnType = type;
                }
                savepoint = this.pushInstanceAt(savepoint, mhVar);
            }
            methodRef = this.mConstants.addMethod(method);
            if (!method.isStatic()) break block31;
            op = -72;
            ** GOTO lbl107
        }
        ++stackPop;
        if (method.enclosingType().isInterface()) {
            nargs = stackPop;
            for (Type actualType : actualTypes) {
                tc = actualType.typeCode();
                if (tc != 9 && tc != 8) continue;
                ++nargs;
            }
            invokeOp /* !! */  = new InvokeInterfaceOp(stackPop, methodRef, nargs);
        } else {
            op = inherit == 0 ? -74 : -73;
lbl107:
            // 2 sources

            invokeOp /* !! */  = new InvokeOp((byte)op, stackPop, methodRef);
        }
        this.addOp(invokeOp /* !! */ );
        if (returnType == null || returnType == Type.VOID) {
            return null;
        }
        return this.storeToNewVar(returnType);
    }

    @Override
    public Variable invoke(MethodHandle handle, Object ... values) {
        MethodType mtype = handle.type();
        if (mtype.parameterCount() != values.length) {
            throw new IllegalArgumentException("Wrong number of parameters (expecting " + mtype.parameterCount() + ")");
        }
        Type returnType = Type.from((Class)mtype.returnType());
        Type handleType = Type.from(MethodHandle.class);
        LocalVar handleVar = new LocalVar(handleType);
        if (this.mClassMaker.allowExactConstants()) {
            handleVar.setExact(handle);
        } else {
            handleVar.set(handle);
        }
        this.addOp(new PushVarOp(handleVar));
        Type[] paramTypes = new Type[values.length];
        for (int i = 0; i < values.length; ++i) {
            paramTypes[i] = this.addPushOp(Type.from((Class)mtype.parameterType(i)), values[i]);
        }
        ConstantPool.C_Method ref = this.mConstants.addMethod(handleType.inventMethod(0, returnType, "invokeExact", paramTypes));
        this.addOp(new InvokeOp(-74, 1 + paramTypes.length, ref));
        if (returnType == Type.VOID) {
            return null;
        }
        return this.storeToNewVar(returnType);
    }

    @Override
    public Variable new_(Object objType, Object ... values) {
        return this.doNew(this.mClassMaker.typeFrom(objType), values, null);
    }

    private LocalVar doNew(final Type type, final Object[] values, Type[] specificParamTypes) {
        if (type.isArray()) {
            if (values == null || values.length == 0) {
                throw new IllegalArgumentException("At least one dimension required");
            }
            int dims = type.dimensions();
            if (values.length > dims || dims > 255) {
                throw new IllegalArgumentException("Too many dimensions");
            }
            for (Object size : values) {
                this.addPushOp(Type.INT, size);
            }
            if (values.length == 1) {
                Type elementType = type.elementType();
                if (elementType.isObject()) {
                    final ConstantPool.C_Class constant = this.mConstants.addClass(elementType);
                    this.addOp(new BytecodeOp(-67, 0){

                        @Override
                        void appendTo(TheMethodMaker m) {
                            super.appendTo(m);
                            m.appendShort(constant.mIndex);
                        }
                    });
                } else {
                    final byte atype = switch (elementType.typeCode()) {
                        case 2 -> 4;
                        case 4 -> 5;
                        case 7 -> 6;
                        case 9 -> 7;
                        case 3 -> 8;
                        case 5 -> 9;
                        case 6 -> 10;
                        case 8 -> 11;
                        default -> throw new IllegalArgumentException(elementType.name());
                    };
                    this.addOp(new BytecodeOp(-68, 0){

                        @Override
                        void appendTo(TheMethodMaker m) {
                            super.appendTo(m);
                            m.appendByte(atype);
                        }
                    });
                }
            } else {
                final ConstantPool.C_Class constant = this.mConstants.addClass(type);
                this.addOp(new BytecodeOp(-59, values.length - 1){

                    @Override
                    void appendTo(TheMethodMaker m) {
                        super.appendTo(m);
                        m.appendShort(constant.mIndex);
                        m.appendByte((byte)values.length);
                    }
                });
            }
        } else if (!type.isHidden()) {
            final ConstantPool.C_Class constant = this.mConstants.addClass(type);
            this.addOp(new BytecodeOp(-69, 0){

                @Override
                void appendTo(TheMethodMaker m) {
                    int newOffset = m.mCodeLen;
                    super.appendTo(m);
                    m.appendShort(constant.mIndex);
                    m.stackPush(type, newOffset);
                    m.appendByte(89);
                    m.stackPush(type, newOffset);
                }
            });
            this.doInvoke(type, null, "<init>", -1, values, null, specificParamTypes);
        } else {
            return this.doInvoke(type, null, "<init>", -1, values, null, specificParamTypes);
        }
        return this.storeToNewVar(type);
    }

    @Override
    public Variable catch_(Label start, Label end, Object type) {
        return this.catch_(this.startLab(start), this.target(end), type);
    }

    private Lab startLab(Label start) {
        Lab startLab = this.target(start);
        if (!startLab.isPositioned()) {
            throw new IllegalStateException("Start is unpositioned");
        }
        return startLab;
    }

    private Variable catch_(Lab startLab, Lab endLab, Object type) {
        Type catchType = type == null ? Type.from(Throwable.class) : this.mClassMaker.typeFrom(type);
        return this.catch_(catchType, startLab, endLab, type);
    }

    private Variable catch_(Type catchType, Lab startLab, final Lab endLab, Object type) {
        this.mHasBranches = true;
        ConstantPool.C_Class catchClass = this.mConstants.addClass(catchType);
        int smCatchCode = 7 | catchClass.mIndex << 8;
        if (type == null) {
            catchClass = null;
        }
        final HandlerLab handlerLab = new HandlerLab(catchType, smCatchCode);
        Op startOp = new Op(){

            @Override
            void appendTo(TheMethodMaker m) {
            }

            @Override
            Op flow(Flow flow, Op prev) {
                endLab.mVisited = true;
                flow.run(handlerLab);
                return this.mNext;
            }
        };
        Op next = startLab.mNext;
        startLab.mNext = startOp;
        startOp.mNext = next;
        if (next == null) {
            this.mLastOp = startOp;
        }
        handlerLab.here();
        Handler handler = new Handler(startLab, endLab, handlerLab, catchClass);
        if (this.mExceptionHandlers == null) {
            this.mExceptionHandlers = new ArrayList<Handler>(4);
        }
        this.mExceptionHandlers.add(handler);
        return this.storeToNewVar(catchType);
    }

    @Override
    public Variable catch_(Label start, Label end, Object ... types) {
        if (types == null) {
            return this.catch_(start, end, (Object)null);
        }
        if (types.length <= 1) {
            if (types.length == 1) {
                return this.catch_(start, end, types[0]);
            }
            throw new IllegalArgumentException("No catch types given");
        }
        HashMap<Type, List<Type>> catchMap = new HashMap<Type, List<Type>>(types.length << 1);
        for (Object type : types) {
            if (type == null) {
                return this.catch_(start, end, (Object)null);
            }
            Type t = this.mClassMaker.typeFrom(type);
            if (!t.isObject()) {
                throw new IllegalArgumentException(t.name());
            }
            catchMap.put(t, null);
        }
        Lab startLab = this.startLab(start);
        Lab endLab = this.target(end);
        if (catchMap.size() == 1) {
            return this.catch_(catchMap.keySet().iterator().next(), startLab, endLab, types[0]);
        }
        Type commonCatchType = Type.commonCatchType(catchMap);
        Variable exVar = this.catch_(commonCatchType, startLab, endLab, types[0]);
        if (catchMap.size() > 1) {
            Iterator<Type> catchTypes = catchMap.keySet().iterator();
            Handler handler = this.mExceptionHandlers.get(this.mExceptionHandlers.size() - 1);
            handler.mCatchClass = this.mConstants.addClass(catchTypes.next());
            do {
                handler = new Handler(handler, this.mConstants.addClass(catchTypes.next()));
                this.mExceptionHandlers.add(handler);
            } while (catchTypes.hasNext());
        }
        return exVar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void catch_(Label start, Object type, Consumer<Variable> handler) {
        Lab startLab = this.startLab(start);
        Label cont = this.label();
        this.goto_(cont);
        Lab endLab = new Lab();
        endLab.here();
        Variable exVar = this.catch_(startLab, endLab, type);
        try {
            handler.accept(exVar);
        }
        finally {
            cont.here();
        }
    }

    private static void adjustPushCount(Object value, int amt) {
        if (value instanceof OwnedVar) {
            OwnedVar var = (OwnedVar)value;
            var.adjustPushCount(amt);
        }
    }

    private static byte flipIf(byte op) {
        return (byte)(op >= -58 ? op ^ 1 : (op - 1 ^ 1) + 1);
    }

    @Override
    public void finally_(Label start, Runnable handler) {
        Op op;
        Lab startLab = this.target(start);
        Lab endLab = new Lab();
        this.addOp(endLab);
        HashSet<Lab> inside = null;
        Op op2 = startLab;
        while (true) {
            if ((op2 = op2.mNext) == null) {
                throw new IllegalStateException("Start is unpositioned");
            }
            if (op2 == endLab) break;
            if (!(op2 instanceof Lab)) continue;
            Op lab = op2;
            if (inside == null) {
                inside = new HashSet<Lab>();
            }
            inside.add((Lab)lab);
        }
        LinkedHashMap<Lab, Lab> exits = new LinkedHashMap<Lab, Lab>();
        Lab retHandler = null;
        LocalVar retVar = null;
        boolean lastTransformed = false;
        Lab veryEnd = null;
        Op prev = startLab;
        while ((op = prev.mNext) != endLab) {
            lastTransformed = true;
            if (op instanceof BranchOp) {
                BranchOp branchOp = (BranchOp)op;
                branchOp.mTarget = this.finallyExit(inside, exits, branchOp.mTarget);
            } else if (op instanceof SwitchOp) {
                SwitchOp switchOp = (SwitchOp)op;
                switchOp.finallyExits(this, inside, exits);
            } else if (op instanceof ReturnOp) {
                ReturnOp retOp = (ReturnOp)op;
                if (retHandler == null) {
                    retHandler = new Lab();
                    if (retOp.op() != -79) {
                        retVar = new LocalVar(this.mMethod.returnType());
                    }
                }
                if (retVar != null) {
                    StoreVarOp storeOp = new StoreVarOp(retVar);
                    prev.mNext = storeOp;
                    prev = storeOp;
                }
                BranchOp gotoOp = new BranchOp(-89, 0, retHandler);
                prev.mNext = gotoOp;
                gotoOp.mNext = op.mNext;
                op = gotoOp;
            } else {
                lastTransformed = false;
            }
            prev = op;
        }
        if (!lastTransformed) {
            handler.run();
            veryEnd = new Lab();
            this.goto_(veryEnd);
        }
        Variable exVar = this.catch_(startLab, endLab, (Object)null);
        handler.run();
        exVar.throw_();
        for (Map.Entry e : exits.entrySet()) {
            ((Lab)e.getValue()).here();
            handler.run();
            this.goto_((Label)e.getKey());
        }
        if (retHandler != null) {
            retHandler.here();
            handler.run();
            if (retVar == null) {
                this.doReturn();
            } else {
                this.return_(retVar);
            }
        }
        if (veryEnd != null) {
            veryEnd.here();
        }
    }

    private Lab finallyExit(HashSet<Lab> inside, Map<Lab, Lab> exits, Lab target) {
        if (inside == null || !inside.contains(target)) {
            Lab handlerLab = exits.get(target);
            if (handlerLab == null) {
                handlerLab = new Lab();
                exits.put(target, handlerLab);
            }
            target = handlerLab;
            target.targeted();
        }
        return target;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Variable concat(Object ... values) {
        Type[] bootParams;
        String bootName;
        ConstantPool.Constant[] bootArgs;
        if (values.length == 0) {
            return this.var(String.class).set("");
        }
        if (values.length == 1) {
            String strValue;
            Object value = values[0];
            if (value == null) {
                strValue = "null";
            } else if (value instanceof String) {
                strValue = (String)value;
            } else {
                return this.var(String.class).invoke("valueOf", value);
            }
            return this.var(String.class).set(strValue);
        }
        if (values.length > 100) {
            int numSlots = values.length;
            for (Object object : values) {
                LocalVar var;
                int tc;
                if (!(object instanceof LocalVar) || (tc = (var = (LocalVar)object).type().typeCode()) != 9 && tc != 8) continue;
                ++numSlots;
            }
            if (numSlots > 200) {
                long capacity;
                for (capacity = (long)values.length * 8L; capacity > Integer.MAX_VALUE; capacity >>= 1) {
                }
                Variable sb = this.new_(StringBuilder.class, (int)capacity);
                for (Object value : values) {
                    sb = sb.invoke("append", value);
                }
                return sb.invoke("toString");
            }
        }
        char[] recipe = null;
        ArrayList<ConstantPool.Constant> constants = null;
        ArrayList<Type> valueTypes = new ArrayList<Type>(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object object = values[i];
            if (!(object instanceof Variable)) {
                char c;
                if (object instanceof Character && ((c = ((Character)object).charValue()) > '\u0002' || c == '\u0000')) {
                    if (recipe == null) {
                        recipe = new char[values.length];
                        Arrays.fill(recipe, '\u0001');
                    }
                    recipe[i] = c;
                    continue;
                }
                ConstantPool.Constant c2 = this.mConstants.tryAddLoadableConstant(object);
                if (c2 != null) {
                    if (recipe == null) {
                        recipe = new char[values.length];
                        Arrays.fill(recipe, '\u0001');
                    }
                    recipe[i] = 2;
                    if (constants == null) {
                        constants = new ArrayList<ConstantPool.Constant>();
                    }
                    constants.add(c2);
                    continue;
                }
            }
            valueTypes.add(this.addPushOp(null, object));
        }
        if (constants == null) {
            bootArgs = recipe == null ? new ConstantPool.Constant[]{} : new ConstantPool.Constant[]{this.mConstants.addString(new String(recipe))};
        } else {
            void var6_18;
            bootArgs = new ConstantPool.Constant[1 + constants.size()];
            bootArgs[0] = this.mConstants.addString(new String(recipe));
            boolean bl = true;
            while (var6_18 < bootArgs.length) {
                bootArgs[var6_18] = (ConstantPool.Constant)constants.get((int)(var6_18 - true));
                ++var6_18;
            }
        }
        Type type = Type.from(String.class);
        if (recipe == null) {
            bootName = "makeConcat";
            bootParams = new Type[3];
        } else {
            bootName = "makeConcatWithConstants";
            bootParams = new Type[5];
            bootParams[3] = type;
            bootParams[4] = Type.from(Object[].class);
        }
        bootParams[0] = Type.from(MethodHandles.Lookup.class);
        bootParams[1] = type;
        bootParams[2] = Type.from(MethodType.class);
        ConstantPool.C_Method ref = this.mConstants.addMethod(Type.from(StringConcatFactory.class).inventMethod(8, Type.from(CallSite.class), bootName, bootParams));
        ConstantPool.C_MethodHandle bootstrapHandle = this.mConstants.addMethodHandle(6, ref);
        int bi = this.mClassMaker.addBootstrapMethod(bootstrapHandle, bootArgs);
        String desc = Type.makeDescriptor(type, valueTypes);
        ConstantPool.C_Dynamic dynamic = this.mConstants.addInvokeDynamic(bi, bootName, desc);
        this.addOp(new InvokeDynamicOp(valueTypes.size(), dynamic, type));
        return this.storeToNewVar(type);
    }

    @Override
    public Field access(VarHandle handle, Object ... values) {
        List<Class<?>> coordTypes = handle.coordinateTypes();
        if (coordTypes.size() != values.length) {
            throw new IllegalArgumentException("Wrong number of coordinates (expecting " + coordTypes.size() + ")");
        }
        Type[] coordinateTypes = new Type[coordTypes.size()];
        int i = 0;
        for (Class<?> clazz : coordTypes) {
            coordinateTypes[i++] = Type.from(clazz);
        }
        Type handleType = Type.from(VarHandle.class);
        LocalVar handleVar = new LocalVar(handleType);
        if (this.mClassMaker.allowExactConstants()) {
            handleVar.setExact(handle);
        } else {
            handleVar.set(handle);
        }
        return new HandleVar(handleVar, Type.from(handle.varType()), coordinateTypes, values);
    }

    @Override
    public void nop() {
        this.addBytecodeOp((byte)0, 0);
    }

    @Override
    public ClassMaker addInnerClass(String className) {
        return this.mClassMaker.addInnerClass(className, this.mMethod);
    }

    @Override
    public MethodHandle finish() {
        throw new IllegalStateException("Not a standalone method");
    }

    private void stackPush(Type type) {
        this.stackPush(type, -1);
    }

    private void stackPush(Type type, int newOffset) {
        LocalVar top;
        int slot;
        if (this.mStackSize == 0) {
            slot = 0;
        } else {
            top = this.stackTop();
            slot = top.mSlot + top.slotWidth();
        }
        top = newOffset < 0 ? new LocalVar(type) : new NewVar(type, newOffset);
        top.mSlot = slot;
        if (this.mStackSize >= this.mStack.length) {
            this.mStack = Arrays.copyOf(this.mStack, this.mStack.length << 1);
        }
        this.mStack[this.mStackSize++] = top;
        int max = slot + top.slotWidth();
        if (max > this.mMaxStackSlot) {
            this.mMaxStackSlot = max;
        }
    }

    private void stackPop() {
        byte op = switch (this.stackTop().mType.typeCode()) {
            default -> 87;
            case 8, 9 -> 88;
        };
        this.appendOp(op, 1);
    }

    private LocalVar stackTop() {
        return this.mStack[this.mStackSize - 1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushConstant(Object value, Type type) {
        if (value == null) {
            this.appendByte(1);
            this.stackPush(Type.Null.THE);
            return;
        } else if (value instanceof String) {
            String str = (String)value;
            this.pushConstant(this.mConstants.addString(str), type);
            return;
        } else if (value instanceof Class) {
            Class clazz = (Class)value;
            this.pushConstant(this.mConstants.addClass(Type.from(clazz)), type);
            return;
        } else if (value instanceof Number) {
            if (value instanceof Integer) {
                Integer num = (Integer)value;
                this.pushConstant(num, type);
                return;
            } else if (value instanceof Long) {
                Long num = (Long)value;
                this.pushConstant(num, type);
                return;
            } else if (value instanceof Float) {
                Float num = (Float)value;
                this.pushConstant(num.floatValue(), type);
                return;
            } else if (value instanceof Double) {
                Double num = (Double)value;
                this.pushConstant(num, type);
                return;
            } else if (value instanceof Byte) {
                Byte num = (Byte)value;
                this.pushConstant(num.byteValue(), type);
                return;
            } else {
                if (!(value instanceof Short)) throw new AssertionError();
                Short num = (Short)value;
                this.pushConstant(num.shortValue(), type);
            }
            return;
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            this.pushConstant(b != false ? 1 : 0, type);
            return;
        } else if (value instanceof Character) {
            Character c = (Character)value;
            this.pushConstant(c.charValue(), type);
            return;
        } else if (value instanceof Type) {
            Type t = (Type)value;
            this.pushConstant(this.mConstants.addClass(t), type);
            return;
        } else if (value instanceof MethodType) {
            MethodType mt = (MethodType)value;
            this.pushConstant(this.mConstants.addMethodType(mt), type);
            return;
        } else {
            if (!(value instanceof MethodHandleInfo)) throw new AssertionError();
            MethodHandleInfo info = (MethodHandleInfo)value;
            this.pushConstant(this.mConstants.addMethodHandle(info), type);
        }
    }

    private void pushConstant(int value, Type type) {
        if (value >= -1 && value <= 5) {
            this.appendByte(3 + value);
        } else if (value >= -128 && value < 128) {
            this.appendByte(16);
            this.appendByte(value);
        } else if (value >= Short.MIN_VALUE && value < 32768) {
            this.appendByte(17);
            this.appendShort(value);
        } else {
            this.pushConstant(this.mConstants.addInteger(value), type);
            return;
        }
        this.stackPush(type);
    }

    private void pushConstant(long value, Type type) {
        if (value >= 0L && value <= 1L) {
            this.appendByte((byte)(9L + value));
        } else {
            this.appendByte(20);
            this.appendShort(this.mConstants.addLong((long)value).mIndex);
        }
        this.stackPush(type);
    }

    private void pushConstant(float value, Type type) {
        int op;
        if (Float.compare(value, 0.0f) == 0) {
            op = 11;
        } else if (value == 1.0f) {
            op = 12;
        } else if (value == 2.0f) {
            op = 13;
        } else {
            this.pushConstant(this.mConstants.addFloat(value), type);
            return;
        }
        this.appendByte(op);
        this.stackPush(type);
    }

    /*
     * Unable to fully structure code
     */
    private void pushConstant(double value, Type type) {
        block2: {
            if (Double.compare(value, 0.0) != 0) break block2;
            op = 14;
            ** GOTO lbl10
        }
        if (value != 1.0) {
            this.appendByte(20);
            this.appendShort(this.mConstants.addDouble((double)value).mIndex);
        } else {
            op = 15;
lbl10:
            // 2 sources

            this.appendByte(op);
        }
        this.stackPush(type);
    }

    private void pushConstant(ConstantPool.Constant constant, Type type) {
        int index = constant.mIndex;
        if (index < 256) {
            this.appendByte(18);
            this.appendByte(index);
        } else {
            this.appendByte(19);
            this.appendShort(index);
        }
        this.stackPush(type);
    }

    /*
     * Unable to fully structure code
     */
    private void pushVar(LocalVar var) {
        block11: {
            block10: {
                slot = var.mSlot;
                if (slot < 0) {
                    throw new AssertionError();
                }
                switch (var.mType.stackMapCode()) {
                    default: {
                        throw new IllegalStateException("Unsupported variable type: " + var.mType.name());
                    }
                    case 1: {
                        if (slot > 3) ** GOTO lbl11
                        op = 26;
                        break block10;
lbl11:
                        // 1 sources

                        op = 21;
                        break;
                    }
                    case 2: {
                        if (slot > 3) ** GOTO lbl17
                        op = 34;
                        break block10;
lbl17:
                        // 1 sources

                        op = 23;
                        break;
                    }
                    case 3: {
                        if (slot > 3) ** GOTO lbl23
                        op = 38;
                        break block10;
lbl23:
                        // 1 sources

                        op = 24;
                        break;
                    }
                    case 4: {
                        if (slot > 3) ** GOTO lbl29
                        op = 30;
                        break block10;
lbl29:
                        // 1 sources

                        op = 22;
                        break;
                    }
                    case 7: {
                        if (slot > 3) ** GOTO lbl35
                        op = 42;
                        break block10;
lbl35:
                        // 1 sources

                        op = 25;
                    }
                }
                if (slot < 256) {
                    this.appendByte(op);
                    this.appendByte(slot);
                } else {
                    this.appendByte(-60);
                    this.appendByte(op);
                    this.appendShort(slot);
                }
                break block11;
            }
            this.appendByte(op + slot);
        }
        this.stackPush(var.mType);
    }

    private void convert(Type from, Type to, int code) {
        if (code <= 0) {
            return;
        }
        if (code < 5) {
            this.convertPrimitive(to, code);
            return;
        }
        if (code < 10) {
            Type primTo = this.convertPrimitive(to, code -= 5);
            if (primTo == null) {
                primTo = this.convertPrimitive(from.box(), code);
            }
            this.box(primTo);
            return;
        }
        if (code < 15) {
            throw new AssertionError();
        }
        if (code < 20) {
            this.unbox(from);
            this.convertPrimitive(to, code - 15);
            return;
        }
        throw new AssertionError();
    }

    private Type convertPrimitive(Type to, int code) {
        switch (code) {
            default: {
                return to.unbox();
            }
            case 1: {
                this.appendOp((byte)-123, 1);
                to = Type.LONG;
                break;
            }
            case 2: {
                this.appendOp((byte)-122, 1);
                to = Type.FLOAT;
                break;
            }
            case 3: {
                this.appendOp((byte)-121, 1);
                to = Type.DOUBLE;
                break;
            }
            case 4: {
                this.appendOp((byte)-115, 1);
                to = Type.DOUBLE;
            }
        }
        this.stackPush(to);
        return to;
    }

    private void box(Type primType) {
        Type objType = primType.box();
        Type.Method method = objType.defineMethod(8, objType, "valueOf", primType);
        this.appendOp((byte)-72, 1);
        this.appendShort(this.mConstants.addMethod((Type.Method)method).mIndex);
        this.stackPush(objType);
    }

    private void unbox(Type objType) {
        Type primType = objType.unbox();
        Type.Method method = objType.defineMethod(0, primType, primType.name() + "Value", new Type[0]);
        this.appendOp((byte)-74, 1);
        this.appendShort(this.mConstants.addMethod((Type.Method)method).mIndex);
        this.stackPush(primType);
    }

    /*
     * Unable to fully structure code
     */
    private void storeVar(LocalVar var) {
        block9: {
            slot = var.mSlot;
            switch (var.mType.stackMapCode()) {
                default: {
                    throw new IllegalStateException("Unsupported variable type: " + var.mType.name());
                }
                case 1: {
                    if (slot > 3) ** GOTO lbl9
                    op = 59;
                    break block9;
lbl9:
                    // 1 sources

                    op = 54;
                    break;
                }
                case 2: {
                    if (slot > 3) ** GOTO lbl15
                    op = 67;
                    break block9;
lbl15:
                    // 1 sources

                    op = 56;
                    break;
                }
                case 3: {
                    if (slot > 3) ** GOTO lbl21
                    op = 71;
                    break block9;
lbl21:
                    // 1 sources

                    op = 57;
                    break;
                }
                case 4: {
                    if (slot > 3) ** GOTO lbl27
                    op = 63;
                    break block9;
lbl27:
                    // 1 sources

                    op = 55;
                    break;
                }
                case 7: {
                    if (slot > 3) ** GOTO lbl33
                    op = 75;
                    break block9;
lbl33:
                    // 1 sources

                    op = 58;
                }
            }
            if (slot < 256) {
                this.appendOp(op, 1);
                this.appendByte(slot);
            } else {
                this.appendOp((byte)-60, 1);
                this.appendByte(op);
                this.appendShort(slot);
            }
            return;
        }
        this.appendOp((byte)(op + slot), 1);
    }

    private void appendOp(byte op, int stackPop) {
        this.appendByte(op);
        if (stackPop > 0) {
            int newSize = this.mStackSize - stackPop;
            if (newSize < 0) {
                throw new IllegalStateException("Stack is empty");
            }
            this.mStackSize = newSize;
        }
    }

    private void appendByte(int v) {
        this.ensureSpace(1);
        this.mCode[this.mCodeLen++] = (byte)v;
    }

    private void appendShort(int v) {
        this.ensureSpace(2);
        BytesOut.cShortArrayHandle.set(this.mCode, this.mCodeLen, (short)v);
        this.mCodeLen += 2;
    }

    private void appendInt(int v) {
        this.ensureSpace(4);
        BytesOut.cIntArrayHandle.set(this.mCode, this.mCodeLen, v);
        this.mCodeLen += 4;
    }

    private void appendPad(int pad) {
        this.ensureSpace(pad);
        this.mCodeLen += pad;
    }

    private void ensureSpace(int amt) {
        int require = this.mCodeLen + amt - this.mCode.length;
        if (require > 0) {
            this.growSpace(require);
        }
    }

    private void growSpace(int require) {
        int newLen = Math.max(this.mCode.length + require, this.mCode.length << 1);
        if ((newLen = Math.min(newLen, 65535)) <= this.mCode.length) {
            throw new IllegalStateException("Code limit reached");
        }
        this.mCode = Arrays.copyOf(this.mCode, newLen);
    }

    private void addOp(Op op) {
        if (this.mLastOp == null) {
            this.mFirstOp = op;
        } else {
            this.mLastOp.mNext = op;
        }
        this.mLastOp = op;
    }

    private void addOps(Op op, Op last) {
        if (this.mLastOp == null) {
            this.mFirstOp = op;
        } else {
            this.mLastOp.mNext = op;
        }
        this.mLastOp = last;
    }

    private void removeOps(Op prev, Op next) {
        if (prev == null) {
            this.mFirstOp = next;
        } else {
            prev.mNext = next;
        }
        if (next == null) {
            this.mLastOp = prev;
        }
    }

    private Op rollback(Op savepoint) {
        Op start;
        if (savepoint == this.mLastOp) {
            return null;
        }
        if (savepoint == null) {
            start = this.mFirstOp;
            this.mFirstOp = null;
        } else {
            start = savepoint.mNext;
            savepoint.mNext = null;
        }
        this.mLastOp = savepoint;
        return start;
    }

    private Op pushInstanceAt(Op savepoint, OwnedVar instance) {
        Op end = this.mLastOp;
        if (end == savepoint) {
            instance.pushObject();
            savepoint = this.mLastOp;
        } else {
            Op rest = this.rollback(savepoint);
            instance.pushObject();
            savepoint = this.mLastOp;
            this.mLastOp.mNext = rest;
            this.mLastOp = end;
        }
        return savepoint;
    }

    private void addBytecodeOp(byte op, int stackPop) {
        this.addOp(new BytecodeOp(op, stackPop));
    }

    private Type addPushOp(Type type, Object value) {
        Op savepoint = this.mLastOp;
        try {
            return this.doAddPushOp(type, value);
        }
        catch (Throwable e) {
            this.rollback(savepoint);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type doAddPushOp(Type type, Object value) {
        void var3_71;
        if (value instanceof OwnedVar) {
            OwnedVar ownedVar = (OwnedVar)value;
            if (!ownedVar.tryPushTo(this)) throw new IllegalStateException("Unknown variable");
            return this.addConversionOp(ownedVar.type(), type);
        }
        if (value == null) {
            if (type != null && type.isPrimitive()) {
                throw new IllegalStateException("Cannot store null into primitive variable");
            }
            Type.Null nullVal = Type.Null.THE;
        } else if (value instanceof String) {
            String str = (String)value;
            int utflen = BytesOut.checkUTF(str);
            if (utflen > 0) {
                throw new IllegalArgumentException("String constant is too large: " + utflen + " bytes");
            }
            Type type2 = Type.from(String.class);
        } else if (value instanceof Class) {
            Class clazz = (Class)value;
            Type type3 = Type.from(Class.class);
            if (clazz.isPrimitive()) {
                new LocalVar(Type.from(clazz).box()).field("TYPE").push();
                return this.addConversionOp(type3, type);
            }
        } else if (value instanceof Number) {
            if (value instanceof Integer) {
                Type type4 = Type.INT;
                if (type != null) {
                    int v = (Integer)value;
                    switch (type.unboxTypeCode()) {
                        case 3: {
                            if ((byte)v != v) break;
                            value = (byte)v;
                            Type type5 = Type.BYTE;
                            break;
                        }
                        case 5: {
                            if ((short)v != v) break;
                            value = (short)v;
                            Type type6 = Type.SHORT;
                            break;
                        }
                        case 7: {
                            float fv = v;
                            if ((int)fv != v) break;
                            value = Float.valueOf(fv);
                            Type type7 = Type.FLOAT;
                            break;
                        }
                        case 9: {
                            value = (double)v;
                            Type type8 = Type.DOUBLE;
                            break;
                        }
                        case 8: {
                            value = (long)v;
                            Type type9 = Type.LONG;
                            break;
                        }
                        case 4: {
                            char cv = (char)v;
                            if (cv != v) break;
                            value = Character.valueOf(cv);
                            Type type10 = Type.CHAR;
                        }
                    }
                }
            } else if (value instanceof Long) {
                Type type11 = Type.LONG;
                if (type != null) {
                    long v = (Long)value;
                    switch (type.unboxTypeCode()) {
                        case 3: {
                            byte bv = (byte)v;
                            if ((long)bv != v) break;
                            value = bv;
                            Type type12 = Type.BYTE;
                            break;
                        }
                        case 5: {
                            short sv = (short)v;
                            if ((long)sv != v) break;
                            value = sv;
                            Type type13 = Type.SHORT;
                            break;
                        }
                        case 6: {
                            int iv = (int)v;
                            if ((long)iv != v) break;
                            value = iv;
                            Type type14 = Type.INT;
                            break;
                        }
                        case 7: {
                            float fv = v;
                            if ((long)fv != v) break;
                            value = Float.valueOf(fv);
                            Type type15 = Type.FLOAT;
                            break;
                        }
                        case 9: {
                            double dv = v;
                            if ((long)dv != v) break;
                            value = dv;
                            Type type16 = Type.DOUBLE;
                            break;
                        }
                        case 4: {
                            char cv = (char)v;
                            if ((long)cv != v) break;
                            value = Character.valueOf(cv);
                            Type type17 = Type.CHAR;
                        }
                    }
                }
            } else if (value instanceof Float) {
                Type type18 = Type.FLOAT;
                if (type != null) {
                    float v = ((Float)value).floatValue();
                    switch (type.unboxTypeCode()) {
                        case 3: {
                            byte bv = (byte)v;
                            if ((float)bv != v) break;
                            value = bv;
                            Type type19 = Type.BYTE;
                            break;
                        }
                        case 5: {
                            short sv = (short)v;
                            if ((float)sv != v) break;
                            value = sv;
                            Type type20 = Type.SHORT;
                            break;
                        }
                        case 6: {
                            int iv = (int)v;
                            if ((float)iv != v) break;
                            value = iv;
                            Type type21 = Type.INT;
                            break;
                        }
                        case 8: {
                            long lv = (long)v;
                            if ((float)lv != v) break;
                            value = lv;
                            Type type22 = Type.LONG;
                            break;
                        }
                        case 9: {
                            value = (double)v;
                            Type type23 = Type.DOUBLE;
                            break;
                        }
                        case 4: {
                            char cv = (char)v;
                            if ((float)cv != v) break;
                            value = Character.valueOf(cv);
                            Type type24 = Type.CHAR;
                        }
                    }
                }
            } else if (value instanceof Double) {
                Type type25 = Type.DOUBLE;
                if (type != null) {
                    double v = (Double)value;
                    switch (type.unboxTypeCode()) {
                        case 3: {
                            byte bv = (byte)v;
                            if ((double)bv != v) break;
                            value = bv;
                            Type type26 = Type.BYTE;
                            break;
                        }
                        case 5: {
                            short sv = (short)v;
                            if ((double)sv != v) break;
                            value = sv;
                            Type type27 = Type.SHORT;
                            break;
                        }
                        case 6: {
                            int iv = (int)v;
                            if ((double)iv != v) break;
                            value = iv;
                            Type type28 = Type.INT;
                            break;
                        }
                        case 7: {
                            float fv = (float)v;
                            if (Double.doubleToRawLongBits(fv) != Double.doubleToRawLongBits(v)) break;
                            value = Float.valueOf(fv);
                            Type type29 = Type.FLOAT;
                            break;
                        }
                        case 8: {
                            long lv = (long)v;
                            if ((double)lv != v) break;
                            value = lv;
                            Type type30 = Type.LONG;
                            break;
                        }
                        case 4: {
                            char cv = (char)v;
                            if ((double)cv != v) break;
                            value = Character.valueOf(cv);
                            Type type31 = Type.CHAR;
                        }
                    }
                }
            } else if (value instanceof Byte) {
                Type type32 = Type.BYTE;
                if (type != null) {
                    byte v = (Byte)value;
                    switch (type.unboxTypeCode()) {
                        case 5: {
                            value = (short)v;
                            Type type33 = Type.SHORT;
                            break;
                        }
                        case 6: {
                            value = (int)v;
                            Type type34 = Type.INT;
                            break;
                        }
                        case 7: {
                            value = Float.valueOf(v);
                            Type type35 = Type.FLOAT;
                            break;
                        }
                        case 8: {
                            value = (long)v;
                            Type type36 = Type.LONG;
                            break;
                        }
                        case 9: {
                            value = (double)v;
                            Type type37 = Type.DOUBLE;
                            break;
                        }
                        case 4: {
                            if (v < 0) break;
                            value = Character.valueOf((char)v);
                            Type type38 = Type.CHAR;
                        }
                    }
                }
            } else {
                if (!(value instanceof Short)) throw TheMethodMaker.unsupportedConstant(value);
                Type type39 = Type.SHORT;
                if (type != null) {
                    short v = (Short)value;
                    switch (type.unboxTypeCode()) {
                        case 3: {
                            byte bv = (byte)v;
                            if ((short)bv != v) break;
                            value = bv;
                            Type type40 = Type.BYTE;
                            break;
                        }
                        case 6: {
                            value = (int)v;
                            Type type41 = Type.INT;
                            break;
                        }
                        case 7: {
                            value = Float.valueOf(v);
                            Type type42 = Type.FLOAT;
                            break;
                        }
                        case 8: {
                            value = (long)v;
                            Type type43 = Type.LONG;
                            break;
                        }
                        case 9: {
                            value = (double)v;
                            Type type44 = Type.DOUBLE;
                            break;
                        }
                        case 4: {
                            if (v < 0) break;
                            value = Character.valueOf((char)v);
                            Type type45 = Type.CHAR;
                        }
                    }
                }
            }
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            if (type != null && type.isObject()) {
                Type type46 = Type.from(Boolean.class);
                Type.Field field = type46.findField(b != false ? "TRUE" : "FALSE");
                this.addOp(new FieldOp(-78, 0, this.mConstants.addField(field)));
                return this.addConversionOp(type46, type);
            }
            Type type47 = Type.BOOLEAN;
        } else if (value instanceof Character) {
            Type type48 = Type.CHAR;
            if (type != null) {
                char v = ((Character)value).charValue();
                switch (type.unboxTypeCode()) {
                    case 3: {
                        if (v >= '\u0080') break;
                        value = (byte)v;
                        Type type49 = Type.BYTE;
                        break;
                    }
                    case 5: {
                        if (v >= '\u8000') break;
                        value = (short)v;
                        Type type50 = Type.SHORT;
                        break;
                    }
                    case 6: {
                        value = (int)v;
                        Type type51 = Type.INT;
                        break;
                    }
                    case 7: {
                        value = Float.valueOf(v);
                        Type type52 = Type.FLOAT;
                        break;
                    }
                    case 8: {
                        value = (long)v;
                        Type type53 = Type.LONG;
                        break;
                    }
                    case 9: {
                        value = (double)v;
                        Type type54 = Type.DOUBLE;
                    }
                }
            }
        } else if (value instanceof Type) {
            Type actualType = (Type)value;
            Type type55 = Type.from(Class.class);
            if (actualType.isPrimitive()) {
                new LocalVar(actualType.box()).field("TYPE").push();
                return this.addConversionOp(type55, type);
            }
        } else if (value instanceof MethodType) {
            Type type56 = Type.from(MethodType.class);
        } else if (value instanceof MethodHandleInfo) {
            Type type57 = Type.from(MethodHandleInfo.class);
            if (type != null && type.equals(Type.from(MethodHandle.class))) {
                Type type58 = type;
            }
        } else {
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                Type type59 = Type.from(value.getClass());
                new LocalVar(type59).field(e.name()).push();
                return this.addConversionOp(type59, type);
            }
            String actualTypeDesc = ConstableSupport.toTypeDescriptor(value);
            if (actualTypeDesc != null) {
                Type actualType = this.mClassMaker.typeFrom(actualTypeDesc);
                Type type60 = Type.from(Class.class);
                if (actualType.isPrimitive()) {
                    new LocalVar(actualType.box()).field("TYPE").push();
                    return this.addConversionOp(type60, type);
                }
                value = actualType;
            } else {
                ConstantVar cv = ConstableSupport.toConstantVar(this, value);
                if (cv == null) throw TheMethodMaker.unsupportedConstant(value);
                cv.push();
                return this.addConversionOp(cv.type(), type);
            }
        }
        this.addOp(new BasicConstantOp(value, (Type)var3_71));
        return this.addConversionOp((Type)var3_71, type);
    }

    private Type addConversionOp(Type from, Type to) {
        if (to != null && !from.equals(to)) {
            this.doAddConversionOp(from, to, from.canConvertTo(to));
            return to;
        }
        return from;
    }

    private void doAddConversionOp(final Type from, final Type to, final int code) {
        LocalVar fromVar;
        if (code == Integer.MAX_VALUE) {
            throw new IllegalStateException("Automatic conversion disallowed: " + from.name() + " to " + to.name());
        }
        if (code == 0) {
            return;
        }
        if (code < 10 || code >= 15) {
            this.addOp(new Op(){

                @Override
                void appendTo(TheMethodMaker m) {
                    m.convert(from, to, code);
                }
            });
            return;
        }
        Op op = this.mLastOp;
        if (op instanceof PushVarOp) {
            PushVarOp op2 = (PushVarOp)op;
            fromVar = op2.mVar;
        } else {
            fromVar = new LocalVar(from);
            this.addOp(new StoreVarOp(fromVar));
            fromVar.push();
        }
        Lab nonNull = new Lab();
        this.addBranchOp((byte)-57, 1, nonNull);
        LocalVar toVar = new LocalVar(to);
        toVar.set(null);
        Lab cont = new Lab();
        this.goto_(cont);
        nonNull.here();
        this.addOp(new PushVarOp(fromVar));
        Type fromPrim = from.unbox();
        this.addConversionOp(from, fromPrim);
        this.addConversionOp(fromPrim, to);
        this.addOp(new StoreVarOp(toVar));
        cont.here();
        this.addOp(new PushVarOp(toVar));
    }

    private ConstantPool.C_Dynamic addExactConstant(Type type, Object value) {
        Set<Type.Method> bootstraps = Type.from(ConstantsRegistry.class).findMethods("find", new Type[]{Type.from(MethodHandles.Lookup.class), Type.from(String.class), Type.from(Class.class), Type.INT}, 0, 1, null, null);
        if (bootstraps.size() != 1) {
            throw new AssertionError();
        }
        ConstantPool.C_Method ref = this.mConstants.addMethod(bootstraps.iterator().next());
        ConstantPool.C_MethodHandle bootHandle = this.mConstants.addMethodHandle(6, ref);
        boolean shared = !"<clinit>".equals(this.name());
        int slot = this.mClassMaker.addExactConstant(value, shared);
        if (!shared) {
            slot |= Integer.MIN_VALUE;
        }
        ConstantPool.Constant[] bootArgs = new ConstantPool.Constant[]{this.addLoadableConstant(Type.INT, slot)};
        int bi = this.mClassMaker.addBootstrapMethod(bootHandle, bootArgs);
        return this.mConstants.addDynamicConstant(bi, "_", type);
    }

    private void addExplicitConstantOp(ConstantPool.Constant constant, Type type) {
        this.addExplicitConstantOp(new ExplicitConstantOp(constant, type));
    }

    private void addExplicitConstantOp(ExplicitConstantOp op) {
        if (CONDY_WORKAROUND && op.mConstant instanceof ConstantPool.C_Dynamic && this.mHasBranches && !"<clinit>".equals(this.name())) {
            ConstantPool.C_Field field;
            if (this.mClassMaker.mResolvedConstants == null) {
                this.mClassMaker.mResolvedConstants = new HashMap<ConstantPool.Constant, ConstantPool.C_Field>();
            }
            if ((field = this.mClassMaker.mResolvedConstants.get(op.mConstant)) == null) {
                TheFieldMaker fm = this.mClassMaker.addSyntheticField(op.mType, "$condy-");
                fm.private_().static_().final_();
                TheMethodMaker mm = this.mClassMaker.addClinit();
                mm.addOp(new ExplicitConstantOp(op.mConstant, op.mType));
                field = mm.field((String)fm.name()).mFieldRef;
                mm.addOp(new FieldOp(-77, 1, field));
                this.mClassMaker.mResolvedConstants.put(op.mConstant, field);
            }
            op.mResolved = field;
        }
        this.addOp(op);
    }

    ConstantPool.Constant addLoadableConstant(Type type, Object value) {
        ConstantPool.Constant c;
        block11: {
            Type retType;
            Type paramType;
            String name;
            String method;
            Type classType;
            block8: {
                block10: {
                    block12: {
                        block9: {
                            block7: {
                                c = this.mConstants.tryAddLoadableConstant(value);
                                if (c != null) {
                                    return c;
                                }
                                classType = Type.from(Class.class);
                                if (value != null) break block7;
                                name = method = "nullConstant";
                                retType = paramType = Type.from(Object.class);
                                break block8;
                            }
                            if (!(value instanceof Type)) break block9;
                            type = (Type)value;
                            if (type.isPrimitive()) break block10;
                            break block11;
                        }
                        if (!(value instanceof Class)) break block12;
                        Class clazz = (Class)value;
                        if (!clazz.isPrimitive()) break block11;
                        type = Type.from(clazz);
                        break block10;
                    }
                    if (!(value instanceof Enum)) break block11;
                    Enum e = (Enum)value;
                    method = "enumConstant";
                    name = e.name();
                    retType = Type.from(Enum.class);
                    paramType = Type.from(value.getClass());
                    break block8;
                }
                method = "primitiveClass";
                name = type.descriptor();
                retType = paramType = classType;
            }
            Type[] bootParams = new Type[]{Type.from(MethodHandles.Lookup.class), Type.from(String.class), classType};
            ConstantPool.C_Method ref = this.mConstants.addMethod(Type.from(ConstantBootstraps.class).inventMethod(8, retType, method, bootParams));
            ConstantPool.C_MethodHandle bootHandle = this.mConstants.addMethodHandle(6, ref);
            return this.mConstants.addDynamicConstant(this.mClassMaker.addBootstrapMethod(bootHandle, new ConstantPool.Constant[0]), name, paramType);
        }
        if (value instanceof Variable) {
            ConstantVar cv;
            if (value instanceof ConstantVar && (c = (cv = (ConstantVar)value).tryObtain(this)) != null) {
                return c;
            }
            throw TheMethodMaker.unsupportedConstant(value);
        }
        if (!this.mClassMaker.allowExactConstants() || ConstableSupport.isConstantDesc(value)) {
            ConstantVar cv = ConstableSupport.toConstantVar(this, value);
            if (cv != null) {
                return cv.mConstant;
            }
            if (!this.mClassMaker.allowExactConstants()) {
                throw TheMethodMaker.unsupportedConstant(value);
            }
        }
        if (type == null) {
            type = Type.from(value.getClass());
        }
        return this.addExactConstant(type, value);
    }

    private static IllegalArgumentException unsupportedConstant(Object value) {
        return new IllegalArgumentException("Unsupported constant type: " + (Serializable)(value == null ? "null" : value.getClass()));
    }

    private void addStoreOp(LocalVar var) {
        this.addOp(new StoreVarOp(var));
    }

    private LocalVar storeToNewVar(Type type) {
        LocalVar var = new LocalVar(type);
        this.addStoreOp(var);
        return var;
    }

    private LocalVar addMathOp(String name, byte op, OwnedVar var, Object value) {
        Type varType = var.type();
        Type primType = varType.unbox();
        if (primType == null) {
            throw new IllegalStateException("Cannot '" + name + "' to a non-numeric type");
        }
        if (op != 116 && value == null) {
            throw new IllegalArgumentException("Cannot '" + name + "' by null");
        }
        byte castOp = 0;
        switch (primType.typeCode()) {
            case 3: {
                castOp = -111;
                break;
            }
            case 4: {
                castOp = -110;
                break;
            }
            case 5: {
                castOp = -109;
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                op = (byte)(op + 1);
                break;
            }
            case 7: {
                op = (byte)(op + 2);
                break;
            }
            case 9: {
                op = (byte)(op + 3);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot '" + name + "' to a non-numeric type");
            }
        }
        this.addPushOp(primType, var);
        int stackPop = 0;
        if (value != null) {
            this.addPushOp(primType, value);
            stackPop = 1;
        }
        this.addBytecodeOp(op, stackPop);
        if (castOp != 0) {
            this.addBytecodeOp(castOp, 0);
        }
        this.addConversionOp(primType, varType);
        return this.storeToNewVar(varType);
    }

    private LocalVar addLogicalOp(String name, byte op, OwnedVar var, Object value) {
        Type varType = var.type();
        Type primType = varType.unbox();
        if (primType == null) {
            throw new IllegalStateException("Cannot '" + name + "' to a non-numeric type");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot '" + name + "' by null");
        }
        byte castOp = 0;
        int mask = 0;
        block0 : switch (primType.typeCode()) {
            case 3: {
                castOp = -111;
                if (op != 124) break;
                mask = 255;
                break;
            }
            case 4: {
                castOp = -110;
                break;
            }
            case 5: {
                castOp = -109;
                if (op != 124) break;
                mask = 65535;
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                op = (byte)(op + 1);
                break;
            }
            case 7: 
            case 9: {
                throw new IllegalStateException("Cannot '" + name + "' to a non-integer type");
            }
            case 2: {
                switch (op) {
                    case -128: 
                    case -126: 
                    case 126: {
                        break block0;
                    }
                }
            }
            default: {
                throw new IllegalStateException("Cannot '" + name + "' to a non-numeric type");
            }
        }
        this.addPushOp(primType, var);
        if (mask != 0) {
            this.addPushOp(Type.INT, mask);
            this.addBytecodeOp((byte)126, 1);
        }
        if ((op & 0xFF) < 126) {
            this.addPushOp(Type.INT, value);
        } else {
            this.addPushOp(primType, value);
        }
        this.addBytecodeOp(op, 1);
        if (castOp != 0) {
            this.addBytecodeOp(castOp, 0);
        }
        this.addConversionOp(primType, varType);
        return this.storeToNewVar(varType);
    }

    private void addBranchOp(byte op, int stackPop, Label label) {
        this.addOp(new BranchOp(op, stackPop, this.target(label)));
    }

    private Lab target(Label label) {
        Lab lab;
        if (label instanceof Lab && (lab = (Lab)label).methodMaker() == this) {
            return lab;
        }
        if (label == null) {
            throw new IllegalArgumentException("Label is null");
        }
        throw new IllegalStateException("Unknown label");
    }

    private static void sortSwitchCases(int[] cases, Label[] labels) {
        TheMethodMaker.sortSwitchCases(cases, labels, 0, cases.length - 1);
    }

    private static void sortSwitchCases(int[] cases, Label[] labels, int low, int high) {
        if (low < high) {
            TheMethodMaker.swapSwitchCases(cases, labels, low, (low + high) / 2);
            int last = low;
            for (int i = low + 1; i <= high; ++i) {
                if (cases[i] >= cases[low]) continue;
                TheMethodMaker.swapSwitchCases(cases, labels, ++last, i);
            }
            TheMethodMaker.swapSwitchCases(cases, labels, low, last);
            TheMethodMaker.sortSwitchCases(cases, labels, low, last - 1);
            TheMethodMaker.sortSwitchCases(cases, labels, last + 1, high);
        }
    }

    private static void swapSwitchCases(int[] cases, Label[] labels, int i, int j) {
        int tempInt = cases[i];
        cases[i] = cases[j];
        cases[j] = tempInt;
        Label tempLabel = labels[i];
        labels[i] = labels[j];
        labels[j] = tempLabel;
    }

    private void addSwitchOp(Lab defaultLabel, int[] cases, Lab[] labels) {
        long tSize = 12L + 4L * ((long)cases[cases.length - 1] - (long)cases[0] + 1L);
        long lSize = 8L + 8L * (long)cases.length;
        byte op = tSize <= lSize ? (byte)-86 : -85;
        this.addOp(new SwitchOp(op, defaultLabel, cases, labels));
    }

    private static boolean isHidden(Class clazz) {
        return clazz != null && clazz.isHidden();
    }

    class Lab
    extends Op
    implements Label {
        int mAddress = -1;
        private int mUsedCount;
        private int[] mTrackOffsets;
        private BranchOp[] mTrackBranches;
        private int mTrackCount;
        private BitSet mVarUsage;

        Lab() {
        }

        @Override
        void reset() {
            super.reset();
            this.mAddress = -1;
            this.mTrackBranches = null;
            this.mTrackCount = 0;
            this.mVarUsage = null;
        }

        @Override
        public Label here() {
            if (this.isPositioned()) {
                throw new IllegalStateException();
            }
            TheMethodMaker.this.addOp(this);
            return this;
        }

        @Override
        public Label goto_() {
            TheMethodMaker.this.goto_(this);
            return this;
        }

        @Override
        public MethodMaker methodMaker() {
            return TheMethodMaker.this;
        }

        boolean isPositioned() {
            return this.mNext != null || TheMethodMaker.this.mLastOp == this;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            this.mAddress = m.mCodeLen;
            if (this.isTarget()) {
                int[] localCodes;
                LocalVar[] vars = m.mVars;
                BitSet usage = this.mVarUsage;
                int numCodes = 0;
                int i = vars.length;
                while (--i >= 0) {
                    LocalVar var = vars[i];
                    int slot = var.mSlot;
                    if (!usage.get(slot)) continue;
                    if (numCodes <= 0) {
                        numCodes = slot + 1;
                        continue;
                    }
                    numCodes -= var.slotWidth() - 1;
                }
                if (numCodes <= 0) {
                    localCodes = null;
                } else {
                    localCodes = new int[numCodes];
                    int adjust = 0;
                    for (LocalVar var : vars) {
                        int slot = var.mSlot;
                        int codeSlot = slot + adjust;
                        if (codeSlot >= localCodes.length) break;
                        if (!usage.get(slot)) continue;
                        localCodes[codeSlot] = var.smCode();
                        adjust -= var.slotWidth() - 1;
                    }
                }
                int[] stackCodes = this.stackCodes(m);
                m.mStackMapTable.add(this.mAddress, localCodes, stackCodes);
            }
            if (this.mTrackOffsets != null && this.mTrackCount != 0) {
                byte[] code = m.mCode;
                for (int i = 0; i < this.mTrackCount; ++i) {
                    int offset = this.mTrackOffsets[i];
                    if (offset >= 0) {
                        int srcAddr = BytesOut.cShortArrayHandle.get(code, offset) & 0xFFFF;
                        int branchAmount = this.mAddress - srcAddr;
                        if (branchAmount <= Short.MAX_VALUE) {
                            BytesOut.cShortArrayHandle.set(code, offset, (short)branchAmount);
                            continue;
                        }
                        this.mTrackBranches[i].makeWide(m);
                        continue;
                    }
                    int branchAmount = this.mAddress - BytesOut.cIntArrayHandle.get(code, offset ^= 0xFFFFFFFF);
                    BytesOut.cIntArrayHandle.set(code, offset, branchAmount);
                }
                --m.mUnpositionedLabels;
                this.mTrackCount = 0;
            }
        }

        @Override
        Op flow(Flow flow, Op prev) {
            this.mVarUsage = (BitSet)flow.mVarUsage.clone();
            return this.mNext;
        }

        @Override
        Op revisit(Flow flow, Op prev) {
            if (this.mVarUsage != null) {
                if (this.mVarUsage.equals(flow.mVarUsage)) {
                    return null;
                }
                flow.mVarUsage.and(this.mVarUsage);
                if (this.mVarUsage.equals(flow.mVarUsage)) {
                    return null;
                }
            }
            this.mVarUsage = (BitSet)flow.mVarUsage.clone();
            return this.mNext;
        }

        void targeted() {
            ++this.mUsedCount;
            if (this.mTrackOffsets == null) {
                this.mTrackOffsets = new int[4];
                TheMethodMaker.this.mHasBranches = true;
            }
        }

        void handler() {
            this.mUsedCount |= Integer.MIN_VALUE;
        }

        boolean lessUsed() {
            int uc = this.mUsedCount;
            int count = uc & Integer.MAX_VALUE;
            if (count != 0) {
                if (--count == 0) {
                    this.mTrackOffsets = null;
                }
                this.mUsedCount = uc = uc & Integer.MIN_VALUE | count;
            }
            return uc == 0;
        }

        boolean isTarget() {
            return (this.mUsedCount & Integer.MAX_VALUE) != 0;
        }

        void comesFrom(BranchOp branch, TheMethodMaker m) {
            int srcAddr = m.mCodeLen - 1;
            if (this.mAddress >= 0) {
                int distance = this.mAddress - srcAddr;
                if (distance >= Short.MIN_VALUE) {
                    m.appendShort(distance);
                } else {
                    byte op = m.mCode[srcAddr];
                    if (op == -89) {
                        m.mCode[srcAddr] = -56;
                        m.appendInt(distance);
                    } else {
                        branch.makeWide(m);
                    }
                }
                return;
            }
            int offset = m.mCodeLen;
            m.appendShort(srcAddr);
            this.addTrackOffset(m, offset);
            if (this.mTrackBranches == null) {
                this.mTrackBranches = new BranchOp[this.mTrackOffsets.length];
            }
            if (this.mTrackBranches.length < this.mTrackOffsets.length) {
                this.mTrackBranches = Arrays.copyOf(this.mTrackBranches, this.mTrackOffsets.length);
            }
            this.mTrackBranches[this.mTrackCount - 1] = branch;
        }

        private void addTrackOffset(TheMethodMaker m, int offset) {
            if (this.mTrackCount == 0) {
                ++m.mUnpositionedLabels;
            } else if (this.mTrackCount >= this.mTrackOffsets.length) {
                this.mTrackOffsets = Arrays.copyOf(this.mTrackOffsets, this.mTrackOffsets.length << 1);
            }
            this.mTrackOffsets[this.mTrackCount++] = offset;
        }

        void comesFromWide(TheMethodMaker m, int srcAddr) {
            if (this.mAddress >= 0) {
                m.appendInt(this.mAddress - srcAddr);
                return;
            }
            int offset = m.mCodeLen;
            m.appendInt(srcAddr);
            this.addTrackOffset(m, ~offset);
        }

        int[] stackCodes(TheMethodMaker m) {
            if (m.mStackSize == 0) {
                return null;
            }
            int[] codes = new int[m.mStackSize];
            for (int i = 0; i < codes.length; ++i) {
                codes[i] = m.mStack[i].smCode();
            }
            return codes;
        }
    }

    static abstract class Op {
        Op mNext;
        boolean mVisited;

        Op() {
        }

        abstract void appendTo(TheMethodMaker var1);

        void reset() {
            this.mVisited = false;
        }

        Op flow(Flow flow, Op prev) {
            return this.mNext;
        }

        Op revisit(Flow flow, Op prev) {
            return this.flow(flow, prev);
        }
    }

    class ParamVar
    extends LocalVar {
        private final int mIndex;

        ParamVar(Type type, int index) {
            super(type);
            this.mIndex = index;
        }

        @Override
        public LocalVar name(String name) {
            super.name(name);
            ParamVar thisVar = TheMethodMaker.this.mThisVar;
            if (this != thisVar) {
                Attribute.MethodParameters mparams = TheMethodMaker.this.mMethodParameters;
                if (mparams == null) {
                    int numParams = TheMethodMaker.this.mParams.length;
                    if (thisVar != null) {
                        --numParams;
                    }
                    TheMethodMaker.this.mMethodParameters = mparams = new Attribute.MethodParameters(TheMethodMaker.this.mConstants, numParams);
                    TheMethodMaker.this.addAttribute(mparams);
                }
                int index = this.mIndex;
                if (thisVar != null) {
                    --index;
                }
                mparams.setName(index, TheMethodMaker.this.mConstants.addUTF8(name));
            }
            return this;
        }

        @Override
        public AnnotationMaker addAnnotation(Object annotationType, boolean visible) {
            int which;
            Attribute.ParameterAnnotations annotations;
            ParamVar thisVar = TheMethodMaker.this.mThisVar;
            if (this == thisVar) {
                return super.addAnnotation(annotationType, visible);
            }
            Attribute.ParameterAnnotations[] set = TheMethodMaker.this.mParameterAnnotationsSet;
            if (set == null) {
                TheMethodMaker.this.mParameterAnnotationsSet = set = new Attribute.ParameterAnnotations[2];
            }
            if ((annotations = set[which = visible ? 0 : 1]) == null) {
                int numParams = TheMethodMaker.this.mParams.length;
                if (thisVar != null) {
                    --numParams;
                }
                set[which] = annotations = new Attribute.ParameterAnnotations(TheMethodMaker.this.mConstants, visible, numParams);
                TheMethodMaker.this.addAttribute(annotations);
            }
            int index = this.mIndex;
            if (thisVar != null) {
                --index;
            }
            TheAnnotationMaker maker = new TheAnnotationMaker(TheMethodMaker.this.mClassMaker, annotationType);
            annotations.forParam(index).add(maker);
            return maker;
        }
    }

    class LocalVar
    extends OwnedVar
    implements Variable,
    Comparable<LocalVar> {
        final Type mType;
        int mSlot;
        int mPushCount;
        private String mName;

        LocalVar(Type type) {
            this.mSlot = -1;
            Objects.requireNonNull(type);
            this.mType = type;
        }

        @Override
        public int compareTo(LocalVar other) {
            return Integer.compare(this.mSlot, other.mSlot);
        }

        int slotWidth() {
            return switch (this.mType.typeCode()) {
                default -> 1;
                case 8, 9 -> 2;
            };
        }

        int smCode() {
            int code = this.mType.stackMapCode();
            if (code == 7) {
                code |= TheMethodMaker.this.mConstants.addClass((Type)this.mType.nonHiddenBase()).mIndex << 8;
            }
            return code;
        }

        @Override
        public Type type() {
            return this.mType;
        }

        @Override
        void push() {
            TheMethodMaker.this.addOp(new PushVarOp(this));
        }

        @Override
        void adjustPushCount(int amt) {
            this.mPushCount += amt;
        }

        @Override
        public String name() {
            return this.mName;
        }

        @Override
        public LocalVar name(String name) {
            Objects.requireNonNull(name);
            if (this.mName != null) {
                throw new IllegalStateException("Already named");
            }
            TheMethodMaker.this.addOp(new NameLocalVarOp(this));
            this.mName = name;
            return this;
        }

        @Override
        public Variable signature(Object ... components) {
            TheMethodMaker.this.addOp(new SignatureLocalVarOp(this, Attributed.fullSignature(components)));
            return this;
        }

        @Override
        public LocalVar set(Object value) {
            TheMethodMaker.this.addPushOp(this.mType, value);
            TheMethodMaker.this.addStoreOp(this);
            return this;
        }

        @Override
        void addStoreConstantOp(ExplicitConstantOp op) {
            TheMethodMaker.this.addExplicitConstantOp(op);
            TheMethodMaker.this.addStoreOp(this);
        }

        @Override
        public void inc(Object value) {
            long amount;
            if (this.mType == Type.INT && (value instanceof Long || value instanceof Integer || value instanceof Byte || value instanceof Short) && -32768L <= (amount = ((Number)value).longValue()) && amount < 32768L) {
                TheMethodMaker.this.addOp(new IncOp(this, (int)amount));
                return;
            }
            this.set(this.add(value));
        }

        @Override
        public BaseFieldVar field(String name) {
            return TheMethodMaker.this.field(this, name);
        }
    }

    final class Flow {
        final List<LocalVar> mVarList;
        final int mMinVars;
        BitSet mVarUsage;
        int mOpCount;
        private Op mRemoved;
        private int mDepth;
        private Overflow mOverflow;

        Flow(List<LocalVar> varList, BitSet varUsage) {
            this.mVarList = varList;
            this.mMinVars = varList.size();
            this.mVarUsage = varUsage;
        }

        void run(Op op) {
            BitSet original = (BitSet)this.mVarUsage.clone();
            if (this.mDepth >= 100) {
                this.mOverflow = new Overflow(this.mOverflow, op, original);
                return;
            }
            while (true) {
                ++this.mDepth;
                Op prev = null;
                while (true) {
                    Op next;
                    if (!op.mVisited) {
                        op.mVisited = true;
                        ++this.mOpCount;
                        next = op.flow(this, prev);
                    } else {
                        next = op.revisit(this, prev);
                    }
                    if (next == null) break;
                    if (next instanceof HandlerLab) {
                        throw new IllegalStateException("Code flows into an exception handler");
                    }
                    if (this.mRemoved == op) {
                        this.mRemoved = null;
                    } else {
                        prev = op;
                    }
                    op = next;
                }
                if (--this.mDepth > 0 || this.mOverflow == null) break;
                op = this.mOverflow.mOp;
                this.mVarUsage = this.mOverflow.mVarUsage;
                this.mOverflow = this.mOverflow.mPrev;
            }
            this.mVarUsage = original;
        }

        void removeOps(Op prev, Op op, Op next, int amt) {
            this.mRemoved = op;
            TheMethodMaker.this.removeOps(prev, next);
            this.mOpCount -= amt;
        }

        Op nextOpFor(Op op) {
            return op == null ? TheMethodMaker.this.mFirstOp : op.mNext;
        }

        Op lastOp() {
            return TheMethodMaker.this.mLastOp;
        }

        void addOps(Op op, Op last) {
            TheMethodMaker.this.addOps(op, last);
        }

        int nextSlot() {
            List<LocalVar> vars = this.mVarList;
            if (vars.isEmpty()) {
                return 0;
            }
            LocalVar last = vars.get(vars.size() - 1);
            return last.mSlot + last.slotWidth();
        }
    }

    private static final class Handler
    implements ExceptionHandler {
        final Lab mStartLab;
        final Lab mEndLab;
        final HandlerLab mHandlerLab;
        ConstantPool.C_Class mCatchClass;

        Handler(Lab start, Lab end, HandlerLab handler, ConstantPool.C_Class catchClass) {
            this.mStartLab = start;
            this.mEndLab = end;
            this.mHandlerLab = handler;
            this.mCatchClass = catchClass;
            start.handler();
            end.handler();
            handler.handler();
        }

        Handler(Handler h, ConstantPool.C_Class catchClass) {
            this.mStartLab = h.mStartLab;
            this.mEndLab = h.mEndLab;
            this.mHandlerLab = h.mHandlerLab;
            this.mCatchClass = catchClass;
        }

        @Override
        public int startAddr() {
            return this.mStartLab.mAddress;
        }

        @Override
        public int endAddr() {
            return this.mEndLab.mAddress;
        }

        @Override
        public int handlerAddr() {
            return this.mHandlerLab.mAddress;
        }

        @Override
        public ConstantPool.C_Class catchClass() {
            return this.mCatchClass;
        }
    }

    class HandlerLab
    extends Lab {
        private final Type mCatchType;
        private final int mSmCatchCode;

        HandlerLab(Type catchType, int smCatchCode) {
            this.mCatchType = catchType;
            this.mSmCatchCode = smCatchCode;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            super.appendTo(m);
            m.stackPush(this.mCatchType);
        }

        @Override
        boolean isTarget() {
            return this.mVisited;
        }

        @Override
        int[] stackCodes(TheMethodMaker m) {
            return new int[]{this.mSmCatchCode};
        }
    }

    final class InitThisVar
    extends ParamVar {
        private int mSmCode;

        InitThisVar(Type type) {
            super(type, 0);
            this.mSmCode = 6;
        }

        @Override
        int smCode() {
            return this.mSmCode;
        }

        void ready() {
            if (this.mSmCode != 6) {
                throw new IllegalStateException("Super or this constructor invoked multiple times");
            }
            this.mSmCode = super.smCode();
        }
    }

    static class BytecodeOp
    extends Op {
        int mCode;

        BytecodeOp(byte op, int stackPop) {
            this.mCode = stackPop << 8 | op & 0xFF;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            m.appendOp(this.op(), this.stackPop());
        }

        final byte op() {
            return (byte)this.mCode;
        }

        final int stackPop() {
            return this.mCode >>> 8;
        }

        @Override
        Op flow(Flow flow, Op prev) {
            byte op = this.op();
            if (op == -65) {
                return null;
            }
            return this.mNext;
        }
    }

    static class ReturnOp
    extends BytecodeOp {
        ReturnOp(byte op, int stackPop) {
            super(op, stackPop);
        }

        @Override
        Op flow(Flow flow, Op prev) {
            return null;
        }
    }

    final class ClassVar
    extends ConstantVar {
        ClassVar(Type type) {
            super(type, TheMethodMaker.this.mClassMaker.mThisClass);
        }

        @Override
        public LocalVar name(String name) {
            throw new IllegalStateException("Already named");
        }
    }

    final class SuperVar
    extends OwnedVar {
        SuperVar() {
        }

        @Override
        public Type type() {
            return TheMethodMaker.this.mClassMaker.superType();
        }

        @Override
        void push() {
            TheMethodMaker.this.this_().push();
        }

        @Override
        void adjustPushCount(int amt) {
            TheMethodMaker.this.this_().adjustPushCount(amt);
        }

        @Override
        public String name() {
            return null;
        }

        @Override
        public LocalVar name(String name) {
            throw new IllegalStateException("Already named");
        }

        @Override
        public Variable signature(Object ... components) {
            throw new IllegalStateException("Cannot define a signature");
        }

        @Override
        public LocalVar set(Object value) {
            throw new IllegalStateException("Unmodifiable variable");
        }

        @Override
        void addStoreConstantOp(ExplicitConstantOp op) {
            throw new IllegalStateException("Unmodifiable variable");
        }

        @Override
        public void inc(Object value) {
            throw new IllegalStateException("Unmodifiable variable");
        }

        @Override
        public FieldVar field(String name) {
            return TheMethodMaker.this.field(this.type(), name);
        }

        @Override
        Type invocationType() {
            return TheMethodMaker.this.mClassMaker.type();
        }

        @Override
        OwnedVar invocationInstance() {
            return TheMethodMaker.this.tryThis();
        }

        @Override
        int inherit() {
            return 1;
        }
    }

    static final class LineNumOp
    extends Op {
        final int mNum;

        LineNumOp(int num) {
            this.mNum = num;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            Attribute.LineNumberTable table = m.mLineNumberTable;
            if (table == null) {
                m.mLineNumberTable = table = new Attribute.LineNumberTable(m.mConstants);
            }
            table.add(m.mCodeLen, this.mNum);
        }
    }

    static final class BranchOp
    extends BytecodeOp {
        Lab mTarget;

        BranchOp(byte op, int stackPop, Lab target) {
            super(op, stackPop);
            this.mTarget = target;
            target.targeted();
        }

        @Override
        void appendTo(TheMethodMaker m) {
            byte op = this.op();
            if (op == -56) {
                int srcAddr = m.mCodeLen;
                m.appendByte(-56);
                this.mTarget.comesFromWide(m, srcAddr);
            } else {
                m.appendOp(op, this.stackPop());
                this.mTarget.comesFrom(this, m);
            }
        }

        @Override
        Op flow(Flow flow, Op prev) {
            Op next;
            Lab target;
            while (true) {
                BranchOp nextBranch;
                target = this.mTarget;
                next = this.mNext;
                byte op = this.op();
                if (op == -89 || op == -56) {
                    if (target == next) {
                        flow.removeOps(prev, this, next, 1);
                        target.lessUsed();
                    }
                    return target;
                }
                if (!(next instanceof BranchOp) || (nextBranch = (BranchOp)next).op() != -89 || next.mNext != target) break;
                Op newNext = target;
                int amtRemoved = 1;
                if (target.lessUsed()) {
                    newNext = target.mNext;
                    ++amtRemoved;
                }
                this.flip(op);
                this.mTarget = nextBranch.mTarget;
                flow.removeOps(this, null, newNext, amtRemoved);
            }
            flow.run(target);
            return next;
        }

        void makeWide(TheMethodMaker m) {
            byte op = this.op();
            if (op == -89) {
                this.mCode = -56;
            } else {
                this.flip(op);
                Op cont = this.mNext;
                this.mNext = new BranchOp(-56, 0, this.mTarget);
                this.mTarget = m.new Lab();
                this.mTarget.targeted();
                this.mNext.mNext = this.mTarget;
                this.mTarget.mNext = cont;
            }
            m.mFinished = -1;
        }

        private void flip(byte op) {
            this.mCode = this.stackPop() << 8 | TheMethodMaker.flipIf(op) & 0xFF;
        }
    }

    final class FieldVar
    extends BaseFieldVar {
        final LocalVar mInstance;
        final ConstantPool.C_Field mFieldRef;
        private ConstantPool.C_Dynamic mVarHandle;

        private FieldVar(LocalVar instance, ConstantPool.C_Field fieldRef) {
            this.mInstance = instance;
            this.mFieldRef = fieldRef;
        }

        BaseFieldVar access() {
            return !TheMethodMaker.isHidden(this.enclosingClass()) ? this : this.toHandleVar();
        }

        private Class enclosingClass() {
            return this.mFieldRef.mField.enclosingType().clazz();
        }

        private HandleVar toHandleVar() {
            Object[] coordinates;
            Type[] coordinateTypes;
            if (this.mInstance == null) {
                coordinateTypes = new Type[]{};
                coordinates = Type.NO_ARGS;
            } else {
                coordinateTypes = new Type[]{Type.from(Object.class)};
                coordinates = new Object[]{this.mInstance};
            }
            return new HandleVar(this.varHandle(), this.type(), coordinateTypes, coordinates);
        }

        @Override
        public Type type() {
            return this.mFieldRef.mField.type();
        }

        @Override
        public String name() {
            return this.mFieldRef.mField.name();
        }

        @Override
        public BaseFieldVar set(Object value) {
            this.addBeginStoreFieldOp();
            TheMethodMaker.this.addPushOp(this.type(), value);
            this.addFinishStoreFieldOp();
            return this;
        }

        @Override
        public ConstantVar varHandle() {
            Type vhType = Type.from(VarHandle.class);
            return new ConstantVar(vhType, this.vh(vhType));
        }

        @Override
        public ConstantVar methodHandleSet() {
            int kind = this.mInstance == null ? 4 : 3;
            return new ConstantVar(Type.from(MethodHandle.class), TheMethodMaker.this.mConstants.addMethodHandle(kind, this.mFieldRef));
        }

        @Override
        public ConstantVar methodHandleGet() {
            int kind = this.mInstance == null ? 2 : 1;
            return new ConstantVar(Type.from(MethodHandle.class), TheMethodMaker.this.mConstants.addMethodHandle(kind, this.mFieldRef));
        }

        @Override
        void push() {
            int stackPop;
            byte op;
            ConstantPool.C_Field fieldRef = this.mFieldRef;
            Type.Field field = fieldRef.mField;
            if (this.mInstance == null) {
                op = -78;
                stackPop = 0;
            } else {
                TheMethodMaker.this.addPushOp(null, this.mInstance);
                op = -76;
                stackPop = 1;
            }
            TheMethodMaker.this.addOp(new FieldOp(op, stackPop, fieldRef));
        }

        @Override
        void adjustPushCount(int amt) {
            if (this.mInstance != null) {
                this.mInstance.adjustPushCount(amt);
            }
        }

        @Override
        void addStoreConstantOp(ExplicitConstantOp op) {
            this.addBeginStoreFieldOp();
            TheMethodMaker.this.addExplicitConstantOp(op);
            this.addFinishStoreFieldOp();
        }

        private void addBeginStoreFieldOp() {
            if (this.mInstance != null) {
                TheMethodMaker.this.addPushOp(null, this.mInstance);
            }
        }

        private void addFinishStoreFieldOp() {
            int stackPop;
            byte op;
            ConstantPool.C_Field fieldRef = this.mFieldRef;
            Type.Field field = fieldRef.mField;
            if (this.mInstance == null) {
                op = -77;
                stackPop = 1;
            } else {
                op = -75;
                stackPop = 2;
            }
            TheMethodMaker.this.addOp(new FieldOp(op, stackPop, fieldRef));
        }

        @Override
        LocalVar vhGet(String name) {
            Type.Method method;
            int stackPop;
            Type thisType = this.type();
            Type vhType = this.pushVarHandle();
            if (this.mInstance == null) {
                stackPop = 1;
                method = vhType.inventMethod(0, thisType, name, new Type[0]);
            } else {
                stackPop = 2;
                TheMethodMaker.this.addOp(new PushVarOp(this.mInstance));
                method = vhType.inventMethod(0, thisType, name, this.mInstance.type());
            }
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(method);
            TheMethodMaker.this.addOp(new InvokeOp(-74, stackPop, ref));
            return TheMethodMaker.this.storeToNewVar(thisType);
        }

        @Override
        void vhSet(String name, Object value) {
            Type.Method method;
            int stackPop;
            Type thisType = this.type();
            Type vhType = this.pushVarHandle();
            if (this.mInstance == null) {
                stackPop = 2;
                TheMethodMaker.this.addPushOp(thisType, value);
                method = vhType.inventMethod(0, Type.VOID, name, thisType);
            } else {
                stackPop = 3;
                TheMethodMaker.this.addOp(new PushVarOp(this.mInstance));
                TheMethodMaker.this.addPushOp(thisType, value);
                method = vhType.inventMethod(0, Type.VOID, name, this.mInstance.type(), thisType);
            }
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(method);
            TheMethodMaker.this.addOp(new InvokeOp(-74, stackPop, ref));
        }

        @Override
        LocalVar vhCas(String name, Type retType, Object expectedValue, Object newValue) {
            Type.Method method;
            int stackPop;
            Type thisType = this.type();
            Type vhType = this.pushVarHandle();
            if (retType == null) {
                retType = thisType;
            }
            if (this.mInstance == null) {
                stackPop = 3;
                TheMethodMaker.this.addPushOp(thisType, expectedValue);
                TheMethodMaker.this.addPushOp(thisType, newValue);
                method = vhType.inventMethod(0, retType, name, thisType, thisType);
            } else {
                stackPop = 4;
                TheMethodMaker.this.addOp(new PushVarOp(this.mInstance));
                TheMethodMaker.this.addPushOp(thisType, expectedValue);
                TheMethodMaker.this.addPushOp(thisType, newValue);
                method = vhType.inventMethod(0, retType, name, this.mInstance.type(), thisType, thisType);
            }
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(method);
            TheMethodMaker.this.addOp(new InvokeOp(-74, stackPop, ref));
            return TheMethodMaker.this.storeToNewVar(retType);
        }

        @Override
        LocalVar vhGas(String name, Object value) {
            Type.Method method;
            int stackPop;
            Type thisType = this.type();
            Type vhType = this.pushVarHandle();
            if (this.mInstance == null) {
                stackPop = 2;
                TheMethodMaker.this.addPushOp(thisType, value);
                method = vhType.inventMethod(0, thisType, name, thisType);
            } else {
                stackPop = 3;
                TheMethodMaker.this.addOp(new PushVarOp(this.mInstance));
                TheMethodMaker.this.addPushOp(thisType, value);
                method = vhType.inventMethod(0, thisType, name, this.mInstance.type(), thisType);
            }
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(method);
            TheMethodMaker.this.addOp(new InvokeOp(-74, stackPop, ref));
            return TheMethodMaker.this.storeToNewVar(thisType);
        }

        private Type pushVarHandle() {
            Type vhType = Type.from(VarHandle.class);
            TheMethodMaker.this.addExplicitConstantOp(this.vh(vhType), vhType);
            return vhType;
        }

        private ConstantPool.C_Dynamic vh(Type vhType) {
            if (this.mVarHandle == null) {
                Type classType = Type.from(Class.class);
                Type[] bootParams = new Type[]{Type.from(MethodHandles.Lookup.class), Type.from(String.class), classType, classType, classType};
                String bootName = this.mInstance == null ? "staticFieldVarHandle" : "fieldVarHandle";
                ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(Type.from(ConstantBootstraps.class).inventMethod(8, vhType, bootName, bootParams));
                ConstantPool.C_MethodHandle bootHandle = TheMethodMaker.this.mConstants.addMethodHandle(6, ref);
                Class enclosingClass = this.enclosingClass();
                ConstantPool.Constant enclosingClassConstant = !TheMethodMaker.isHidden(enclosingClass) ? this.mFieldRef.mClass : TheMethodMaker.this.addLoadableConstant(classType, enclosingClass);
                ConstantPool.Constant[] bootArgs = new ConstantPool.Constant[]{enclosingClassConstant, TheMethodMaker.this.addLoadableConstant(null, this.mFieldRef.mField.type())};
                this.mVarHandle = TheMethodMaker.this.mConstants.addDynamicConstant(TheMethodMaker.this.mClassMaker.addBootstrapMethod(bootHandle, bootArgs), this.mFieldRef.mNameAndType.mName, vhType);
            }
            return this.mVarHandle;
        }
    }

    abstract class BaseFieldVar
    extends OwnedVar
    implements Field {
        BaseFieldVar() {
        }

        @Override
        public void inc(Object value) {
            this.set(this.add(value));
        }

        @Override
        public Field field(String name) {
            return this.get().field(name);
        }

        @Override
        public void synchronized_(Runnable body) {
            this.get().synchronized_(body);
        }

        @Override
        public LocalVar getPlain() {
            return this.vhGet("get");
        }

        @Override
        public void setPlain(Object value) {
            this.vhSet("set", value);
        }

        @Override
        public LocalVar getOpaque() {
            return this.vhGet("getOpaque");
        }

        @Override
        public void setOpaque(Object value) {
            this.vhSet("setOpaque", value);
        }

        @Override
        public LocalVar getAcquire() {
            return this.vhGet("getAcquire");
        }

        @Override
        public void setRelease(Object value) {
            this.vhSet("setRelease", value);
        }

        @Override
        public LocalVar getVolatile() {
            return this.vhGet("getVolatile");
        }

        @Override
        public void setVolatile(Object value) {
            this.vhSet("setVolatile", value);
        }

        @Override
        public Variable compareAndSet(Object expectedValue, Object newValue) {
            return this.vhCas("compareAndSet", Type.BOOLEAN, expectedValue, newValue);
        }

        @Override
        public Variable compareAndExchange(Object expectedValue, Object newValue) {
            return this.vhCas("compareAndExchange", null, expectedValue, newValue);
        }

        @Override
        public Variable compareAndExchangeAcquire(Object expectedValue, Object newValue) {
            return this.vhCas("compareAndExchangeAcquire", null, expectedValue, newValue);
        }

        @Override
        public Variable compareAndExchangeRelease(Object expectedValue, Object newValue) {
            return this.vhCas("compareAndExchangeRelease", null, expectedValue, newValue);
        }

        @Override
        public Variable weakCompareAndSetPlain(Object expectedValue, Object newValue) {
            return this.vhCas("weakCompareAndSetPlain", Type.BOOLEAN, expectedValue, newValue);
        }

        @Override
        public Variable weakCompareAndSet(Object expectedValue, Object newValue) {
            return this.vhCas("weakCompareAndSet", Type.BOOLEAN, expectedValue, newValue);
        }

        @Override
        public Variable weakCompareAndSetAcquire(Object expectedValue, Object newValue) {
            return this.vhCas("weakCompareAndSetAcquire", Type.BOOLEAN, expectedValue, newValue);
        }

        @Override
        public Variable weakCompareAndSetRelease(Object expectedValue, Object newValue) {
            return this.vhCas("weakCompareAndSetRelease", Type.BOOLEAN, expectedValue, newValue);
        }

        @Override
        public Variable getAndSet(Object value) {
            return this.vhGas("getAndSet", value);
        }

        @Override
        public Variable getAndSetAcquire(Object value) {
            return this.vhGas("getAndSetAcquire", value);
        }

        @Override
        public Variable getAndSetRelease(Object value) {
            return this.vhGas("getAndSetRelease", value);
        }

        @Override
        public Variable getAndAdd(Object value) {
            return this.vhGas("getAndAdd", value);
        }

        @Override
        public Variable getAndAddAcquire(Object value) {
            return this.vhGas("getAndAddAcquire", value);
        }

        @Override
        public Variable getAndAddRelease(Object value) {
            return this.vhGas("getAndAddRelease", value);
        }

        @Override
        public Variable getAndBitwiseOr(Object value) {
            return this.vhGas("getAndBitwiseOr", value);
        }

        @Override
        public Variable getAndBitwiseOrAcquire(Object value) {
            return this.vhGas("getAndBitwiseOrAcquire", value);
        }

        @Override
        public Variable getAndBitwiseOrRelease(Object value) {
            return this.vhGas("getAndBitwiseOrRelease", value);
        }

        @Override
        public Variable getAndBitwiseAnd(Object value) {
            return this.vhGas("getAndBitwiseAnd", value);
        }

        @Override
        public Variable getAndBitwiseAndAcquire(Object value) {
            return this.vhGas("getAndBitwiseAndAcquire", value);
        }

        @Override
        public Variable getAndBitwiseAndRelease(Object value) {
            return this.vhGas("getAndBitwiseAndRelease", value);
        }

        @Override
        public Variable getAndBitwiseXor(Object value) {
            return this.vhGas("getAndBitwiseXor", value);
        }

        @Override
        public Variable getAndBitwiseXorAcquire(Object value) {
            return this.vhGas("getAndBitwiseXorAcquire", value);
        }

        @Override
        public Variable getAndBitwiseXorRelease(Object value) {
            return this.vhGas("getAndBitwiseXorRelease", value);
        }

        abstract LocalVar vhGet(String var1);

        abstract void vhSet(String var1, Object var2);

        abstract LocalVar vhCas(String var1, Type var2, Object var3, Object var4);

        abstract LocalVar vhGas(String var1, Object var2);
    }

    abstract class OwnedVar
    implements Variable,
    Typed {
        OwnedVar() {
        }

        @Override
        public Class<?> classType() {
            return this.type().clazz();
        }

        @Override
        public ClassMaker makerType() {
            return this.type().maker();
        }

        @Override
        public AnnotationMaker addAnnotation(Object annotationType, boolean visible) {
            throw new IllegalStateException("Cannot add an annotation");
        }

        @Override
        public Variable clear() {
            Type type = this.type();
            if (type.isObject()) {
                this.set(null);
            } else if (type != Type.BOOLEAN) {
                this.set(0);
            } else {
                this.set(false);
            }
            return this;
        }

        boolean tryPushTo(TheMethodMaker mm) {
            if (TheMethodMaker.this == mm) {
                this.push();
                return true;
            }
            return false;
        }

        abstract void push();

        void push(Type type) {
            Op savepoint = TheMethodMaker.this.mLastOp;
            try {
                this.push();
                TheMethodMaker.this.addConversionOp(this.type(), type);
            }
            catch (Throwable e) {
                TheMethodMaker.this.rollback(savepoint);
                throw e;
            }
        }

        void pushObject() {
            this.push();
            Type type = this.type();
            if (type.isPrimitive()) {
                TheMethodMaker.this.addConversionOp(type, type.box());
            }
        }

        abstract void adjustPushCount(int var1);

        @Override
        public Variable setExact(Object value) {
            if (value == null) {
                return this.set(null);
            }
            Type type = this.type();
            if (!type.isAssignableFrom(Type.from(value.getClass()))) {
                throw new IllegalStateException("Mismatched type");
            }
            this.addStoreConstantOp(new ExplicitConstantOp(TheMethodMaker.this.addExactConstant(type, value), type));
            return this;
        }

        abstract void addStoreConstantOp(ExplicitConstantOp var1);

        @Override
        public LocalVar get() {
            this.push();
            return TheMethodMaker.this.storeToNewVar(this.type());
        }

        @Override
        public void ifTrue(Label label) {
            this.push(Type.BOOLEAN);
            TheMethodMaker.this.addBranchOp((byte)-102, 1, label);
        }

        @Override
        public void ifFalse(Label label) {
            this.push(Type.BOOLEAN);
            TheMethodMaker.this.addBranchOp((byte)-103, 1, label);
        }

        @Override
        public void ifEq(Object value, Label label) {
            if (value == null) {
                this.nullCompareCheck();
                this.push();
                TheMethodMaker.this.addBranchOp((byte)-58, 1, label);
            } else {
                this.ifRelational(value, label, true, (byte)-97, (byte)-103);
            }
        }

        @Override
        public void ifNe(Object value, Label label) {
            if (value == null) {
                this.nullCompareCheck();
                this.push();
                TheMethodMaker.this.addBranchOp((byte)-57, 1, label);
            } else {
                this.ifRelational(value, label, true, (byte)-96, (byte)-102);
            }
        }

        private void nullCompareCheck() {
            if (this.type().isPrimitive()) {
                throw new IllegalStateException("Cannot compare a primitive type to null");
            }
        }

        @Override
        public void ifLt(Object value, Label label) {
            this.ifRelational(value, label, false, (byte)-95, (byte)-101);
        }

        @Override
        public void ifGe(Object value, Label label) {
            this.ifRelational(value, label, false, (byte)-94, (byte)-100);
        }

        @Override
        public void ifGt(Object value, Label label) {
            this.ifRelational(value, label, false, (byte)-93, (byte)-99);
        }

        @Override
        public void ifLe(Object value, Label label) {
            this.ifRelational(value, label, false, (byte)-92, (byte)-98);
        }

        private void ifRelational(Object value, Label label, boolean eq, byte op, byte zeroOp) {
            byte cmpOp;
            Type typeCmp;
            block13: {
                block15: {
                    Type unbox;
                    block16: {
                        block14: {
                            int code;
                            block12: {
                                Objects.requireNonNull(value);
                                if (!(value instanceof LocalVar)) break block12;
                                LocalVar var = (LocalVar)value;
                                typeCmp = this.comparisonType(var.mType, eq);
                                this.push(typeCmp);
                                TheMethodMaker.this.addPushOp(typeCmp, value);
                                break block13;
                            }
                            if (!(value instanceof Number)) break block14;
                            Number num = (Number)value;
                            if (num.longValue() == 0L && num.doubleValue() == 0.0 && Type.from(value.getClass()).unboxTypeCode() != 10 && (unbox = this.type().unbox()) != null && 3 <= (code = unbox.typeCode()) && code <= 6) {
                                this.push(unbox);
                                TheMethodMaker.this.addBranchOp(zeroOp, 1, label);
                                return;
                            }
                            break block15;
                        }
                        if (!(value instanceof Boolean) || (unbox = this.type().unbox()) != Type.BOOLEAN) break block15;
                        if (!((Boolean)value).booleanValue()) break block16;
                        if (!eq) break block15;
                        zeroOp = TheMethodMaker.flipIf(zeroOp);
                    }
                    this.push(unbox);
                    TheMethodMaker.this.addBranchOp(zeroOp, 1, label);
                    return;
                }
                Op savepoint = TheMethodMaker.this.mLastOp;
                Type valueType = TheMethodMaker.this.addPushOp(null, value);
                typeCmp = this.comparisonType(valueType, eq);
                Op end = TheMethodMaker.this.mLastOp;
                Op rest = TheMethodMaker.this.rollback(savepoint);
                this.push(typeCmp);
                TheMethodMaker.this.mLastOp.mNext = rest;
                TheMethodMaker.this.mLastOp = end;
                TheMethodMaker.this.addConversionOp(valueType, typeCmp);
            }
            switch (typeCmp.stackMapCode()) {
                case 7: {
                    TheMethodMaker.this.addBranchOp((byte)(op + 6), 2, label);
                    return;
                }
                case 1: {
                    TheMethodMaker.this.addBranchOp(op, 2, label);
                    return;
                }
                case 2: {
                    cmpOp = zeroOp == -98 || zeroOp == -101 ? (byte)-106 : -107;
                    break;
                }
                case 3: {
                    cmpOp = zeroOp == -98 || zeroOp == -101 ? (byte)-104 : -105;
                    break;
                }
                case 4: {
                    cmpOp = -108;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            TheMethodMaker.this.addOp(new BytecodeOp(cmpOp, 2){

                @Override
                void appendTo(TheMethodMaker m) {
                    super.appendTo(m);
                    TheMethodMaker.this.stackPush(Type.INT);
                }
            });
            TheMethodMaker.this.addBranchOp(zeroOp, 1, label);
        }

        private Type comparisonType(Type other, boolean eq) {
            block6: {
                int cost2;
                Type otherCmp;
                Type thisCmp;
                block5: {
                    thisCmp = this.type();
                    otherCmp = other;
                    if (eq && thisCmp.isObject() && otherCmp.isObject()) break block5;
                    thisCmp = thisCmp.unbox();
                    otherCmp = otherCmp.unbox();
                    if (thisCmp == null || otherCmp == null) break block6;
                }
                int cost1 = other.canConvertTo(thisCmp);
                if (cost1 == 0 || cost1 < (cost2 = this.type().canConvertTo(otherCmp))) {
                    return thisCmp;
                }
                if (cost2 != Integer.MAX_VALUE) {
                    return otherCmp;
                }
            }
            throw new IllegalStateException("Incomparable types: " + this.type().name() + " with " + other.name());
        }

        @Override
        public void switch_(Label defaultLabel, int[] cases, Label ... labels) {
            int i;
            if (cases.length != labels.length) {
                throw new IllegalArgumentException("Number of cases and labels doesn't match");
            }
            if (cases.length == 0) {
                TheMethodMaker.this.goto_(defaultLabel);
                return;
            }
            Lab defaultLab = TheMethodMaker.this.target(defaultLabel);
            if (cases.length == 1) {
                Lab lab = TheMethodMaker.this.target(labels[0]);
                this.push(Type.INT);
                if (cases[0] == 0) {
                    TheMethodMaker.this.addBranchOp((byte)-103, 1, lab);
                } else {
                    TheMethodMaker.this.addOp(new BasicConstantOp(cases[0], Type.INT));
                    TheMethodMaker.this.addBranchOp((byte)-97, 2, lab);
                }
                TheMethodMaker.this.goto_(defaultLab);
                return;
            }
            defaultLab.targeted();
            Label[] labs = new Lab[labels.length];
            for (i = 0; i < labels.length; ++i) {
                labs[i] = TheMethodMaker.this.target(labels[i]);
                ((Lab)labs[i]).targeted();
            }
            cases = (int[])cases.clone();
            TheMethodMaker.sortSwitchCases(cases, labs);
            for (i = 1; i < cases.length; ++i) {
                if (cases[i] != cases[i - 1]) continue;
                throw new IllegalArgumentException("Duplicate switch cases: " + cases[i]);
            }
            this.push(Type.INT);
            TheMethodMaker.this.addSwitchOp(defaultLab, cases, (Lab[])labs);
        }

        @Override
        public void switch_(Label defaultLabel, String[] cases, Label ... labels) {
            Switcher.switchString(TheMethodMaker.this, this, defaultLabel, cases, labels);
        }

        @Override
        public LocalVar add(Object value) {
            return TheMethodMaker.this.addMathOp("add", (byte)96, this, value);
        }

        @Override
        public LocalVar sub(Object value) {
            return TheMethodMaker.this.addMathOp("subtract", (byte)100, this, value);
        }

        @Override
        public LocalVar mul(Object value) {
            return TheMethodMaker.this.addMathOp("multiply", (byte)104, this, value);
        }

        @Override
        public LocalVar div(Object value) {
            return TheMethodMaker.this.addMathOp("divide", (byte)108, this, value);
        }

        @Override
        public LocalVar rem(Object value) {
            return TheMethodMaker.this.addMathOp("remainder", (byte)112, this, value);
        }

        @Override
        public LocalVar eq(Object value) {
            return this.relational(value, true, (byte)-97, (byte)-103);
        }

        @Override
        public LocalVar ne(Object value) {
            return this.relational(value, true, (byte)-96, (byte)-102);
        }

        @Override
        public LocalVar lt(Object value) {
            return this.relational(value, false, (byte)-95, (byte)-101);
        }

        @Override
        public LocalVar ge(Object value) {
            return this.relational(value, false, (byte)-94, (byte)-100);
        }

        @Override
        public LocalVar gt(Object value) {
            return this.relational(value, false, (byte)-93, (byte)-99);
        }

        @Override
        public LocalVar le(Object value) {
            return this.relational(value, false, (byte)-92, (byte)-98);
        }

        private LocalVar relational(Object val, final boolean eq, final byte op, final byte zeroOp) {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            if (val != null) break block5;
                            this.nullCompareCheck();
                            if (!eq) {
                                Objects.requireNonNull(val);
                            }
                            break block6;
                        }
                        if (!CONDY_WORKAROUND) break block6;
                        TheMethodMaker.this.mHasBranches = true;
                        if (!(val instanceof ConstantVar)) break block7;
                        ConstantVar cv = (ConstantVar)val;
                        ConstantPool.Constant constant = cv.mConstant;
                        if (constant instanceof ConstantPool.C_Dynamic) break block8;
                        break block6;
                    }
                    if (!ConstableSupport.isDynamicConstant(val)) break block6;
                }
                val = TheMethodMaker.this.storeToNewVar(TheMethodMaker.this.addPushOp(null, val));
            }
            final Object value = val;
            final LocalVar result = new LocalVar(Type.BOOLEAN);
            this.adjustPushCount(1);
            TheMethodMaker.adjustPushCount(value, 1);
            TheMethodMaker.this.addOp(new Op(){

                @Override
                void appendTo(TheMethodMaker m) {
                    throw new AssertionError();
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                Op flow(Flow flow, Op prev) {
                    OwnedVar.this.adjustPushCount(-1);
                    TheMethodMaker.adjustPushCount(value, -1);
                    next = this.mNext;
                    last = flow.lastOp();
                    if (result.mPushCount != 1 || !(next instanceof PushVarOp)) ** GOTO lbl-1000
                    push = (PushVarOp)next;
                    if (push.mVar == result && push.mNext instanceof BranchOp && ((branchOp = (branch = (BranchOp)push.mNext).op()) == -103 || branchOp == -102)) {
                        flow.removeOps(prev, this, null, 3);
                        branch.mTarget.lessUsed();
                        if (value == null) {
                            effectiveOp = (byte)(zeroOp + 45);
                            if (branchOp == -103) {
                                effectiveOp = TheMethodMaker.flipIf(effectiveOp);
                            }
                            OwnedVar.this.push();
                            TheMethodMaker.this.addBranchOp(effectiveOp, 1, branch.mTarget);
                        } else {
                            effectiveOp = op;
                            effectiveZeroOp = zeroOp;
                            if (branchOp == -103) {
                                effectiveOp = TheMethodMaker.flipIf(effectiveOp);
                                effectiveZeroOp = TheMethodMaker.flipIf(effectiveZeroOp);
                            }
                            OwnedVar.this.ifRelational(value, branch.mTarget, eq, effectiveOp, effectiveZeroOp);
                        }
                        next = branch.mNext;
                    } else lbl-1000:
                    // 2 sources

                    {
                        flow.removeOps(prev, this, null, 1);
                        match = new PopLab();
                        if (value == null) {
                            OwnedVar.this.push();
                            TheMethodMaker.this.addBranchOp((byte)(zeroOp + 45), 1, match);
                        } else {
                            OwnedVar.this.ifRelational(value, match, eq, op, zeroOp);
                        }
                        TheMethodMaker.this.addOp(new BasicConstantOp(false, Type.BOOLEAN));
                        cont = TheMethodMaker.this.label();
                        TheMethodMaker.this.goto_(cont);
                        match.here();
                        TheMethodMaker.this.addOp(new BasicConstantOp(true, Type.BOOLEAN));
                        cont.here();
                        TheMethodMaker.this.addStoreOp(result);
                    }
                    flow.addOps(next, last);
                    return flow.nextOpFor(prev);
                }
            });
            return result;
        }

        @Override
        public LocalVar instanceOf(Object clazz) {
            if (!this.type().isObject()) {
                throw new IllegalStateException("Not an object type");
            }
            Type isType = TheMethodMaker.this.mClassMaker.typeFrom(clazz);
            if (!isType.isHidden()) {
                final ConstantPool.C_Class constant = TheMethodMaker.this.mConstants.addClass(isType);
                this.push();
                TheMethodMaker.this.addOp(new BytecodeOp(-63, 1){

                    @Override
                    void appendTo(TheMethodMaker m) {
                        super.appendTo(m);
                        m.appendShort(constant.mIndex);
                        m.stackPush(Type.BOOLEAN);
                    }
                });
            } else {
                Type classType = Type.from(Class.class);
                Type objType = Type.from(Object.class);
                ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(classType.findMethod("isInstance", new Type[]{objType}, 0, -1, null, null));
                LocalVar classVar = new LocalVar(classType);
                classVar.setExact(isType.clazz());
                TheMethodMaker.this.addOp(new PushVarOp(classVar));
                this.push();
                TheMethodMaker.this.addOp(new InvokeOp(-74, 2, ref));
            }
            return TheMethodMaker.this.storeToNewVar(Type.BOOLEAN);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public LocalVar cast(Object clazz) {
            Type toType;
            Type fromType = this.type();
            int code = fromType.canConvertTo(toType = TheMethodMaker.this.mClassMaker.typeFrom(clazz));
            if (code != Integer.MAX_VALUE) {
                this.push();
                TheMethodMaker.this.doAddConversionOp(fromType, toType, code);
                return TheMethodMaker.this.storeToNewVar(toType);
            }
            if (toType.isObject()) {
                if (!fromType.isObject()) {
                    if (!fromType.isPrimitive()) throw new IllegalStateException("Unsupported cast: " + fromType.name() + " to " + toType.name());
                    Type unbox = toType.unbox();
                    if (unbox == null) throw new IllegalStateException("Unsupported cast: " + fromType.name() + " to " + toType.name());
                    return this.cast(unbox.clazz()).cast(clazz);
                }
                if (toType.isHidden()) {
                    Class toClass = toType.clazz();
                    MethodHandle id = MethodHandles.identity(toClass);
                    MethodType mt = MethodType.methodType(toClass, Object.class);
                    MethodHandle converter = MethodHandles.explicitCastArguments(id, mt);
                    Type handleType = Type.from(MethodHandle.class);
                    LocalVar handleVar = new LocalVar(handleType);
                    handleVar.setExact(converter);
                    TheMethodMaker.this.addOp(new PushVarOp(handleVar));
                    this.push();
                    ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(handleType.inventMethod(0, toType.nonHiddenBase(), "invoke", Type.from(Object.class)));
                    TheMethodMaker.this.addOp(new InvokeOp(-74, 2, ref));
                    return TheMethodMaker.this.storeToNewVar(toType);
                }
                final ConstantPool.C_Class constant = TheMethodMaker.this.mConstants.addClass(toType);
                this.push();
                TheMethodMaker.this.addOp(new BytecodeOp(-64, 0){

                    @Override
                    void appendTo(TheMethodMaker m) {
                        super.appendTo(m);
                        m.appendShort(constant.mIndex);
                    }
                });
                return TheMethodMaker.this.storeToNewVar(toType);
            }
            Type primType = fromType.unbox();
            if (primType == null) {
                LocalVar casted;
                if (Type.from(Number.class).isAssignableFrom(fromType) && toType != Type.BOOLEAN && toType != Type.CHAR) {
                    return this.invoke(toType.name() + "Value");
                }
                if (!fromType.equals(Type.from(Object.class))) throw new IllegalStateException("Unsupported conversion: " + fromType.name() + " to " + toType.name());
                if (toType == Type.BOOLEAN) {
                    casted = this.cast(Boolean.class);
                    return casted.cast(clazz);
                }
                if (toType == Type.CHAR) {
                    casted = this.cast(Character.class);
                    return casted.cast(clazz);
                }
                casted = this.cast(Number.class);
                return casted.cast(clazz);
            }
            int toTypeCode = toType.typeCode();
            byte op = 0;
            block0 : switch (primType.stackMapCode()) {
                case 1: {
                    switch (toTypeCode) {
                        case 6: {
                            this.push();
                            return TheMethodMaker.this.storeToNewVar(toType);
                        }
                        case 2: {
                            (primType == Type.INT ? this : this.cast(Integer.TYPE)).and(1).push();
                            return TheMethodMaker.this.storeToNewVar(toType);
                        }
                        case 3: {
                            op = -111;
                            break block0;
                        }
                        case 4: {
                            op = -110;
                            break block0;
                        }
                        case 5: {
                            op = -109;
                            break block0;
                        }
                        case 7: {
                            op = -122;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (toTypeCode) {
                        case 6: {
                            op = -117;
                            break block0;
                        }
                        case 8: {
                            op = -116;
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (toTypeCode) {
                        case 6: {
                            op = -114;
                            break block0;
                        }
                        case 7: {
                            op = -112;
                            break block0;
                        }
                        case 8: {
                            op = -113;
                            break block0;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (toTypeCode) {
                        case 6: {
                            op = -120;
                            break block0;
                        }
                        case 7: {
                            op = -119;
                            break block0;
                        }
                        case 9: {
                            op = -118;
                            break block0;
                        }
                    }
                }
            }
            if (op == 0) {
                switch (toTypeCode) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return this.cast(Integer.TYPE).cast(clazz);
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        if (primType != Type.BOOLEAN) throw new IllegalStateException("Unsupported conversion: " + fromType.name() + " to " + toType.name());
                        return this.cast(Integer.TYPE).cast(clazz);
                    }
                }
                throw new IllegalStateException("Unsupported conversion: " + fromType.name() + " to " + toType.name());
            }
            this.push(primType);
            TheMethodMaker.this.addOp(new BytecodeOp(op, 1){

                @Override
                void appendTo(TheMethodMaker m) {
                    super.appendTo(m);
                    m.stackPush(toType);
                }
            });
            return TheMethodMaker.this.storeToNewVar(toType);
        }

        @Override
        public LocalVar not() {
            return this.eq(false);
        }

        @Override
        public LocalVar and(Object value) {
            return TheMethodMaker.this.addLogicalOp("and", (byte)126, this, value);
        }

        @Override
        public LocalVar or(Object value) {
            return TheMethodMaker.this.addLogicalOp("or", (byte)-128, this, value);
        }

        @Override
        public LocalVar xor(Object value) {
            return TheMethodMaker.this.addLogicalOp("xor", (byte)-126, this, value);
        }

        @Override
        public LocalVar shl(Object value) {
            return TheMethodMaker.this.addLogicalOp("shift", (byte)120, this, value);
        }

        @Override
        public LocalVar shr(Object value) {
            return TheMethodMaker.this.addLogicalOp("shift", (byte)122, this, value);
        }

        @Override
        public LocalVar ushr(Object value) {
            return TheMethodMaker.this.addLogicalOp("shift", (byte)124, this, value);
        }

        @Override
        public LocalVar neg() {
            return TheMethodMaker.this.addMathOp("negate", (byte)116, this, null);
        }

        @Override
        public LocalVar com() {
            return TheMethodMaker.this.addLogicalOp("complement", (byte)-126, this, -1);
        }

        @Override
        public LocalVar box() {
            Type type = this.type().box();
            this.push(type);
            return TheMethodMaker.this.storeToNewVar(type);
        }

        @Override
        public LocalVar unbox() {
            Type type = this.type().unbox();
            if (type == null) {
                throw new IllegalStateException("Cannot be unboxed");
            }
            this.push(type);
            return TheMethodMaker.this.storeToNewVar(type);
        }

        @Override
        public LocalVar alength() {
            this.arrayCheck();
            this.push();
            TheMethodMaker.this.addBytecodeOp((byte)-66, 0);
            return TheMethodMaker.this.storeToNewVar(Type.INT);
        }

        @Override
        public LocalVar aget(Object index) {
            byte op = this.aloadOp();
            this.push();
            TheMethodMaker.this.addPushOp(Type.INT, index);
            TheMethodMaker.this.addBytecodeOp(op, 1);
            return TheMethodMaker.this.storeToNewVar(this.type().elementType());
        }

        @Override
        public void aset(Object index, Object value) {
            byte op = this.aloadOp();
            this.push();
            TheMethodMaker.this.addPushOp(Type.INT, index);
            TheMethodMaker.this.addPushOp(this.type().elementType(), value);
            TheMethodMaker.this.addBytecodeOp((byte)(op + 33), 3);
        }

        private Type arrayCheck() throws IllegalStateException {
            Type type = this.type();
            if (!type.isArray()) {
                throw new IllegalStateException("Not an array type");
            }
            return type;
        }

        private byte aloadOp() {
            switch (this.arrayCheck().elementType().typeCode()) {
                case 2: 
                case 3: {
                    return 51;
                }
                case 4: {
                    return 52;
                }
                case 5: {
                    return 53;
                }
                case 6: {
                    return 46;
                }
                case 7: {
                    return 48;
                }
                case 8: {
                    return 47;
                }
                case 9: {
                    return 49;
                }
            }
            return 50;
        }

        @Override
        public LocalVar invoke(String name, Object ... values) {
            return TheMethodMaker.this.doInvoke(this.invocationType(), this.invocationInstance(), name, this.inherit(), values, null, null);
        }

        @Override
        public LocalVar invoke(String name) {
            return this.invoke(name, Type.NO_ARGS);
        }

        @Override
        public LocalVar invoke(Object retType, String name, Object[] types, Object ... values) {
            Type newReturnType;
            Type returnType = null;
            Type[] paramTypes = null;
            if (retType != null) {
                returnType = TheMethodMaker.this.mClassMaker.typeFrom(retType);
            }
            if (types != null) {
                paramTypes = new Type[types.length];
                for (int i = 0; i < types.length; ++i) {
                    Object type = types[i];
                    paramTypes[i] = type == null ? null : TheMethodMaker.this.mClassMaker.typeFrom(type);
                }
            }
            if (name.equals(".new") && (newReturnType = this.newReturnType(returnType)) != null) {
                return TheMethodMaker.this.doNew(newReturnType, values, paramTypes);
            }
            return TheMethodMaker.this.doInvoke(this.invocationType(), this.invocationInstance(), name, this.inherit(), values, returnType, paramTypes);
        }

        @Override
        public ConstantVar methodHandle(Object retType, String name, Object ... types) {
            Type[] paramTypes;
            Type returnType;
            Type type = returnType = retType == null ? null : TheMethodMaker.this.mClassMaker.typeFrom(retType);
            if (types == null) {
                paramTypes = new Type[]{};
            } else {
                paramTypes = new Type[types.length];
                for (int i = 0; i < types.length; ++i) {
                    paramTypes[i] = TheMethodMaker.this.mClassMaker.typeFrom(types[i]);
                }
            }
            return this.methodHandle(returnType, name, paramTypes);
        }

        ConstantVar methodHandle(Type returnType, String name, Type ... paramTypes) {
            ConstantPool.Constant mhConstant;
            int kind;
            Type.Method method;
            Type newReturnType;
            if (name.equals(".new") && (newReturnType = this.newReturnType(returnType)) != null) {
                method = newReturnType.findMethod("<init>", paramTypes, -1, -1, null, paramTypes);
                kind = 8;
            } else {
                int inherit;
                Type type = this.invocationType();
                if (type.isPrimitive()) {
                    type = type.box();
                }
                kind = (method = type.findMethod(name, paramTypes, inherit = this.inherit(), 0, returnType, paramTypes)).isStatic() ? 6 : (method.enclosingType().isInterface() ? 9 : (inherit == 0 ? 5 : 7));
            }
            Class<?> clazz = this.classType();
            Type mhType = Type.from(MethodHandle.class);
            if (!TheMethodMaker.isHidden(clazz)) {
                mhConstant = TheMethodMaker.this.mConstants.addMethodHandle(kind, TheMethodMaker.this.mConstants.addMethod(method));
            } else {
                Type classType = Type.from(Class.class);
                Type classArrayType = Type.from(Class[].class);
                Type[] bootParams = new Type[]{Type.from(MethodHandles.Lookup.class), Type.from(String.class), classType, Type.INT, classType, classType, classArrayType};
                ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(Type.from(MethodHandleBootstraps.class).inventMethod(8, mhType, "methodHandle", bootParams));
                ConstantPool.C_MethodHandle bootHandle = TheMethodMaker.this.mConstants.addMethodHandle(6, ref);
                paramTypes = method.paramTypes();
                ConstantPool.Constant[] bootArgs = new ConstantPool.Constant[3 + paramTypes.length];
                bootArgs[0] = TheMethodMaker.this.mConstants.addInteger(kind);
                bootArgs[1] = TheMethodMaker.this.addLoadableConstant(null, clazz);
                bootArgs[2] = TheMethodMaker.this.addLoadableConstant(null, method.returnType());
                for (int i = 0; i < paramTypes.length; ++i) {
                    bootArgs[3 + i] = TheMethodMaker.this.addLoadableConstant(null, paramTypes[i]);
                }
                if (kind == 8) {
                    name = "_";
                }
                mhConstant = TheMethodMaker.this.mConstants.addDynamicConstant(TheMethodMaker.this.mClassMaker.addBootstrapMethod(bootHandle, bootArgs), name, mhType);
            }
            return new ConstantVar(mhType, mhConstant);
        }

        private Type newReturnType(Type returnType) {
            Type type = this.type();
            return returnType == null || returnType == type ? type : null;
        }

        Type invocationType() {
            return this.type();
        }

        OwnedVar invocationInstance() {
            return this;
        }

        int inherit() {
            return 0;
        }

        @Override
        public Bootstrap indy(String name, Object ... args) {
            return this.bootstrap(false, name, args);
        }

        @Override
        public Bootstrap condy(String name, Object ... args) {
            return this.bootstrap(true, name, args);
        }

        private Bootstrap bootstrap(boolean condy, String name, Object ... args) {
            Type[] types = new Type[3 + args.length];
            types[0] = Type.from(MethodHandles.Lookup.class);
            types[1] = Type.from(String.class);
            types[2] = Type.from(condy ? Class.class : MethodType.class);
            for (int i = 0; i < args.length; ++i) {
                Type type;
                Object arg = args[i];
                if (arg == null) {
                    type = Type.Null.THE;
                } else if (arg instanceof Typed) {
                    Typed typed = (Typed)arg;
                    type = typed.type();
                } else if (arg instanceof MethodHandleInfo) {
                    type = Type.from(MethodHandle.class);
                } else {
                    type = ConstableSupport.toConstantDescType(TheMethodMaker.this, arg);
                    if (type == null) {
                        type = TheMethodMaker.this.mClassMaker.typeFrom(arg.getClass());
                    }
                }
                types[3 + i] = type;
            }
            Type.Method bootstrap = this.type().findMethod(name, types, 0, 1, null, null);
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(bootstrap);
            ConstantPool.C_MethodHandle bootHandle = TheMethodMaker.this.mConstants.addMethodHandle(6, ref);
            Type[] bootTypes = bootstrap.paramTypes();
            ConstantPool.Constant[] bootArgs = new ConstantPool.Constant[args.length];
            if (!bootstrap.isVarargs()) {
                for (i = 0; i < args.length; ++i) {
                    bootArgs[i] = TheMethodMaker.this.addLoadableConstant(bootTypes[i + 3], args[i]);
                }
            } else {
                for (i = 3; i < bootTypes.length - 1; ++i) {
                    bootArgs[i - 3] = TheMethodMaker.this.addLoadableConstant(bootTypes[i], args[i - 3]);
                }
                Type varargType = bootTypes[i].elementType();
                i -= 3;
                while (i < args.length) {
                    bootArgs[i] = TheMethodMaker.this.addLoadableConstant(varargType, args[i]);
                    ++i;
                }
            }
            int bi = TheMethodMaker.this.mClassMaker.addBootstrapMethod(bootHandle, bootArgs);
            return new BootstrapImpl(bi, condy);
        }

        @Override
        public void throw_() {
            Type type = this.type();
            Class clazz = type.clazz();
            if (clazz == null) {
                clazz = ((TheClassMaker)type.maker()).superType().clazz();
            }
            if (!Throwable.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("Non-throwable type: " + type.name());
            }
            this.push();
            TheMethodMaker.this.addBytecodeOp((byte)-65, 1);
        }

        @Override
        public void monitorEnter() {
            this.monitor((byte)-62);
        }

        @Override
        public void monitorExit() {
            this.monitor((byte)-61);
        }

        private void monitor(byte op) {
            if (!this.type().isObject()) {
                throw new IllegalStateException("Not an object type");
            }
            this.push();
            TheMethodMaker.this.addBytecodeOp(op, 1);
        }

        @Override
        public void synchronized_(Runnable body) {
            this.monitorEnter();
            Label start = TheMethodMaker.this.label().here();
            body.run();
            TheMethodMaker.this.finally_(start, this::monitorExit);
        }

        @Override
        public MethodMaker methodMaker() {
            return TheMethodMaker.this;
        }
    }

    class ConstantVar
    extends LocalVar {
        final ConstantPool.Constant mConstant;

        ConstantVar(Type type, ConstantPool.Constant constant) {
            super(type);
            this.mConstant = constant;
        }

        @Override
        public LocalVar set(Object value) {
            throw new IllegalStateException("Unmodifiable variable");
        }

        @Override
        public Variable setExact(Object value) {
            throw new IllegalStateException("Unmodifiable variable");
        }

        @Override
        public void inc(Object value) {
            throw new IllegalStateException("Unmodifiable variable");
        }

        ConstantPool.Constant tryObtain(TheMethodMaker mm) {
            return mm.mClassMaker == TheMethodMaker.this.mClassMaker ? this.mConstant : null;
        }

        @Override
        boolean tryPushTo(TheMethodMaker mm) {
            if (TheMethodMaker.this.mClassMaker == mm.mClassMaker) {
                this.pushTo(mm);
                return true;
            }
            return false;
        }

        @Override
        void push() {
            this.pushTo(TheMethodMaker.this);
        }

        void pushTo(TheMethodMaker mm) {
            mm.addExplicitConstantOp(this.mConstant, this.mType);
        }
    }

    static final class InvokeInterfaceOp
    extends BytecodeOp {
        final ConstantPool.C_Method mMethodRef;
        final int mNargs;

        InvokeInterfaceOp(int stackPop, ConstantPool.C_Method methodRef, int nargs) {
            super((byte)-71, stackPop);
            this.mMethodRef = methodRef;
            this.mNargs = nargs;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            super.appendTo(m);
            m.appendShort(this.mMethodRef.mIndex);
            m.appendByte(this.mNargs);
            m.appendByte(0);
            Type returnType = this.mMethodRef.mMethod.returnType();
            if (returnType != Type.VOID) {
                m.stackPush(returnType);
            }
        }
    }

    static final class InvokeOp
    extends BytecodeOp {
        final ConstantPool.C_Method mMethodRef;

        InvokeOp(byte op, int stackPop, ConstantPool.C_Method methodRef) {
            super(op, stackPop);
            this.mMethodRef = methodRef;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            super.appendTo(m);
            m.appendShort(this.mMethodRef.mIndex);
            Type returnType = this.mMethodRef.mMethod.returnType();
            if (returnType != Type.VOID) {
                m.stackPush(returnType);
            }
        }
    }

    static final class PushVarOp
    extends LocalVarOp {
        PushVarOp(LocalVar var) {
            super(var);
            ++var.mPushCount;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            m.pushVar(this.mVar);
        }

        @Override
        Op flow(Flow flow, Op prev) {
            StoreVarOp op;
            Op next = this.mNext;
            if (next instanceof StoreVarOp && (op = (StoreVarOp)next).unusedVar()) {
                --this.mVar.mPushCount;
                next = next.mNext;
                flow.removeOps(prev, this, next, 1);
                return next;
            }
            return super.flow(flow, prev);
        }
    }

    static final class SwitchOp
    extends BytecodeOp {
        Lab mDefault;
        final int[] mCases;
        final Lab[] mLabels;

        SwitchOp(byte op, Lab defaultLabel, int[] cases, Lab[] labels) {
            super(op, 1);
            this.mDefault = defaultLabel;
            this.mCases = cases;
            this.mLabels = labels;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            int srcAddr = m.mCodeLen;
            super.appendTo(m);
            m.appendPad(3 - (srcAddr & 3));
            this.mDefault.comesFromWide(m, srcAddr);
            if (this.op() == -85) {
                m.appendInt(this.mCases.length);
                for (int i = 0; i < this.mCases.length; ++i) {
                    m.appendInt(this.mCases[i]);
                    this.mLabels[i].comesFromWide(m, srcAddr);
                }
            } else {
                int smallest = this.mCases[0];
                int largest = this.mCases[this.mCases.length - 1];
                m.appendInt(smallest);
                m.appendInt(largest);
                int i = 0;
                for (int c = smallest; c <= largest; ++c) {
                    if (c == this.mCases[i]) {
                        this.mLabels[i].comesFromWide(m, srcAddr);
                        ++i;
                        continue;
                    }
                    this.mDefault.comesFromWide(m, srcAddr);
                }
            }
        }

        @Override
        Op flow(Flow flow, Op prev) {
            for (Lab lab : this.mLabels) {
                flow.run(lab);
            }
            return this.mDefault;
        }

        void finallyExits(TheMethodMaker m, HashSet<Lab> inside, Map<Lab, Lab> exits) {
            this.mDefault = m.finallyExit(inside, exits, this.mDefault);
            for (int i = 0; i < this.mLabels.length; ++i) {
                this.mLabels[i] = m.finallyExit(inside, exits, this.mLabels[i]);
            }
        }
    }

    static final class StoreVarOp
    extends LocalVarOp {
        StoreVarOp(LocalVar var) {
            super(var);
        }

        @Override
        void appendTo(TheMethodMaker m) {
            if (this.unusedVar() && this.mVar.mSlot < 0) {
                m.stackPop();
            } else {
                m.storeVar(this.mVar);
            }
        }

        @Override
        Op flow(Flow flow, Op prev) {
            Op next = this.mNext;
            if (next instanceof PushVarOp) {
                PushVarOp push = (PushVarOp)next;
                LocalVar var = this.mVar;
                if (var == push.mVar && var.mPushCount == 1) {
                    var.mPushCount = 0;
                    next = next.mNext;
                    flow.removeOps(prev, this, next, 1);
                    return next;
                }
            }
            if (this.unusedVar()) {
                return next;
            }
            return super.flow(flow, prev);
        }

        boolean unusedVar() {
            return this.mVar.mPushCount == 0;
        }
    }

    static final class InvokeDynamicOp
    extends BytecodeOp {
        final ConstantPool.C_Dynamic mDynamic;
        final Type mReturnType;

        InvokeDynamicOp(int stackPop, ConstantPool.C_Dynamic dynamic, Type returnType) {
            super((byte)-70, stackPop);
            this.mDynamic = dynamic;
            this.mReturnType = returnType;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            super.appendTo(m);
            m.appendShort(this.mDynamic.mIndex);
            m.appendShort(0);
            if (this.mReturnType != Type.VOID) {
                m.stackPush(this.mReturnType);
            }
        }
    }

    final class HandleVar
    extends BaseFieldVar {
        private final LocalVar mHandleVar;
        private final Type mType;
        private final Type[] mCoordinateTypes;
        private final Object[] mCoordinates;
        private Variable mHandleGet;
        private Variable mHandleSet;

        HandleVar(LocalVar handleVar, Type type, Type[] coordinateTypes, Object[] coordinates) {
            this.mHandleVar = handleVar;
            this.mType = type;
            this.mCoordinateTypes = coordinateTypes;
            this.mCoordinates = coordinates;
        }

        @Override
        public Type type() {
            return this.mType;
        }

        @Override
        public String name() {
            return null;
        }

        @Override
        public LocalVar get() {
            return this.getPlain();
        }

        @Override
        public HandleVar set(Object value) {
            this.setPlain(value);
            return this;
        }

        @Override
        public Variable varHandle() {
            return this.mHandleVar.get();
        }

        @Override
        public Variable methodHandleGet() {
            if (this.mHandleGet == null) {
                this.mHandleGet = this.mHandleVar.invoke("toMethodHandle", new Object[]{VarHandle.AccessMode.GET});
            }
            return this.mHandleGet.get();
        }

        @Override
        public Variable methodHandleSet() {
            if (this.mHandleSet == null) {
                this.mHandleSet = this.mHandleVar.invoke("toMethodHandle", new Object[]{VarHandle.AccessMode.SET});
            }
            return this.mHandleSet.get();
        }

        @Override
        void push() {
            this.vhPush("get");
        }

        @Override
        void adjustPushCount(int amt) {
            this.mHandleVar.adjustPushCount(amt);
            for (Object coordinate : this.mCoordinates) {
                TheMethodMaker.adjustPushCount(coordinate, amt);
            }
        }

        @Override
        void addStoreConstantOp(ExplicitConstantOp op) {
            this.vhSet("set", op);
        }

        @Override
        LocalVar vhGet(String name) {
            this.vhPush(name);
            return TheMethodMaker.this.storeToNewVar(this.mType);
        }

        void vhPush(String name) {
            this.mHandleVar.push();
            for (int i = 0; i < this.mCoordinates.length; ++i) {
                TheMethodMaker.this.addPushOp(this.mCoordinateTypes[i], this.mCoordinates[i]);
            }
            Type vhType = this.mHandleVar.type();
            Type.Method method = vhType.inventMethod(0, this.mType, name, this.mCoordinateTypes);
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(method);
            TheMethodMaker.this.addOp(new InvokeOp(-74, 1 + this.mCoordinates.length, ref));
        }

        @Override
        void vhSet(String name, Object value) {
            this.mHandleVar.push();
            Type[] allTypes = new Type[this.mCoordinateTypes.length + 1];
            for (int i = 0; i < this.mCoordinates.length; ++i) {
                allTypes[i] = TheMethodMaker.this.addPushOp(this.mCoordinateTypes[i], this.mCoordinates[i]);
            }
            if (value instanceof ExplicitConstantOp) {
                ExplicitConstantOp op = (ExplicitConstantOp)value;
                allTypes[i] = this.mType;
                TheMethodMaker.this.addExplicitConstantOp(op);
            } else {
                allTypes[i] = TheMethodMaker.this.addPushOp(this.mType, value);
            }
            Type vhType = this.mHandleVar.type();
            Type.Method method = vhType.inventMethod(0, Type.VOID, name, allTypes);
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(method);
            TheMethodMaker.this.addOp(new InvokeOp(-74, 2 + this.mCoordinates.length, ref));
        }

        @Override
        LocalVar vhCas(String name, Type retType, Object expectedValue, Object newValue) {
            this.mHandleVar.push();
            Type[] allTypes = new Type[this.mCoordinateTypes.length + 2];
            for (int i = 0; i < this.mCoordinates.length; ++i) {
                allTypes[i] = TheMethodMaker.this.addPushOp(this.mCoordinateTypes[i], this.mCoordinates[i]);
            }
            allTypes[i++] = TheMethodMaker.this.addPushOp(this.mType, expectedValue);
            allTypes[i] = TheMethodMaker.this.addPushOp(this.mType, newValue);
            Type vhType = this.mHandleVar.type();
            if (retType == null) {
                retType = this.mType;
            }
            Type.Method method = vhType.inventMethod(0, retType, name, allTypes);
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(method);
            TheMethodMaker.this.addOp(new InvokeOp(-74, 3 + this.mCoordinates.length, ref));
            return TheMethodMaker.this.storeToNewVar(retType);
        }

        @Override
        LocalVar vhGas(String name, Object value) {
            this.mHandleVar.push();
            Type[] allTypes = new Type[this.mCoordinateTypes.length + 1];
            for (int i = 0; i < this.mCoordinates.length; ++i) {
                allTypes[i] = TheMethodMaker.this.addPushOp(this.mCoordinateTypes[i], this.mCoordinates[i]);
            }
            allTypes[i] = TheMethodMaker.this.addPushOp(this.mType, value);
            Type vhType = this.mHandleVar.type();
            Type.Method method = vhType.inventMethod(0, this.mType, name, allTypes);
            ConstantPool.C_Method ref = TheMethodMaker.this.mConstants.addMethod(method);
            TheMethodMaker.this.addOp(new InvokeOp(-74, 2 + this.mCoordinates.length, ref));
            return TheMethodMaker.this.storeToNewVar(this.mType);
        }
    }

    final class NewVar
    extends LocalVar {
        private final int mNewOffset;

        NewVar(Type type, int newOffset) {
            super(type);
            this.mNewOffset = newOffset;
        }

        @Override
        int smCode() {
            return 8 | this.mNewOffset << 8;
        }
    }

    static final class FieldOp
    extends BytecodeOp {
        final ConstantPool.C_Field mFieldRef;

        FieldOp(byte op, int stackPop, ConstantPool.C_Field fieldRef) {
            super(op, stackPop);
            this.mFieldRef = fieldRef;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            super.appendTo(m);
            m.appendShort(this.mFieldRef.mIndex);
            byte op = this.op();
            if (op == -76 || op == -78) {
                m.stackPush(this.mFieldRef.mField.type());
            }
        }
    }

    static final class BasicConstantOp
    extends ConstantOp {
        final Object mValue;
        final Type mType;

        BasicConstantOp(Object value, Type type) {
            this.mValue = value;
            this.mType = type;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            m.pushConstant(this.mValue, this.mType);
        }
    }

    static final class ExplicitConstantOp
    extends ConstantOp {
        final ConstantPool.Constant mConstant;
        final Type mType;
        ConstantPool.C_Field mResolved;

        ExplicitConstantOp(ConstantPool.Constant constant, Type type) {
            this.mConstant = constant;
            this.mType = type;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            if (this.mResolved == null) {
                int typeCode = this.mType.typeCode();
                if (typeCode == 9 || typeCode == 8) {
                    int index = this.mConstant.mIndex;
                    m.appendByte(20);
                    m.appendShort(index);
                    m.stackPush(this.mType);
                } else {
                    m.pushConstant(this.mConstant, this.mType);
                }
            } else {
                m.appendByte(-78);
                m.appendShort(this.mResolved.mIndex);
                m.stackPush(this.mResolved.mField.type());
            }
        }
    }

    final class BootstrapImpl
    implements Bootstrap {
        final int mBootstrapIndex;
        final boolean mCondy;

        BootstrapImpl(int bi, boolean condy) {
            this.mBootstrapIndex = bi;
            this.mCondy = condy;
        }

        @Override
        public LocalVar invoke(Object retType, String name, Object[] types, Object ... values) {
            int length;
            int n = length = values == null ? 0 : values.length;
            if (this.mCondy) {
                if (types != null && types.length != 0 || length != 0) {
                    throw new IllegalStateException("Dynamic constant has no parameters");
                }
                if (retType == null) {
                    throw TheMethodMaker.unsupportedConstant(null);
                }
                Type returnType = TheMethodMaker.this.mClassMaker.typeFrom(retType);
                ConstantPool.C_Dynamic dynamic = TheMethodMaker.this.mConstants.addDynamicConstant(this.mBootstrapIndex, name, returnType);
                return new ConstantVar(returnType, dynamic);
            }
            if (types != null && types.length != length) {
                throw new IllegalArgumentException("Mismatched parameter types and values");
            }
            Type[] paramTypes = new Type[length];
            for (int i = 0; i < paramTypes.length; ++i) {
                Type type = types == null ? null : TheMethodMaker.this.mClassMaker.typeFrom(types[i]);
                paramTypes[i] = TheMethodMaker.this.addPushOp(type, values[i]);
            }
            Type returnType = retType == null ? Type.VOID : TheMethodMaker.this.mClassMaker.typeFrom(retType);
            String desc = Type.makeDescriptor(returnType, paramTypes);
            ConstantPool.C_Dynamic dynamic = TheMethodMaker.this.mConstants.addInvokeDynamic(this.mBootstrapIndex, name, desc);
            TheMethodMaker.this.addOp(new InvokeDynamicOp(length, dynamic, returnType));
            return returnType == Type.VOID ? null : TheMethodMaker.this.storeToNewVar(returnType);
        }
    }

    static final class SignatureLocalVarOp
    extends Op {
        final LocalVar mVar;
        final String mSignature;

        SignatureLocalVarOp(LocalVar var, String signature) {
            this.mVar = var;
            this.mSignature = signature;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            String name;
            int slot = this.mVar.mSlot;
            if (slot < 0 || (name = this.mVar.name()) == null) {
                return;
            }
            ConstantPool constants = m.mConstants;
            Attribute.LocalVariableTable table = m.mLocalVariableTypeTable;
            if (table == null) {
                m.mLocalVariableTypeTable = table = new Attribute.LocalVariableTable(constants, "LocalVariableTypeTable");
            }
            table.add(0, Integer.MAX_VALUE, constants.addUTF8(name), constants.addUTF8(this.mSignature), slot);
        }
    }

    static final class NameLocalVarOp
    extends Op {
        final LocalVar mVar;

        NameLocalVarOp(LocalVar var) {
            this.mVar = var;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            int slot = this.mVar.mSlot;
            if (slot < 0) {
                return;
            }
            ConstantPool constants = m.mConstants;
            Attribute.LocalVariableTable table = m.mLocalVariableTable;
            if (table == null) {
                m.mLocalVariableTable = table = new Attribute.LocalVariableTable(constants, "LocalVariableTable");
            }
            table.add(0, Integer.MAX_VALUE, constants.addUTF8(this.mVar.name()), constants.addUTF8(this.mVar.mType.descriptor()), slot);
        }
    }

    static final class IncOp
    extends LocalVarOp {
        final int mAmount;

        IncOp(LocalVar var, int amount) {
            super(var);
            this.mAmount = amount;
            ++var.mPushCount;
        }

        @Override
        void appendTo(TheMethodMaker m) {
            int slot = this.mVar.mSlot;
            if (-128 <= this.mAmount && this.mAmount < 128 && slot < 256) {
                m.appendByte(-124);
                m.appendByte(slot);
                m.appendByte(this.mAmount);
            } else {
                m.appendByte(-60);
                m.appendByte(-124);
                m.appendShort(slot);
                m.appendShort(this.mAmount);
            }
        }
    }

    static abstract class LocalVarOp
    extends Op {
        final LocalVar mVar;

        LocalVarOp(LocalVar var) {
            this.mVar = var;
        }

        @Override
        Op flow(Flow flow, Op prev) {
            LocalVar var = this.mVar;
            int slot = var.mSlot;
            if (slot < 0) {
                List<LocalVar> varList = flow.mVarList;
                var.mSlot = slot = flow.nextSlot();
                varList.add(var);
            }
            flow.mVarUsage.set(slot);
            return this.mNext;
        }
    }

    static abstract class ConstantOp
    extends Op {
        ConstantOp() {
        }

        @Override
        Op flow(Flow flow, Op prev) {
            StoreVarOp op;
            Op next = this.mNext;
            if (next instanceof StoreVarOp && (op = (StoreVarOp)next).unusedVar()) {
                next = next.mNext;
                flow.removeOps(prev, this, next, 1);
                return next;
            }
            return next;
        }
    }

    class PopLab
    extends Lab {
        PopLab() {
        }

        @Override
        void appendTo(TheMethodMaker m) {
            int newSize = m.mStackSize - 1;
            if (newSize < 0) {
                throw new IllegalStateException("Stack is empty");
            }
            m.mStackSize = newSize;
            super.appendTo(m);
        }
    }

    private static class Overflow {
        final Overflow mPrev;
        final Op mOp;
        final BitSet mVarUsage;

        Overflow(Overflow prev, Op op, BitSet varUsage) {
            this.mPrev = prev;
            this.mOp = op;
            this.mVarUsage = varUsage;
        }
    }
}

