/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.cojen.maker.Candidate;
import org.cojen.maker.ClassMaker;
import org.cojen.maker.ConstableSupport;
import org.cojen.maker.TheClassMaker;
import org.cojen.maker.Typed;

abstract class Type {
    static final int SM_TOP = 0;
    static final int SM_INT = 1;
    static final int SM_FLOAT = 2;
    static final int SM_DOUBLE = 3;
    static final int SM_LONG = 4;
    static final int SM_NULL = 5;
    static final int SM_UNINIT_THIS = 6;
    static final int SM_OBJECT = 7;
    static final int SM_UNINIT = 8;
    static final int T_VOID = 1;
    static final int T_BOOLEAN = 2;
    static final int T_BYTE = 3;
    static final int T_CHAR = 4;
    static final int T_SHORT = 5;
    static final int T_INT = 6;
    static final int T_FLOAT = 7;
    static final int T_LONG = 8;
    static final int T_DOUBLE = 9;
    static final int T_OBJECT = 10;
    static final Type BOOLEAN = new Primitive(1, 2);
    static final Type BYTE = new Primitive(1, 3);
    static final Type SHORT = new Primitive(1, 5);
    static final Type CHAR = new Primitive(1, 4);
    static final Type INT = new Primitive(1, 6);
    static final Type FLOAT = new Primitive(2, 7);
    static final Type LONG = new Primitive(4, 8);
    static final Type DOUBLE = new Primitive(3, 9);
    static final Type VOID = new Primitive(0, 1);
    static final int FLAG_PUBLIC = 1;
    static final int FLAG_PRIVATE = 2;
    static final int FLAG_PROTECTED = 4;
    static final int FLAG_STATIC = 8;
    static final int FLAG_FINAL = 16;
    static final int FLAG_BRIDGE = 64;
    static final int FLAG_VARARGS = 128;
    static final Object[] NO_ARGS = new Object[0];
    private static final WeakHashMap<ClassLoader, SoftReference<ConcurrentHashMap<Object, Type>>> cCacheMap = new WeakHashMap();

    Type() {
    }

    static Type begin(ClassLoader loader, TheClassMaker maker, String name) {
        return new NewClazz(loader, maker, name);
    }

    static Type from(ClassLoader loader, Object type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return Type.from(clazz);
        }
        if (type instanceof Typed) {
            Typed typed = (Typed)type;
            return typed.type();
        }
        if (type instanceof String) {
            String str = (String)type;
            return Type.from(loader, str);
        }
        if (type == null) {
            throw new NullPointerException();
        }
        String desc = ConstableSupport.toTypeDescriptor(type);
        if (desc == null) {
            throw new IllegalArgumentException("Unknown type: " + type);
        }
        return Type.from(loader, desc);
    }

    static Type from(ClassLoader loader, String type) {
        ConcurrentHashMap<Object, Type> cache = Type.cache(loader);
        Type t = cache.get(type);
        return t != null ? t : Type.cachePut(cache, type, Type.find(loader, type));
    }

    private static Type find(ClassLoader loader, String type) {
        String name;
        block42: {
            Object desc;
            block44: {
                block43: {
                    switch (type = type.trim()) {
                        case "boolean": 
                        case "Z": {
                            return BOOLEAN;
                        }
                        case "byte": 
                        case "B": {
                            return BYTE;
                        }
                        case "short": 
                        case "S": {
                            return SHORT;
                        }
                        case "char": 
                        case "C": {
                            return CHAR;
                        }
                        case "int": 
                        case "I": {
                            return INT;
                        }
                        case "float": 
                        case "F": {
                            return FLOAT;
                        }
                        case "double": 
                        case "D": {
                            return DOUBLE;
                        }
                        case "long": 
                        case "J": {
                            return LONG;
                        }
                        case "void": 
                        case "V": {
                            return VOID;
                        }
                        case "": {
                            throw new IllegalArgumentException();
                        }
                    }
                    if (type.endsWith("[]")) {
                        return new Array(Type.from(loader, type.substring(0, type.length() - 2)));
                    }
                    char first = type.charAt(0);
                    if (first == '[') {
                        return new Array(Type.from(loader, type.substring(1)));
                    }
                    if (first != 'L') break block42;
                    if (type.charAt(type.length() - 1) != ';') break block43;
                    desc = type.replace('.', '/');
                    break block44;
                }
                if (type.indexOf(47) <= 0) break block42;
                desc = type.replace('.', '/') + ";";
            }
            return new Clazz(loader, null, (String)desc, null);
        }
        if (type.charAt(type.length() - 1) == ';') {
            type = type.substring(0, type.length() - 1);
        }
        if ((name = type.replace('/', '.')).startsWith("java.lang.")) {
            try {
                return new JavaLang(Class.forName(name, true, loader));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new Clazz(loader, name, null, null);
    }

    static Type from(Class type) {
        ConcurrentHashMap<Object, Type> cache = Type.cache(type.getClassLoader());
        Type t = cache.get(type);
        return t != null ? t : Type.cachePut(cache, type, Type.find(type));
    }

    private static Type find(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return INT;
            }
            if (type == Long.TYPE) {
                return LONG;
            }
            if (type == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (type == Double.TYPE) {
                return DOUBLE;
            }
            if (type == Float.TYPE) {
                return FLOAT;
            }
            if (type == Byte.TYPE) {
                return BYTE;
            }
            if (type == Character.TYPE) {
                return CHAR;
            }
            if (type == Short.TYPE) {
                return SHORT;
            }
            return VOID;
        }
        if (type.isArray()) {
            Array arr = new Array(Type.from(type.getComponentType()));
            arr.mClass = type;
            return arr;
        }
        if (type.getPackageName().equals("java.lang")) {
            return new JavaLang(type);
        }
        return new Clazz(type);
    }

    static String makeDescriptor(Type returnType, List<Type> paramTypes) {
        StringBuilder b = new StringBuilder().append('(');
        for (Type type : paramTypes) {
            b.append(type.descriptor());
        }
        return b.append(')').append(returnType.descriptor()).toString();
    }

    static String makeDescriptor(Type returnType, Type[] paramTypes) {
        StringBuilder b = new StringBuilder().append('(');
        for (Type type : paramTypes) {
            b.append(type.descriptor());
        }
        return b.append(')').append(returnType.descriptor()).toString();
    }

    abstract boolean isPrimitive();

    final boolean isObject() {
        return !this.isPrimitive();
    }

    abstract boolean isInterface();

    abstract boolean isArray();

    abstract Type elementType();

    final int dimensions() {
        int dims = 0;
        for (Type type = this.elementType(); type != null; type = type.elementType()) {
            ++dims;
        }
        return dims;
    }

    final Type asArray() {
        return new Array(this);
    }

    abstract int stackMapCode();

    abstract int typeCode();

    abstract String name();

    abstract String descriptor();

    abstract Type box();

    abstract Type unbox();

    final int unboxTypeCode() {
        Type t = this.unbox();
        return t == null ? 10 : t.typeCode();
    }

    abstract boolean isAssignableFrom(Type var1);

    final int canConvertTo(Type to) {
        Type toUnboxed;
        if (this.equals(to)) {
            return 0;
        }
        if (this.isPrimitive()) {
            if (to.isPrimitive()) {
                switch (this.typeCode()) {
                    case 3: {
                        switch (to.typeCode()) {
                            case 5: 
                            case 6: {
                                return 0;
                            }
                            case 8: {
                                return 1;
                            }
                            case 7: {
                                return 2;
                            }
                            case 9: {
                                return 3;
                            }
                        }
                        return Integer.MAX_VALUE;
                    }
                    case 4: 
                    case 5: {
                        switch (to.typeCode()) {
                            case 6: {
                                return 0;
                            }
                            case 8: {
                                return 1;
                            }
                            case 7: {
                                return 2;
                            }
                            case 9: {
                                return 3;
                            }
                        }
                        return Integer.MAX_VALUE;
                    }
                    case 6: {
                        switch (to.typeCode()) {
                            case 8: {
                                return 1;
                            }
                            case 9: {
                                return 3;
                            }
                        }
                        return Integer.MAX_VALUE;
                    }
                    case 7: {
                        return to != DOUBLE ? Integer.MAX_VALUE : 4;
                    }
                }
                return Integer.MAX_VALUE;
            }
            Type toUnboxed2 = to.unbox();
            if (toUnboxed2 != null) {
                int code = this.canConvertTo(toUnboxed2);
                if (code != Integer.MAX_VALUE) {
                    code += 5;
                }
                return code;
            }
            if (to.isAssignableFrom(Type.from(Number.class))) {
                return 5;
            }
            return Integer.MAX_VALUE;
        }
        if (to.isObject() && to.isAssignableFrom(this)) {
            return 0;
        }
        Type thisUnboxed = this.unbox();
        if (thisUnboxed == null || (toUnboxed = to.unbox()) == null) {
            return Integer.MAX_VALUE;
        }
        int code = thisUnboxed.canConvertTo(toUnboxed);
        if (code != Integer.MAX_VALUE) {
            code += to.isObject() ? 10 : 15;
        }
        return code;
    }

    abstract Class clazz();

    boolean isHidden() {
        return false;
    }

    Type nonHiddenBase() {
        return this;
    }

    ClassMaker maker() {
        return null;
    }

    Type superType() {
        return null;
    }

    Set<Type> interfaces() {
        return null;
    }

    void resetInherited() {
    }

    void toInterface() {
    }

    Map<String, Field> fields() {
        return Collections.emptyMap();
    }

    final Field findField(String name) {
        Type type = this;
        do {
            Field field;
            if ((field = type.fields().get(name)) == null) continue;
            return field;
        } while ((type = type.superType()) != null);
        return null;
    }

    Field defineField(int flags, Type type, String name) {
        throw new IllegalStateException();
    }

    Field inventField(int flags, Type type, String name) {
        throw new IllegalStateException();
    }

    Map<MethodKey, Method> methods() {
        return Collections.emptyMap();
    }

    Set<Method> findMethods(String methodName, Type[] params, int inherit, int staticAllowed, Type specificReturnType, Type[] specificParamTypes) {
        return Collections.emptySet();
    }

    final Method findMethod(String methodName, Type[] params, int inherit, int staticAllowed, Type specificReturnType, Type[] specificParamTypes) {
        Set<Method> candidates = this.findMethods(methodName, params, inherit, staticAllowed, specificReturnType, specificParamTypes);
        if (candidates.size() == 1) {
            Type[] paramTypes;
            Method method = candidates.iterator().next();
            if (!method.isStatic() && method.isVarargs() && this.possiblySignaturePolymorphic(methodName) && (paramTypes = Type.verifyTypes(params, specificParamTypes)) != null) {
                Type returnType = specificReturnType != null ? specificReturnType : method.returnType();
                method = this.inventMethod(0, returnType, methodName, paramTypes);
            }
            return method;
        }
        if (candidates.isEmpty()) {
            Type[] paramTypes;
            Method method;
            if (specificReturnType != null && this.possiblySignaturePolymorphic(methodName) && (candidates = this.findMethods(methodName, params, -1, -1, null, null)).size() == 1 && (method = candidates.iterator().next()) != null && method.isVarargs() && (paramTypes = Type.verifyTypes(params, specificParamTypes)) != null) {
                return this.inventMethod(0, specificReturnType, methodName, paramTypes);
            }
            throw new IllegalStateException("No matching methods found for: " + this.name() + "." + methodName);
        }
        StringBuilder b = new StringBuilder().append("No best matching method found for: ").append(this.name()).append('.').append(methodName).append(". Remaining candidates: ");
        int amt = 0;
        for (Method m : candidates) {
            if (amt > 0) {
                b.append(", ");
            }
            b.append(m);
            ++amt;
        }
        throw new IllegalStateException(b.toString());
    }

    private boolean possiblySignaturePolymorphic(String methodName) {
        Class clazz = this.clazz();
        return clazz == MethodHandle.class && !methodName.equals("invokeWithArguments") || clazz == VarHandle.class;
    }

    private static Type[] verifyTypes(Type[] params, Type[] specificParamTypes) {
        if (specificParamTypes != null && params.length == specificParamTypes.length) {
            for (int i = 0; i < specificParamTypes.length; ++i) {
                if (specificParamTypes[i].isAssignableFrom(params[i])) continue;
                return null;
            }
            return specificParamTypes;
        }
        return params;
    }

    Method defineMethod(int flags, Type returnType, String name, Type ... paramTypes) {
        throw new IllegalStateException();
    }

    Method inventMethod(int flags, Type returnType, String name, Type ... paramTypes) {
        throw new IllegalStateException();
    }

    static Type commonCatchType(Map<Type, List<Type>> catchMap) {
        int minPos = Integer.MIN_VALUE;
        for (Map.Entry<Type, List<Type>> entry : catchMap.entrySet()) {
            ArrayList<Type> list = new ArrayList<Type>();
            Type catchType = entry.getKey();
            do {
                list.add(catchType);
            } while ((catchType = catchType.superType()) != null);
            entry.setValue(list);
            minPos = Math.max(minPos, -list.size());
        }
        Type commonType = null;
        for (int pos = -1; pos >= minPos; --pos) {
            Iterator<Map.Entry<Type, List<Type>>> it = catchMap.entrySet().iterator();
            List<Type> list = it.next().getValue();
            Type levelType = list.get(list.size() + pos);
            while (it.hasNext()) {
                list = it.next().getValue();
                Type type = list.get(list.size() + pos);
                if (levelType.equals(type)) continue;
                return commonType;
            }
            commonType = levelType;
        }
        Iterator<Type> it = catchMap.keySet().iterator();
        while (it.hasNext()) {
            Type type = it.next();
            if (type == commonType) continue;
            it.remove();
        }
        return commonType;
    }

    public String toString() {
        return "Type {name=" + this.name() + ", descriptor=" + this.descriptor() + ", isPrimitive=" + this.isPrimitive() + ", isInterface=" + this.isInterface() + ", isArray=" + this.isArray() + ", elementType=" + this.toString(this.elementType()) + ", stackMapCode=" + this.stackMapCode() + ", typeCode=" + this.typeCode() + ", box=" + this.toString(this.box()) + ", unbox=" + this.toString(this.unbox()) + "}";
    }

    private String toString(Type type) {
        return type == null ? null : type.name();
    }

    private static synchronized ConcurrentHashMap<Object, Type> cache(ClassLoader loader) {
        ConcurrentHashMap<Object, Type> cache;
        SoftReference<ConcurrentHashMap<Object, Type>> cacheRef = cCacheMap.get(loader);
        if (cacheRef == null || (cache = cacheRef.get()) == null) {
            cache = new ConcurrentHashMap();
            cCacheMap.put(loader, new SoftReference<ConcurrentHashMap<Object, Type>>(cache));
        }
        return cache;
    }

    private static Type cachePut(ConcurrentHashMap<Object, Type> cache, Object key, Type type) {
        Type existing = cache.putIfAbsent(key, type);
        return existing == null ? type : existing;
    }

    static synchronized void clearCaches() {
        cCacheMap.clear();
    }

    private static final class NewClazz
    extends Clazz {
        private final WeakReference<TheClassMaker> mMakerRef;

        NewClazz(ClassLoader loader, TheClassMaker maker, String name) {
            super(loader, name, null, false);
            this.mMakerRef = new WeakReference<TheClassMaker>(maker);
        }

        @Override
        Class clazz() {
            return null;
        }

        @Override
        TheClassMaker maker() {
            return (TheClassMaker)this.mMakerRef.get();
        }

        @Override
        Type superType() {
            Type superType = this.mSuperType;
            if (superType == null) {
                this.mSuperType = superType = this.maker().superType();
            }
            return superType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Set<Type> interfaces() {
            Set<Type> interfaces = this.mInterfaces;
            if (interfaces == null) {
                NewClazz newClazz = this;
                synchronized (newClazz) {
                    interfaces = this.mInterfaces;
                    if (interfaces == null) {
                        this.mInterfaces = interfaces = this.maker().allInterfaces();
                    }
                }
            }
            return interfaces;
        }

        @Override
        void resetInherited() {
            this.mSuperType = null;
            this.mInterfaces = null;
        }

        @Override
        void toInterface() {
            this.mIsInterface = true;
        }
    }

    private static final class Array
    extends Obj {
        private final Type mElementType;
        private volatile String mName;
        private volatile String mDesc;
        private volatile Class mClass;

        private Array(Type elementType) {
            this.mElementType = elementType;
        }

        @Override
        boolean isInterface() {
            return false;
        }

        @Override
        boolean isArray() {
            return true;
        }

        @Override
        Type elementType() {
            return this.mElementType;
        }

        @Override
        String name() {
            Object name = this.mName;
            if (name == null) {
                this.mName = name = this.mElementType.name() + "[]";
            }
            return name;
        }

        @Override
        String descriptor() {
            Object desc = this.mDesc;
            if (desc == null) {
                this.mDesc = desc = "[" + this.mElementType.descriptor();
            }
            return desc;
        }

        @Override
        Type unbox() {
            return null;
        }

        @Override
        boolean isAssignableFrom(Type other) {
            return other == Null.THE || this.equals(other) || other.isArray() && this.elementType().isAssignableFrom(other.elementType());
        }

        @Override
        Class clazz() {
            Class element;
            Class<?> clazz = this.mClass;
            if (clazz == null && (element = this.mElementType.clazz()) != null) {
                this.mClass = clazz = java.lang.reflect.Array.newInstance(element, 0).getClass();
            }
            return clazz;
        }

        @Override
        Type superType() {
            return Array.from(Object.class);
        }

        @Override
        Set<Method> findMethods(String methodName, Type[] params, int inherit, int staticAllowed, Type specificReturnType, Type[] specificParamTypes) {
            return this.superType().findMethods(methodName, params, inherit, staticAllowed, specificReturnType, specificParamTypes);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Array)) return false;
            Array other = (Array)obj;
            if (!this.mElementType.equals(other.mElementType)) return false;
            return true;
        }

        public int hashCode() {
            return this.mElementType.hashCode() * 31;
        }
    }

    private static class Clazz
    extends Obj {
        private final ClassLoader mLoader;
        private volatile Class mClass;
        private volatile String mName;
        private volatile String mDesc;
        protected volatile Boolean mIsInterface;
        protected volatile Type mSuperType;
        protected volatile Set<Type> mInterfaces;
        private volatile ConcurrentHashMap<String, Field> mFields;
        private volatile ConcurrentHashMap<MethodKey, Method> mMethods;
        private volatile ConcurrentHashMap<String, Map<FindKey, Set<Method>>> mFindMethods;

        Clazz(Class clazz) {
            this(clazz.getClassLoader(), clazz.getName(), null, clazz.isInterface());
            this.mClass = clazz;
        }

        Clazz(ClassLoader loader, String name, String desc, Boolean isInterface) {
            this.mLoader = loader;
            this.mName = name;
            this.mDesc = desc;
            this.mIsInterface = isInterface;
        }

        @Override
        final boolean isInterface() {
            Boolean is = this.mIsInterface;
            if (is == null) {
                Class clazz = this.clazz();
                this.mIsInterface = is = Boolean.valueOf(clazz != null && clazz.isInterface());
            }
            return is;
        }

        @Override
        final boolean isArray() {
            return false;
        }

        @Override
        final Type elementType() {
            return null;
        }

        @Override
        final String name() {
            String name = this.mName;
            if (name == null) {
                String desc = this.mDesc;
                int end = desc.length();
                if (desc.charAt(end - 1) == ';') {
                    --end;
                }
                this.mName = name = desc.substring(1, end).replace('/', '.');
            }
            return name;
        }

        @Override
        final String descriptor() {
            Object desc = this.mDesc;
            if (desc == null) {
                this.mDesc = desc = "L" + this.mName.replace('.', '/') + ";";
            }
            return desc;
        }

        @Override
        Type unbox() {
            return null;
        }

        @Override
        boolean isAssignableFrom(Type other) {
            if (other == Null.THE || this.equals(other)) {
                return true;
            }
            Class thisClass = this.clazz();
            Class otherClass = other.clazz();
            if (thisClass != null && otherClass != null) {
                return thisClass.isAssignableFrom(otherClass);
            }
            if (other.isPrimitive()) {
                return false;
            }
            if (thisClass == Object.class) {
                return true;
            }
            Type otherSuperType = other.superType();
            if (otherSuperType != null && this.isAssignableFrom(otherSuperType)) {
                return true;
            }
            Set<Type> interfaces = other.interfaces();
            if (interfaces != null) {
                for (Type iface : interfaces) {
                    if (!this.isAssignableFrom(iface)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        Class clazz() {
            Class<?> clazz = this.mClass;
            if (clazz == null) {
                try {
                    this.mClass = clazz = Class.forName(this.name(), true, this.mLoader);
                }
                catch (ClassNotFoundException | LinkageError throwable) {
                    // empty catch block
                }
            }
            return clazz;
        }

        @Override
        boolean isHidden() {
            Class clazz = this.clazz();
            return clazz != null && clazz.isHidden();
        }

        @Override
        Type nonHiddenBase() {
            Class clazz = this.clazz();
            return clazz == null || !clazz.isHidden() ? this : Clazz.findNonHiddenBase(clazz);
        }

        private static Type findNonHiddenBase(Class clazz) {
            while ((clazz = clazz.getSuperclass()).isHidden()) {
            }
            return Type.from(clazz);
        }

        @Override
        Type superType() {
            Type superType;
            block2: {
                Class<Object> clazz;
                block3: {
                    superType = this.mSuperType;
                    if (superType != null || (clazz = this.clazz()) == null) break block2;
                    if ((clazz = clazz.getSuperclass()) != null) break block3;
                    if (!this.isInterface()) break block2;
                    clazz = Object.class;
                }
                this.mSuperType = superType = Clazz.from(clazz);
            }
            return superType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Set<Type> interfaces() {
            Set<Type> interfaces = this.mInterfaces;
            if (interfaces == null) {
                Clazz clazz = this;
                synchronized (clazz) {
                    Class clazz2;
                    interfaces = this.mInterfaces;
                    if (interfaces == null && (clazz2 = this.clazz()) != null) {
                        Set<Type> all = Clazz.allInterfaces(null, clazz2);
                        this.mInterfaces = interfaces = all == null ? Collections.emptySet() : all;
                    }
                }
            }
            return interfaces;
        }

        private static Set<Type> allInterfaces(Set<Type> all, Class clazz) {
            Class superclass;
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces != null && interfaces.length != 0) {
                if (all == null) {
                    all = new LinkedHashSet<Type>(1);
                }
                for (Class<?> iface : interfaces) {
                    all.add(Type.from(iface));
                }
                for (Class<?> iface : interfaces) {
                    all = Clazz.allInterfaces(all, iface);
                }
            }
            if ((superclass = clazz.getSuperclass()) != null) {
                all = Clazz.allInterfaces(all, superclass);
            }
            return all;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Map<String, Field> fields() {
            Map<String, Field> fields = this.mFields;
            if (fields == null) {
                Clazz clazz = this;
                synchronized (clazz) {
                    fields = this.mFields;
                    if (fields == null) {
                        fields = this.initFields();
                    }
                }
            }
            return fields;
        }

        @Override
        Field defineField(int flags, Type type, String name) {
            return this.defineField(false, flags, type, name);
        }

        @Override
        Field inventField(int flags, Type type, String name) {
            return this.defineField(true, flags, type, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Field defineField(boolean invent, int flags, Type type, String name) {
            Field existing;
            Field field = new Field(flags, type, name);
            Clazz clazz = this;
            synchronized (clazz) {
                Map<String, Field> fields = this.mFields;
                if (fields == null) {
                    fields = this.initFields();
                }
                if (field.equals(existing = (Field)fields.get(name))) {
                    return existing;
                }
                if (existing == null) {
                    if (!invent) {
                        fields.put(name, field);
                    }
                    return field;
                }
            }
            if (invent) {
                return existing;
            }
            throw new IllegalStateException("Conflicting field exists: " + existing);
        }

        private Map<String, Field> initFields() {
            ConcurrentHashMap<String, Field> fields = new ConcurrentHashMap<String, Field>();
            Class clazz = this.clazz();
            if (clazz != null) {
                for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
                    int flags = field.getModifiers();
                    String name = field.getName();
                    Type type = Clazz.from(field.getType());
                    fields.put(name, new Field(flags, type, name));
                }
            }
            this.mFields = fields;
            return this.mFields;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Map<MethodKey, Method> methods() {
            Map<MethodKey, Method> methods = this.mMethods;
            if (methods == null) {
                Clazz clazz = this;
                synchronized (clazz) {
                    methods = this.mMethods;
                    if (methods == null) {
                        methods = this.initMethods();
                    }
                }
            }
            return methods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Set<Method> findMethods(String methodName, Type[] params, int inherit, int staticAllowed, Type specificReturnType, Type[] specificParamTypes) {
            FindKey findKey;
            Set<Method> results;
            Map<FindKey, Set<Method>> existing;
            Map<FindKey, Set<Method>> subMap;
            Type type = this;
            if (inherit > 0 && (type = ((Type)type).superType()) == null) {
                return Collections.emptySet();
            }
            ConcurrentHashMap<String, Map<FindKey, Set<Method>>> findMethods = this.mFindMethods;
            if (findMethods == null) {
                Clazz clazz = this;
                synchronized (clazz) {
                    findMethods = this.mFindMethods;
                    if (findMethods == null) {
                        this.mFindMethods = findMethods = new ConcurrentHashMap();
                    }
                }
            }
            if ((subMap = findMethods.get(methodName)) == null && (existing = findMethods.putIfAbsent(methodName, subMap = new ConcurrentHashMap<FindKey, Set<Method>>())) != null) {
                subMap = existing;
            }
            if ((results = subMap.get(findKey = new FindKey(params, inherit, staticAllowed, specificReturnType, specificParamTypes))) != null) {
                return results;
            }
            results = Clazz.doFindMethods(type, methodName, params, inherit, staticAllowed, specificReturnType, specificParamTypes);
            subMap.put(findKey, results);
            return results;
        }

        private void uncacheFindMethod(String methodName) {
            ConcurrentHashMap<String, Map<FindKey, Set<Method>>> findMethods = this.mFindMethods;
            if (findMethods != null) {
                findMethods.remove(methodName);
            }
        }

        private static Set<Method> doFindMethods(Type type, String methodName, Type[] params, int inherit, int staticAllowed, Type specificReturnType, Type[] specificParamTypes) {
            Set<Type> interfaces;
            if (methodName.equals("<clinit>")) {
                return Collections.emptySet();
            }
            LinkedHashSet<Method> methods = new LinkedHashSet<Method>(4);
            Clazz.addMethods(methods, type, methodName, params, staticAllowed);
            if (inherit >= 0) {
                for (Type superType = type.superType(); superType != null; superType = superType.superType()) {
                    Clazz.addMethods(methods, superType, methodName, params, staticAllowed);
                }
            }
            if (inherit == 0 && (interfaces = type.interfaces()) != null) {
                for (Type iface : interfaces) {
                    Clazz.addMethods(methods, iface, methodName, params, staticAllowed);
                }
            }
            if (specificReturnType != null && !methods.isEmpty()) {
                methods.removeIf(m -> !specificReturnType.equals(m.returnType()));
            }
            if (specificParamTypes != null && !methods.isEmpty()) {
                methods.removeIf(m -> !Arrays.equals(specificParamTypes, m.paramTypes()));
            }
            if (methods.size() > 1) {
                Iterator it = methods.iterator();
                Method best = (Method)it.next();
                LinkedHashSet<Method> bestSet = new LinkedHashSet<Method>(1);
                bestSet.add(best);
                while (it.hasNext()) {
                    Method candidate = (Method)it.next();
                    int cmp = Candidate.compare(params, best, candidate);
                    if (cmp < 0) continue;
                    if (cmp > 0) {
                        best = candidate;
                        bestSet.clear();
                        bestSet.add(best);
                        continue;
                    }
                    bestSet.add(candidate);
                }
                methods = bestSet;
            }
            if (methods.size() > 1) {
                int nonBridges = 0;
                int bridges = 0;
                for (Method m2 : methods) {
                    if (m2.isBridge()) {
                        ++bridges;
                        continue;
                    }
                    ++nonBridges;
                }
                if (nonBridges > 0 && bridges > 0) {
                    methods.removeIf(Method::isBridge);
                }
            }
            if (methods.isEmpty()) {
                return Collections.emptySet();
            }
            return methods;
        }

        private static void addMethods(Set<Method> methods, Type type, String methodName, Type[] params, int staticAllowed) {
            block0: for (Method m : type.methods().values()) {
                if (!m.name().equals(methodName) || (m.isStatic() ? staticAllowed < 0 : staticAllowed > 0)) continue;
                Type[] actualParams = m.paramTypes();
                if (!m.isVarargs()) {
                    if (actualParams.length != params.length) continue;
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i].canConvertTo(actualParams[i]) == Integer.MAX_VALUE) continue block0;
                    }
                } else {
                    if (params.length < actualParams.length - 1) continue;
                    Type varType = actualParams[actualParams.length - 1].elementType();
                    for (int i = 0; i < params.length; ++i) {
                        Type actual;
                        Type type2 = actual = i < actualParams.length - 1 ? actualParams[i] : varType;
                        if (params[i].canConvertTo(actual) != Integer.MAX_VALUE) continue;
                        if (i != actualParams.length - 1 || params[i].canConvertTo(actualParams[i]) == Integer.MAX_VALUE) continue block0;
                        break;
                    }
                }
                methods.add(m);
            }
        }

        @Override
        Method defineMethod(int flags, Type returnType, String name, Type ... paramTypes) {
            return this.defineMethod(false, flags, returnType, name, paramTypes);
        }

        @Override
        Method inventMethod(int flags, Type returnType, String name, Type ... paramTypes) {
            return this.defineMethod(true, flags, returnType, name, paramTypes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Method defineMethod(boolean invent, int flags, Type returnType, String name, Type ... paramTypes) {
            Method existing;
            MethodKey key = new MethodKey(returnType, name, paramTypes);
            Method method = new Method(flags, returnType, name, paramTypes);
            Clazz clazz = this;
            synchronized (clazz) {
                Map<MethodKey, Method> methods = this.mMethods;
                if (methods == null) {
                    methods = this.initMethods();
                }
                if (method.equals(existing = (Method)methods.get(key))) {
                    return existing;
                }
                if (existing == null) {
                    if (!invent) {
                        methods.put(key, method);
                        this.uncacheFindMethod(name);
                    }
                    return method;
                }
            }
            if (invent) {
                return existing;
            }
            throw new IllegalStateException("Conflicting method exists: " + existing);
        }

        private Map<MethodKey, Method> initMethods() {
            ConcurrentHashMap<MethodKey, Method> methods = new ConcurrentHashMap<MethodKey, Method>();
            Class clazz = this.clazz();
            if (clazz != null) {
                for (java.lang.reflect.Method method : clazz.getDeclaredMethods()) {
                    this.addMethod(methods, method.getName(), method, Clazz.from(method.getReturnType()));
                }
                for (Executable executable : clazz.getDeclaredConstructors()) {
                    this.addMethod(methods, "<init>", executable, VOID);
                }
            }
            this.mMethods = methods;
            return this.mMethods;
        }

        private void addMethod(Map<MethodKey, Method> methods, String name, Executable method, Type returnType) {
            int flags = method.getModifiers();
            Class<?>[] params = method.getParameterTypes();
            Type[] paramTypes = new Type[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = Clazz.from(params[i]);
            }
            MethodKey key = new MethodKey(returnType, name, paramTypes);
            methods.put(key, new Method(flags, returnType, name, paramTypes));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof Clazz)) return false;
            Clazz other = (Clazz)obj;
            if (!this.name().equals(other.name())) return false;
            return true;
        }

        public int hashCode() {
            return this.name().hashCode();
        }

        private static final class FindKey {
            final Type[] params;
            final int inherit;
            final int staticAllowed;
            final Type specificReturnType;
            final Type[] specificParamTypes;
            final int hash;

            FindKey(Type[] params, int inherit, int staticAllowed, Type specificReturnType, Type[] specificParamTypes) {
                this.params = params;
                this.inherit = inherit;
                this.staticAllowed = staticAllowed;
                this.specificReturnType = specificReturnType;
                this.specificParamTypes = specificParamTypes;
                int hash = Arrays.hashCode(params);
                hash = hash * 31 + Objects.hashCode(specificReturnType);
                hash = hash * 31 + Arrays.hashCode(specificParamTypes);
                hash += inherit;
                this.hash = hash += staticAllowed << 1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object obj) {
                if (this == obj) return true;
                if (!(obj instanceof FindKey)) return false;
                FindKey other = (FindKey)obj;
                if (!Arrays.equals(this.params, other.params)) return false;
                if (this.inherit != other.inherit) return false;
                if (this.staticAllowed != other.staticAllowed) return false;
                if (!Objects.equals(this.specificReturnType, other.specificReturnType)) return false;
                if (!Arrays.equals(this.specificParamTypes, other.specificParamTypes)) return false;
                return true;
            }

            public int hashCode() {
                return this.hash;
            }
        }
    }

    private static final class JavaLang
    extends Clazz {
        private volatile Type mUnbox;

        JavaLang(Class clazz) {
            super(clazz);
        }

        @Override
        Type unbox() {
            Type unbox = this.mUnbox;
            if (unbox == null) {
                switch (this.name().substring(10)) {
                    case "Boolean": {
                        unbox = BOOLEAN;
                        break;
                    }
                    case "Byte": {
                        unbox = BYTE;
                        break;
                    }
                    case "Short": {
                        unbox = SHORT;
                        break;
                    }
                    case "Character": {
                        unbox = CHAR;
                        break;
                    }
                    case "Integer": {
                        unbox = INT;
                        break;
                    }
                    case "Float": {
                        unbox = FLOAT;
                        break;
                    }
                    case "Double": {
                        unbox = DOUBLE;
                        break;
                    }
                    case "Long": {
                        unbox = LONG;
                        break;
                    }
                    case "Void": {
                        unbox = VOID;
                    }
                }
                this.mUnbox = unbox;
            }
            return unbox;
        }
    }

    final class Field
    extends Member {
        private final Type mType;

        Field(int flags, Type type, String name) {
            super(flags, name);
            Objects.requireNonNull(type);
            this.mType = type;
        }

        Type type() {
            return this.mType;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Field)) return false;
            Field other = (Field)obj;
            if (!this.name().equals(other.name())) return false;
            if (!this.type().equals(other.type())) return false;
            if (this.isStatic() != other.isStatic()) return false;
            return true;
        }

        public String toString() {
            return "Field {name=" + this.name() + ", type=" + this.type().name() + ", isPrivate=" + this.isPrivate() + ", isStatic=" + this.isStatic() + ", isFinal=" + this.isFinal() + ", enclosingType=" + this.enclosingType().name() + "}";
        }
    }

    final class Method
    extends Member {
        private final Type mReturnType;
        private final Type[] mParamTypes;
        private int mHash;
        private volatile String mDesc;

        Method(int flags, Type returnType, String name, Type ... paramTypes) {
            super(flags, name);
            Objects.requireNonNull(returnType);
            Objects.requireNonNull(paramTypes);
            this.mReturnType = returnType;
            this.mParamTypes = paramTypes;
        }

        boolean isBridge() {
            return (this.mFlags & 0x40) != 0;
        }

        void toBridge() {
            this.mFlags |= 0x40;
        }

        boolean isVarargs() {
            return (this.mFlags & 0x80) != 0;
        }

        void toVarargs() {
            this.mFlags |= 0x80;
        }

        Type returnType() {
            return this.mReturnType;
        }

        Type[] paramTypes() {
            return this.mParamTypes;
        }

        String descriptor() {
            String desc = this.mDesc;
            if (desc == null) {
                this.mDesc = desc = Type.makeDescriptor(this.mReturnType, this.mParamTypes);
            }
            return desc;
        }

        String signature() {
            StringBuilder b = new StringBuilder().append(this.returnType().name()).append(' ').append(this.name());
            this.appendParams(b);
            return b.toString();
        }

        Method tryNonHidden() {
            Type type = this.enclosingType();
            if (!type.isHidden()) {
                return this;
            }
            if ((this.mFlags & 0xA) != 0 || "<init>".equals(this.name())) {
                return null;
            }
            MethodKey key = new MethodKey(this.returnType(), this.name(), this.paramTypes());
            for (Type s = type.superType(); s != null; s = s.superType()) {
                Method parent = s.methods().get(key);
                if (parent == null || !parent.allowHiddenOverride()) continue;
                return parent;
            }
            for (Type iface : type.interfaces()) {
                Method parent = iface.methods().get(key);
                if (parent == null || !parent.allowHiddenOverride()) continue;
                return parent;
            }
            return null;
        }

        private boolean allowHiddenOverride() {
            return (this.mFlags & 0x1A) == 0 && !this.isPackagePrivate() && !this.enclosingType().isHidden();
        }

        @Override
        public int hashCode() {
            int hash = this.mHash;
            if (hash == 0) {
                hash = this.name().hashCode();
                hash = hash * 31 + this.mReturnType.hashCode();
                this.mHash = hash = hash * 31 + Arrays.hashCode(this.mParamTypes);
            }
            return hash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Method)) return false;
            Method other = (Method)obj;
            if (!this.name().equals(other.name())) return false;
            if (!this.returnType().equals(other.returnType())) return false;
            if (this.isStatic() != other.isStatic()) return false;
            if (!Arrays.equals(this.mParamTypes, other.mParamTypes)) return false;
            return true;
        }

        public String toString() {
            return "Method {name=" + this.name() + ", returnType=" + this.returnType().name() + ", paramTypes=" + this.paramsToString() + ", isPrivate=" + this.isPrivate() + ", isStatic=" + this.isStatic() + ", isFinal=" + this.isFinal() + ", isBridge=" + this.isBridge() + ", enclosingType=" + this.enclosingType().name() + "}";
        }

        private String paramsToString() {
            StringBuilder b = new StringBuilder();
            this.appendParams(b);
            return b.toString();
        }

        private void appendParams(StringBuilder b) {
            b.append('(');
            for (int i = 0; i < this.mParamTypes.length; ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.mParamTypes[i].name());
            }
            b.append(')');
        }
    }

    private static final class Primitive
    extends Type {
        private final int mStackMapCode;
        private final int mTypeCode;
        private volatile SoftReference<Type> mBoxRef;

        private Primitive(int stackMapCode, int typeCode) {
            this.mStackMapCode = stackMapCode;
            this.mTypeCode = typeCode;
        }

        @Override
        boolean isPrimitive() {
            return true;
        }

        @Override
        boolean isInterface() {
            return false;
        }

        @Override
        boolean isArray() {
            return false;
        }

        @Override
        Type elementType() {
            return null;
        }

        @Override
        int stackMapCode() {
            return this.mStackMapCode;
        }

        @Override
        int typeCode() {
            return this.mTypeCode;
        }

        @Override
        String name() {
            return switch (this.mTypeCode) {
                default -> "void";
                case 2 -> "boolean";
                case 3 -> "byte";
                case 4 -> "char";
                case 5 -> "short";
                case 6 -> "int";
                case 7 -> "float";
                case 8 -> "long";
                case 9 -> "double";
            };
        }

        @Override
        String descriptor() {
            return switch (this.mTypeCode) {
                default -> "V";
                case 2 -> "Z";
                case 3 -> "B";
                case 4 -> "C";
                case 5 -> "S";
                case 6 -> "I";
                case 7 -> "F";
                case 8 -> "J";
                case 9 -> "D";
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Type box() {
            Type box;
            SoftReference<Type> boxRef = this.mBoxRef;
            if (boxRef == null || (box = boxRef.get()) == null) {
                Primitive primitive = this;
                synchronized (primitive) {
                    boxRef = this.mBoxRef;
                    if (boxRef == null || (box = boxRef.get()) == null) {
                        box = switch (this.mTypeCode) {
                            default -> Primitive.from(Void.class);
                            case 2 -> Primitive.from(Boolean.class);
                            case 3 -> Primitive.from(Byte.class);
                            case 4 -> Primitive.from(Character.class);
                            case 5 -> Primitive.from(Short.class);
                            case 6 -> Primitive.from(Integer.class);
                            case 7 -> Primitive.from(Float.class);
                            case 8 -> Primitive.from(Long.class);
                            case 9 -> Primitive.from(Double.class);
                        };
                        this.mBoxRef = new SoftReference<Type>(box);
                    }
                }
            }
            return box;
        }

        @Override
        Type unbox() {
            return this;
        }

        @Override
        boolean isAssignableFrom(Type other) {
            return this.equals(other);
        }

        @Override
        Class clazz() {
            return switch (this.mTypeCode) {
                default -> Void.TYPE;
                case 2 -> Boolean.TYPE;
                case 3 -> Byte.TYPE;
                case 4 -> Character.TYPE;
                case 5 -> Short.TYPE;
                case 6 -> Integer.TYPE;
                case 7 -> Float.TYPE;
                case 8 -> Long.TYPE;
                case 9 -> Double.TYPE;
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Primitive)) return false;
            Primitive other = (Primitive)obj;
            if (this.mTypeCode != other.mTypeCode) return false;
            return true;
        }

        public int hashCode() {
            return this.mTypeCode;
        }
    }

    static final class Null
    extends Obj {
        static final Null THE = new Null();

        Null() {
        }

        @Override
        boolean isInterface() {
            return false;
        }

        @Override
        boolean isArray() {
            return false;
        }

        @Override
        Type elementType() {
            return null;
        }

        @Override
        int stackMapCode() {
            return 5;
        }

        @Override
        String name() {
            return Object.class.getName();
        }

        @Override
        String descriptor() {
            return Object.class.descriptorString();
        }

        @Override
        Type unbox() {
            return null;
        }

        @Override
        boolean isAssignableFrom(Type other) {
            return this.equals(other);
        }

        @Override
        Class clazz() {
            return null;
        }
    }

    private static abstract class Obj
    extends Type {
        private Obj() {
        }

        @Override
        final boolean isPrimitive() {
            return false;
        }

        @Override
        int stackMapCode() {
            return 7;
        }

        @Override
        final int typeCode() {
            return 10;
        }

        @Override
        final Type box() {
            return this;
        }
    }

    static final class MethodKey {
        final Type returnType;
        final String name;
        final Type[] paramTypes;

        MethodKey(Type returnType, String name, Type ... paramTypes) {
            this.returnType = returnType;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof MethodKey)) return false;
            MethodKey other = (MethodKey)obj;
            if (!this.name.equals(other.name)) return false;
            if (!this.returnType.equals(other.returnType)) return false;
            if (!Arrays.equals(this.paramTypes, other.paramTypes)) return false;
            return true;
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + Arrays.hashCode(this.paramTypes);
        }
    }

    abstract class Member {
        protected int mFlags;
        private final String mName;

        Member(int flags, String name) {
            Objects.requireNonNull(name);
            this.mFlags = flags;
            this.mName = name;
        }

        final Type enclosingType() {
            return Type.this;
        }

        final boolean isPrivate() {
            return (this.mFlags & 2) != 0;
        }

        final void toPrivate() {
            this.mFlags |= 2;
        }

        final boolean isPackagePrivate() {
            return (this.mFlags & 7) == 0;
        }

        final boolean isStatic() {
            return (this.mFlags & 8) != 0;
        }

        final void toStatic() {
            this.mFlags |= 8;
        }

        final boolean isFinal() {
            return (this.mFlags & 0x10) != 0;
        }

        final void toFinal() {
            this.mFlags |= 0x10;
        }

        final String name() {
            return this.mName;
        }

        public int hashCode() {
            return this.name().hashCode();
        }
    }
}

