/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.maker;

import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

final class WeakCache<K, V>
extends ReferenceQueue<Object> {
    private Entry<K, V>[] mEntries = new Entry[2];
    private int mSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Reference ref = this.poll();
        if (ref != null) {
            WeakCache weakCache = this;
            synchronized (weakCache) {
                this.cleanup(ref);
            }
        }
        Entry<K, V>[] entries = this.mEntries;
        Entry<K, V> e = entries[key.hashCode() & entries.length - 1];
        while (e != null) {
            if (e.mKey.equals(key)) {
                return (V)e.get();
            }
            e = e.mNext;
        }
        return null;
    }

    public synchronized V put(K key, V value) {
        Reference ref = this.poll();
        if (ref != null) {
            this.cleanup(ref);
        }
        Entry<K, V>[] entries = this.mEntries;
        int hash = key.hashCode();
        int index = hash & entries.length - 1;
        Entry<K, V> e = entries[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (e.mKey.equals(key)) {
                Object replaced = e.get();
                if (replaced != null) {
                    e.clear();
                }
                Entry<K, V> newEntry = new Entry<K, V>(key, value, hash, this);
                if (prev == null) {
                    newEntry.mNext = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                    newEntry.mNext = entries[index];
                }
                VarHandle.storeStoreFence();
                entries[index] = newEntry;
                return (V)replaced;
            }
            prev = e;
            e = e.mNext;
        }
        if (this.mSize >= entries.length) {
            Entry[] newEntries = new Entry[entries.length << 1];
            int size = 0;
            int i = entries.length;
            while (--i >= 0) {
                Entry<K, V> existing = entries[i];
                while (existing != null) {
                    Entry<K, V> e2 = existing;
                    existing = existing.mNext;
                    if (e2.get() == null) continue;
                    ++size;
                    index = e2.mHash & newEntries.length - 1;
                    e2.mNext = newEntries[index];
                    newEntries[index] = e2;
                }
            }
            entries = newEntries;
            this.mEntries = newEntries;
            this.mSize = size;
            index = hash & entries.length - 1;
        }
        Entry<K, V> newEntry = new Entry<K, V>(key, value, hash, this);
        newEntry.mNext = entries[index];
        VarHandle.storeStoreFence();
        entries[index] = newEntry;
        ++this.mSize;
        return null;
    }

    private void cleanup(Object ref) {
        Entry<K, V>[] entries = this.mEntries;
        block0: do {
            Entry cleared = (Entry)ref;
            int ix = cleared.mHash & entries.length - 1;
            Entry<K, V> e = entries[ix];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e == cleared) {
                    if (prev == null) {
                        entries[ix] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                    --this.mSize;
                    continue block0;
                }
                prev = e;
                e = e.mNext;
            }
        } while ((ref = this.poll()) != null);
    }

    private static final class Entry<K, V>
    extends WeakReference<V> {
        final K mKey;
        final int mHash;
        Entry<K, V> mNext;

        Entry(K key, V value, int hash, WeakCache<K, V> cache) {
            super(value, cache);
            this.mKey = key;
            this.mHash = hash;
        }
    }
}

