/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.SessionAcceptor;
import org.cojen.dirmi.SessionConnector;
import org.cojen.dirmi.core.StandardSession;
import org.cojen.dirmi.core.StandardSessionAcceptor;
import org.cojen.dirmi.io.BasicChannelBrokerAcceptor;
import org.cojen.dirmi.io.BasicChannelBrokerConnector;
import org.cojen.dirmi.io.BufferedSocketChannelAcceptor;
import org.cojen.dirmi.io.BufferedSocketChannelConnector;
import org.cojen.dirmi.io.ChannelAcceptor;
import org.cojen.dirmi.io.ChannelBroker;
import org.cojen.dirmi.io.ChannelBrokerAcceptor;
import org.cojen.dirmi.io.ChannelBrokerConnector;
import org.cojen.dirmi.io.ChannelConnector;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.PipedChannelBroker;
import org.cojen.dirmi.io.RecyclableSocketChannelAcceptor;
import org.cojen.dirmi.io.RecyclableSocketChannelConnector;
import org.cojen.dirmi.io.RecyclableSocketChannelSelector;
import org.cojen.dirmi.io.SocketChannelSelector;
import org.cojen.dirmi.util.Cache;
import org.cojen.dirmi.util.ThreadPool;
import org.cojen.dirmi.util.Timer;
import org.cojen.util.ThrowUnchecked;

public class Environment
implements Closeable {
    private static final boolean RECYCLABLE_SOCKETS;
    private final ScheduledExecutorService mExecutor;
    private final IOExecutor mIOExecutor;
    private final Cache<Closeable, Object> mCloseableSet;
    private final AtomicBoolean mClosed;
    private final boolean mRecyclableSockets = RECYCLABLE_SOCKETS;
    private final SocketFactory mSocketFactory;
    private final ServerSocketFactory mServerSocketFactory;
    private final RecyclableSocketChannelSelector mSelector;
    private final ClassLoader mClassLoader;

    public Environment() {
        this(1000);
    }

    public Environment(int maxThreads) {
        this(maxThreads, null, null);
    }

    public Environment(int maxThreads, String threadNamePrefix, Thread.UncaughtExceptionHandler handler) {
        this(new ThreadPool(maxThreads, false, threadNamePrefix == null ? "dirmi" : threadNamePrefix, handler));
    }

    public Environment(ScheduledExecutorService executor) {
        this(executor, null, null, null, null, null, null, null);
    }

    private Environment(ScheduledExecutorService executor, IOExecutor ioExecutor, Cache<Closeable, Object> closeable, AtomicBoolean closed, SocketFactory sf, ServerSocketFactory ssf, RecyclableSocketChannelSelector selector, ClassLoader classLoader) {
        if (executor == null) {
            throw new IllegalArgumentException("Must provide an executor");
        }
        this.mExecutor = executor;
        IOExecutor iOExecutor = this.mIOExecutor = ioExecutor == null ? new IOExecutor(executor) : ioExecutor;
        if (closeable == null) {
            closeable = Cache.newWeakIdentityCache(17);
        }
        this.mCloseableSet = closeable;
        this.mClosed = closed == null ? new AtomicBoolean(false) : closed;
        this.mSocketFactory = sf;
        this.mServerSocketFactory = ssf;
        this.mSelector = selector;
        this.mClassLoader = classLoader;
    }

    public Environment withClientSocketFactory(SocketFactory sf) {
        if (this.mSelector != null) {
            throw new IllegalStateException("Cannot combine socket factory and selector");
        }
        return new Environment(this.mExecutor, this.mIOExecutor, this.mCloseableSet, this.mClosed, sf, this.mServerSocketFactory, null, this.mClassLoader);
    }

    public Environment withServerSocketFactory(ServerSocketFactory ssf) {
        if (this.mSelector != null) {
            throw new IllegalStateException("Cannot combine socket factory and selector");
        }
        return new Environment(this.mExecutor, this.mIOExecutor, this.mCloseableSet, this.mClosed, this.mSocketFactory, ssf, null, this.mClassLoader);
    }

    public Environment withSocketSelector() throws IOException {
        block6: {
            String version;
            int index;
            if (this.mSocketFactory != null || this.mServerSocketFactory != null) {
                throw new IllegalStateException("Cannot combine socket factory and selector");
            }
            if (!this.mRecyclableSockets) {
                throw new IllegalStateException("Cannot use unrecyclable sockets with selector");
            }
            if ("Linux".equals(System.getProperty("os.name")) && "Sun Microsystems Inc.".equals(System.getProperty("java.vendor")) && "1.6".equals(System.getProperty("java.specification.version")) && (index = (version = System.getProperty("java.version")).indexOf(95)) > 0) {
                int subVersion;
                try {
                    subVersion = Integer.parseInt(version.substring(index + 1));
                }
                catch (RuntimeException e) {
                    break block6;
                }
                if (subVersion < 18) {
                    throw new IOException("Java version doesn't have fix for bug 6693490: " + version);
                }
            }
        }
        final RecyclableSocketChannelSelector selector = new RecyclableSocketChannelSelector(this.mIOExecutor);
        this.addToClosableSet(selector);
        this.mIOExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    selector.selectLoop();
                }
                catch (IOException e) {
                    ThrowUnchecked.fire((Throwable)e);
                }
            }
        });
        return new Environment(this.mExecutor, this.mIOExecutor, this.mCloseableSet, this.mClosed, null, null, selector, this.mClassLoader);
    }

    public Environment withClassLoader(ClassLoader classLoader) {
        return new Environment(this.mExecutor, this.mIOExecutor, this.mCloseableSet, this.mClosed, this.mSocketFactory, this.mServerSocketFactory, this.mSelector, this.mClassLoader);
    }

    public SessionConnector newSessionConnector(String host, int port) {
        return this.newSessionConnector(new InetSocketAddress(host, port));
    }

    public SessionConnector newSessionConnector(SocketAddress remoteAddress) {
        return this.newSessionConnector(remoteAddress, null);
    }

    public SessionConnector newSessionConnector(SocketAddress remoteAddress, SocketAddress localAddress) {
        return new SocketConnector(remoteAddress, localAddress);
    }

    public SessionAcceptor newSessionAcceptor(int port) throws IOException {
        return this.newSessionAcceptor(new InetSocketAddress(port));
    }

    public SessionAcceptor newSessionAcceptor(SocketAddress localAddress) throws IOException {
        return StandardSessionAcceptor.create(this, this.newBrokerAcceptor(localAddress));
    }

    private ChannelBrokerAcceptor newBrokerAcceptor(SocketAddress localAddress) throws IOException {
        this.checkClosed();
        ChannelAcceptor channelAcceptor = this.newChannelAcceptor(localAddress);
        BasicChannelBrokerAcceptor brokerAcceptor = new BasicChannelBrokerAcceptor(this.mIOExecutor, channelAcceptor);
        this.addToClosableSet(brokerAcceptor);
        return brokerAcceptor;
    }

    public Session newSession(ChannelBroker broker) throws IOException {
        this.checkClosed();
        try {
            Session session = StandardSession.create(this.mIOExecutor, broker);
            this.addToClosableSet(session);
            if (this.mClassLoader != null) {
                session.setClassLoader(this.mClassLoader);
            }
            return session;
        }
        catch (IOException e) {
            broker.close();
            throw e;
        }
    }

    public Session newSession(ChannelBroker broker, long timeout, TimeUnit unit) throws IOException {
        return timeout < 0L ? this.newSession(broker) : this.newSession(broker, new Timer(timeout, unit));
    }

    Session newSession(ChannelBroker broker, Timer timer) throws IOException {
        this.checkClosed();
        try {
            Session session = StandardSession.create(this.mIOExecutor, broker, timer);
            this.addToClosableSet(session);
            if (this.mClassLoader != null) {
                session.setClassLoader(this.mClassLoader);
            }
            return session;
        }
        catch (IOException e) {
            broker.close();
            throw e;
        }
    }

    public Session[] newSessionPair() throws RejectedException {
        Session session_1;
        Session session_0;
        final ChannelBroker[] brokers = PipedChannelBroker.newPair(this.mIOExecutor);
        class Create
        implements Runnable {
            private IOException mException;
            private Session mSession;

            Create() {
            }

            @Override
            public synchronized void run() {
                try {
                    this.mSession = Environment.this.newSession(brokers[0]);
                }
                catch (IOException e) {
                    this.mException = e;
                }
                this.notifyAll();
            }

            public synchronized Session waitForSession() throws IOException {
                while (this.mException == null && this.mSession == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.mException != null) {
                    throw this.mException;
                }
                return this.mSession;
            }
        }
        Create create = new Create();
        this.mIOExecutor.execute(create);
        try {
            session_0 = this.newSession(brokers[1]);
            session_1 = create.waitForSession();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return new Session[]{session_0, session_1};
    }

    public ScheduledExecutorService executor() {
        return this.mExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList closeable;
        boolean wasClosed = this.mClosed.getAndSet(true);
        IOException exception = null;
        Cache<Closeable, Object> cache = this.mCloseableSet;
        synchronized (cache) {
            closeable = new ArrayList(this.mCloseableSet.size());
            this.mCloseableSet.copyKeysInto(closeable);
            this.mCloseableSet.clear();
        }
        for (int i = 1; i <= 3; ++i) {
            Iterator iterator = closeable.iterator();
            while (iterator.hasNext()) {
                Closeable c;
                if (i == 1 != (c = (Closeable)iterator.next()) instanceof Session || i == 3 != c instanceof SocketChannelSelector) continue;
                try {
                    c.close();
                }
                catch (IOException e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
        }
        if (!wasClosed) {
            this.mExecutor.shutdown();
        }
        if (exception != null) {
            throw exception;
        }
    }

    void checkClosed() throws IOException {
        if (this.mClosed.get()) {
            throw new IOException("Environment is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToClosableSet(Closeable c) throws IOException {
        try {
            Cache<Closeable, Object> cache = this.mCloseableSet;
            synchronized (cache) {
                this.checkClosed();
                this.mCloseableSet.put(c, "");
            }
        }
        catch (IOException e) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    ChannelAcceptor newChannelAcceptor(SocketAddress localAddress) throws IOException {
        RecyclableSocketChannelSelector selector = this.mSelector;
        if (selector != null) {
            return selector.newChannelAcceptor(localAddress);
        }
        ServerSocketFactory ssf = this.mServerSocketFactory;
        if (ssf == null) {
            ssf = ServerSocketFactory.getDefault();
        }
        ServerSocket ss = ssf.createServerSocket();
        if (this.mRecyclableSockets) {
            return new RecyclableSocketChannelAcceptor(this.mIOExecutor, localAddress, ss);
        }
        return new BufferedSocketChannelAcceptor(this.mIOExecutor, localAddress, ss);
    }

    ChannelConnector newChannelConnector(SocketAddress remoteAddress, SocketAddress localAddress) {
        RecyclableSocketChannelSelector selector = this.mSelector;
        if (selector != null) {
            return selector.newChannelConnector(remoteAddress, localAddress);
        }
        SocketFactory sf = this.mSocketFactory;
        if (sf == null) {
            sf = SocketFactory.getDefault();
        }
        if (this.mRecyclableSockets) {
            return new RecyclableSocketChannelConnector(this.mIOExecutor, remoteAddress, localAddress, sf);
        }
        return new BufferedSocketChannelConnector(this.mIOExecutor, remoteAddress, localAddress, sf);
    }

    static {
        boolean recyclableSockets = true;
        try {
            String prop = System.getProperty("org.cojen.dirmi.Environment.recyclableSockets");
            if (prop != null && prop.equalsIgnoreCase("false")) {
                recyclableSockets = false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        RECYCLABLE_SOCKETS = recyclableSockets;
    }

    private class SocketConnector
    implements SessionConnector {
        private final ChannelConnector mChannelConnector;
        private final ChannelBrokerConnector mBrokerConnector;

        SocketConnector(SocketAddress remoteAddress, SocketAddress localAddress) {
            if (remoteAddress == null) {
                throw new IllegalArgumentException("Must provide a remote address");
            }
            this.mChannelConnector = Environment.this.newChannelConnector(remoteAddress, localAddress);
            this.mBrokerConnector = new BasicChannelBrokerConnector(Environment.this.mIOExecutor, this.mChannelConnector);
        }

        @Override
        public Session connect() throws IOException {
            Environment.this.checkClosed();
            ChannelBroker broker = this.mBrokerConnector.connect();
            Environment.this.addToClosableSet(broker);
            try {
                return Environment.this.newSession(broker);
            }
            catch (IOException e) {
                broker.close();
                throw e;
            }
        }

        @Override
        public Session connect(long timeout, TimeUnit unit) throws IOException {
            if (timeout < 0L) {
                return this.connect();
            }
            Environment.this.checkClosed();
            Timer timer = new Timer(timeout, unit);
            ChannelBroker broker = this.mBrokerConnector.connect(timer);
            Environment.this.addToClosableSet(broker);
            try {
                return Environment.this.newSession(broker, timer);
            }
            catch (IOException e) {
                broker.close();
                throw e;
            }
        }

        @Override
        public Object getRemoteAddress() {
            return this.mChannelConnector.getRemoteAddress();
        }

        @Override
        public Object getLocalAddress() {
            return this.mChannelConnector.getLocalAddress();
        }

        public String toString() {
            String str = "SessionConnector {remoteAddress=" + this.getRemoteAddress();
            Object localAddress = this.getLocalAddress();
            if (localAddress != null) {
                str = str + ", localAddress=" + localAddress;
            }
            return str + '}';
        }
    }
}

