/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi;

import java.rmi.RemoteException;

public class ReconstructedException
extends RemoteException {
    private static final long serialVersionUID = 1L;
    private final Throwable mReconstructCause;

    private static String makeMessage(Throwable reconstructed, Throwable reconstructCause) {
        StringBuilder b = new StringBuilder("Reconstructed exception of type ").append(reconstructed.getClass().getName());
        if (reconstructed.getMessage() != null) {
            b.append(" with message \"").append(reconstructed.getMessage()).append('\"');
        }
        return b.append("; ").append(reconstructCause).toString();
    }

    private static String makeMessage(String reconstructedClassName, String message, Throwable reconstructCause) {
        StringBuilder b = new StringBuilder("Unable to reconstruct exception of type ").append(reconstructedClassName);
        if (message != null) {
            b.append(" with message \"").append(message).append('\"');
        }
        return b.append("; ").append(reconstructCause).toString();
    }

    public ReconstructedException(Throwable reconstructCause, Throwable reconstructed) {
        super(ReconstructedException.makeMessage(reconstructed, reconstructCause), reconstructed);
        this.mReconstructCause = reconstructCause;
    }

    public ReconstructedException(Throwable reconstructCause, String reconstructedClassName, String message, Throwable cause) {
        super(ReconstructedException.makeMessage(reconstructedClassName, message, reconstructCause), cause);
        this.mReconstructCause = reconstructCause;
    }

    @Override
    public Throwable getCause() {
        return super.getCause();
    }

    public Throwable getReconstructCause() {
        return this.mReconstructCause;
    }
}

