/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi;

import java.rmi.RemoteException;
import java.util.concurrent.RejectedExecutionException;

public class RejectedException
extends RemoteException {
    private final boolean mShutdown;

    public RejectedException(boolean isShutdown) {
        this(isShutdown, "Rejected");
    }

    public RejectedException(boolean isShutdown, String message) {
        super(message);
        this.mShutdown = isShutdown;
    }

    public RejectedException(boolean isShutdown, Throwable cause) {
        super(cause.getMessage(), cause);
        this.mShutdown = isShutdown;
    }

    public RejectedException(boolean isShutdown, String message, Throwable cause) {
        super(message, cause);
        this.mShutdown = isShutdown;
    }

    public RejectedException(String message, RejectedException cause) {
        super(message, RejectedException.getCause(cause));
        this.mShutdown = cause == null ? false : cause.isShutdown();
    }

    public boolean isShutdown() {
        return this.mShutdown;
    }

    public RuntimeException throwUncheckedException() {
        Throwable cause = this.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new RejectedExecutionException(this.getMessage());
    }

    private static Throwable getCause(RejectedException e) {
        if (e == null) {
            return null;
        }
        Throwable cause = e.getCause();
        return cause == null ? e : cause;
    }
}

