/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi;

import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.util.Timer;

public class RemoteTimeoutException
extends RemoteException {
    private static final long serialVersionUID = 1L;

    private static String createMessage(double timeout, TimeUnit unit) {
        return RemoteTimeoutException.createMessage(String.valueOf(timeout), unit, timeout != 1.0);
    }

    private static String createMessage(long timeout, TimeUnit unit) {
        return RemoteTimeoutException.createMessage(String.valueOf(timeout), unit, timeout != 1L);
    }

    private static String createMessage(String timeout, TimeUnit unit, boolean plural) {
        String unitString;
        if (unit == null) {
            unitString = null;
        } else {
            switch (unit) {
                case NANOSECONDS: {
                    unitString = "nanosecond";
                    break;
                }
                case MICROSECONDS: {
                    unitString = "microsecond";
                    break;
                }
                case MILLISECONDS: {
                    unitString = "millisecond";
                    break;
                }
                case SECONDS: {
                    unitString = "second";
                    break;
                }
                case MINUTES: {
                    unitString = "minute";
                    break;
                }
                case HOURS: {
                    unitString = "hour";
                    break;
                }
                case DAYS: {
                    unitString = "day";
                    break;
                }
                default: {
                    unitString = null;
                }
            }
        }
        if (unitString == null) {
            unitString = "(unknown time unit)";
        } else if (plural) {
            unitString = unitString + 's';
        }
        return "Timed out after " + timeout + ' ' + unitString;
    }

    public RemoteTimeoutException(long timeout, TimeUnit unit) {
        super(RemoteTimeoutException.createMessage(timeout, unit));
    }

    public RemoteTimeoutException(double timeout, TimeUnit unit) {
        super(RemoteTimeoutException.createMessage(timeout, unit));
    }

    public RemoteTimeoutException(Timer timer) {
        this(timer.duration(), timer.unit());
    }

    public static long checkRemaining(Timer timer) throws RemoteTimeoutException {
        long remaining = timer.remaining();
        if (remaining <= 0L) {
            throw new RemoteTimeoutException(timer);
        }
        return remaining;
    }
}

