/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;

abstract class AbstractIdentifier
implements Comparable<AbstractIdentifier>,
Serializable {
    private final long mBits;

    AbstractIdentifier(long bits) {
        this.mBits = bits;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.mBits);
    }

    public void write(OutputStream out) throws IOException {
        long bits = this.mBits;
        byte[] buf = new byte[]{(byte)(bits >>> 56), (byte)(bits >>> 48), (byte)(bits >>> 40), (byte)(bits >>> 32), (byte)(bits >>> 24), (byte)(bits >>> 16), (byte)(bits >>> 8), (byte)bits};
        out.write(buf, 0, 8);
    }

    public abstract Object tryRetrieve();

    public abstract <T> void register(T var1) throws IllegalArgumentException;

    byte getData() {
        return (byte)this.mBits;
    }

    public int hashCode() {
        return (int)(this.mBits ^ this.mBits >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractIdentifier) {
            AbstractIdentifier other = (AbstractIdentifier)obj;
            return this.mBits == other.mBits;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("0000000000000000");
        int end = b.length();
        String bits = Long.toHexString(this.mBits);
        b.replace(end - bits.length(), end, bits);
        return b.toString();
    }

    @Override
    public int compareTo(AbstractIdentifier id) {
        if (this != id) {
            if (this.mBits < id.mBits) {
                return -1;
            }
            if (this.mBits > id.mBits) {
                return 1;
            }
        }
        return 0;
    }

    abstract Object readResolve() throws ObjectStreamException;
}

