/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.ProtocolException;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.Completion;
import org.cojen.dirmi.ConnectException;
import org.cojen.dirmi.RemoteTimeoutException;
import org.cojen.dirmi.UnknownHostException;
import org.cojen.dirmi.core.InvocationChannel;
import org.cojen.dirmi.core.RemoteCompletionServer;
import org.cojen.dirmi.core.StubSupport;
import org.cojen.dirmi.core.VersionedIdentifier;

abstract class AbstractStubSupport
implements StubSupport {
    protected final VersionedIdentifier mObjId;

    AbstractStubSupport(VersionedIdentifier id) {
        this.mObjId = id;
    }

    AbstractStubSupport() {
        this.mObjId = VersionedIdentifier.identify(this);
    }

    @Override
    public <V> Completion<V> createCompletion(Object stub) {
        return new RemoteCompletionServer(stub);
    }

    @Override
    public <T extends Throwable> T failedAndCancelTimeout(Class<T> remoteFailureEx, InvocationChannel channel, Throwable cause, long timeout, TimeUnit unit) {
        if (!channel.cancelTimeout() && cause instanceof IOException) {
            cause = new RemoteTimeoutException(timeout, unit);
        }
        return this.failed(remoteFailureEx, channel, cause);
    }

    @Override
    public <T extends Throwable> T failedAndCancelTimeout(Class<T> remoteFailureEx, InvocationChannel channel, Throwable cause, double timeout, TimeUnit unit) {
        if (!channel.cancelTimeout() && cause instanceof IOException) {
            cause = new RemoteTimeoutException(timeout, unit);
        }
        return this.failed(remoteFailureEx, channel, cause);
    }

    @Override
    public int stubHashCode() {
        return this.mObjId.hashCode();
    }

    @Override
    public boolean stubEquals(StubSupport support) {
        if (this == support) {
            return true;
        }
        if (support instanceof AbstractStubSupport) {
            return this.mObjId.equals(((AbstractStubSupport)support).mObjId);
        }
        return false;
    }

    @Override
    public String stubToString() {
        return this.mObjId.toString();
    }

    protected <T extends Throwable> T remoteException(Class<T> remoteFailureEx, Throwable cause) {
        RemoteException ex;
        if (this.possibleCommunicationFailure(cause)) {
            this.checkCommunication(cause);
        }
        if (cause == null) {
            ex = new RemoteException();
        } else {
            if (cause instanceof EOFException) {
                cause = new ClosedException();
            }
            if (remoteFailureEx.isAssignableFrom(cause.getClass())) {
                return (T)cause;
            }
            if (cause instanceof RemoteException) {
                ex = (RemoteException)cause;
            } else {
                String message = cause.getMessage();
                if (message == null || (message = message.trim()).length() == 0) {
                    message = cause.toString();
                }
                ex = cause instanceof java.net.ConnectException ? new ConnectException(message, (Exception)cause) : (cause instanceof java.net.UnknownHostException ? new UnknownHostException(message, (Exception)cause) : new RemoteException(message, cause));
            }
        }
        if (!remoteFailureEx.isAssignableFrom(RemoteException.class)) {
            for (Constructor<?> ctor : remoteFailureEx.getConstructors()) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                if (paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(RemoteException.class)) continue;
                try {
                    return (T)((Throwable)ctor.newInstance(ex));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return (T)ex;
    }

    protected long toNanos(double timeout, TimeUnit unit) {
        double factor;
        switch (unit) {
            case NANOSECONDS: {
                factor = 1.0;
                break;
            }
            case MICROSECONDS: {
                factor = 1000.0;
                break;
            }
            case MILLISECONDS: {
                factor = 1000000.0;
                break;
            }
            case SECONDS: {
                factor = 1.0E9;
                break;
            }
            case MINUTES: {
                factor = 6.0E10;
                break;
            }
            case HOURS: {
                factor = 3.6E12;
                break;
            }
            case DAYS: {
                factor = 8.64E13;
                break;
            }
            default: {
                throw new IllegalArgumentException(unit.toString());
            }
        }
        return (long)(timeout * factor);
    }

    protected boolean possibleCommunicationFailure(Throwable cause) {
        return cause instanceof IOException && (cause instanceof SocketException || cause instanceof ProtocolException || cause instanceof java.net.UnknownHostException);
    }

    protected abstract void checkCommunication(Throwable var1);
}

