/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.RemoteFailure;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.util.Cache;
import org.cojen.dirmi.util.ScheduledTask;

class ClassDescriptorCache {
    private final IOExecutor mExecutor;
    private final ReadWriteLock mLock;
    private final Cache<Key, Reference> mRemoteReferences;
    private Handle mRemoteHandle;
    private Map<Key, ObjectStreamClass> mRequestedReferences;
    private Map<Key, Future> mInFlightRequests;
    private boolean mSendScheduled;

    ClassDescriptorCache(IOExecutor executor) {
        this.mExecutor = executor;
        this.mLock = new ReentrantReadWriteLock(false);
        this.mRemoteReferences = Cache.newSoftValueCache(17);
    }

    public Handle localLink() {
        return new LocalHandle();
    }

    public void link(Remote obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.mLock.writeLock().lock();
        try {
            if (this.mRemoteHandle != null) {
                throw new IllegalStateException();
            }
            this.mRemoteHandle = (Handle)obj;
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote toReference(ObjectStreamClass desc) {
        Key key = new Key(desc);
        Lock lock = this.mLock.readLock();
        lock.lock();
        try {
            Remote remote = this.mRemoteReferences.get(key);
            return remote;
        }
        finally {
            lock.unlock();
        }
    }

    public ObjectStreamClass toDescriptor(Remote ref) {
        return ((LocalReference)ref).getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReference(ObjectStreamClass desc) {
        Key key = new Key(desc);
        Lock lock = this.mLock.writeLock();
        lock.lock();
        try {
            if (this.mRemoteHandle != null) {
                Map<Key, Future> inFlight = this.mInFlightRequests;
                if (inFlight != null && inFlight.containsKey(key)) {
                    return;
                }
                Map<Key, ObjectStreamClass> requested = this.mRequestedReferences;
                if (requested == null) {
                    this.mRequestedReferences = requested = new HashMap<Key, ObjectStreamClass>();
                }
                if (requested.put(key, desc) == null) {
                    this.scheduleSend(false);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSend(boolean reschedule) {
        Lock lock = this.mLock.writeLock();
        lock.lock();
        try {
            if (this.mSendScheduled || this.mRequestedReferences == null) {
                if (reschedule) {
                    this.mSendScheduled = false;
                }
                return;
            }
            try {
                this.mSendScheduled = true;
                this.mExecutor.schedule(new ScheduledTask<RuntimeException>(){

                    @Override
                    protected void doRun() {
                        ClassDescriptorCache.this.sendReferenceRequests();
                    }
                }, 10L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedException e) {
                this.mSendScheduled = false;
                this.mRequestedReferences = null;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendReferenceRequests() {
        try {
            ReferenceTransport[] refs;
            Handle remoteHandle;
            this.mLock.writeLock().lock();
            try {
                remoteHandle = this.mRemoteHandle;
                Map<Key, ObjectStreamClass> requested = this.mRequestedReferences;
                this.mRequestedReferences = null;
                if (requested == null || requested.isEmpty()) {
                    return;
                }
                Map<Key, Future> inFlight = this.mInFlightRequests;
                if (inFlight == null) {
                    this.mInFlightRequests = inFlight = new HashMap<Key, Future>();
                }
                refs = new ReferenceTransport[requested.size()];
                int i = 0;
                for (Map.Entry<Key, ObjectStreamClass> entry : requested.entrySet()) {
                    Key key = entry.getKey();
                    ObjectStreamClass desc = entry.getValue();
                    refs[i++] = new ReferenceTransport(desc);
                    RemoveInFlight rif = new RemoveInFlight(key);
                    try {
                        ScheduledFuture<?> future = this.mExecutor.schedule(rif, 5L, TimeUnit.SECONDS);
                        inFlight.put(key, future);
                        rif.setFuture(future);
                    }
                    catch (RejectedException e) {}
                }
            }
            finally {
                this.mLock.writeLock().unlock();
            }
            try {
                remoteHandle.receive(refs);
            }
            catch (RemoteException e) {
                this.mLock.writeLock().lock();
                try {
                    this.mInFlightRequests = null;
                }
                finally {
                    this.mLock.writeLock().unlock();
                }
            }
        }
        finally {
            this.scheduleSend(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveReferences(ReferenceTransport ... refs) {
        Lock lock = this.mLock.writeLock();
        Cache<Key, Reference> remoteReferences = this.mRemoteReferences;
        for (ReferenceTransport ref : refs) {
            lock.lock();
            try {
                remoteReferences.put(ref.mKey, ref.mReference);
                this.removeInFlight(ref.mKey, null);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInFlight(Key key, Future expect) {
        Lock lock = this.mLock.writeLock();
        lock.lock();
        try {
            Map<Key, Future> inFlight = this.mInFlightRequests;
            if (inFlight != null) {
                Future task;
                if ((expect == null || inFlight.get(key) == expect) && (task = inFlight.remove(key)) != null) {
                    task.cancel(false);
                }
                if (inFlight.isEmpty()) {
                    this.mInFlightRequests = null;
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static class ReferenceTransport
    implements Externalizable {
        transient Key mKey;
        transient Reference mReference;

        public ReferenceTransport() {
        }

        ReferenceTransport(ObjectStreamClass desc) {
            this.mKey = new Key(desc);
            this.mReference = new LocalReference(desc);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mKey.mName);
            out.writeLong(this.mKey.mId);
            out.writeObject(this.mReference);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.mKey = new Key((String)in.readObject(), in.readLong());
            this.mReference = (Reference)in.readObject();
        }
    }

    private static class Key {
        final String mName;
        final long mId;

        Key(ObjectStreamClass desc) {
            this.mName = desc.getName();
            this.mId = desc.getSerialVersionUID();
        }

        Key(String name, long id) {
            this.mName = name;
            this.mId = id;
        }

        public int hashCode() {
            return this.mName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.mName.equals(other.mName) && this.mId == other.mId;
            }
            return false;
        }

        public String toString() {
            return this.mName + '/' + this.mId;
        }
    }

    private static class LocalReference
    implements Reference {
        private final ObjectStreamClass mDescriptor;

        LocalReference(ObjectStreamClass desc) {
            this.mDescriptor = desc;
        }

        @Override
        public ObjectStreamClass getDescriptor() {
            return this.mDescriptor;
        }
    }

    private class LocalHandle
    implements Handle {
        private LocalHandle() {
        }

        @Override
        public void receive(ReferenceTransport ... refs) {
            ClassDescriptorCache.this.receiveReferences(refs);
        }
    }

    public static interface Reference
    extends Remote {
        @RemoteFailure(declared=false)
        public ObjectStreamClass getDescriptor();
    }

    public static interface Handle
    extends Remote {
        public void receive(ReferenceTransport ... var1) throws RemoteException;
    }

    private class RemoveInFlight
    extends ScheduledTask<RuntimeException> {
        private final Key mKey;
        private Future mFuture;
        private boolean mFutureSet;

        RemoveInFlight(Key key) {
            this.mKey = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() {
            Future future;
            RemoveInFlight removeInFlight = this;
            synchronized (removeInFlight) {
                while (!this.mFutureSet) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                future = this.mFuture;
            }
            ClassDescriptorCache.this.removeInFlight(this.mKey, future);
        }

        synchronized void setFuture(Future future) {
            this.mFuture = future;
            this.mFutureSet = true;
            this.notify();
        }
    }
}

