/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import org.cojen.dirmi.ClassResolver;
import org.cojen.util.SoftValueCache;

class ClassLoaderResolver
implements ClassResolver {
    static final ClassResolver DEFAULT = new ClassLoaderResolver(null);
    private final ClassLoader mLoader;
    private final SoftValueCache<String, Class<?>> mCache;

    ClassLoaderResolver(ClassLoader loader) {
        this.mLoader = loader;
        this.mCache = new SoftValueCache(101);
    }

    @Override
    public Class<?> resolveClass(String name) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)this.mCache.get((Object)name);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.mLoader == null ? Class.forName(name) : Class.forName(name, true, this.mLoader);
        Class<?> existing = (Class<?>)this.mCache.putIfAbsent((Object)name, clazz);
        return existing != null ? existing : clazz;
    }
}

