/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.core.InvocationChannel;
import org.cojen.dirmi.core.WrappedPipe;

abstract class ClientPipe
extends WrappedPipe {
    private static final int WRITING = 0;
    private static final int READING = 1;
    private static final int CLOSED = 2;
    private static final AtomicIntegerFieldUpdater<ClientPipe> cStateUpdater = AtomicIntegerFieldUpdater.newUpdater(ClientPipe.class, "mState");
    private final InvocationChannel mChannel;
    private volatile int mState;
    private volatile boolean mCannotResume;

    ClientPipe(InvocationChannel channel) {
        this.mChannel = channel;
    }

    @Override
    public void close() throws IOException {
        int oldState = cStateUpdater.getAndSet(this, 2);
        if (oldState == 2) {
            return;
        }
        InvocationChannel channel = this.mChannel;
        if (!channel.cancelTimeout()) {
            return;
        }
        try {
            if (this.mCannotResume) {
                channel.close();
                return;
            }
            if (oldState == 0) {
                if (channel.outputSuspend()) {
                    channel.reset();
                } else {
                    channel.close();
                    return;
                }
            }
            this.tryInputResume(channel);
        }
        catch (ClosedException e) {
            return;
        }
    }

    @Override
    Pipe pipeForRead() throws IOException {
        InvocationChannel channel = this.mChannel;
        if (this.mState == 1) {
            return channel;
        }
        if (cStateUpdater.compareAndSet(this, 0, 1)) {
            if (channel.outputSuspend()) {
                channel.reset();
            } else {
                this.mCannotResume = true;
            }
            return channel;
        }
        if (this.mState == 1) {
            return channel;
        }
        throw new IOException("Pipe is closed");
    }

    @Override
    Pipe pipeForWrite() throws IOException {
        if (this.mState == 0) {
            return this.mChannel;
        }
        this.anyPipe();
        throw new IOException("Pipe is not in a writable state");
    }

    @Override
    Pipe anyPipe() throws IOException {
        if (this.mState != 2) {
            return this.mChannel;
        }
        throw new IOException("Pipe is closed");
    }

    abstract void tryInputResume(InvocationChannel var1);
}

