/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.DataOutput;
import java.rmi.server.Unreferenced;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.dirmi.Link;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.UnimplementedMethodException;
import org.cojen.dirmi.core.BatchedInvocationException;
import org.cojen.dirmi.core.Identifier;
import org.cojen.dirmi.core.InvocationChannel;
import org.cojen.dirmi.core.InvocationInputStream;
import org.cojen.dirmi.core.InvocationOutputStream;
import org.cojen.dirmi.core.SkeletonSupport;
import org.cojen.dirmi.core.StubSupport;
import org.cojen.dirmi.core.VersionedIdentifier;
import org.cojen.dirmi.info.RemoteParameter;

class CodeBuilderUtil {
    static final TypeDesc IDENTIFIER_TYPE = TypeDesc.forClass(Identifier.class);
    static final TypeDesc VERSIONED_IDENTIFIER_TYPE = TypeDesc.forClass(VersionedIdentifier.class);
    static final TypeDesc STUB_SUPPORT_TYPE = TypeDesc.forClass(StubSupport.class);
    static final TypeDesc SKEL_SUPPORT_TYPE = TypeDesc.forClass(SkeletonSupport.class);
    static final TypeDesc INV_CHANNEL_TYPE = TypeDesc.forClass(InvocationChannel.class);
    static final TypeDesc INV_IN_TYPE = TypeDesc.forClass(InvocationInputStream.class);
    static final TypeDesc INV_OUT_TYPE = TypeDesc.forClass(InvocationOutputStream.class);
    static final TypeDesc NO_SUCH_METHOD_EX_TYPE = TypeDesc.forClass(NoSuchMethodException.class);
    static final TypeDesc UNIMPLEMENTED_EX_TYPE = TypeDesc.forClass(UnimplementedMethodException.class);
    static final TypeDesc BATCH_INV_EX_TYPE = TypeDesc.forClass(BatchedInvocationException.class);
    static final TypeDesc THROWABLE_TYPE = TypeDesc.forClass(Throwable.class);
    static final TypeDesc CLASS_TYPE = TypeDesc.forClass(Class.class);
    static final TypeDesc FUTURE_TYPE = TypeDesc.forClass(Future.class);
    static final TypeDesc TIME_UNIT_TYPE = TypeDesc.forClass(TimeUnit.class);
    static final TypeDesc PIPE_TYPE = TypeDesc.forClass(Pipe.class);
    static final TypeDesc DATA_OUTPUT_TYPE = TypeDesc.forClass(DataOutput.class);
    static final TypeDesc UNREFERENCED_TYPE = TypeDesc.forClass(Unreferenced.class);
    static final TypeDesc LINK_TYPE = TypeDesc.forClass(Link.class);

    CodeBuilderUtil() {
    }

    static boolean equalTypes(RemoteParameter a, RemoteParameter b) {
        return a == null ? b == null : a.equalTypes(b);
    }

    static RuntimeClassFile createRuntimeClassFile(String name, ClassLoader loader) {
        if (name.startsWith("java.")) {
            name = "java$" + name.substring(4);
        }
        return new RuntimeClassFile(name, null, loader);
    }

    static void readParam(CodeBuilder b, RemoteParameter param, LocalVariable invInVar) {
        TypeDesc castType;
        TypeDesc methodType;
        String methodName;
        TypeDesc type = CodeBuilderUtil.getTypeDesc(param);
        if (type.isPrimitive() || !param.isUnshared()) {
            CodeBuilderUtil.readValue(b, type, invInVar);
            return;
        }
        if (TypeDesc.STRING == type) {
            methodName = "readUnsharedString";
            methodType = type;
            castType = null;
        } else {
            methodName = "readUnshared";
            methodType = TypeDesc.OBJECT;
            castType = type;
        }
        b.loadLocal(invInVar);
        if (invInVar.getType().toClass().isInterface()) {
            b.invokeInterface(invInVar.getType(), methodName, methodType, null);
        } else {
            b.invokeVirtual(invInVar.getType(), methodName, methodType, null);
        }
        if (castType != null && castType != TypeDesc.OBJECT) {
            b.checkCast(type);
        }
    }

    static void readValue(CodeBuilder b, TypeDesc type, LocalVariable inVar) {
        TypeDesc castType;
        TypeDesc methodType;
        String methodName;
        if (type.isPrimitive()) {
            methodName = type.getRootName();
            methodName = "read" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
            methodType = type;
            castType = null;
        } else {
            methodName = "readObject";
            methodType = TypeDesc.OBJECT;
            castType = type;
        }
        b.loadLocal(inVar);
        if (inVar.getType().toClass().isInterface()) {
            b.invokeInterface(inVar.getType(), methodName, methodType, null);
        } else {
            b.invokeVirtual(inVar.getType(), methodName, methodType, null);
        }
        if (castType != null && castType != TypeDesc.OBJECT) {
            b.checkCast(type);
        }
    }

    static boolean writeParam(CodeBuilder b, RemoteParameter param, LocalVariable invOutVar, LocalVariable paramVar) {
        TypeDesc methodType;
        String methodName;
        TypeDesc type = CodeBuilderUtil.getTypeDesc(param);
        if (type.isPrimitive() || !param.isUnshared()) {
            return CodeBuilderUtil.writeValue(b, type, invOutVar, paramVar);
        }
        if (TypeDesc.STRING == type) {
            methodName = "writeUnsharedString";
            methodType = type;
        } else {
            methodName = "writeUnshared";
            methodType = TypeDesc.OBJECT;
        }
        b.loadLocal(invOutVar);
        b.loadLocal(paramVar);
        if (invOutVar.getType().toClass().isInterface()) {
            b.invokeInterface(invOutVar.getType(), methodName, null, new TypeDesc[]{methodType});
        } else {
            b.invokeVirtual(invOutVar.getType(), methodName, null, new TypeDesc[]{methodType});
        }
        return false;
    }

    static boolean writeValue(CodeBuilder b, TypeDesc type, LocalVariable outVar, LocalVariable valueVar) {
        TypeDesc methodType;
        String methodName;
        boolean shared;
        if (type.isPrimitive()) {
            shared = false;
            methodName = type.getRootName();
            methodName = "write" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
            switch (type.getTypeCode()) {
                case 5: 
                case 8: 
                case 9: {
                    methodType = TypeDesc.INT;
                    break;
                }
                default: {
                    methodType = type;
                    break;
                }
            }
        } else {
            shared = true;
            methodName = "writeObject";
            methodType = TypeDesc.OBJECT;
        }
        b.loadLocal(outVar);
        if (valueVar == null) {
            b.swap();
        } else {
            b.loadLocal(valueVar);
        }
        if (outVar.getType().toClass().isInterface()) {
            b.invokeInterface(outVar.getType(), methodName, null, new TypeDesc[]{methodType});
        } else {
            b.invokeVirtual(outVar.getType(), methodName, null, new TypeDesc[]{methodType});
        }
        return shared;
    }

    static TypeDesc getTypeDesc(RemoteParameter param) {
        if (param == null) {
            return null;
        }
        return TypeDesc.forClass(param.getType());
    }

    static TypeDesc[] getTypeDescs(Collection<? extends RemoteParameter> params) {
        TypeDesc[] paramDescs = new TypeDesc[params.size()];
        int j = 0;
        for (RemoteParameter remoteParameter : params) {
            paramDescs[j++] = CodeBuilderUtil.getTypeDesc(remoteParameter);
        }
        return paramDescs;
    }

    static boolean isKnownType(ClassLoader loader, TypeDesc type) {
        if (type == null) {
            return true;
        }
        if (type.isArray()) {
            type = type.getRootComponentType();
        }
        if (type.isPrimitive()) {
            return true;
        }
        String name = type.getRootName();
        try {
            if (loader == null) {
                Class.forName(name);
            } else {
                loader.loadClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    static boolean isKnownTypes(ClassLoader loader, TypeDesc ... types) {
        for (TypeDesc type : types) {
            if (CodeBuilderUtil.isKnownType(loader, type)) continue;
            return false;
        }
        return true;
    }

    static void addStaticFactoryRef(ClassFile cf, Object factoryRef) {
        CodeBuilder b = CodeBuilderUtil.addStaticFactoryRefUnfinished(cf, factoryRef);
        if (b != null) {
            b.returnVoid();
        }
    }

    static CodeBuilder addStaticFactoryRefUnfinished(ClassFile cf, Object factoryRef) {
        return CodeBuilderUtil.addStaticFieldsInitializer(cf, new TypeDesc[]{TypeDesc.OBJECT}, factoryRef);
    }

    private static CodeBuilder addStaticFieldsInitializer(ClassFile cf, TypeDesc[] types, Object ... values) {
        String[] names = new String[types.length];
        if (types.length == 0) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            String name;
            names[i] = name = "field$" + i;
            cf.addField(Modifiers.PRIVATE.toStatic(true).toFinal(true), name, types[i]);
        }
        CodeBuilder b = new CodeBuilder(cf.addInitializer());
        TypeDesc localType = TypeDesc.forClass(ThreadLocal.class);
        b.loadStaticField(Local.class.getName(), "value", localType);
        b.invokeVirtual(localType, "get", TypeDesc.OBJECT, null);
        if (types.length == 1) {
            Local.value.set(values[0]);
            TypeDesc type = types[0];
            if (type != TypeDesc.OBJECT) {
                b.checkCast(type);
            }
            b.storeStaticField(names[0], type);
        } else {
            Local.value.set(values);
            b.checkCast(TypeDesc.OBJECT.toArrayType());
            for (int i = 0; i < types.length; ++i) {
                b.dup();
                b.loadConstant(i);
                b.loadFromArray(TypeDesc.OBJECT);
                TypeDesc type = types[i];
                if (type != TypeDesc.OBJECT) {
                    b.checkCast(type);
                }
                b.storeStaticField(names[i], type);
            }
        }
        return b;
    }

    public static class Local {
        public static final ThreadLocal<Object> value = new ThreadLocal();
    }
}

