/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.cojen.dirmi.core.AbstractIdentifier;
import org.cojen.dirmi.util.Cache;
import org.cojen.dirmi.util.Random;
import org.cojen.util.WeakCanonicalSet;

abstract class IdentifierStore<I extends AbstractIdentifier> {
    private final WeakCanonicalSet<I> mIdentifiers = new WeakCanonicalSet();
    private final Cache<Object, I> mObjectsToIdentifiers = Cache.newWeakIdentityCache(17);
    private final Cache<I, Object> mIdentifiersToObjects = Cache.newWeakValueCache(17);

    public synchronized I identify(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        AbstractIdentifier id = (AbstractIdentifier)this.mObjectsToIdentifiers.get(obj);
        if (id == null) {
            while (this.mIdentifiersToObjects.get(id = this.newIdentifier(Random.randomLong())) != null) {
            }
            id = (AbstractIdentifier)this.mIdentifiers.put((Object)id);
            this.mObjectsToIdentifiers.put(obj, id);
            this.mIdentifiersToObjects.put(id, obj);
        }
        return (I)id;
    }

    public I read(DataInput in) throws IOException {
        return this.canonicalIdentifier(this.newIdentifier(in.readLong()));
    }

    public I read(InputStream in) throws IOException {
        int amt;
        int off = 0;
        int len = 8;
        byte[] buf = new byte[len];
        while ((amt = in.read(buf, off, len)) > 0) {
            off += amt;
            len -= amt;
        }
        if (len > 0) {
            throw new EOFException("Unable to fully read identifier");
        }
        long bits = ((long)buf[0] << 56) + ((long)(buf[1] & 0xFF) << 48) + ((long)(buf[2] & 0xFF) << 40) + ((long)(buf[3] & 0xFF) << 32) + ((long)(buf[4] & 0xFF) << 24) + (long)((buf[5] & 0xFF) << 16) + (long)((buf[6] & 0xFF) << 8) + (long)(buf[7] & 0xFF);
        return this.canonicalIdentifier(this.newIdentifier(bits));
    }

    synchronized <T> void register(I id, T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Registered object cannot be null");
        }
        this.mObjectsToIdentifiers.put(obj, id);
    }

    synchronized Object tryRetrieve(I id) {
        return this.mIdentifiersToObjects.get(id);
    }

    synchronized I canonicalIdentifier(I id) {
        return (I)((AbstractIdentifier)this.mIdentifiers.put(id));
    }

    abstract I newIdentifier(long var1);
}

