/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.dirmi.ReconstructedException;
import org.cojen.dirmi.core.InvocationChannel;
import org.cojen.dirmi.core.InvocationInput;
import org.cojen.dirmi.core.InvocationOutputStream;
import org.cojen.dirmi.core.StubFactoryGenerator;

public class InvocationInputStream
extends InputStream
implements InvocationInput {
    private static final String STUB_GENERATOR_NAME = StubFactoryGenerator.class.getName();
    private final InvocationChannel mChannel;
    private final ObjectInputStream mIn;
    private static final int CTOR_NO_ARG = 1;
    private static final int CTOR_MESSAGE = 2;
    private static final int CTOR_CAUSE = 3;
    private static final int CTOR_MESSAGE_AND_CAUSE = 4;
    private static final int CTOR_CAUSE_AND_MESSAGE = 5;

    public InvocationInputStream(InvocationChannel channel, ObjectInputStream in) {
        this.mChannel = channel;
        this.mIn = in;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.mIn.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int offset, int length) throws IOException {
        this.mIn.readFully(b, offset, length);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.mIn.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.mIn.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.mIn.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.mIn.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.mIn.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.mIn.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.mIn.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.mIn.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.mIn.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.mIn.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.mIn.readDouble();
    }

    @Override
    @Deprecated
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return this.mIn.readUTF();
    }

    @Override
    public String readUnsharedString() throws IOException {
        int length = this.readVarUnsignedInteger();
        if (length == 0) {
            return null;
        }
        if (--length == 0) {
            return "";
        }
        char[] value = new char[length];
        int offset = 0;
        ObjectInputStream in = this.mIn;
        block5: while (offset < length) {
            int b1 = ((InputStream)in).read();
            switch (b1 >> 5) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    value[offset++] = (char)b1;
                    continue block5;
                }
                case 4: 
                case 5: {
                    int b2 = ((InputStream)in).read();
                    if (b2 < 0) {
                        throw new EOFException();
                    }
                    value[offset++] = (char)((b1 & 0x3F) << 8 | b2);
                    continue block5;
                }
                case 6: {
                    int b2 = ((InputStream)in).read();
                    int b3 = ((InputStream)in).read();
                    if ((b2 | b3) < 0) {
                        throw new EOFException();
                    }
                    int c = (b1 & 0x1F) << 16 | b2 << 8 | b3;
                    if (c >= 65536) {
                        value[offset++] = (char)(0xD800 | (c -= 65536) >> 10 & 0x3FF);
                        value[offset++] = (char)(0xDC00 | c & 0x3FF);
                        continue block5;
                    }
                    value[offset++] = (char)c;
                    continue block5;
                }
            }
            if (b1 < 0) {
                throw new EOFException();
            }
            throw new StreamCorruptedException();
        }
        return new String(value);
    }

    @Override
    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.mIn.readUnshared();
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        return this.mIn.readObject();
    }

    @Override
    public int read() throws IOException {
        return this.mIn.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.mIn.read(b);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        return this.mIn.read(b, offset, length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.mIn.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.mIn.available();
    }

    private int readVarUnsignedInteger() throws IOException {
        ObjectInputStream in = this.mIn;
        int b1 = ((InputStream)in).read();
        if (b1 < 0) {
            throw new EOFException();
        }
        if (b1 <= 127) {
            return b1;
        }
        int b2 = ((InputStream)in).read();
        if (b2 < 0) {
            throw new EOFException();
        }
        if (b1 <= 191) {
            return (b1 & 0x3F) << 8 | b2;
        }
        int b3 = ((InputStream)in).read();
        if (b3 < 0) {
            throw new EOFException();
        }
        if (b1 <= 223) {
            return (b1 & 0x1F) << 16 | b2 << 8 | b3;
        }
        int b4 = ((InputStream)in).read();
        if (b4 < 0) {
            throw new EOFException();
        }
        if (b1 <= 239) {
            return (b1 & 0xF) << 24 | b2 << 16 | b3 << 8 | b4;
        }
        int b5 = ((InputStream)in).read();
        if (b5 < 0) {
            throw new EOFException();
        }
        return b2 << 24 | b3 << 16 | b4 << 8 | b5;
    }

    @Override
    public Throwable readThrowable() throws IOException, ReconstructedException {
        Exception reconstructCause;
        Throwable t;
        int b = this.read();
        if (b < 0) {
            throw new EOFException();
        }
        if (b == 2) {
            return null;
        }
        ArrayList<ThrowableInfo> chain = null;
        String serverLocalAddress = null;
        String serverRemoteAddress = null;
        try {
            ObjectInputStream in = this.mIn;
            serverLocalAddress = (String)in.readObject();
            serverRemoteAddress = (String)in.readObject();
            int chainLength = this.readVarUnsignedInteger();
            chain = new ArrayList<ThrowableInfo>(chainLength);
            for (int i = 0; i < chainLength; ++i) {
                chain.add(new ThrowableInfo(in));
            }
            t = (Throwable)in.readObject();
            reconstructCause = null;
        }
        catch (IOException e) {
            t = this.tryReconstruct(e, chain);
            if (t == null) {
                throw e;
            }
            reconstructCause = e;
        }
        catch (ClassNotFoundException e) {
            t = this.tryReconstruct(e, chain);
            if (t == null) {
                throw new RemoteException(e.getMessage(), e);
            }
            reconstructCause = e;
        }
        StackTraceElement[] localTrace = this.localTrace(serverLocalAddress, serverRemoteAddress);
        StackTraceElement[] rootRemoteTrace = t.getStackTrace();
        int skeletonOffset = -1;
        for (int i = 0; i < rootRemoteTrace.length; ++i) {
            if (!InvocationOutputStream.SKELETON_GENERATOR_NAME.equals(rootRemoteTrace[i].getFileName())) continue;
            skeletonOffset = i;
            break;
        }
        t.setStackTrace(this.stitchTrace(rootRemoteTrace, localTrace));
        Throwable cause = t;
        block5: while ((cause = cause.getCause()) != null) {
            StackTraceElement[] causeTrace = cause.getStackTrace();
            int i = rootRemoteTrace.length;
            int j = causeTrace.length;
            while (--i >= skeletonOffset && --j >= 0) {
                if (rootRemoteTrace[i].equals(causeTrace[j])) continue;
                continue block5;
            }
            cause.setStackTrace(this.stitchTrace(causeTrace, localTrace));
        }
        if (reconstructCause == null) {
            return t;
        }
        if (t instanceof ReconstructedException) {
            throw (ReconstructedException)t;
        }
        throw new ReconstructedException(reconstructCause, t);
    }

    private StackTraceElement[] stitchTrace(StackTraceElement[] remoteTrace, StackTraceElement[] localTrace) {
        int remoteTraceLength = remoteTrace.length;
        if (remoteTraceLength > 1 && InvocationOutputStream.SKELETON_GENERATOR_NAME.equals(remoteTrace[remoteTraceLength - 1].getFileName())) {
            --remoteTraceLength;
        }
        StackTraceElement[] combined = new StackTraceElement[remoteTraceLength + localTrace.length];
        System.arraycopy(remoteTrace, 0, combined, 0, remoteTraceLength);
        System.arraycopy(localTrace, 0, combined, remoteTraceLength, localTrace.length);
        return combined;
    }

    private StackTraceElement[] localTrace(String serverLocalAddress, String serverRemoteAddress) {
        StackTraceElement element;
        int i;
        StackTraceElement[] localTrace;
        ArrayList<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        String message = "--- remote method invocation ---";
        InvocationInputStream.addAddress(trace, message, "address", serverLocalAddress, InvocationInputStream.remoteAddress(this.mChannel));
        InvocationInputStream.addAddress(trace, message, "address", serverRemoteAddress, InvocationInputStream.localAddress(this.mChannel));
        try {
            localTrace = Thread.currentThread().getStackTrace();
        }
        catch (SecurityException e) {
            localTrace = e.getStackTrace();
        }
        String thisClassName = this.getClass().getName();
        for (i = 0; i < localTrace.length && !STUB_GENERATOR_NAME.equals((element = localTrace[i]).getFileName()); ++i) {
            if (!thisClassName.equals(element.getClassName()) || !"localTrace".equals(element.getMethodName())) continue;
            ++i;
            break;
        }
        if (i >= localTrace.length) {
            i = 0;
        }
        while (i < localTrace.length) {
            trace.add(localTrace[i]);
            ++i;
        }
        return trace.toArray(new StackTraceElement[trace.size()]);
    }

    private static void addAddress(List<StackTraceElement> list, String message, String addrType, String addr1, String addr2) {
        if (addr1 == null || addr2 != null && addr2.contains(addr1)) {
            list.add(new StackTraceElement(message, addrType, addr2, -1));
        } else if (addr2 == null || addr1 != null && addr1.contains(addr2)) {
            list.add(new StackTraceElement(message, addrType, addr1, -1));
        } else {
            list.add(new StackTraceElement(message, addrType, addr1, -1));
            list.add(new StackTraceElement(message, addrType, addr2, -1));
        }
    }

    private Throwable tryReconstruct(Throwable reconstructCause, List<ThrowableInfo> chain) {
        if (chain == null || chain.size() == 0) {
            return null;
        }
        Throwable cause = null;
        for (ThrowableInfo info : chain) {
            if (info == null) continue;
            cause = this.tryReconstruct(reconstructCause, info.mClassName, info.mMessage, cause);
            cause.setStackTrace(info.mStackTrace);
        }
        return cause;
    }

    private Throwable tryReconstruct(Throwable reconstructCause, String className, String message, Throwable cause) {
        try {
            Class<?> exClass = Class.forName(className);
            int[] preferences = cause == null ? (message == null ? new int[]{1, 2, 3, 4, 5} : new int[]{2, 4, 5}) : (message == null ? new int[]{3, 5, 4, 1, 2} : new int[]{4, 5, 2});
            Throwable t = this.tryReconstruct(exClass, message, cause, preferences);
            if (t != null) {
                return t;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new ReconstructedException(reconstructCause, className, message, cause);
    }

    private Throwable tryReconstruct(Class exClass, String message, Throwable cause, int ... preferences) throws Exception {
        Throwable t = null;
        for (int pref : preferences) {
            block10: for (Constructor<?> ctor : exClass.getConstructors()) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                switch (pref) {
                    case 1: {
                        if (paramTypes.length != 0) continue block10;
                        t = (Throwable)ctor.newInstance(new Object[0]);
                        continue block10;
                    }
                    case 2: {
                        if (paramTypes.length != 1 || paramTypes[0] != String.class) continue block10;
                        t = (Throwable)ctor.newInstance(message);
                        continue block10;
                    }
                    case 3: {
                        if (paramTypes.length != 1 || !this.isAssignableThrowable(paramTypes[0], cause)) continue block10;
                        return (Throwable)ctor.newInstance(cause);
                    }
                    case 4: {
                        if (paramTypes.length != 2 || paramTypes[0] != String.class || !this.isAssignableThrowable(paramTypes[1], cause)) continue block10;
                        return (Throwable)ctor.newInstance(message, cause);
                    }
                    case 5: {
                        if (paramTypes.length != 2 || !this.isAssignableThrowable(paramTypes[0], cause) || paramTypes[1] != String.class) continue block10;
                        return (Throwable)ctor.newInstance(cause, message);
                    }
                }
            }
        }
        if (t != null && cause != null) {
            try {
                t.initCause(cause);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        return t;
    }

    private boolean isAssignableThrowable(Class type, Throwable cause) {
        return cause == null && Throwable.class.isAssignableFrom(type) || type.isInstance(cause);
    }

    public String toString() {
        if (this.mChannel == null) {
            return super.toString();
        }
        return "InputStream for ".concat(this.mChannel.toString());
    }

    @Override
    public void close() throws IOException {
        if (this.mChannel == null) {
            this.mIn.close();
        } else {
            this.mChannel.close();
        }
    }

    void doClose() throws IOException {
        this.mIn.close();
    }

    static String localAddress(InvocationChannel channel) {
        return channel == null ? null : InvocationInputStream.toString(channel.getLocalAddress());
    }

    static String remoteAddress(InvocationChannel channel) {
        return channel == null ? null : InvocationInputStream.toString(channel.getRemoteAddress());
    }

    static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private static class ThrowableInfo {
        final String mClassName;
        final String mMessage;
        final StackTraceElement[] mStackTrace;

        ThrowableInfo(ObjectInput in) throws IOException, ClassNotFoundException {
            this.mClassName = (String)in.readObject();
            this.mMessage = (String)in.readObject();
            this.mStackTrace = (StackTraceElement[])in.readObject();
        }
    }
}

