/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cojen.dirmi.core.DrainableObjectOutputStream;
import org.cojen.dirmi.core.InvocationChannel;
import org.cojen.dirmi.core.InvocationInputStream;
import org.cojen.dirmi.core.InvocationOutput;
import org.cojen.dirmi.core.SkeletonFactoryGenerator;

public class InvocationOutputStream
extends OutputStream
implements InvocationOutput {
    static final String SKELETON_GENERATOR_NAME;
    private static final boolean cPruneStackTraces;
    static final byte FALSE = 0;
    static final byte TRUE = 1;
    static final byte NULL = 2;
    static final byte NOT_NULL = 3;
    private final InvocationChannel mChannel;
    private final DrainableObjectOutputStream mOut;

    public InvocationOutputStream(InvocationChannel channel, DrainableObjectOutputStream out) {
        this.mChannel = channel;
        this.mOut = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.mOut.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mOut.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.mOut.write(b, offset, length);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.mOut.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.mOut.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.mOut.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.mOut.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.mOut.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.mOut.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.mOut.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.mOut.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.mOut.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.mOut.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.mOut.writeUTF(s);
    }

    @Override
    public void writeUnsharedString(String str) throws IOException {
        if (str == null) {
            this.mOut.write(0);
            return;
        }
        int length = str.length();
        this.writeVarUnsignedInt(length + 1);
        DrainableObjectOutputStream out = this.mOut;
        for (int i = 0; i < length; ++i) {
            char c2;
            int c = str.charAt(i);
            if (c <= 127) {
                ((OutputStream)out).write(c);
                continue;
            }
            if (c <= 16383) {
                ((OutputStream)out).write(0x80 | c >> 8);
                ((OutputStream)out).write(c);
                continue;
            }
            if (c >= 55296 && c <= 56319 && i + 1 < length && (c2 = str.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                c = 65536 + ((c & 0x3FF) << 10 | c2 & 0x3FF);
                ++i;
            }
            ((OutputStream)out).write(0xC0 | c >> 16);
            ((OutputStream)out).write(c >> 8);
            ((OutputStream)out).write(c);
        }
    }

    private void writeVarUnsignedInt(int v) throws IOException {
        DrainableObjectOutputStream out = this.mOut;
        if (v < 128) {
            ((OutputStream)out).write(v);
        } else if (v < 16384) {
            ((OutputStream)out).write(v >> 8 | 0x80);
            ((OutputStream)out).write(v);
        } else if (v < 0x200000) {
            ((OutputStream)out).write(v >> 16 | 0xC0);
            ((OutputStream)out).write(v >> 8);
            ((OutputStream)out).write(v);
        } else if (v < 0x10000000) {
            ((OutputStream)out).write(v >> 24 | 0xE0);
            ((OutputStream)out).write(v >> 16);
            ((OutputStream)out).write(v >> 8);
            ((OutputStream)out).write(v);
        } else {
            ((OutputStream)out).write(240);
            ((OutputStream)out).write(v >> 24);
            ((OutputStream)out).write(v >> 16);
            ((OutputStream)out).write(v >> 8);
            ((OutputStream)out).write(v);
        }
    }

    @Override
    public void writeUnshared(Object obj) throws IOException {
        this.mOut.writeUnshared(obj);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.mOut.writeObject(obj);
    }

    @Override
    public void writeThrowable(Throwable t) throws IOException {
        if (t == null) {
            this.write(2);
            return;
        }
        this.write(3);
        ArrayList<Throwable> chain = new ArrayList<Throwable>(8);
        InvocationOutputStream.collectChain(chain, t);
        DrainableObjectOutputStream out = this.mOut;
        out.writeObject(InvocationInputStream.localAddress(this.mChannel));
        out.writeObject(InvocationInputStream.remoteAddress(this.mChannel));
        this.writeVarUnsignedInt(chain.size());
        for (int i = 0; i < chain.size(); ++i) {
            Throwable sub = (Throwable)chain.get(i);
            out.writeObject(sub.getClass().getName());
            out.writeObject(sub.getMessage());
            StackTraceElement[] trace = sub.getStackTrace();
            if (cPruneStackTraces) {
                trace = InvocationOutputStream.prune(trace);
                sub.setStackTrace(trace);
            }
            out.writeObject(trace);
        }
        out.flush();
        out.writeObject(t);
    }

    private static void collectChain(List<Throwable> chain, Throwable t) {
        Throwable cause = t.getCause();
        if (cause != null) {
            InvocationOutputStream.collectChain(chain, cause);
        }
        chain.add(t);
    }

    private static StackTraceElement[] prune(StackTraceElement[] trace) {
        int i;
        for (i = 0; i < trace.length && !SKELETON_GENERATOR_NAME.equals(trace[i].getFileName()); ++i) {
        }
        if (i > 0 && i < trace.length) {
            return Arrays.copyOfRange(trace, 0, i + 1);
        }
        return trace;
    }

    @Override
    public void reset() throws IOException {
        this.mOut.reset();
    }

    @Override
    public void flush() throws IOException {
        this.mOut.flush();
    }

    public String toString() {
        if (this.mChannel == null) {
            return super.toString();
        }
        return "OutputStream for ".concat(this.mChannel.toString());
    }

    @Override
    public void close() throws IOException {
        if (this.mChannel == null) {
            this.mOut.close();
        } else {
            this.mChannel.close();
        }
    }

    void doDrain() throws IOException {
        this.mOut.drain();
    }

    void doClose() throws IOException {
        this.mOut.close();
    }

    static {
        boolean prune;
        SKELETON_GENERATOR_NAME = SkeletonFactoryGenerator.class.getName();
        try {
            String prop = System.getProperty("org.cojen.dirmi.pruneServerStackTraces");
            prune = prop == null || prop.equalsIgnoreCase("true");
        }
        catch (SecurityException e) {
            prune = true;
        }
        cPruneStackTraces = prune;
    }
}

