/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.cojen.dirmi.MalformedRemoteObjectException;
import org.cojen.dirmi.core.Marshalled;

class MarshalledIntrospectionFailure
implements Marshalled,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String mMessage;
    private String mClassName;
    private Class mClass;

    public MarshalledIntrospectionFailure() {
    }

    MarshalledIntrospectionFailure(String message, String className) {
        this.mMessage = message;
        this.mClassName = className;
        this.mClass = null;
    }

    MarshalledIntrospectionFailure(String message, Class clazz) {
        this.mMessage = message;
        this.mClassName = clazz.getName();
        this.mClass = clazz;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.mMessage);
        out.writeObject(this.mClassName);
        out.writeObject(this.mClass);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mMessage = (String)in.readObject();
        this.mClassName = (String)in.readObject();
        try {
            this.mClass = (Class)in.readObject();
        }
        catch (ClassNotFoundException e) {
            this.mClass = null;
        }
    }

    public MalformedRemoteObjectException toException() {
        if (this.mClass == null) {
            return new MalformedRemoteObjectException(this.mMessage, this.mClassName);
        }
        return new MalformedRemoteObjectException(this.mMessage, this.mClass);
    }
}

