/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.cojen.dirmi.core.Marshalled;
import org.cojen.dirmi.core.VersionedIdentifier;
import org.cojen.dirmi.info.RemoteInfo;

class MarshalledRemote
implements Marshalled,
Externalizable {
    private static final long serialVersionUID = 1L;
    VersionedIdentifier mObjId;
    int mObjVersion;
    VersionedIdentifier mTypeId;
    int mTypeVersion;
    RemoteInfo mInfo;

    public MarshalledRemote() {
    }

    MarshalledRemote(VersionedIdentifier objId, VersionedIdentifier typeId, RemoteInfo info) {
        this.mObjId = objId;
        this.mTypeId = typeId;
        this.mInfo = info;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.mObjId.writeWithNextVersion(out);
        this.mTypeId.writeWithNextVersion(out);
        out.writeObject(this.mInfo);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mObjId = VersionedIdentifier.read(in);
        this.mObjVersion = in.readInt();
        this.mTypeId = VersionedIdentifier.read(in);
        this.mTypeVersion = in.readInt();
        this.mInfo = (RemoteInfo)in.readObject();
    }

    public void updateRemoteVersions() {
        this.mObjId.updateRemoteVersion(this.mObjVersion);
        this.mTypeId.updateRemoteVersion(this.mTypeVersion);
    }
}

