/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.PriorityQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.core.RemoteCompletion;
import org.cojen.dirmi.core.StandardSession;
import org.cojen.dirmi.core.VersionedIdentifier;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.util.ScheduledTask;

public class OrderedInvoker
implements Closeable {
    private static final int MAX_HOLE_DURATION_MILLIS;
    private final StandardSession mSession;
    private int mLastSequence;
    private PriorityQueue<SequencedOp> mPendingOps;
    private boolean mRunning;
    private boolean mDraining;
    private Future<?> mHoleCheckTaskFuture;
    private boolean mClosed;

    OrderedInvoker(StandardSession session) {
        this.mSession = session;
    }

    public synchronized boolean waitForNext(int sequence) throws InterruptedException {
        while (!this.isNext(sequence)) {
            if (this.mClosed) {
                return false;
            }
            this.wait(MAX_HOLE_DURATION_MILLIS);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNext(int sequence) {
        try {
            OrderedInvoker orderedInvoker = this;
            synchronized (orderedInvoker) {
                if (this.mLastSequence + 1 == sequence) {
                    if (this.mHoleCheckTaskFuture != null) {
                        this.mHoleCheckTaskFuture.cancel(false);
                        this.mHoleCheckTaskFuture = null;
                    }
                    this.mRunning = true;
                    return true;
                }
                if (!this.mRunning && this.mHoleCheckTaskFuture == null && !this.mClosed) {
                    this.mHoleCheckTaskFuture = new HoleCheckTask().schedule(this.mSession.mExecutor);
                }
            }
        }
        catch (RejectedException e) {
            this.close(true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(int sequence) {
        SequencedOp op;
        OrderedInvoker orderedInvoker = this;
        synchronized (orderedInvoker) {
            if (this.mClosed) {
                return;
            }
            this.mRunning = false;
            if (this.mLastSequence + 1 == sequence) {
                this.mLastSequence = sequence;
                this.notifyAll();
            } else {
                this.addPendingOp(new SequencedOp(sequence));
            }
            op = this.shouldDrainOps();
            if (op == null) {
                return;
            }
        }
        this.drainPendingOps(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingMethod(int sequence, final Method method, final Object instance, final Object[] params, final VersionedIdentifier disposeId) {
        SequencedOp op;
        OrderedInvoker orderedInvoker = this;
        synchronized (orderedInvoker) {
            if (this.mClosed) {
                return;
            }
            this.addPendingOp(new SequencedOp(sequence){

                @Override
                public void apply() {
                    try {
                        method.invoke(instance, params);
                    }
                    catch (Throwable e) {
                        OrderedInvoker.this.uncaughtException(e);
                    }
                    finally {
                        if (disposeId != null) {
                            OrderedInvoker.this.mSession.disposeSkeleton(disposeId);
                        }
                    }
                }
            });
            op = this.shouldDrainOps();
            if (op == null) {
                return;
            }
        }
        this.drainPendingOps(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void addPendingMethod(int sequence, final Method method, final Object instance, final Object[] params, final VersionedIdentifier disposeId, final RemoteCompletion<V> completion) {
        SequencedOp op;
        OrderedInvoker orderedInvoker = this;
        synchronized (orderedInvoker) {
            if (this.mClosed) {
                return;
            }
            this.addPendingOp(new SequencedOp(sequence){

                @Override
                public void apply() {
                    try {
                        Future response = (Future)method.invoke(instance, params);
                        StandardSession.completion(response, completion);
                    }
                    catch (Throwable e) {
                        try {
                            completion.exception(e);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (disposeId != null) {
                            OrderedInvoker.this.mSession.disposeSkeleton(disposeId);
                        }
                    }
                }
            });
            op = this.shouldDrainOps();
            if (op == null) {
                return;
            }
        }
        this.drainPendingOps(op);
    }

    @Override
    public void close() {
        this.close(false);
    }

    void uncaughtException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        try {
            Thread t = Thread.currentThread();
            t.getUncaughtExceptionHandler().uncaughtException(t, cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addPendingOp(SequencedOp op) {
        if (this.mPendingOps == null) {
            this.mPendingOps = new PriorityQueue();
        }
        this.mPendingOps.add(op);
    }

    private SequencedOp shouldDrainOps() {
        if (this.mDraining) {
            return null;
        }
        this.mDraining = true;
        return this.nextOp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainPendingOps(SequencedOp op) {
        while (true) {
            try {
                op.apply();
                continue;
            }
            finally {
                OrderedInvoker orderedInvoker = this;
                synchronized (orderedInvoker) {
                    this.mRunning = false;
                    if (this.mLastSequence + 1 == op.mSequence) {
                        this.mLastSequence = op.mSequence;
                        this.notifyAll();
                    }
                    if ((op = this.nextOp()) == null) {
                        return;
                    }
                }
                continue;
            }
            break;
        }
    }

    private SequencedOp nextOp() {
        if (this.mPendingOps != null) {
            if (this.mPendingOps.isEmpty()) {
                this.mPendingOps = null;
            } else if (this.isNext(this.mPendingOps.peek().mSequence)) {
                return this.mPendingOps.poll();
            }
        }
        this.mDraining = false;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void holeCheck(Future<?> taskFuture) {
        OrderedInvoker orderedInvoker = this;
        synchronized (orderedInvoker) {
            if (taskFuture == null || this.mHoleCheckTaskFuture != taskFuture) {
                return;
            }
        }
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean onFailure) {
        OrderedInvoker orderedInvoker = this;
        synchronized (orderedInvoker) {
            this.mClosed = true;
            this.mPendingOps = null;
            this.mRunning = false;
            this.mDraining = false;
            if (this.mHoleCheckTaskFuture != null) {
                this.mHoleCheckTaskFuture.cancel(false);
                this.mHoleCheckTaskFuture = null;
            }
            this.notifyAll();
        }
        if (onFailure) {
            this.mSession.close("Closing session after waiting " + MAX_HOLE_DURATION_MILLIS + " milliseconds for missing ordered method invocation");
        }
    }

    static {
        int maxHoleDuration = 10000;
        try {
            String propValue = System.getProperty("org.cojen.dirmi.core.OrderedInvoker.maxHoleDurationMillis");
            if (propValue != null) {
                try {
                    maxHoleDuration = Math.max(1, Integer.parseInt(propValue));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        MAX_HOLE_DURATION_MILLIS = maxHoleDuration;
    }

    private class HoleCheckTask
    extends ScheduledTask<RuntimeException> {
        private Future<?> mFuture;

        private HoleCheckTask() {
        }

        Future<?> schedule(IOExecutor executor) throws RejectedException {
            this.mFuture = executor.schedule(this, (long)MAX_HOLE_DURATION_MILLIS, TimeUnit.MILLISECONDS);
            return this.mFuture;
        }

        @Override
        protected void doRun() {
            OrderedInvoker.this.holeCheck(this.mFuture);
        }
    }

    private static class SequencedOp
    implements Comparable<SequencedOp> {
        final int mSequence;

        SequencedOp(int sequence) {
            this.mSequence = sequence;
        }

        void apply() {
        }

        @Override
        public int compareTo(SequencedOp op) {
            return this.mSequence - op.mSequence;
        }
    }
}

