/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.rmi.RemoteException;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cojen.dirmi.Completion;
import org.cojen.dirmi.Unreferenced;
import org.cojen.dirmi.core.RemoteCompletion;

class RemoteCompletionServer<V>
implements Completion<V>,
RemoteCompletion<V>,
Unreferenced {
    private volatile Object mStub;
    private V mValue;
    private Throwable mComplete;
    private Queue<? super Completion<V>> mQueue;

    RemoteCompletionServer(Object stub) {
        this.mStub = stub;
    }

    @Override
    public synchronized void register(Queue<? super Completion<V>> completionQueue) {
        if (completionQueue == null) {
            throw new IllegalArgumentException("Completion queue is null");
        }
        if (this.mQueue != null) {
            throw new IllegalStateException("Already registered with a completion queue");
        }
        this.mQueue = completionQueue;
        if (this.mComplete != null) {
            completionQueue.add(this);
        }
    }

    @Override
    public boolean cancel(boolean mayInterrupt) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this.mComplete != null;
    }

    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        Throwable complete;
        while ((complete = this.mComplete) == null) {
            this.wait();
        }
        if (complete == Complete.THE) {
            return this.mValue;
        }
        throw new ExecutionException(complete);
    }

    @Override
    public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = unit.toMillis(timeout);
        Throwable complete = this.mComplete;
        if (complete == null && timeoutMillis > 0L) {
            long endNanos = System.nanoTime() + unit.toNanos(timeout);
            while (true) {
                long timeoutNanos;
                this.wait(timeoutMillis);
                complete = this.mComplete;
                if (complete != null || (timeoutNanos = endNanos - System.nanoTime()) < 1000000L) break;
                timeoutMillis = timeoutNanos / 1000000L;
            }
        }
        if (complete == null) {
            throw new TimeoutException("" + timeout + ' ' + (Object)((Object)unit));
        }
        if (complete == Complete.THE) {
            return this.mValue;
        }
        throw new ExecutionException(complete);
    }

    @Override
    public synchronized void complete(V value) {
        if (this.mComplete == null) {
            this.mValue = value;
            this.mComplete = Complete.THE;
            this.done();
        }
    }

    @Override
    public synchronized void exception(Throwable cause) {
        if (this.mComplete == null) {
            if (cause == null) {
                cause = new NullPointerException("Exception cause is null");
            }
            this.mComplete = cause;
            this.done();
        }
    }

    @Override
    public synchronized void unreferenced() {
        if (this.mComplete == null) {
            this.mComplete = new RemoteException("Session closed");
            this.done();
        }
    }

    private void done() {
        this.notifyAll();
        if (this.mQueue != null) {
            this.mQueue.add(this);
        }
        this.mStub = null;
    }

    private static class Complete
    extends Throwable {
        static final Complete THE = new Complete();

        private Complete() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

