/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.dirmi.ClassResolver;
import org.cojen.dirmi.core.ClassLoaderResolver;
import org.cojen.dirmi.core.CodeBuilderUtil;
import org.cojen.dirmi.core.StandardSession;
import org.cojen.dirmi.info.RemoteInfo;
import org.cojen.dirmi.info.RemoteIntrospector;
import org.cojen.dirmi.util.Cache;
import org.cojen.util.KeyFactory;

class RemoteTypeResolver
implements ClassResolver {
    private static final AtomicReferenceFieldUpdater<RemoteTypeResolver, ClassResolver> classResolverUpdater = AtomicReferenceFieldUpdater.newUpdater(RemoteTypeResolver.class, ClassResolver.class, "mClassResolver");
    private volatile ClassResolver mClassResolver;
    private Cache<Object, Class> mSyntheticRemoteTypes;
    private Cache<Object, Class> mSyntheticSerializableTypes;

    RemoteTypeResolver() {
    }

    @Override
    public Class<?> resolveClass(String name) throws IOException, ClassNotFoundException {
        Class<?> clazz;
        if (this.mClassResolver == null || (clazz = this.mClassResolver.resolveClass(name)) == null) {
            clazz = ClassLoaderResolver.DEFAULT.resolveClass(name);
        }
        return clazz;
    }

    Class<?> resolveClass(String name, StandardSession.Hidden.Admin admin) throws IOException, ClassNotFoundException {
        try {
            return this.resolveClass(name);
        }
        catch (ClassNotFoundException e) {
            long serialVersionUID;
            String classInfo;
            if (admin == null) {
                throw e;
            }
            if (name.startsWith("java.")) {
                throw e;
            }
            try {
                classInfo = admin.getUnknownClassInfo(name);
            }
            catch (IOException ioe) {
                throw e;
            }
            if (classInfo == null) {
                throw e;
            }
            int index = classInfo.indexOf(58);
            if (index <= 0) {
                throw e;
            }
            try {
                serialVersionUID = Long.parseLong(classInfo.substring(0, index));
            }
            catch (NumberFormatException nfe) {
                throw e;
            }
            String type = classInfo.substring(index + 1);
            return this.syntheticSerializableClass(name, serialVersionUID, type, admin);
        }
    }

    void setClassResolver(ClassResolver resolver) {
        if (resolver == null) {
            resolver = ClassLoaderResolver.DEFAULT;
        }
        if (!classResolverUpdater.compareAndSet(this, null, resolver)) {
            throw new IllegalStateException("ClassResolver is already set");
        }
    }

    Class<?> resolveRemoteType(RemoteInfo info) throws IOException {
        Class<?> type;
        try {
            type = this.resolveClass(info.getName());
            if (!type.isInterface() || !Remote.class.isAssignableFrom(type)) {
                type = null;
            }
        }
        catch (ClassNotFoundException e) {
            type = null;
        }
        if (type != null) {
            return type;
        }
        TreeSet<String> nameSet = new TreeSet<String>(info.getInterfaceNames());
        LinkedHashSet<Class> ifaceSet = new LinkedHashSet<Class>(nameSet.size());
        for (String name : nameSet) {
            if (name.equals(Remote.class.getName())) continue;
            try {
                Class<?> iface = this.resolveClass(name);
                RemoteIntrospector.examine(iface);
                ifaceSet.add(iface);
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        if (ifaceSet.isEmpty()) {
            return Remote.class;
        }
        return this.syntheticRemoteType(info.getName(), ifaceSet);
    }

    private synchronized Class<?> syntheticRemoteType(String typeName, Set<Class> ifaceSet) {
        Object key = KeyFactory.createKey((Object[])new Object[]{typeName, ifaceSet});
        if (this.mSyntheticRemoteTypes == null) {
            this.mSyntheticRemoteTypes = Cache.newSoftValueCache(7);
        } else {
            Class type = this.mSyntheticRemoteTypes.get(key);
            if (type != null) {
                return type;
            }
        }
        RuntimeClassFile cf = CodeBuilderUtil.createRuntimeClassFile(typeName, new Loader(null));
        cf.setModifiers(Modifiers.PUBLIC.toInterface(true));
        cf.addInterface(Remote.class);
        TypeDesc exType = TypeDesc.forClass(RemoteException.class);
        HashSet<String> methodsAdded = new HashSet<String>();
        for (Class iface : ifaceSet) {
            cf.addInterface(iface);
            for (Method method : iface.getMethods()) {
                String name = method.getName();
                MethodDesc desc = MethodDesc.forMethod((Method)method);
                String sig = desc.toMethodSignature(name);
                if (!methodsAdded.add(sig)) continue;
                cf.addMethod(Modifiers.PUBLIC_ABSTRACT, name, desc.getReturnType(), desc.getParameterTypes()).addException(exType);
            }
        }
        Class type = cf.defineClass();
        this.mSyntheticRemoteTypes.put(key, type);
        return type;
    }

    private synchronized Class<?> syntheticSerializableClass(String name, long serialVersionUID, String type, StandardSession.Hidden.Admin admin) throws IOException, ClassNotFoundException {
        String supers;
        Object key = KeyFactory.createKey((Object[])new Object[]{name, serialVersionUID, type});
        if (this.mSyntheticSerializableTypes == null) {
            this.mSyntheticSerializableTypes = Cache.newSoftValueCache(7);
        } else {
            Class clazz = this.mSyntheticSerializableTypes.get(key);
            if (clazz != null) {
                return clazz;
            }
        }
        int index = type.indexOf(58);
        if (index <= 0) {
            supers = null;
        } else {
            supers = type.substring(index + 1);
            type = type.substring(0, index);
        }
        String superClassName = null;
        if (supers != null) {
            int index2 = supers.indexOf(58);
            if (index2 < 0) {
                superClassName = supers;
                supers = null;
            } else if (index2 == 0) {
                superClassName = null;
                supers = supers.substring(index2 + 1);
            } else {
                superClassName = supers.substring(0, index2);
                supers = supers.substring(index2 + 1);
            }
            try {
                superClassName = TypeDesc.forDescriptor((String)superClassName).getFullName();
            }
            catch (IllegalArgumentException e) {
                superClassName = null;
            }
        }
        if (superClassName == null) {
            superClassName = "U".equals(type) ? Enum.class.getName() : null;
        }
        RuntimeClassFile cf = new RuntimeClassFile(name, superClassName, (ClassLoader)new Loader(admin), null, true);
        cf.setModifiers(Modifiers.PUBLIC);
        cf.addField(Modifiers.PRIVATE.toStatic(true).toFinal(true), "serialVersionUID", TypeDesc.LONG).setConstantValue(serialVersionUID);
        if (!"N".equals(type)) {
            cf.addInterface("E".equals(type) ? Externalizable.class : Serializable.class);
        }
        while (supers != null && supers.length() > 0) {
            String interfaceName;
            int index3 = supers.indexOf(59);
            if (index3 < 0) {
                interfaceName = supers;
                supers = null;
            } else {
                interfaceName = supers.substring(0, index3 + 1);
                supers = supers.substring(index3 + 1);
            }
            try {
                interfaceName = TypeDesc.forDescriptor((String)interfaceName).getFullName();
            }
            catch (IllegalArgumentException e) {
                interfaceName = null;
            }
            if (interfaceName == null) continue;
            cf.addInterface(interfaceName);
        }
        if ("U".equals(type)) {
            TypeDesc[] params = new TypeDesc[]{TypeDesc.STRING, TypeDesc.INT};
            MethodInfo mi = cf.addConstructor(Modifiers.PRIVATE, params);
            CodeBuilder b = new CodeBuilder(mi);
            b.loadThis();
            b.loadLocal(b.getParameter(0));
            b.loadLocal(b.getParameter(1));
            b.invokeSuperConstructor(params);
            b.returnVoid();
        } else {
            cf.addDefaultConstructor();
        }
        Class clazz = cf.defineClass();
        this.mSyntheticSerializableTypes.put(key, clazz);
        return clazz;
    }

    private class Loader
    extends ClassLoader {
        private final WeakReference<StandardSession.Hidden.Admin> mAdminRef;

        Loader(StandardSession.Hidden.Admin admin) {
            this.mAdminRef = admin == null ? null : new WeakReference<StandardSession.Hidden.Admin>(admin);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            StandardSession.Hidden.Admin admin = this.mAdminRef == null ? null : (StandardSession.Hidden.Admin)this.mAdminRef.get();
            try {
                return RemoteTypeResolver.this.resolveClass(name, admin);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name + ", " + e);
            }
        }
    }
}

